/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.util.Objects;
import org.apache.commons.lang3.tuple.Triple;

public class ImmutableTriple<L, M, R>
extends Triple<L, M, R> {
    public static final ImmutableTriple<?, ?, ?>[] EMPTY_ARRAY = new ImmutableTriple[0];
    private static final ImmutableTriple NULL = new ImmutableTriple<Object, Object, Object>(null, null, null);
    private static final long serialVersionUID = 1L;
    public final L left;
    public final M middle;
    public final R right;

    public static <L, M, R> ImmutableTriple<L, M, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, M, R> ImmutableTriple<L, M, R> nullTriple() {
        return NULL;
    }

    public static <L, M, R> ImmutableTriple<L, M, R> of(L left2, M middle, R right2) {
        return left2 != null | middle != null || right2 != null ? new ImmutableTriple<L, M, R>(left2, middle, right2) : ImmutableTriple.nullTriple();
    }

    public static <L, M, R> ImmutableTriple<L, M, R> ofNonNull(L left2, M middle, R right2) {
        return ImmutableTriple.of(Objects.requireNonNull(left2, "left"), Objects.requireNonNull(middle, "middle"), Objects.requireNonNull(right2, "right"));
    }

    public ImmutableTriple(L left2, M middle, R right2) {
        this.left = left2;
        this.middle = middle;
        this.right = right2;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public M getMiddle() {
        return this.middle;
    }

    @Override
    public R getRight() {
        return this.right;
    }
}

