/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import javajs.util.P3;
import javajs.util.T3;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Node;

class Leaf
extends Element {
    T3[] tuples;

    Leaf(Bspt bspt, Leaf leaf, int countToKeep) {
        this.bspt = bspt;
        this.count = 0;
        this.tuples = new P3[2];
        if (leaf == null) {
            return;
        }
        for (int i = countToKeep; i < 2; ++i) {
            this.tuples[this.count++] = leaf.tuples[i];
            leaf.tuples[i] = null;
        }
        leaf.count = countToKeep;
    }

    void sort(int dim) {
        int i = this.count;
        while (--i > 0) {
            T3 champion = this.tuples[i];
            float championValue = Node.getDimensionValue(champion, dim);
            int j = i;
            while (--j >= 0) {
                T3 challenger = this.tuples[j];
                float challengerValue = Node.getDimensionValue(challenger, dim);
                if (!(challengerValue > championValue)) continue;
                this.tuples[i] = challenger;
                this.tuples[j] = champion;
                champion = challenger;
                championValue = challengerValue;
            }
        }
    }

    @Override
    Element addTuple(int level, T3 tuple) {
        if (this.count < 2) {
            this.tuples[this.count++] = tuple;
            return this;
        }
        Node node = new Node(this.bspt, level, this);
        return node.addTuple(level, tuple);
    }
}

