/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

public class DefaultComboBoxModel<E>
extends AbstractListModel<E>
implements MutableComboBoxModel<E>,
Serializable {
    Vector<E> objects;
    Object selectedObject;

    public DefaultComboBoxModel() {
        this.objects = new Vector();
    }

    public DefaultComboBoxModel(E[] EArray) {
        this.objects = new Vector(EArray.length);
        int n = EArray.length;
        for (int i = 0; i < n; ++i) {
            this.objects.addElement(EArray[i]);
        }
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    public DefaultComboBoxModel(Vector<E> vector) {
        this.objects = vector;
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    @Override
    public void setSelectedItem(Object object) {
        if (this.selectedObject != null && !this.selectedObject.equals(object) || this.selectedObject == null && object != null) {
            this.selectedObject = object;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public int getSize() {
        return this.objects.size();
    }

    @Override
    public E getElementAt(int n) {
        if (n >= 0 && n < this.objects.size()) {
            return this.objects.elementAt(n);
        }
        return null;
    }

    public int getIndexOf(Object object) {
        return this.objects.indexOf(object);
    }

    @Override
    public void addElement(E e) {
        this.objects.addElement(e);
        this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        if (this.objects.size() == 1 && this.selectedObject == null && e != null) {
            this.setSelectedItem(e);
        }
    }

    @Override
    public void insertElementAt(E e, int n) {
        this.objects.insertElementAt(e, n);
        this.fireIntervalAdded(this, n, n);
    }

    @Override
    public void removeElementAt(int n) {
        if (this.getElementAt(n) == this.selectedObject) {
            if (n == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(n + 1));
            } else {
                this.setSelectedItem(this.getElementAt(n - 1));
            }
        }
        this.objects.removeElementAt(n);
        this.fireIntervalRemoved(this, n, n);
    }

    @Override
    public void removeElement(Object object) {
        int n = this.objects.indexOf(object);
        if (n != -1) {
            this.removeElementAt(n);
        }
    }

    public void removeAllElements() {
        if (this.objects.size() > 0) {
            int n = 0;
            int n2 = this.objects.size() - 1;
            this.objects.removeAllElements();
            this.selectedObject = null;
            this.fireIntervalRemoved(this, n, n2);
        } else {
            this.selectedObject = null;
        }
    }
}

