/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.indices;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.client.TimedRequest;
import org.opensearch.client.Validatable;
import org.opensearch.common.Nullable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;

public class GetIndexTemplatesRequest
implements Validatable {
    private final List<String> names;
    private TimeValue clusterManagerNodeTimeout = TimedRequest.DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT;
    private boolean local = false;

    public GetIndexTemplatesRequest(String ... names) {
        this(Arrays.asList(names));
    }

    public GetIndexTemplatesRequest(List<String> names) {
        Objects.requireNonNull(names);
        if (names.stream().anyMatch(name -> name == null || !Strings.hasText((String)name))) {
            throw new IllegalArgumentException("all index template names must be non null and non empty");
        }
        this.names = Collections.unmodifiableList(names);
    }

    public List<String> names() {
        return this.names;
    }

    public TimeValue getClusterManagerNodeTimeout() {
        return this.clusterManagerNodeTimeout;
    }

    public void setClusterManagerNodeTimeout(@Nullable TimeValue clusterManagerNodeTimeout) {
        this.clusterManagerNodeTimeout = clusterManagerNodeTimeout;
    }

    public void setClusterManagerNodeTimeout(String clusterManagerNodeTimeout) {
        TimeValue timeValue = TimeValue.parseTimeValue((String)clusterManagerNodeTimeout, (String)(this.getClass().getSimpleName() + ".clusterManagerNodeTimeout"));
        this.setClusterManagerNodeTimeout(timeValue);
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }
}

