/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.configuration.PrivilegesInterceptorImpl;
import org.opensearch.security.privileges.DashboardsMultiTenancyConfiguration;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.privileges.PrivilegesEvaluatorImpl;
import org.opensearch.security.privileges.RoleMapper;
import org.opensearch.security.privileges.TenantPrivileges;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.DynamicConfigFactory;
import org.opensearch.security.securityconf.FlattenedActionGroups;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class PrivilegesConfiguration {
    private static final Logger log = LogManager.getLogger(PrivilegesConfiguration.class);
    private final AtomicReference<TenantPrivileges> tenantPrivileges = new AtomicReference<TenantPrivileges>(TenantPrivileges.EMPTY);
    private final AtomicReference<PrivilegesEvaluator> privilegesEvaluator;
    private final AtomicReference<FlattenedActionGroups> actionGroups = new AtomicReference<FlattenedActionGroups>(FlattenedActionGroups.EMPTY);
    private final Map<String, RoleV7> pluginIdToRolePrivileges = new HashMap<String, RoleV7>();
    private final AtomicReference<DashboardsMultiTenancyConfiguration> multiTenancyConfiguration = new AtomicReference<DashboardsMultiTenancyConfiguration>(DashboardsMultiTenancyConfiguration.DEFAULT);
    private final PrivilegesInterceptorImpl privilegesInterceptor;
    private final FlattenedActionGroups staticActionGroups;

    public PrivilegesConfiguration(ConfigurationRepository configurationRepository, ClusterService clusterService, Supplier<ClusterState> clusterStateSupplier, Client client, RoleMapper roleMapper, ThreadPool threadPool, IndexNameExpressionResolver resolver, AuditLog auditLog, Settings settings, Supplier<String> unavailablityReasonSupplier, IndexResolverReplacer indexResolverReplacer) {
        this.privilegesEvaluator = new AtomicReference<PrivilegesEvaluator.NotInitialized>(new PrivilegesEvaluator.NotInitialized(unavailablityReasonSupplier));
        this.privilegesInterceptor = new PrivilegesInterceptorImpl(resolver, clusterService, client, threadPool, this.tenantPrivileges::get, this.multiTenancyConfiguration::get);
        this.staticActionGroups = PrivilegesConfiguration.buildStaticActionGroups();
        if (configurationRepository != null) {
            configurationRepository.subscribeOnChange(configMap -> {
                SecurityDynamicConfiguration<ActionGroupsV7> actionGroupsConfiguration = configurationRepository.getConfiguration(CType.ACTIONGROUPS);
                SecurityDynamicConfiguration<RoleV7> rolesConfiguration = configurationRepository.getConfiguration(CType.ROLES).withStaticConfig();
                SecurityDynamicConfiguration<TenantV7> tenantConfiguration = configurationRepository.getConfiguration(CType.TENANTS).withStaticConfig();
                ConfigV7 generalConfiguration = configurationRepository.getConfiguration(CType.CONFIG).getCEntry(CType.CONFIG.name());
                FlattenedActionGroups flattenedActionGroups = new FlattenedActionGroups(actionGroupsConfiguration.withStaticConfig());
                this.actionGroups.set(flattenedActionGroups);
                PrivilegesEvaluator currentPrivilegesEvaluator = this.privilegesEvaluator.get();
                PrivilegesEvaluator.PrivilegesEvaluatorType targetType = PrivilegesEvaluator.PrivilegesEvaluatorType.STANDARD;
                PrivilegesEvaluator.PrivilegesEvaluatorType currentType = currentPrivilegesEvaluator.type();
                if (currentType != targetType) {
                    PrivilegesEvaluator oldInstance = this.privilegesEvaluator.getAndSet(new PrivilegesEvaluatorImpl(clusterService, clusterStateSupplier, roleMapper, threadPool, threadPool.getThreadContext(), resolver, auditLog, settings, this.privilegesInterceptor, indexResolverReplacer, flattenedActionGroups, this.staticActionGroups, rolesConfiguration, generalConfiguration, this.pluginIdToRolePrivileges));
                    if (oldInstance != null) {
                        oldInstance.shutdown();
                    }
                } else {
                    this.privilegesEvaluator.get().updateConfiguration(flattenedActionGroups, rolesConfiguration, generalConfiguration);
                }
                try {
                    this.multiTenancyConfiguration.set(new DashboardsMultiTenancyConfiguration(generalConfiguration));
                }
                catch (Exception e) {
                    log.error("Error while updating DashboardsMultiTenancyConfiguration", (Throwable)e);
                }
                try {
                    this.tenantPrivileges.set(new TenantPrivileges(rolesConfiguration, tenantConfiguration, flattenedActionGroups));
                }
                catch (Exception e) {
                    log.error("Error while updating TenantPrivileges", (Throwable)e);
                }
            });
        }
        if (clusterService != null) {
            clusterService.addListener(event -> this.privilegesEvaluator.get().updateClusterStateMetadata(clusterService));
        }
    }

    public PrivilegesConfiguration(PrivilegesEvaluator privilegesEvaluator) {
        this.privilegesEvaluator = new AtomicReference<PrivilegesEvaluator>(privilegesEvaluator);
        this.privilegesInterceptor = null;
        this.staticActionGroups = PrivilegesConfiguration.buildStaticActionGroups();
    }

    public TenantPrivileges tenantPrivileges() {
        return this.tenantPrivileges.get();
    }

    public PrivilegesEvaluator privilegesEvaluator() {
        return this.privilegesEvaluator.get();
    }

    public FlattenedActionGroups actionGroups() {
        return this.actionGroups.get();
    }

    public DashboardsMultiTenancyConfiguration multiTenancyConfiguration() {
        return this.multiTenancyConfiguration.get();
    }

    public void updatePluginToActionPrivileges(String pluginIdentifier, RoleV7 pluginPermissions) {
        this.pluginIdToRolePrivileges.put(pluginIdentifier, pluginPermissions);
    }

    private static FlattenedActionGroups buildStaticActionGroups() {
        return new FlattenedActionGroups(DynamicConfigFactory.addStatics(SecurityDynamicConfiguration.empty(CType.ACTIONGROUPS)));
    }
}

