/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.Random;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.cli.OptionPrint;
import net.sourceforge.plantuml.dedication.Dedication;
import net.sourceforge.plantuml.dedication.QBlock;
import net.sourceforge.plantuml.dedication.TurningBytes;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.utils.SignatureUtils;
import net.sourceforge.plantuml.version.LicenseInfo;
import net.sourceforge.plantuml.version.LicenseType;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PLSSignature {
    private final int type;
    private final byte[] sha;
    private final long now;
    private final long exp;
    private final String owner;
    private final String context;

    public PLSSignature(int type, byte[] sha, long now, long exp, String owner, String context) {
        this.type = type;
        this.sha = sha;
        this.now = now;
        this.exp = exp;
        this.owner = owner;
        this.context = context;
    }

    private LicenseInfo toLicenseInfo() {
        return new LicenseInfo(LicenseType.fromInt(this.type), this.now, this.exp, this.owner, this.context, this.sha);
    }

    public static byte[] retrieveDistributorImageSignature() throws IOException, NoSuchAlgorithmException {
        InputStream dis = PSystemVersion.class.getResourceAsStream("/distributor.png");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtils.copyToStream(dis, (OutputStream)baos);
        return SignatureUtils.getSHA512raw(baos.toByteArray());
    }

    public static PLSSignature fromRaw512(byte[] data) throws NoSuchAlgorithmException, IOException {
        if (data.length != 512) {
            throw new IllegalArgumentException();
        }
        byte[] resultA = new byte[64];
        byte[] resultB = new byte[448];
        System.arraycopy(data, 0, resultA, 0, resultA.length);
        System.arraycopy(data, 64, resultB, 0, resultB.length);
        byte[] sig = SignatureUtils.getSHA512raw(resultB);
        if (!SignatureUtils.toHexString(resultA).equals(SignatureUtils.toHexString(sig))) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(resultB);
        int type = bais.read();
        if (type == 0) {
            int version = bais.read();
            byte[] sha = PLSSignature.readBytes(bais, 64);
            long now = PLSSignature.readLong(bais);
            long exp = PLSSignature.readLong(bais);
            String owner = PLSSignature.readString(bais);
            return new PLSSignature(type, sha, now, exp, owner, null);
        }
        if (type == 2) {
            int version = bais.read();
            byte[] sha = PLSSignature.readBytes(bais, 64);
            long now = PLSSignature.readLong(bais);
            long exp = PLSSignature.readLong(bais);
            String owner = PLSSignature.readString(bais);
            String context = PLSSignature.readString(bais);
            return new PLSSignature(type, sha, now, exp, owner, context);
        }
        return null;
    }

    private static byte[] readBytes(ByteArrayInputStream bais, int size) throws IOException {
        byte[] result = new byte[size];
        int read = bais.read(result);
        if (read != size) {
            throw new IOException();
        }
        return result;
    }

    private static String readString(ByteArrayInputStream bais) throws IOException {
        int size = bais.read();
        if (size > 80) {
            throw new IOException();
        }
        byte[] result = new byte[size];
        int read = bais.read(result);
        if (read != size) {
            throw new IOException();
        }
        return new String(result, StandardCharsets.UTF_8);
    }

    private static long readLong(ByteArrayInputStream bais) throws IOException {
        byte[] result = new byte[8];
        int read = bais.read(result);
        if (read != 8) {
            throw new IOException();
        }
        long ll = 0L;
        for (int i = 7; i >= 0; --i) {
            long mask = (long)(result[i] & 0xFF) << 8 * (7 - i);
            ll |= mask;
        }
        return ll;
    }

    public static LicenseInfo retrieveNamed(String sig, String key, boolean doCheck) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        byte[] block = PLSSignature.decode(key);
        PLSSignature.xor(block, SignatureUtils.getSHA512raw(SignatureUtils.salting(sig, PLSSignature.getSalt(sig))));
        PLSSignature sig2 = PLSSignature.fromRaw512(block);
        if (sig2 == null) {
            return LicenseInfo.NONE;
        }
        return sig2.toLicenseInfo();
    }

    public static LicenseInfo retrieveDistributor(String key) throws IOException, NoSuchAlgorithmException {
        byte[] block = PLSSignature.decode(key);
        PLSSignature sig2 = PLSSignature.fromRaw512(block);
        if (sig2 == null) {
            return LicenseInfo.NONE;
        }
        return sig2.toLicenseInfo();
    }

    private static byte[] decode(String key) throws IOException {
        BigInteger lu = new BigInteger(key, 36);
        QBlock qb2 = new QBlock(lu);
        QBlock qb3 = qb2.change(Dedication.E, Dedication.N);
        byte[] block = qb3.getData512();
        if (block.length != 512) {
            throw new IOException();
        }
        return block;
    }

    private static void xor(byte[] buffer, TurningBytes turningBytes) {
        int i = 0;
        while (i < buffer.length) {
            int n = i++;
            buffer[n] = (byte)(buffer[n] ^ turningBytes.nextByte());
        }
    }

    public static void xor(byte[] buffer, byte[] key) {
        PLSSignature.xor(buffer, new TurningBytes(key));
    }

    public static byte[] getSalt(String signature) throws UnsupportedEncodingException {
        Random rnd = new Random(PLSSignature.getSeed(signature.getBytes(StandardCharsets.UTF_8)));
        byte[] salt = new byte[512];
        rnd.nextBytes(salt);
        return salt;
    }

    private static long getSeed(byte[] bytes) {
        long result = 19L;
        for (byte b : bytes) {
            result = result * 41L + (long)b;
        }
        return result;
    }

    public static byte[] signature() throws IOException {
        String signature = OptionPrint.getHostName() + PLSSignature.getMacAddress();
        try {
            return SignatureUtils.getSHA512raw(SignatureUtils.salting(signature, PLSSignature.getSalt(signature)));
        }
        catch (Exception e) {
            Logme.error(e);
            throw new IOException();
        }
    }

    private static String getMacAddress() throws IOException {
        Enumeration<NetworkInterface> net = NetworkInterface.getNetworkInterfaces();
        StringBuilder result = new StringBuilder();
        while (net.hasMoreElements()) {
            NetworkInterface element = net.nextElement();
            byte[] mac = element.getHardwareAddress();
            if (mac == null) continue;
            for (byte b : mac) {
                result.append(String.format("%02x", b));
            }
        }
        return result.toString();
    }
}

