/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.xml;

import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.xml.infer.AttributeDecl;
import com.thaiopensource.xml.infer.ChoiceParticle;
import com.thaiopensource.xml.infer.ElementDecl;
import com.thaiopensource.xml.infer.ElementParticle;
import com.thaiopensource.xml.infer.EmptyParticle;
import com.thaiopensource.xml.infer.InferHandler;
import com.thaiopensource.xml.infer.OneOrMoreParticle;
import com.thaiopensource.xml.infer.Particle;
import com.thaiopensource.xml.infer.ParticleVisitor;
import com.thaiopensource.xml.infer.Schema;
import com.thaiopensource.xml.infer.SequenceParticle;
import com.thaiopensource.xml.infer.TextParticle;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class Inferrer {
    private final Schema schema;
    private final Set multiplyReferencedElementNames = new HashSet();
    private final GrammarPattern grammar;
    private final ParticleConverter particleConverter = new ParticleConverter();
    private final List outputQueue = new Vector();
    private final Set queued = new HashSet();
    private String prefixSeparator;
    private static final String SEPARATORS = ".-_";
    static /* synthetic */ Class class$com$thaiopensource$relaxng$edit$TextPattern;
    static /* synthetic */ Class class$com$thaiopensource$relaxng$edit$RefPattern;
    static /* synthetic */ Class class$com$thaiopensource$relaxng$edit$ElementPattern;

    static SchemaCollection infer(String[] stringArray, Options options, ErrorHandler errorHandler) throws SAXException, IOException {
        Object object;
        InferHandler inferHandler = new InferHandler(new DatatypeLibraryLoader());
        Jaxp11XMLReaderCreator jaxp11XMLReaderCreator = new Jaxp11XMLReaderCreator();
        XMLReader xMLReader = jaxp11XMLReaderCreator.createXMLReader();
        xMLReader.setErrorHandler(errorHandler);
        xMLReader.setContentHandler(inferHandler);
        int n = 0;
        while (n < stringArray.length) {
            object = new InputSource(stringArray[n]);
            if (options.encoding != null) {
                ((InputSource)object).setEncoding(options.encoding);
            }
            xMLReader.parse((InputSource)object);
            ++n;
        }
        object = new SchemaCollection();
        ((SchemaCollection)object).setMainUri(stringArray[0]);
        SchemaDocument schemaDocument = new SchemaDocument(new Inferrer((Schema)inferHandler.getSchema()).grammar);
        ((SchemaCollection)object).getSchemaDocumentMap().put(((SchemaCollection)object).getMainUri(), schemaDocument);
        return object;
    }

    private Inferrer(Schema schema) {
        this.schema = schema;
        this.grammar = new GrammarPattern();
        this.findMultiplyReferencedElements();
        this.choosePrefixSeparator();
        this.grammar.getComponents().add(new DefineComponent(DefineComponent.START, this.particleConverter.convert(schema.getStart())));
        int n = 0;
        while (n < this.outputQueue.size()) {
            Name name = (Name)this.outputQueue.get(n);
            this.grammar.getComponents().add(new DefineComponent(this.getDefineName(name), this.createElementPattern(name)));
            ++n;
        }
    }

    private void findMultiplyReferencedElements() {
        ReferenceFinder referenceFinder = new ReferenceFinder();
        this.schema.getStart().accept(referenceFinder);
        Iterator iterator = this.schema.getElementDecls().values().iterator();
        while (iterator.hasNext()) {
            ElementDecl elementDecl = (ElementDecl)iterator.next();
            Particle particle = elementDecl.getContentModel();
            if (particle == null) continue;
            particle.accept(referenceFinder);
        }
    }

    private void choosePrefixSeparator() {
        Map map = this.schema.getPrefixMap();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.multiplyReferencedElementNames.iterator();
        while (iterator.hasNext()) {
            hashSet.add(((Name)iterator.next()).getNamespaceUri());
        }
        if (hashSet.size() <= 1) {
            return;
        }
        hashSet.removeAll(map.keySet());
        if (hashSet.size() > 1) {
            hashSet.remove("");
            int n = 1;
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                String string;
                while (map.containsKey(string = "ns" + Integer.toString(n++))) {
                }
                map.put(iterator2.next(), string);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (true) {
            int n2 = 0;
            while (n2 < SEPARATORS.length()) {
                char c = SEPARATORS.charAt(n2);
                int n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(c);
                    ++n3;
                }
                this.prefixSeparator = stringBuffer.toString();
                if (this.prefixSeparatorOk()) {
                    return;
                }
                stringBuffer.setLength(0);
                ++n2;
            }
            ++n;
        }
    }

    private boolean prefixSeparatorOk() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.multiplyReferencedElementNames.iterator();
        while (iterator.hasNext()) {
            String string = this.getDefineName((Name)iterator.next());
            if (hashSet.contains(string)) {
                return false;
            }
            hashSet.add(string);
        }
        return true;
    }

    private Pattern createElementPattern(Name name) {
        ElementDecl elementDecl = this.schema.getElementDecl(name);
        Particle particle = elementDecl.getContentModel();
        Pattern pattern = particle != null ? this.particleConverter.convert(particle) : Inferrer.makeDatatype(elementDecl.getDatatype());
        Map map = elementDecl.getAttributeDecls();
        if (map.size() > 0) {
            GroupPattern groupPattern = new GroupPattern();
            Vector vector = new Vector();
            vector.addAll(map.keySet());
            Collections.sort(vector);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Name name2 = (Name)iterator.next();
                AttributeDecl attributeDecl = (AttributeDecl)map.get(name2);
                Pattern pattern2 = attributeDecl.getDatatype() == null ? new TextPattern() : Inferrer.makeDatatype(attributeDecl.getDatatype());
                pattern2 = new AttributePattern(this.makeNameClass(name2), pattern2);
                if (attributeDecl.isOptional()) {
                    pattern2 = new OptionalPattern(pattern2);
                }
                groupPattern.getChildren().add(pattern2);
            }
            if (pattern instanceof GroupPattern) {
                groupPattern.getChildren().addAll(((GroupPattern)pattern).getChildren());
            } else if (!(pattern instanceof EmptyPattern)) {
                groupPattern.getChildren().add(pattern);
            }
            pattern = groupPattern;
        }
        return new ElementPattern(this.makeNameClass(name), pattern);
    }

    private NameNameClass makeNameClass(Name name) {
        String string;
        String string2 = name.getNamespaceUri();
        NameNameClass nameNameClass = new NameNameClass(string2, name.getLocalName());
        if (!string2.equals("") && (string = (String)this.schema.getPrefixMap().get(string2)) != null) {
            nameNameClass.setPrefix(string);
        }
        return nameNameClass;
    }

    private static DataPattern makeDatatype(Name name) {
        return new DataPattern(name.getNamespaceUri(), name.getLocalName());
    }

    private String getDefineName(Name name) {
        String string;
        if (this.prefixSeparator != null && (string = (String)this.schema.getPrefixMap().get(name.getNamespaceUri())) != null) {
            return string + this.prefixSeparator + name.getLocalName();
        }
        return name.getLocalName();
    }

    private static Pattern normalize(CompositePattern compositePattern) {
        if (compositePattern.getChildren().size() == 1) {
            return (Pattern)compositePattern.getChildren().get(0);
        }
        return compositePattern;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ReferenceFinder
    implements ParticleVisitor {
        private final Set referencedElementNames = new HashSet();

        private ReferenceFinder() {
        }

        public Object visitElement(ElementParticle elementParticle) {
            Name name = elementParticle.getName();
            if (this.referencedElementNames.contains(name)) {
                Inferrer.this.multiplyReferencedElementNames.add(name);
            } else {
                this.referencedElementNames.add(name);
            }
            return null;
        }

        public Object visitChoice(ChoiceParticle choiceParticle) {
            choiceParticle.getChild1().accept(this);
            choiceParticle.getChild2().accept(this);
            return null;
        }

        public Object visitSequence(SequenceParticle sequenceParticle) {
            sequenceParticle.getChild1().accept(this);
            sequenceParticle.getChild2().accept(this);
            return null;
        }

        public Object visitEmpty(EmptyParticle emptyParticle) {
            return null;
        }

        public Object visitText(TextParticle textParticle) {
            return null;
        }

        public Object visitOneOrMore(OneOrMoreParticle oneOrMoreParticle) {
            return oneOrMoreParticle.getChild().accept(this);
        }
    }

    private class ParticleConverter
    extends PatternComparator
    implements ParticleVisitor {
        private ParticleConverter() {
        }

        public Object visitElement(ElementParticle elementParticle) {
            Name name = elementParticle.getName();
            if (Inferrer.this.multiplyReferencedElementNames.contains(name)) {
                if (!Inferrer.this.queued.contains(name)) {
                    Inferrer.this.queued.add(name);
                    Inferrer.this.outputQueue.add(name);
                }
                return new RefPattern(Inferrer.this.getDefineName(name));
            }
            return Inferrer.this.createElementPattern(name);
        }

        public Object visitChoice(ChoiceParticle choiceParticle) {
            ChoicePattern choicePattern = new ChoicePattern();
            List list = choicePattern.getChildren();
            this.addChoices(list, choiceParticle.getChild1());
            this.addChoices(list, choiceParticle.getChild2());
            Collections.sort(list, this);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof EmptyPattern)) continue;
                iterator.remove();
                return this.makeOptional(choicePattern);
            }
            return choicePattern;
        }

        private Object makeOptional(ChoicePattern choicePattern) {
            List list = choicePattern.getChildren();
            boolean bl = false;
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                Pattern pattern = (Pattern)list.get(n);
                if (pattern instanceof OneOrMorePattern) {
                    list.set(n, new ZeroOrMorePattern(((OneOrMorePattern)pattern).getChild()));
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                return Inferrer.normalize(choicePattern);
            }
            return new OptionalPattern(Inferrer.normalize(choicePattern));
        }

        private void addChoices(List list, Particle particle) {
            Pattern pattern = this.convert(particle);
            if (pattern instanceof ChoicePattern) {
                list.addAll(((ChoicePattern)pattern).getChildren());
            } else {
                list.add(pattern);
            }
        }

        public Object visitSequence(SequenceParticle sequenceParticle) {
            GroupPattern groupPattern = new GroupPattern();
            this.addGroup(groupPattern.getChildren(), sequenceParticle.getChild1());
            this.addGroup(groupPattern.getChildren(), sequenceParticle.getChild2());
            return groupPattern;
        }

        private void addGroup(List list, Particle particle) {
            Pattern pattern = this.convert(particle);
            if (pattern instanceof GroupPattern) {
                list.addAll(((GroupPattern)pattern).getChildren());
            } else {
                list.add(pattern);
            }
        }

        public Object visitEmpty(EmptyParticle emptyParticle) {
            return new EmptyPattern();
        }

        public Object visitText(TextParticle textParticle) {
            return new TextPattern();
        }

        public Object visitOneOrMore(OneOrMoreParticle oneOrMoreParticle) {
            return new OneOrMorePattern(this.convert(oneOrMoreParticle.getChild()));
        }

        public Pattern convert(Particle particle) {
            return (Pattern)particle.accept(this);
        }
    }

    private static class PatternComparator
    implements Comparator {
        private static final Class[] classOrder = new Class[]{class$com$thaiopensource$relaxng$edit$TextPattern == null ? (class$com$thaiopensource$relaxng$edit$TextPattern = Inferrer.class$("com.thaiopensource.relaxng.edit.TextPattern")) : class$com$thaiopensource$relaxng$edit$TextPattern, class$com$thaiopensource$relaxng$edit$RefPattern == null ? (class$com$thaiopensource$relaxng$edit$RefPattern = Inferrer.class$("com.thaiopensource.relaxng.edit.RefPattern")) : class$com$thaiopensource$relaxng$edit$RefPattern, class$com$thaiopensource$relaxng$edit$ElementPattern == null ? (class$com$thaiopensource$relaxng$edit$ElementPattern = Inferrer.class$("com.thaiopensource.relaxng.edit.ElementPattern")) : class$com$thaiopensource$relaxng$edit$ElementPattern};

        private PatternComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object.getClass() != object2.getClass()) {
                return PatternComparator.classIndex(object.getClass()) - PatternComparator.classIndex(object2.getClass());
            }
            if (object instanceof RefPattern) {
                return ((RefPattern)object).getName().compareTo(((RefPattern)object2).getName());
            }
            if (object instanceof ElementPattern) {
                return PatternComparator.extractElementName(object).compareTo(PatternComparator.extractElementName(object2));
            }
            return 0;
        }

        private static Name extractElementName(Object object) {
            NameNameClass nameNameClass = (NameNameClass)((ElementPattern)object).getNameClass();
            return new Name(nameNameClass.getNamespaceUri(), nameNameClass.getLocalName());
        }

        private static int classIndex(Class clazz) {
            int n = 0;
            while (n < classOrder.length) {
                if (clazz == classOrder[n]) {
                    return n;
                }
                ++n;
            }
            return classOrder.length;
        }
    }

    static class Options {
        String encoding;

        Options() {
        }
    }
}

