/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.generic;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class Accent
extends ControlSequence {
    public static final int[][] ACUTE_ACCENTS = new int[][]{{65, 193}, {97, 225}, {69, 201}, {101, 233}, {73, 205}, {105, 237}, {79, 211}, {111, 243}, {85, 218}, {117, 250}, {121, 253}, {67, 262}, {99, 263}, {76, 313}, {108, 314}, {78, 323}, {110, 324}, {82, 340}, {114, 341}, {83, 346}, {115, 347}, {90, 377}, {122, 378}};
    public static final int[][] GRAVE_ACCENTS = new int[][]{{65, 192}, {97, 224}, {69, 200}, {101, 232}, {73, 204}, {105, 236}, {79, 210}, {111, 242}, {85, 217}, {117, 249}, {121, 253}};
    public static final int[][] CIRCUM_ACCENTS = new int[][]{{65, 194}, {97, 226}, {69, 202}, {101, 234}, {73, 206}, {105, 238}, {85, 219}, {117, 251}, {67, 264}, {99, 265}, {71, 284}, {103, 285}, {72, 292}, {104, 293}, {74, 308}, {106, 309}, {83, 348}, {115, 349}, {87, 372}, {119, 373}, {89, 374}, {121, 375}};
    public static final int[][] TILDE_ACCENTS = new int[][]{{65, 195}, {97, 227}, {79, 213}, {111, 245}, {78, 209}, {110, 241}, {73, 296}, {105, 297}};
    public static final int[][] UMLAUT_ACCENTS = new int[][]{{65, 196}, {97, 228}, {69, 203}, {101, 235}, {73, 207}, {105, 239}, {79, 214}, {111, 246}, {85, 220}, {117, 252}, {121, 255}, {89, 376}};
    public static final int[][] CEDILLA_ACCENTS = new int[][]{{67, 199}, {99, 231}};
    public static final int[][] RING_ACCENTS = new int[][]{{65, 197}, {97, 229}, {85, 366}, {117, 367}};
    public static final int[][] MACRON_ACCENTS = new int[][]{{65, 256}, {97, 257}, {69, 274}, {97, 275}, {73, 298}, {105, 299}, {79, 332}, {111, 333}, {85, 362}, {117, 363}};
    public static final int[][] BREVE_ACCENTS = new int[][]{{65, 258}, {97, 259}, {69, 276}, {101, 277}, {71, 286}, {103, 287}, {73, 300}, {105, 301}, {79, 334}, {111, 335}, {85, 364}, {117, 365}};
    public static final int[][] DOT_ACCENTS = new int[][]{{67, 266}, {99, 267}, {69, 278}, {101, 279}, {71, 288}, {103, 289}, {73, 304}, {90, 379}, {122, 380}, {66, 7682}, {66, 7683}, {68, 7690}, {100, 7691}, {70, 7710}, {102, 7711}, {72, 7714}, {104, 7715}, {78, 7748}, {110, 7749}};
    public static final int[][] CARON_ACCENTS = new int[][]{{67, 268}, {99, 269}, {68, 270}, {69, 282}, {101, 283}, {78, 327}, {110, 328}, {82, 344}, {114, 345}, {83, 352}, {115, 353}, {84, 356}, {90, 381}, {122, 382}};
    public static final int[][] DOT_UNDER_ACCENTS = new int[][]{{66, 7684}, {98, 7685}, {68, 7692}, {100, 7693}, {72, 7716}, {104, 7717}, {75, 7730}, {107, 7731}, {76, 7734}, {108, 7735}, {77, 7746}, {109, 7747}, {78, 7750}, {110, 7751}, {82, 7770}, {114, 7771}, {83, 7778}, {115, 7779}, {84, 7788}, {116, 7789}, {86, 7806}, {118, 7807}, {87, 7816}, {119, 7817}, {90, 7826}, {122, 7827}, {65, 7840}, {97, 7841}};
    public static final int[][] UNDERBAR_ACCENTS = new int[][]{{66, 7686}, {98, 7687}, {68, 7694}, {100, 7695}, {75, 7732}, {107, 7733}, {76, 7738}, {108, 7739}, {78, 7752}, {110, 7753}, {82, 7774}, {114, 7775}, {84, 7790}, {116, 7791}, {90, 7828}, {122, 7829}, {104, 7830}};
    public static final int[][] DOUBLE_ACUTE_ACCENTS = new int[][]{{79, 336}, {111, 337}, {85, 368}, {117, 369}};
    public static final int[][] OGONEK_ACCENTS = new int[][]{{79, 490}, {111, 491}, {85, 370}, {117, 371}, {105, 303}, {73, 302}, {101, 281}, {69, 280}, {97, 261}, {65, 260}};

    public Accent(String string) {
        super(string);
    }

    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = teXParser.popNextArg();
        TeXObjectList teXObjectList = null;
        String string = this.name;
        if (this.name.equals("a")) {
            if (teXObject instanceof Group) {
                teXObject = ((Group)teXObject).toList();
            }
            if (teXObject instanceof Expandable) {
                teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser);
                teXObject = teXObjectList.size() == 0 ? teXParser.popStack() : teXObjectList.pop();
            }
            if (!(teXObject instanceof CharObject)) {
                throw new TeXSyntaxException(teXParser, "tex.error.invalid_accent", teXObject.toString(teXParser));
            }
            string = "" + (char)((CharObject)teXObject).getCharCode();
            teXObject = teXObjectList != null && teXObjectList.size() > 0 ? teXObjectList.pop() : teXParser.popStack();
        }
        if (teXObject instanceof Group) {
            if (((Group)teXObject).size() == 0) {
                teXParser.getListener().getWriteable().write(this.getText(string, -1));
                return;
            }
            teXObjectList = ((Group)teXObject).toList();
            teXObject = teXObjectList.pop();
        }
        if (teXObject instanceof Expandable) {
            TeXObjectList teXObjectList2 = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList);
            if (teXObjectList2 != null) {
                if (teXObjectList == null) {
                    teXObjectList = teXObjectList2;
                } else {
                    teXObjectList.add(0, teXObjectList2);
                }
            }
            teXObject = teXObjectList.pop();
        }
        if (teXObject instanceof CharObject) {
            int n = ((CharObject)teXObject).getCharCode();
            teXParser.getListener().getWriteable().write(this.getText(string, n));
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
        if (teXObjectList != null && teXObjectList.size() > 0) {
            teXParser.push(teXObjectList);
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXObjectList == null || teXObjectList.size() == 0 || teXObjectList == teXParser) {
            this.process(teXParser);
            return;
        }
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        TeXObjectList teXObjectList2 = null;
        String string = this.name;
        if (this.name.equals("a")) {
            if (teXObject instanceof Group) {
                teXObject = ((Group)teXObject).toList();
            }
            if (teXObject instanceof Expandable) {
                teXObjectList2 = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList);
                teXObject = teXObjectList2 == null || teXObjectList2.size() == 0 ? (teXObjectList.size() == 0 ? teXParser.popNextArg() : teXObjectList.popArg(teXParser)) : teXObjectList2.popArg(teXParser);
            }
            if (!(teXObject instanceof CharObject)) {
                throw new TeXSyntaxException(teXParser, "tex.error.invalid_accent", teXObject.toString(teXParser));
            }
            string = "" + (char)((CharObject)teXObject).getCharCode();
            teXObject = teXObjectList2 != null && teXObjectList2.size() > 0 ? teXObjectList2.popArg(teXParser) : (teXObjectList.size() > 0 ? teXObjectList.popArg(teXParser) : teXParser.popNextArg());
        }
        if (teXObject instanceof Group) {
            if (((Group)teXObject).size() == 0) {
                teXParser.getListener().getWriteable().write(this.getText(string, -1));
                return;
            }
            teXObjectList2 = ((Group)teXObject).toList();
            teXObject = teXObjectList2.size() == 0 ? teXObjectList.popStack(teXParser) : teXObjectList2.popStack(teXParser);
        }
        if (teXObject instanceof Expandable) {
            TeXObjectList teXObjectList3 = null;
            teXObjectList3 = teXObjectList2 == null || teXObjectList2.size() == 0 ? ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList) : ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList2);
            if (teXObjectList3 != null) {
                if (teXObjectList2 == null) {
                    teXObjectList2 = teXObjectList3;
                } else {
                    teXObjectList2.add(0, teXObjectList3);
                }
            }
            teXObject = teXObjectList2.size() == 0 ? teXObjectList.popStack(teXParser) : teXObjectList2.popStack(teXParser);
        }
        if (!(teXObject instanceof CharObject)) {
            if (teXObjectList2 != null && teXObjectList2.size() > 0) {
                teXObjectList.push(teXObjectList2);
            }
            teXObject.process(teXParser, teXObjectList);
            throw new TeXSyntaxException(teXParser, "tex.error.invalid_accent", teXObject.toString(teXParser));
        }
        int n = ((CharObject)teXObject).getCharCode();
        teXParser.getListener().getWriteable().write(this.getText(string, n));
        if (teXObjectList2 != null && teXObjectList2.size() > 0) {
            teXObjectList.push(teXObjectList2);
        }
    }

    public static void addCommands(TeXParser teXParser) {
        teXParser.putControlSequence(new Accent("'"));
        teXParser.putControlSequence(new Accent("`"));
        teXParser.putControlSequence(new Accent("\""));
        teXParser.putControlSequence(new Accent("u"));
        teXParser.putControlSequence(new Accent("c"));
        teXParser.putControlSequence(new Accent("~"));
        teXParser.putControlSequence(new Accent("^"));
        teXParser.putControlSequence(new Accent("r"));
        teXParser.putControlSequence(new Accent("b"));
        teXParser.putControlSequence(new Accent("d"));
        teXParser.putControlSequence(new Accent("="));
        teXParser.putControlSequence(new Accent("."));
        teXParser.putControlSequence(new Accent("v"));
        teXParser.putControlSequence(new Accent("H"));
        teXParser.putControlSequence(new Accent("k"));
    }

    public static boolean isAccentCommand(String string) {
        if (string.length() != 1) {
            return false;
        }
        char c = string.charAt(0);
        return c == '`' || c == '\'' || c == '\"' || c == 'u' || c == 'c' || c == '~' || c == '^' || c == 'r' || c == 'b' || c == 'd' || c == '=' || c == '.' || c == 'v' || c == 'H' || c == 'k';
    }

    private String getText(String string, int n) throws IOException {
        if (string.equals("'")) {
            return this.getAccent(n, ACUTE_ACCENTS, 769);
        }
        if (string.equals("`")) {
            return this.getAccent(n, GRAVE_ACCENTS, 768);
        }
        if (string.equals("\"")) {
            return this.getAccent(n, UMLAUT_ACCENTS, 776);
        }
        if (string.equals("u")) {
            return this.getAccent(n, BREVE_ACCENTS, 774);
        }
        if (string.equals("c")) {
            return this.getAccent(n, CEDILLA_ACCENTS, 807);
        }
        if (string.equals("~")) {
            return this.getAccent(n, TILDE_ACCENTS, 771);
        }
        if (string.equals("^")) {
            return this.getAccent(n, CIRCUM_ACCENTS, 770);
        }
        if (string.equals("r")) {
            return this.getAccent(n, RING_ACCENTS, 778);
        }
        if (string.equals("b")) {
            return this.getAccent(n, UNDERBAR_ACCENTS, 800);
        }
        if (string.equals("d")) {
            return this.getAccent(n, DOT_UNDER_ACCENTS, 803);
        }
        if (string.equals("=")) {
            return this.getAccent(n, MACRON_ACCENTS, 772);
        }
        if (string.equals(".")) {
            return this.getAccent(n, DOT_ACCENTS, 775);
        }
        if (string.equals("v")) {
            return this.getAccent(n, CARON_ACCENTS, 780);
        }
        if (string.equals("H")) {
            return this.getAccent(n, DOUBLE_ACUTE_ACCENTS, 779);
        }
        if (string.equals("k")) {
            return this.getAccent(n, OGONEK_ACCENTS, 731);
        }
        return "" + (char)n;
    }

    private String getAccent(int n, int[][] nArray) throws IOException {
        return this.getAccent(n, nArray, -1);
    }

    private String getAccent(int n, int[][] nArray, int n2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(2);
        if (n == -1) {
            stringBuilder.append(' ');
            if (n2 != -1) {
                stringBuilder.appendCodePoint(n2);
            }
            return stringBuilder.toString();
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i][0]) continue;
            stringBuilder.appendCodePoint(nArray[i][1]);
            return stringBuilder.toString();
        }
        stringBuilder.appendCodePoint(n);
        if (n2 != -1) {
            stringBuilder.appendCodePoint(n2);
        }
        return stringBuilder.toString();
    }

    @Override
    public Object clone() {
        return new Accent(this.getName());
    }
}

