/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.io.FileNotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.HeadlessBootstrap;
import org.zaproxy.zap.ShutdownRequestedException;

class DaemonBootstrap
extends HeadlessBootstrap {
    private static final Logger LOGGER = LogManager.getLogger(DaemonBootstrap.class);

    public DaemonBootstrap(CommandLine cmdLineArgs) {
        super(cmdLineArgs);
    }

    @Override
    public int start() {
        int rc = super.start();
        if (rc != 0) {
            return rc;
        }
        View.setDaemon(true);
        LOGGER.info(DaemonBootstrap.getStartingMessage());
        try {
            this.initModel();
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                System.out.println(Constant.messages.getString("start.db.error"));
                System.out.println(e.getLocalizedMessage());
            }
            LOGGER.fatal(e.getMessage(), (Throwable)e);
            return 1;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Control control;
                try {
                    control = DaemonBootstrap.this.initControl();
                }
                catch (IllegalStateException e) {
                    System.err.println("Failed to start ZAP. " + e.getMessage());
                    return;
                }
                DaemonBootstrap.this.warnAddOnsAndExtensionsNoLongerRunnable();
                if (!DaemonBootstrap.this.handleCmdLineSessionArgsSynchronously(control)) {
                    return;
                }
                HeadlessBootstrap.checkForUpdates();
                try {
                    control.getExtensionLoader().hookCommandLineListener(DaemonBootstrap.this.getArgs());
                    DaemonBootstrap.this.recordStartStats();
                    control.runCommandLine();
                }
                catch (ShutdownRequestedException e) {
                    control.shutdown(false);
                    LOGGER.info("{} terminated.", (Object)Constant.PROGRAM_TITLE);
                    return;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(100000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        });
        t.setName("ZAP-daemon");
        t.start();
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

