﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appfabric/AppFabricRequest.h>
#include <aws/appfabric/AppFabric_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace AppFabric {
namespace Model {

/**
 */
class DeleteAppAuthorizationRequest : public AppFabricRequest {
 public:
  AWS_APPFABRIC_API DeleteAppAuthorizationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteAppAuthorization"; }

  AWS_APPFABRIC_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
   * app bundle to use for the request.</p>
   */
  inline const Aws::String& GetAppBundleIdentifier() const { return m_appBundleIdentifier; }
  inline bool AppBundleIdentifierHasBeenSet() const { return m_appBundleIdentifierHasBeenSet; }
  template <typename AppBundleIdentifierT = Aws::String>
  void SetAppBundleIdentifier(AppBundleIdentifierT&& value) {
    m_appBundleIdentifierHasBeenSet = true;
    m_appBundleIdentifier = std::forward<AppBundleIdentifierT>(value);
  }
  template <typename AppBundleIdentifierT = Aws::String>
  DeleteAppAuthorizationRequest& WithAppBundleIdentifier(AppBundleIdentifierT&& value) {
    SetAppBundleIdentifier(std::forward<AppBundleIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the
   * app authorization to use for the request.</p>
   */
  inline const Aws::String& GetAppAuthorizationIdentifier() const { return m_appAuthorizationIdentifier; }
  inline bool AppAuthorizationIdentifierHasBeenSet() const { return m_appAuthorizationIdentifierHasBeenSet; }
  template <typename AppAuthorizationIdentifierT = Aws::String>
  void SetAppAuthorizationIdentifier(AppAuthorizationIdentifierT&& value) {
    m_appAuthorizationIdentifierHasBeenSet = true;
    m_appAuthorizationIdentifier = std::forward<AppAuthorizationIdentifierT>(value);
  }
  template <typename AppAuthorizationIdentifierT = Aws::String>
  DeleteAppAuthorizationRequest& WithAppAuthorizationIdentifier(AppAuthorizationIdentifierT&& value) {
    SetAppAuthorizationIdentifier(std::forward<AppAuthorizationIdentifierT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_appBundleIdentifier;

  Aws::String m_appAuthorizationIdentifier;
  bool m_appBundleIdentifierHasBeenSet = false;
  bool m_appAuthorizationIdentifierHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppFabric
}  // namespace Aws
