﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/directconnect/DirectConnectRequest.h>
#include <aws/directconnect/DirectConnect_EXPORTS.h>

#include <utility>

namespace Aws {
namespace DirectConnect {
namespace Model {

/**
 */
class DeleteLagRequest : public DirectConnectRequest {
 public:
  AWS_DIRECTCONNECT_API DeleteLagRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteLag"; }

  AWS_DIRECTCONNECT_API Aws::String SerializePayload() const override;

  AWS_DIRECTCONNECT_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The ID of the LAG.</p>
   */
  inline const Aws::String& GetLagId() const { return m_lagId; }
  inline bool LagIdHasBeenSet() const { return m_lagIdHasBeenSet; }
  template <typename LagIdT = Aws::String>
  void SetLagId(LagIdT&& value) {
    m_lagIdHasBeenSet = true;
    m_lagId = std::forward<LagIdT>(value);
  }
  template <typename LagIdT = Aws::String>
  DeleteLagRequest& WithLagId(LagIdT&& value) {
    SetLagId(std::forward<LagIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_lagId;
  bool m_lagIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DirectConnect
}  // namespace Aws
