﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/AnalyticsIntentField.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {

/**
 * <p>Contains the category by which the intent analytics were grouped and a member
 * of that category.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/AnalyticsIntentGroupByKey">AWS
 * API Reference</a></p>
 */
class AnalyticsIntentGroupByKey {
 public:
  AWS_LEXMODELSV2_API AnalyticsIntentGroupByKey() = default;
  AWS_LEXMODELSV2_API AnalyticsIntentGroupByKey(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API AnalyticsIntentGroupByKey& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A category by which the intent analytics were grouped.</p>
   */
  inline AnalyticsIntentField GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  inline void SetName(AnalyticsIntentField value) {
    m_nameHasBeenSet = true;
    m_name = value;
  }
  inline AnalyticsIntentGroupByKey& WithName(AnalyticsIntentField value) {
    SetName(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A member of the category by which the intent analytics were grouped.</p>
   */
  inline const Aws::String& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = Aws::String>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = Aws::String>
  AnalyticsIntentGroupByKey& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}
 private:
  AnalyticsIntentField m_name{AnalyticsIntentField::NOT_SET};

  Aws::String m_value;
  bool m_nameHasBeenSet = false;
  bool m_valueHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
