﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/LaunchTemplateEbsBlockDevice.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {

/**
 * <p>Describes a block device mapping.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/LaunchTemplateBlockDeviceMapping">AWS
 * API Reference</a></p>
 */
class LaunchTemplateBlockDeviceMapping {
 public:
  AWS_EC2_API LaunchTemplateBlockDeviceMapping() = default;
  AWS_EC2_API LaunchTemplateBlockDeviceMapping(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_EC2_API LaunchTemplateBlockDeviceMapping& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_EC2_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_EC2_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The device name.</p>
   */
  inline const Aws::String& GetDeviceName() const { return m_deviceName; }
  inline bool DeviceNameHasBeenSet() const { return m_deviceNameHasBeenSet; }
  template <typename DeviceNameT = Aws::String>
  void SetDeviceName(DeviceNameT&& value) {
    m_deviceNameHasBeenSet = true;
    m_deviceName = std::forward<DeviceNameT>(value);
  }
  template <typename DeviceNameT = Aws::String>
  LaunchTemplateBlockDeviceMapping& WithDeviceName(DeviceNameT&& value) {
    SetDeviceName(std::forward<DeviceNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The virtual device name (ephemeralN).</p>
   */
  inline const Aws::String& GetVirtualName() const { return m_virtualName; }
  inline bool VirtualNameHasBeenSet() const { return m_virtualNameHasBeenSet; }
  template <typename VirtualNameT = Aws::String>
  void SetVirtualName(VirtualNameT&& value) {
    m_virtualNameHasBeenSet = true;
    m_virtualName = std::forward<VirtualNameT>(value);
  }
  template <typename VirtualNameT = Aws::String>
  LaunchTemplateBlockDeviceMapping& WithVirtualName(VirtualNameT&& value) {
    SetVirtualName(std::forward<VirtualNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the block device for an EBS volume.</p>
   */
  inline const LaunchTemplateEbsBlockDevice& GetEbs() const { return m_ebs; }
  inline bool EbsHasBeenSet() const { return m_ebsHasBeenSet; }
  template <typename EbsT = LaunchTemplateEbsBlockDevice>
  void SetEbs(EbsT&& value) {
    m_ebsHasBeenSet = true;
    m_ebs = std::forward<EbsT>(value);
  }
  template <typename EbsT = LaunchTemplateEbsBlockDevice>
  LaunchTemplateBlockDeviceMapping& WithEbs(EbsT&& value) {
    SetEbs(std::forward<EbsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>To omit the device from the block device mapping, specify an empty
   * string.</p>
   */
  inline const Aws::String& GetNoDevice() const { return m_noDevice; }
  inline bool NoDeviceHasBeenSet() const { return m_noDeviceHasBeenSet; }
  template <typename NoDeviceT = Aws::String>
  void SetNoDevice(NoDeviceT&& value) {
    m_noDeviceHasBeenSet = true;
    m_noDevice = std::forward<NoDeviceT>(value);
  }
  template <typename NoDeviceT = Aws::String>
  LaunchTemplateBlockDeviceMapping& WithNoDevice(NoDeviceT&& value) {
    SetNoDevice(std::forward<NoDeviceT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_deviceName;

  Aws::String m_virtualName;

  LaunchTemplateEbsBlockDevice m_ebs;

  Aws::String m_noDevice;
  bool m_deviceNameHasBeenSet = false;
  bool m_virtualNameHasBeenSet = false;
  bool m_ebsHasBeenSet = false;
  bool m_noDeviceHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
