/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.ColorProviderUtil;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.util.Direction;

public class TabLineBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private ColorProvider color;
    private Border border;
    private boolean last;
    private boolean afterHighlighted;
    private boolean highlighted;
    private boolean drawTopLine;
    private boolean drawBottomLine;
    private int index;
    private boolean tabSpacing;

    public TabLineBorder() {
        this(null);
    }

    public TabLineBorder(Color color) {
        this(color, false);
    }

    public TabLineBorder(Color color, boolean drawBottomLine) {
        this(color, drawBottomLine, true);
    }

    public TabLineBorder(boolean drawBottomLine, boolean drawTopLine) {
        this((Color)null, drawBottomLine, drawTopLine);
    }

    public TabLineBorder(Color color, boolean drawBottomLine, boolean drawTopLine) {
        this(ColorProviderUtil.getColorProvider(color, UIManagerColorProvider.TABBED_PANE_DARK_SHADOW), drawBottomLine, drawTopLine);
    }

    public TabLineBorder(ColorProvider colorProvider, boolean drawBottomLine, boolean drawTopLine) {
        this.color = colorProvider;
        this.border = new LineBorder();
        this.drawBottomLine = drawBottomLine;
        this.drawTopLine = drawTopLine;
    }

    public TabLineBorder(Color color, Border innerBorder) {
        this(color, innerBorder, false);
    }

    public TabLineBorder(Color color, Border innerBorder, boolean drawBottomLine) {
        this(color, drawBottomLine);
        if (innerBorder != null) {
            this.border = new CompoundBorder(this.border, innerBorder);
        }
    }

    public TabLineBorder(ColorProvider colorProvider, Border innerBorder, boolean drawBottomLine, boolean drawTopLine) {
        this(colorProvider, drawBottomLine, drawTopLine);
        if (innerBorder != null) {
            this.border = new CompoundBorder(this.border, innerBorder);
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.border.paintBorder(c, g, x, y, width, height);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.border.getBorderInsets(c);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    private void initialize(Tab tab) {
        this.index = tab.getTabbedPanel().getTabIndex(tab);
        this.last = this.index == tab.getTabbedPanel().getTabCount() - 1;
        this.afterHighlighted = this.index > 0 && tab.getTabbedPanel().getTabAt(this.index - 1) == tab.getTabbedPanel().getHighlightedTab();
        this.highlighted = tab == tab.getTabbedPanel().getHighlightedTab();
    }

    private class LineBorder
    implements Border {
        LineBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics g, int x, int y, int width, int height) {
            Color c = TabLineBorder.this.color.getColor(component);
            Tab tab = TabbedUtils.getParentTab(component);
            if (tab != null && tab.getTabbedPanel() != null) {
                Direction d = tab.getTabbedPanel().getProperties().getTabAreaOrientation();
                TabLineBorder.this.tabSpacing = tab.getTabbedPanel().getProperties().getTabSpacing() > 0;
                TabLineBorder.this.initialize(tab);
                if (d == Direction.UP) {
                    this.paintUpBorder(g, x, y, width, height, c);
                } else if (d == Direction.LEFT) {
                    this.paintLeftBorder(g, x, y, width, height, c);
                } else if (d == Direction.DOWN) {
                    this.paintDownBorder(g, x, y, width, height, c);
                } else {
                    this.paintRightBorder(g, x, y, width, height, c);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Tab tab = TabbedUtils.getParentTab(c);
            if (tab != null && tab.getTabbedPanel() != null && tab.getParent() != null) {
                int right;
                int bottom;
                int left;
                int top;
                Direction d = tab.getTabbedPanel().getProperties().getTabAreaOrientation();
                TabLineBorder.this.initialize(tab);
                if (d == Direction.UP) {
                    top = TabLineBorder.this.drawTopLine ? 1 : 0;
                    left = 1;
                    bottom = 0;
                    right = 1;
                } else if (d == Direction.LEFT) {
                    top = 1;
                    left = TabLineBorder.this.drawTopLine ? 1 : 0;
                    bottom = 1;
                    right = 0;
                } else if (d == Direction.DOWN) {
                    top = 0;
                    left = 1;
                    bottom = TabLineBorder.this.drawTopLine ? 1 : 0;
                    right = 1;
                } else {
                    top = 1;
                    left = 0;
                    bottom = 1;
                    right = TabLineBorder.this.drawTopLine ? 1 : 0;
                }
                return new Insets(top, left, bottom, right);
            }
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        private void paintUpBorder(Graphics g, int x, int y, int width, int height, Color color) {
            g.setColor(color);
            if (!TabLineBorder.this.afterHighlighted || TabLineBorder.this.tabSpacing) {
                g.drawLine(x, y, x, y + height - 1);
            }
            if (TabLineBorder.this.highlighted || TabLineBorder.this.last || TabLineBorder.this.tabSpacing) {
                g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            }
            if (TabLineBorder.this.drawTopLine) {
                g.drawLine(x, y, x + width - 1, y);
            }
            if (TabLineBorder.this.drawBottomLine) {
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            }
        }

        private void paintLeftBorder(Graphics g, int x, int y, int width, int height, Color color) {
            g.setColor(color);
            if (!TabLineBorder.this.afterHighlighted || TabLineBorder.this.tabSpacing) {
                g.drawLine(x, y, x + width - 1, y);
            }
            if (TabLineBorder.this.drawTopLine) {
                g.drawLine(x, y, x, y + height - 1);
            }
            if (TabLineBorder.this.highlighted || TabLineBorder.this.last || TabLineBorder.this.tabSpacing) {
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            }
            if (TabLineBorder.this.drawBottomLine) {
                g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            }
        }

        private void paintDownBorder(Graphics g, int x, int y, int width, int height, Color color) {
            g.setColor(color);
            if (!TabLineBorder.this.afterHighlighted || TabLineBorder.this.tabSpacing) {
                g.drawLine(x, y, x, y + height - 1);
            }
            if (TabLineBorder.this.highlighted || TabLineBorder.this.last || TabLineBorder.this.tabSpacing) {
                g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            }
            if (TabLineBorder.this.drawTopLine) {
                g.drawLine(x, y + height - 1, x + width, y + height - 1);
            }
            if (TabLineBorder.this.drawBottomLine) {
                g.drawLine(x, y, x + width, y);
            }
        }

        private void paintRightBorder(Graphics g, int x, int y, int width, int height, Color color) {
            g.setColor(color);
            if (!TabLineBorder.this.afterHighlighted || TabLineBorder.this.tabSpacing) {
                g.drawLine(x, y, x + width - 1, y);
            }
            if (TabLineBorder.this.drawTopLine) {
                g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            }
            if (TabLineBorder.this.highlighted || TabLineBorder.this.last || TabLineBorder.this.tabSpacing) {
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            }
            if (TabLineBorder.this.drawBottomLine) {
                g.drawLine(x, y, x, y + height - 1);
            }
        }
    }
}

