/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.lang.reflect.Array;
import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.jdbc.DelegatingJdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class JsonArrayViaElementArgumentReturnTypeResolver
implements FunctionReturnTypeResolver {
    public static final FunctionReturnTypeResolver INSTANCE = new JsonArrayViaElementArgumentReturnTypeResolver();

    private JsonArrayViaElementArgumentReturnTypeResolver() {
    }

    @Override
    public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, @Nullable SqmToSqlAstConverter converter, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
        if (converter != null) {
            if (converter.isInTypeInference()) {
                return null;
            }
            MappingModelExpressible<?> inferredType = converter.resolveFunctionImpliedReturnType();
            if (inferredType != null) {
                if (inferredType instanceof ReturnableType) {
                    ReturnableType returnableType = (ReturnableType)((Object)inferredType);
                    return returnableType;
                }
                if (inferredType instanceof BasicValuedMapping) {
                    BasicValuedMapping basicValuedMapping = (BasicValuedMapping)inferredType;
                    return (ReturnableType)((Object)basicValuedMapping.getJdbcMapping());
                }
            }
        }
        if (impliedType != null) {
            return impliedType;
        }
        for (SqmTypedNode<?> argument : arguments) {
            SqmDomainType sqmType = argument.getExpressible().getSqmType();
            if (!(sqmType instanceof ReturnableType)) continue;
            return JsonArrayViaElementArgumentReturnTypeResolver.resolveJsonArrayType(sqmType, typeConfiguration);
        }
        return null;
    }

    @Override
    public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
        return null;
    }

    @AllowReflection
    public static <T> BasicType<?> resolveJsonArrayType(DomainType<T> elementType, TypeConfiguration typeConfiguration) {
        Class<?> arrayClass = Array.newInstance(elementType.getJavaType(), 0).getClass();
        BasicPluralJavaType arrayJavaType = (BasicPluralJavaType)((Object)typeConfiguration.getJavaTypeRegistry().getDescriptor(arrayClass));
        JdbcTypeIndicators currentBaseSqlTypeIndicators = typeConfiguration.getCurrentBaseSqlTypeIndicators();
        return arrayJavaType.resolveType(typeConfiguration, currentBaseSqlTypeIndicators.getDialect(), (BasicType)elementType, null, new DelegatingJdbcTypeIndicators(currentBaseSqlTypeIndicators){

            @Override
            public Integer getExplicitJdbcTypeCode() {
                return 3018;
            }

            @Override
            public int getPreferredSqlTypeCodeForArray(int elementSqlTypeCode) {
                return 3018;
            }
        });
    }
}

