/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import javax.json.JsonValue;
import oracle.jdbc.driver.json.binary.JsonpOsonArray;
import oracle.jdbc.driver.json.binary.JsonpOsonObject;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonValueFactory;
import oracle.jdbc.driver.json.tree.JsonpPrimitive;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonValue;

public class JsonpOsonValueFactory
extends OsonValueFactory {
    public static JsonpOsonValueFactory INSTANCE = new JsonpOsonValueFactory();

    @Override
    Object createBinary(OsonContext ctx, int pos, int len, boolean isId) {
        byte[] raw = new byte[len];
        ctx.b.position(pos);
        ctx.b.get(raw);
        return new JsonpPrimitive.JsonpBinaryImpl(raw, isId);
    }

    @Override
    public OsonAbstractArray createArray(OsonContext ctx, int pos) {
        return new JsonpOsonArray(ctx, pos);
    }

    @Override
    public OsonAbstractObject createObject(OsonContext ctx, int pos) {
        return new JsonpOsonObject(ctx, pos);
    }

    @Override
    public JsonpPrimitive.JsonpStringImpl createString(OsonContext ctx, int pos, int len) {
        ctx.b.position(pos);
        return new JsonpPrimitive.JsonpStringImpl(ctx.b.readString(len));
    }

    @Override
    public JsonpPrimitive.JsonpNumberImpl createNumber(byte[] raw, OracleJsonDecimal.TargetType type) {
        return new JsonpPrimitive.JsonpNumberImpl(raw, type);
    }

    @Override
    public JsonpPrimitive.JsonpStringNumberImpl createStringNumber(String value) {
        return new JsonpPrimitive.JsonpStringNumberImpl(value);
    }

    @Override
    public JsonpPrimitive.JsonpDoubleImpl createDouble(double value) {
        return new JsonpPrimitive.JsonpDoubleImpl(value);
    }

    @Override
    public JsonpPrimitive.JsonpTimestampImpl createTimestamp(byte[] raw) {
        return new JsonpPrimitive.JsonpTimestampImpl(raw);
    }

    @Override
    public Object createTimestampTZ(byte[] raw) {
        return new JsonpPrimitive.JsonpTimestampTZImpl(raw);
    }

    @Override
    public JsonpPrimitive.JsonpFloatImpl createFloat(float flt) {
        return new JsonpPrimitive.JsonpFloatImpl(flt);
    }

    @Override
    public JsonpPrimitive.JsonpDateImpl createDate(byte[] raw) {
        return new JsonpPrimitive.JsonpDateImpl(raw);
    }

    @Override
    public JsonpPrimitive.JsonpIntervalYMImpl createIntervalYM(byte[] raw) {
        return new JsonpPrimitive.JsonpIntervalYMImpl(raw);
    }

    @Override
    public JsonpPrimitive.JsonpIntervalDSImpl createIntervalDS(byte[] raw) {
        return new JsonpPrimitive.JsonpIntervalDSImpl(raw);
    }

    @Override
    public Object createTrue() {
        return JsonValue.TRUE;
    }

    @Override
    public Object createFalse() {
        return JsonValue.FALSE;
    }

    @Override
    public Object createNull() {
        return JsonValue.NULL;
    }

    @Override
    Object createVector(OsonContext ctx, int pos, int len) {
        throw new UnsupportedOperationException(OracleJsonValue.OracleJsonType.VECTOR.toString());
    }
}

