/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

import * as ReactDOM from 'react-dom';

/**
 * Root interface for React 16 compatibility with React 18's createRoot API
 */

/**
 * Shim for React 18's createRoot API
 * This provides a compatible API for React 16 using ReactDOM.render
 *
 * @param container The DOM element to render into
 * @returns A root object with render and unmount methods
 */
export function createRoot(container) {
  return {
    render: function render(element) {
      ReactDOM.render(element, container);
    },
    unmount: function unmount() {
      ReactDOM.unmountComponentAtNode(container);
    }
  };
}