"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ouiResizableButtonWithControls = ouiResizableButtonWithControls;
Object.defineProperty(exports, "EuiResizableButton", {
  enumerable: true,
  get: function get() {
    return _resizable_button.EuiResizableButton;
  }
});
Object.defineProperty(exports, "euiResizableButtonWithControls", {
  enumerable: true,
  get: function get() {
    return _resizable_button.euiResizableButtonWithControls;
  }
});
exports.OuiResizableButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../i18n");
var _services = require("../../services");
var _context = require("./context");
var _resizable_button = require("../../eui_components/resizable_container/resizable_button");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) { ; } } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var generatePanelId = (0, _services.htmlIdGenerator)('resizable-button');
var OuiResizableButton = function OuiResizableButton(_ref) {
  var isHorizontal = _ref.isHorizontal,
    className = _ref.className,
    id = _ref.id,
    registration = _ref.registration,
    disabled = _ref.disabled,
    onFocus = _ref.onFocus,
    onBlur = _ref.onBlur,
    rest = _objectWithoutProperties(_ref, ["isHorizontal", "className", "id", "registration", "disabled", "onFocus", "onBlur"]);
  var resizerId = (0, _react.useRef)(id || generatePanelId());
  var _useOuiResizableConta = (0, _context.useOuiResizableContainerContext)(),
    _useOuiResizableConta2 = _useOuiResizableConta.registry;
  _useOuiResizableConta2 = _useOuiResizableConta2 === void 0 ? {
    resizers: {}
  } : _useOuiResizableConta2;
  var resizers = _useOuiResizableConta2.resizers;
  var isDisabled = (0, _react.useMemo)(function () {
    return disabled || resizers[resizerId.current] && resizers[resizerId.current].isDisabled;
  }, [resizers, disabled]);
  var classes = (0, _classnames.default)('ouiResizableButton', {
    'ouiResizableButton--vertical': !isHorizontal,
    'ouiResizableButton--horizontal': isHorizontal,
    'ouiResizableButton--disabled': isDisabled
  }, className);
  var previousRef = (0, _react.useRef)();
  var onRef = (0, _react.useCallback)(function (ref) {
    if (!registration) return;
    var id = resizerId.current;
    if (ref) {
      previousRef.current = ref;
      registration.register({
        id: id,
        ref: ref,
        isFocused: false,
        isDisabled: disabled || false
      });
    } else {
      if (previousRef.current != null) {
        registration.deregister(id);
        previousRef.current = undefined;
      }
    }
  }, [registration, disabled]);
  var setFocus = function setFocus(e) {
    return e.currentTarget.focus();
  };
  var handleFocus = function handleFocus() {
    onFocus && onFocus(resizerId.current);
  };
  return /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    tokens: ['ouiResizableButton.horizontalResizerAriaLabel', 'ouiResizableButton.verticalResizerAriaLabel'],
    defaults: ['Press left or right to adjust panels size', 'Press up or down to adjust panels size']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      horizontalResizerAriaLabel = _ref3[0],
      verticalResizerAriaLabel = _ref3[1];
    return /*#__PURE__*/_react.default.createElement("button", _extends({
      id: resizerId.current,
      ref: onRef,
      "aria-label": isHorizontal ? horizontalResizerAriaLabel : verticalResizerAriaLabel,
      className: classes,
      "data-test-subj": "ouiResizableButton",
      type: "button",
      onClick: setFocus,
      onFocus: handleFocus,
      onBlur: onBlur,
      disabled: isDisabled
    }, rest));
  });
};
exports.OuiResizableButton = OuiResizableButton;
OuiResizableButton.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};
function ouiResizableButtonWithControls(controls) {
  return function (props) {
    return /*#__PURE__*/_react.default.createElement(OuiResizableButton, _extends({}, controls, props));
  };
}

/* OUI -> EUI Aliases: Build-Time */
/* OUI -> EUI Aliases: Build-Time */