/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.util.IterableUtil;

public abstract class AbstractComparisonStrategy
implements ComparisonStrategy {
    @Override
    public Iterable<?> duplicatesFrom(Iterable<?> iterable) {
        if (IterableUtil.isNullOrEmpty(iterable)) {
            return Collections.EMPTY_SET;
        }
        Set<Object> noDuplicates = this.newSetUsingComparisonStrategy();
        LinkedHashSet duplicatesWithOrderPreserved = new LinkedHashSet();
        for (Object element : iterable) {
            if (noDuplicates.contains(element)) {
                duplicatesWithOrderPreserved.add(element);
                continue;
            }
            noDuplicates.add(element);
        }
        return duplicatesWithOrderPreserved;
    }

    protected abstract Set<Object> newSetUsingComparisonStrategy();

    @Override
    public boolean arrayContains(Object array, Object value) {
        for (int i2 = 0; i2 < Array.getLength(array); ++i2) {
            Object element = Array.get(array, i2);
            if (!this.areEqual(element, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLessThan(Object actual, Object other) {
        return !this.isGreaterThanOrEqualTo(actual, other);
    }

    @Override
    public boolean isLessThanOrEqualTo(Object actual, Object other) {
        return !this.isGreaterThan(actual, other);
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Object actual, Object other) {
        return this.areEqual(actual, other) || this.isGreaterThan(actual, other);
    }

    @Override
    public boolean isStandard() {
        return false;
    }
}

