/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jackhuang.hmcl.download.MaintainTask;
import org.jackhuang.hmcl.download.game.VersionJsonSaveTask;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventBus;
import org.jackhuang.hmcl.event.GameJsonParseFailedEvent;
import org.jackhuang.hmcl.event.LoadedOneVersionEvent;
import org.jackhuang.hmcl.event.RefreshedVersionsEvent;
import org.jackhuang.hmcl.event.RefreshingVersionsEvent;
import org.jackhuang.hmcl.event.RemoveVersionEvent;
import org.jackhuang.hmcl.event.RenameVersionEvent;
import org.jackhuang.hmcl.game.Artifact;
import org.jackhuang.hmcl.game.AssetIndex;
import org.jackhuang.hmcl.game.AssetObject;
import org.jackhuang.hmcl.game.ClassicVersion;
import org.jackhuang.hmcl.game.GameDirectoryType;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.GameVersion;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.LoggingInfo;
import org.jackhuang.hmcl.game.SimpleVersionProvider;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.game.VersionNotFoundException;
import org.jackhuang.hmcl.game.tlauncher.TLauncherVersion;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jetbrains.annotations.Nullable;

public class DefaultGameRepository
implements GameRepository {
    private Path baseDirectory;
    protected Map<String, Version> versions;
    private final ConcurrentHashMap<Path, Optional<String>> gameVersions = new ConcurrentHashMap();

    public DefaultGameRepository(Path baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public Path getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(Path baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    @Override
    public boolean hasVersion(String id) {
        return id != null && this.versions.containsKey(id);
    }

    @Override
    public Version getVersion(String id) {
        if (!this.hasVersion(id)) {
            throw new VersionNotFoundException("Version '" + id + "' does not exist in " + String.valueOf(this.versions.keySet()) + ".");
        }
        return this.versions.get(id);
    }

    @Override
    public int getVersionCount() {
        return this.versions.size();
    }

    @Override
    public Collection<Version> getVersions() {
        return this.versions.values();
    }

    @Override
    public Path getLibrariesDirectory(Version version) {
        return this.getBaseDirectory().resolve("libraries");
    }

    @Override
    public Path getLibraryFile(Version version, Library lib) {
        if ("local".equals(lib.getHint())) {
            if (lib.getFileName() != null) {
                return this.getVersionRoot(version.getId()).resolve("libraries/" + lib.getFileName());
            }
            return this.getVersionRoot(version.getId()).resolve("libraries/" + lib.getArtifact().getFileName());
        }
        return this.getLibrariesDirectory(version).resolve(lib.getPath());
    }

    public Path getArtifactFile(Version version, Artifact artifact) {
        return artifact.getPath(this.getBaseDirectory().resolve("libraries"));
    }

    public GameDirectoryType getGameDirectoryType(String id) {
        return GameDirectoryType.ROOT_FOLDER;
    }

    @Override
    public Path getRunDirectory(String id) {
        return switch (this.getGameDirectoryType(id)) {
            case GameDirectoryType.VERSION_FOLDER -> this.getVersionRoot(id);
            case GameDirectoryType.ROOT_FOLDER -> this.getBaseDirectory();
            default -> throw new IllegalStateException();
        };
    }

    @Override
    public Path getVersionJar(Version version) {
        Version v = version.resolve(this);
        String id = Optional.ofNullable(v.getJar()).orElse(v.getId());
        return this.getVersionRoot(id).resolve(id + ".jar");
    }

    @Override
    public Optional<String> getGameVersion(Version version) {
        return this.gameVersions.computeIfAbsent(this.getVersionJar(version), versionJar -> {
            Optional<String> gameVersion = GameVersion.minecraftVersion(versionJar);
            if (gameVersion.isEmpty()) {
                Logger.LOG.warning("Cannot find out game version of " + version.getId() + ", primary jar: " + versionJar.toString() + ", jar exists: " + Files.exists(versionJar, new LinkOption[0]));
            }
            return gameVersion;
        });
    }

    @Override
    public Path getNativeDirectory(String id, Platform platform) {
        return this.getVersionRoot(id).resolve("natives-" + String.valueOf(platform));
    }

    @Override
    public Path getModsDirectory(String id) {
        return this.getRunDirectory(id).resolve("mods");
    }

    @Override
    public Path getVersionRoot(String id) {
        return this.getBaseDirectory().resolve("versions/" + id);
    }

    public Path getVersionJson(String id) {
        return this.getVersionRoot(id).resolve(id + ".json");
    }

    public Version readVersionJson(String id) throws IOException, JsonParseException {
        return this.readVersionJson(this.getVersionJson(id));
    }

    public Version readVersionJson(Path file) throws IOException, JsonParseException {
        String jsonText = Files.readString(file);
        try {
            return JsonUtils.fromNonNullJson(jsonText, TLauncherVersion.class).toVersion();
        }
        catch (JsonParseException jsonParseException) {
            try {
                return JsonUtils.fromNonNullJson(jsonText, Version.class);
            }
            catch (JsonParseException jsonParseException2) {
                Logger.LOG.warning("Cannot parse version json: " + String.valueOf(file) + "\n" + jsonText);
                throw new JsonParseException("Version json incorrect");
            }
        }
    }

    @Override
    public boolean renameVersion(String from, String to) {
        if (EventBus.EVENT_BUS.fireEvent(new RenameVersionEvent(this, from, to)) == Event.Result.DENY) {
            return false;
        }
        try {
            Version fromVersion = this.getVersion(from);
            Path fromDir = this.getVersionRoot(from);
            Path toDir = this.getVersionRoot(to);
            Files.move(fromDir, toDir, new CopyOption[0]);
            Path fromJson = toDir.resolve(from + ".json");
            Path fromJar = toDir.resolve(from + ".jar");
            Path toJson = toDir.resolve(to + ".json");
            Path toJar = toDir.resolve(to + ".jar");
            boolean hasJarFile = Files.exists(fromJar, new LinkOption[0]);
            try {
                Files.move(fromJson, toJson, new CopyOption[0]);
                if (hasJarFile) {
                    Files.move(fromJar, toJar, new CopyOption[0]);
                }
            }
            catch (IOException e) {
                Lang.ignoringException(() -> Files.move(toJson, fromJson, new CopyOption[0]));
                if (hasJarFile) {
                    Lang.ignoringException(() -> Files.move(toJar, fromJar, new CopyOption[0]));
                }
                Lang.ignoringException(() -> Files.move(toDir, fromDir, new CopyOption[0]));
                throw e;
            }
            if (fromVersion.getId().equals(fromVersion.getJar())) {
                fromVersion = fromVersion.setJar(null);
            }
            JsonUtils.writeToJsonFile(toJson, fromVersion.setId(to));
            for (Version version : this.getVersions()) {
                if (!from.equals(version.getInheritsFrom())) continue;
                Path targetPath = this.getVersionJson(version.getId());
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                JsonUtils.writeToJsonFile(targetPath, version.setInheritsFrom(to));
            }
            return true;
        }
        catch (JsonParseException | IOException | InvalidPathException | VersionNotFoundException e) {
            Logger.LOG.warning("Unable to rename version " + from + " to " + to, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeVersionFromDisk(String id) {
        if (EventBus.EVENT_BUS.fireEvent(new RemoveVersionEvent(this, id)) == Event.Result.DENY) {
            return false;
        }
        if (!this.versions.containsKey(id)) {
            return FileUtils.deleteDirectoryQuietly(this.getVersionRoot(id));
        }
        Path file = this.getVersionRoot(id);
        if (Files.notExists(file, new LinkOption[0])) {
            return true;
        }
        Path removedFile = file.toAbsolutePath().resolveSibling(FileUtils.getName(file) + "_removed");
        try {
            Files.move(file, removedFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to rename file " + String.valueOf(file), e);
            return false;
        }
        try {
            this.versions.remove(id);
            if (FileUtils.moveToTrash(removedFile)) {
                boolean e = true;
                return e;
            }
            for (Path path : FileUtils.listFilesByExtension(removedFile, "json")) {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to delete file " + String.valueOf(path), e);
                }
            }
            try {
                FileUtils.deleteDirectory(removedFile);
            }
            catch (IOException e) {
                Logger.LOG.warning("Unable to remove version folder: " + String.valueOf(file), e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.refreshVersionsAsync().start();
        }
    }

    protected void refreshVersionsImpl() {
        TreeMap<String, Version> versions = new TreeMap<String, Version>();
        if (ClassicVersion.hasClassicVersion(this.getBaseDirectory())) {
            ClassicVersion version = new ClassicVersion();
            versions.put(version.getId(), version);
        }
        SimpleVersionProvider provider = new SimpleVersionProvider();
        Path versionsDir = this.getBaseDirectory().resolve("versions");
        if (Files.isDirectory(versionsDir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(versionsDir);){
                ((Stream)stream.parallel()).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(dir -> {
                    Version version;
                    String id = FileUtils.getName(dir);
                    Path json = dir.resolve(id + ".json");
                    if (Files.notExists(json, new LinkOption[0])) {
                        List<Path> jsons = FileUtils.listFilesByExtension(dir, "json");
                        if (jsons.size() == 1) {
                            Logger.LOG.info("Renaming json file " + String.valueOf(jsons.get(0)) + " to " + String.valueOf(json));
                            try {
                                Files.move(jsons.get(0), json, new CopyOption[0]);
                            }
                            catch (IOException e) {
                                Logger.LOG.warning("Cannot rename json file, ignoring version " + id, e);
                                return Stream.empty();
                            }
                            Path jar = dir.resolve(FileUtils.getNameWithoutExtension(jsons.get(0)) + ".jar");
                            if (Files.exists(jar, new LinkOption[0])) {
                                try {
                                    Files.move(jar, dir.resolve(id + ".jar"), new CopyOption[0]);
                                }
                                catch (IOException e) {
                                    Logger.LOG.warning("Cannot rename jar file, ignoring version " + id, e);
                                    return Stream.empty();
                                }
                            }
                        } else {
                            Logger.LOG.info("No available json file found, ignoring version " + id);
                            return Stream.empty();
                        }
                    }
                    try {
                        version = this.readVersionJson(json);
                    }
                    catch (Exception e) {
                        Logger.LOG.warning("Malformed version json " + id, e);
                        if (EventBus.EVENT_BUS.fireEvent(new GameJsonParseFailedEvent(this, json, id)) != Event.Result.ALLOW) {
                            return Stream.empty();
                        }
                        try {
                            version = this.readVersionJson(json);
                        }
                        catch (Exception e2) {
                            Logger.LOG.error("User corrected version json is still malformed", e2);
                            return Stream.empty();
                        }
                    }
                    if (!id.equals(version.getId())) {
                        try {
                            String from = id;
                            String to = version.getId();
                            Path fromDir = this.getVersionRoot(from);
                            Path toDir = this.getVersionRoot(to);
                            Files.move(fromDir, toDir, new CopyOption[0]);
                            Path fromJson = toDir.resolve(from + ".json");
                            Path fromJar = toDir.resolve(from + ".jar");
                            Path toJson = toDir.resolve(to + ".json");
                            Path toJar = toDir.resolve(to + ".jar");
                            try {
                                Files.move(fromJson, toJson, new CopyOption[0]);
                                if (Files.exists(fromJar, new LinkOption[0])) {
                                    Files.move(fromJar, toJar, new CopyOption[0]);
                                }
                            }
                            catch (IOException e) {
                                Lang.ignoringException(() -> Files.move(toJson, fromJson, new CopyOption[0]));
                                Lang.ignoringException(() -> Files.move(toJar, fromJar, new CopyOption[0]));
                                Lang.ignoringException(() -> Files.move(toDir, fromDir, new CopyOption[0]));
                                throw e;
                            }
                        }
                        catch (IOException e) {
                            Logger.LOG.warning("Ignoring version " + version.getId() + " because version id does not match folder name " + id + ", and we cannot correct it.", e);
                            return Stream.empty();
                        }
                    }
                    return Stream.of(version);
                }).forEachOrdered(provider::addVersion);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to load versions from " + String.valueOf(versionsDir), e);
            }
        }
        for (Version version : provider.getVersionMap().values()) {
            try {
                Version resolved = version.resolve(provider);
                if (!resolved.appliesToCurrentEnvironment() || EventBus.EVENT_BUS.fireEvent(new LoadedOneVersionEvent(this, resolved)) == Event.Result.DENY) continue;
                versions.put(version.getId(), version);
            }
            catch (VersionNotFoundException e) {
                Logger.LOG.warning("Ignoring version " + version.getId() + " because it inherits from a nonexistent version.");
            }
        }
        this.gameVersions.clear();
        this.versions = versions;
    }

    @Override
    public void refreshVersions() {
        if (EventBus.EVENT_BUS.fireEvent(new RefreshingVersionsEvent(this)) == Event.Result.DENY) {
            return;
        }
        this.refreshVersionsImpl();
        EventBus.EVENT_BUS.fireEvent(new RefreshedVersionsEvent(this));
    }

    @Override
    public AssetIndex getAssetIndex(String version, String assetId) throws IOException {
        try {
            return Objects.requireNonNull(JsonUtils.fromJsonFile(this.getIndexFile(version, assetId), AssetIndex.class));
        }
        catch (JsonParseException | NullPointerException e) {
            throw new IOException("Asset index file malformed", e);
        }
    }

    @Override
    public Path getActualAssetDirectory(String version, String assetId) {
        try {
            return this.reconstructAssets(version, assetId);
        }
        catch (JsonParseException | IOException e) {
            Logger.LOG.error("Unable to reconstruct asset directory", e);
            return this.getAssetDirectory(version, assetId);
        }
    }

    @Override
    public Path getAssetDirectory(String version, String assetId) {
        return this.getBaseDirectory().resolve("assets");
    }

    @Override
    public Optional<Path> getAssetObject(String version, String assetId, String name) throws IOException {
        try {
            AssetObject assetObject = this.getAssetIndex(version, assetId).getObjects().get(name);
            if (assetObject == null) {
                return Optional.empty();
            }
            return Optional.of(this.getAssetObject(version, assetId, assetObject));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Unrecognized asset object " + name + " in asset " + assetId + " of version " + version, e);
        }
    }

    @Override
    public Path getAssetObject(String version, String assetId, AssetObject obj) {
        return this.getAssetObject(version, this.getAssetDirectory(version, assetId), obj);
    }

    public Path getAssetObject(String version, Path assetDir, AssetObject obj) {
        return assetDir.resolve("objects").resolve(obj.getLocation());
    }

    @Override
    public Path getIndexFile(String version, String assetId) {
        return this.getAssetDirectory(version, assetId).resolve("indexes").resolve(assetId + ".json");
    }

    @Override
    public Path getLoggingObject(String version, String assetId, LoggingInfo loggingInfo) {
        return this.getAssetDirectory(version, assetId).resolve("log_configs").resolve(loggingInfo.getFile().getId());
    }

    protected Path reconstructAssets(String version, String assetId) throws IOException, JsonParseException {
        Path assetsDir = this.getAssetDirectory(version, assetId);
        Path indexFile = this.getIndexFile(version, assetId);
        Path virtualRoot = assetsDir.resolve("virtual").resolve(assetId);
        if (!Files.isRegularFile(indexFile, new LinkOption[0])) {
            return assetsDir;
        }
        AssetIndex index = JsonUtils.fromJsonFile(indexFile, AssetIndex.class);
        if (index == null) {
            return assetsDir;
        }
        if (index.isVirtual()) {
            Path resourcesDir = this.getRunDirectory(version).resolve("resources");
            int cnt = 0;
            int tot = index.getObjects().size();
            for (Map.Entry<String, AssetObject> entry : index.getObjects().entrySet()) {
                Path target = virtualRoot.resolve(entry.getKey());
                Path original = this.getAssetObject(version, assetsDir, entry.getValue());
                if (!Files.exists(original, new LinkOption[0])) continue;
                ++cnt;
                if (!Files.isRegularFile(target, new LinkOption[0])) {
                    FileUtils.copyFile(original, target);
                }
                if (!index.needMapToResources() || Files.isRegularFile(target = resourcesDir.resolve(entry.getKey()), new LinkOption[0])) continue;
                FileUtils.copyFile(original, target);
            }
            if (cnt * 10 < tot) {
                return assetsDir;
            }
            return virtualRoot;
        }
        return assetsDir;
    }

    public Task<Version> saveAsync(Version version) {
        this.gameVersions.remove(this.getVersionJar(version));
        if (version.isResolvedPreservingPatches()) {
            return new VersionJsonSaveTask(this, MaintainTask.maintainPreservingPatches(this, version));
        }
        return new VersionJsonSaveTask(this, version);
    }

    public boolean isLoaded() {
        return this.versions != null;
    }

    public Path getModpackConfiguration(String version) {
        return this.getVersionRoot(version).resolve("modpack.json");
    }

    @Nullable
    public ModpackConfiguration<?> readModpackConfiguration(String version) throws IOException, VersionNotFoundException {
        if (!this.hasVersion(version)) {
            throw new VersionNotFoundException(version);
        }
        Path file = this.getModpackConfiguration(version);
        if (Files.notExists(file, new LinkOption[0])) {
            return null;
        }
        return JsonUtils.fromJsonFile(file, ModpackConfiguration.class);
    }

    public boolean isModpack(String version) {
        return Files.exists(this.getModpackConfiguration(version), new LinkOption[0]);
    }

    public ModManager getModManager(String version) {
        return new ModManager(this, version);
    }

    public Path getSavesDirectory(String id) {
        return this.getRunDirectory(id).resolve("saves");
    }

    public Path getBackupsDirectory(String id) {
        return this.getRunDirectory(id).resolve("backups");
    }

    public Path getSchematicsDirectory(String id) {
        return this.getRunDirectory(id).resolve("schematics");
    }

    public String toString() {
        return new ToStringBuilder(this).append("versions", this.versions == null ? null : this.versions.keySet()).append("baseDirectory", this.baseDirectory).toString();
    }
}

