/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.SingleSelectionModel;

public interface TabControl {
    public ObservableList<Tab<?>> getTabs();

    public static final class Tab<T extends Node> {
        private final StringProperty id = new SimpleStringProperty((Object)this, "id");
        private final StringProperty text = new SimpleStringProperty((Object)this, "text");
        private final ReadOnlyBooleanWrapper selected = new ReadOnlyBooleanWrapper((Object)this, "selected");
        private final ObjectProperty<T> node = new SimpleObjectProperty((Object)this, "node");
        private final ObjectProperty<Object> userData = new SimpleObjectProperty((Object)this, "userData");
        private Supplier<? extends T> nodeSupplier;

        public Tab(String id) {
            this.setId(id);
        }

        public Tab(String id, String text) {
            this.setId(id);
            this.setText(text);
        }

        public Supplier<? extends T> getNodeSupplier() {
            return this.nodeSupplier;
        }

        public void setNodeSupplier(Supplier<? extends T> nodeSupplier) {
            this.nodeSupplier = nodeSupplier;
        }

        public String getId() {
            return (String)this.id.get();
        }

        public StringProperty idProperty() {
            return this.id;
        }

        public void setId(String id) {
            this.id.set((Object)id);
        }

        public String getText() {
            return (String)this.text.get();
        }

        public StringProperty textProperty() {
            return this.text;
        }

        public void setText(String text) {
            this.text.set((Object)text);
        }

        public boolean isSelected() {
            return this.selected.get();
        }

        public ReadOnlyBooleanProperty selectedProperty() {
            return this.selected.getReadOnlyProperty();
        }

        private void setSelected(boolean selected) {
            this.selected.set(selected);
        }

        public T getNode() {
            return (T)((Node)this.node.get());
        }

        public ObjectProperty<T> nodeProperty() {
            return this.node;
        }

        public void setNode(T node) {
            this.node.set(node);
        }

        public Object getUserData() {
            return this.userData.get();
        }

        public ObjectProperty<?> userDataProperty() {
            return this.userData;
        }

        public void setUserData(Object userData) {
            this.userData.set(userData);
        }

        public boolean isInitialized() {
            return this.getNode() != null;
        }

        public boolean initializeIfNeeded() {
            if (this.getNode() == null) {
                if (this.getNodeSupplier() == null) {
                    return false;
                }
                this.setNode((Node)this.getNodeSupplier().get());
                return true;
            }
            return false;
        }
    }

    public static class TabControlSelectionModel
    extends SingleSelectionModel<Tab<?>> {
        private final TabControl tabHeader;

        public TabControlSelectionModel(TabControl t) {
            if (t == null) {
                throw new NullPointerException("TabPane can not be null");
            }
            this.tabHeader = t;
            ListChangeListener itemsContentObserver = c -> {
                while (c.next()) {
                    for (Tab tab : c.getRemoved()) {
                        if (tab == null || this.tabHeader.getTabs().contains((Object)tab) || !tab.isSelected()) continue;
                        tab.setSelected(false);
                        int tabIndex = c.getFrom();
                        this.findNearestAvailableTab(tabIndex, true);
                    }
                    if (!c.wasAdded() && !c.wasRemoved() || this.getSelectedIndex() == this.tabHeader.getTabs().indexOf(this.getSelectedItem())) continue;
                    this.clearAndSelect(this.tabHeader.getTabs().indexOf(this.getSelectedItem()));
                }
                if (this.getSelectedIndex() == -1 && this.getSelectedItem() == null && this.tabHeader.getTabs().size() > 0) {
                    this.findNearestAvailableTab(0, true);
                } else if (this.tabHeader.getTabs().isEmpty()) {
                    this.clearSelection();
                }
            };
            if (this.tabHeader.getTabs() != null) {
                this.tabHeader.getTabs().addListener(itemsContentObserver);
            }
        }

        public void select(int index) {
            if (index < 0 || this.getItemCount() > 0 && index >= this.getItemCount() || index == this.getSelectedIndex() && ((Tab)this.getModelItem(index)).isSelected()) {
                return;
            }
            if (this.getSelectedIndex() >= 0 && this.getSelectedIndex() < this.tabHeader.getTabs().size()) {
                ((Tab)this.tabHeader.getTabs().get(this.getSelectedIndex())).setSelected(false);
            }
            this.setSelectedIndex(index);
            Object tab = this.getModelItem(index);
            if (tab != null) {
                this.setSelectedItem(tab);
            }
            if (this.getSelectedIndex() >= 0 && this.getSelectedIndex() < this.tabHeader.getTabs().size()) {
                ((Tab)this.tabHeader.getTabs().get(this.getSelectedIndex())).setSelected(true);
            }
            ((Node)this.tabHeader).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
        }

        public void select(Tab tab) {
            int itemCount = this.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                Object value = this.getModelItem(i);
                if (value == null || !value.equals(tab)) continue;
                this.select(i);
                return;
            }
            if (tab != null) {
                this.setSelectedItem(tab);
            }
        }

        protected Tab<?> getModelItem(int index) {
            ObservableList<Tab<?>> items = this.tabHeader.getTabs();
            if (items == null) {
                return null;
            }
            if (index < 0 || index >= items.size()) {
                return null;
            }
            return (Tab)items.get(index);
        }

        protected int getItemCount() {
            ObservableList<Tab<?>> items = this.tabHeader.getTabs();
            return items == null ? 0 : items.size();
        }

        private Tab<?> findNearestAvailableTab(int tabIndex, boolean doSelect) {
            int tabCount = this.getItemCount();
            int i = 1;
            Object bestTab = null;
            while (true) {
                Object _tab;
                Object _tab2;
                int downPos;
                if ((downPos = tabIndex - i) >= 0 && (_tab2 = this.getModelItem(downPos)) != null) {
                    bestTab = _tab2;
                    break;
                }
                int upPos = tabIndex + i - 1;
                if (upPos < tabCount && (_tab = this.getModelItem(upPos)) != null) {
                    bestTab = _tab;
                    break;
                }
                if (downPos < 0 && upPos >= tabCount) break;
                ++i;
            }
            if (doSelect && bestTab != null) {
                this.select((Tab)bestTab);
            }
            return bestTab;
        }
    }
}

