/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n.translator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.util.i18n.SupportedLocale;
import org.jackhuang.hmcl.util.i18n.translator.Translator;
import org.jackhuang.hmcl.util.logging.Logger;

public class Translator_en_Qabs
extends Translator {
    private static final Map<Integer, Integer> MAPPER;
    private final SupportedLocale originalLocale = SupportedLocale.getLocale(Locale.ENGLISH);

    public static String translate(String str) {
        StringBuilder builder = new StringBuilder(str.length());
        str.codePoints().forEach(ch -> builder.appendCodePoint(MAPPER.getOrDefault(ch, ch)));
        return builder.reverse().toString();
    }

    public Translator_en_Qabs(SupportedLocale locale) {
        super(locale);
    }

    @Override
    public String getDisplayVersion(RemoteVersion remoteVersion) {
        return Translator_en_Qabs.translate(remoteVersion.getSelfVersion());
    }

    @Override
    public String formatDateTime(TemporalAccessor time) {
        return Translator_en_Qabs.translate(this.originalLocale.getTranslator().formatDateTime(time));
    }

    @Override
    public String formatSpeed(long bytes) {
        return Translator_en_Qabs.translate(this.originalLocale.getTranslator().formatSpeed(bytes));
    }

    static {
        LinkedHashMap map = new LinkedHashMap();
        InputStream inputStream = Translator_en_Qabs.class.getResourceAsStream("/assets/lang/upside_down.txt");
        if (inputStream != null) {
            try (InputStream inputStream2 = inputStream;){
                new String(inputStream.readAllBytes(), StandardCharsets.UTF_8).lines().forEach(line -> {
                    if (line.isBlank() || line.startsWith("#")) {
                        return;
                    }
                    if (line.length() != 2) {
                        Logger.LOG.warning("Invalid line: " + line);
                        return;
                    }
                    map.put(Integer.valueOf(line.charAt(0)), Integer.valueOf(line.charAt(1)));
                });
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to load upside_down.txt", e);
            }
        } else {
            Logger.LOG.warning("upside_down.txt not found");
        }
        MAPPER = Collections.unmodifiableMap(map);
    }
}

