/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.chardet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.glavo.chardet.CharsetListener;
import org.glavo.chardet.DetectedCharset;
import org.glavo.chardet.prober.CharsetProber;
import org.glavo.chardet.prober.EscCharsetProber;
import org.glavo.chardet.prober.Latin1Prober;
import org.glavo.chardet.prober.MBCSGroupProber;
import org.glavo.chardet.prober.SBCSGroupProber;

public final class UniversalDetector {
    public static final float MINIMUM_THRESHOLD = 0.2f;
    private InputState inputState;
    private boolean done;
    private boolean start;
    private boolean gotData;
    private boolean onlyPrintableASCII = true;
    private byte lastChar;
    private DetectedCharset detectedCharset;
    private final CharsetProber[] probers;
    private CharsetProber escCharsetProber;
    private CharsetListener listener;

    public UniversalDetector() {
        this(null);
    }

    public UniversalDetector(CharsetListener listener) {
        this.listener = listener;
        this.escCharsetProber = null;
        this.probers = new CharsetProber[3];
        this.reset();
    }

    public boolean isDone() {
        return this.done;
    }

    public DetectedCharset getDetectedCharset() {
        return this.detectedCharset;
    }

    public void setListener(CharsetListener listener) {
        this.listener = listener;
    }

    public CharsetListener getListener() {
        return this.listener;
    }

    public void handleData(byte[] buf) {
        this.handleData(buf, 0, buf.length);
    }

    public void handleData(byte[] buf, int offset, int length) {
        this.handleData(ByteBuffer.wrap(buf), offset, length);
    }

    public void handleData(ByteBuffer buf) {
        this.handleData(buf, buf.position(), buf.remaining());
    }

    public void handleData(ByteBuffer buf, int offset, int length) {
        if (this.done) {
            return;
        }
        if (length == 0) {
            return;
        }
        if (length > 0) {
            this.gotData = true;
        }
        if (this.start) {
            DetectedCharset detectedBOM;
            this.start = false;
            if (length > 3 && (detectedBOM = UniversalDetector.detectCharsetFromBOM(buf, offset)) != null) {
                this.detectedCharset = detectedBOM;
                this.done = true;
                return;
            }
        }
        int maxPos = offset + length;
        for (int i = offset; i < maxPos; ++i) {
            int c = buf.get(i) & 0xFF;
            if ((c & 0x80) != 0 && c != 160) {
                if (this.inputState == InputState.HIGHBYTE) continue;
                this.inputState = InputState.HIGHBYTE;
                if (this.escCharsetProber != null) {
                    this.escCharsetProber = null;
                }
                if (this.probers[0] == null) {
                    this.probers[0] = new MBCSGroupProber();
                }
                if (this.probers[1] == null) {
                    this.probers[1] = new SBCSGroupProber();
                }
                if (this.probers[2] != null) continue;
                this.probers[2] = new Latin1Prober();
                continue;
            }
            if (this.inputState == InputState.PURE_ASCII && (c == 27 || c == 123 && this.lastChar == 126)) {
                this.inputState = InputState.ESC_ASCII;
            }
            if (this.inputState == InputState.PURE_ASCII && this.onlyPrintableASCII) {
                this.onlyPrintableASCII = c >= 32 && c <= 126 || c == 10 || c == 13 || c == 9;
            }
            this.lastChar = buf.get(i);
        }
        if (this.inputState == InputState.ESC_ASCII) {
            CharsetProber.ProbingState st;
            if (this.escCharsetProber == null) {
                this.escCharsetProber = new EscCharsetProber();
            }
            if ((st = this.escCharsetProber.handleData(buf, offset, length)) == CharsetProber.ProbingState.FOUND_IT || 0.99f == this.escCharsetProber.getConfidence()) {
                this.done = true;
                this.detectedCharset = this.escCharsetProber.getCharset();
            }
        } else if (this.inputState == InputState.HIGHBYTE) {
            for (CharsetProber prober : this.probers) {
                CharsetProber.ProbingState st = prober.handleData(buf, offset, length);
                if (st != CharsetProber.ProbingState.FOUND_IT) continue;
                this.done = true;
                this.detectedCharset = prober.getCharset();
                return;
            }
        }
    }

    protected static DetectedCharset detectCharsetFromBOM(ByteBuffer buf, int offset) {
        if (buf.limit() > offset + 3) {
            int b1 = buf.get(offset) & 0xFF;
            int b2 = buf.get(offset + 1) & 0xFF;
            int b3 = buf.get(offset + 2) & 0xFF;
            int b4 = buf.get(offset + 3) & 0xFF;
            switch (b1) {
                case 239: {
                    if (b2 != 187 || b3 != 191) break;
                    return DetectedCharset.UTF_8;
                }
                case 254: {
                    if (b2 == 255 && b3 == 0 && b4 == 0) {
                        return DetectedCharset.X_ISO_10646_UCS_4_3412;
                    }
                    if (b2 != 255) break;
                    return DetectedCharset.UTF_16BE;
                }
                case 0: {
                    if (b2 == 0 && b3 == 254 && b4 == 255) {
                        return DetectedCharset.UTF_32BE;
                    }
                    if (b2 != 0 || b3 != 255 || b4 != 254) break;
                    return DetectedCharset.X_ISO_10646_UCS_4_2143;
                }
                case 255: {
                    if (b2 == 254 && b3 == 0 && b4 == 0) {
                        return DetectedCharset.UTF_32LE;
                    }
                    if (b2 != 254) break;
                    return DetectedCharset.UTF_16LE;
                }
            }
        }
        return null;
    }

    public void dataEnd() {
        if (!this.gotData) {
            return;
        }
        if (this.detectedCharset != null) {
            this.done = true;
            this.notifyListener(this.detectedCharset);
            return;
        }
        if (this.inputState == InputState.HIGHBYTE) {
            float maxProberConfidence = 0.0f;
            int maxProber = 0;
            for (int i = 0; i < this.probers.length; ++i) {
                float proberConfidence = this.probers[i].getConfidence();
                if (!(proberConfidence > maxProberConfidence)) continue;
                maxProberConfidence = proberConfidence;
                maxProber = i;
            }
            if (maxProberConfidence > 0.2f) {
                this.detectedCharset = this.probers[maxProber].getCharset();
                this.notifyListener(this.detectedCharset);
            }
        } else if (this.inputState != InputState.ESC_ASCII && this.inputState == InputState.PURE_ASCII && this.onlyPrintableASCII) {
            this.detectedCharset = DetectedCharset.US_ASCII;
            this.notifyListener(this.detectedCharset);
        }
    }

    public void reset() {
        this.done = false;
        this.start = true;
        this.detectedCharset = null;
        this.gotData = false;
        this.inputState = InputState.PURE_ASCII;
        this.lastChar = 0;
        if (this.escCharsetProber != null) {
            this.escCharsetProber.reset();
        }
        for (CharsetProber prober : this.probers) {
            if (prober == null) continue;
            prober.reset();
        }
    }

    private void notifyListener(DetectedCharset detectedCharset) {
        if (this.listener != null && detectedCharset != null) {
            this.listener.report(detectedCharset);
        }
    }

    public static DetectedCharset detectCharset(File file) throws IOException {
        return UniversalDetector.detectCharset(file.toPath());
    }

    public static DetectedCharset detectCharset(Path path) throws IOException {
        try (SeekableByteChannel channel = Files.newByteChannel(path, new OpenOption[0]);){
            DetectedCharset detectedCharset = UniversalDetector.detectCharset(channel);
            return detectedCharset;
        }
    }

    public static DetectedCharset detectCharset(InputStream inputStream) throws IOException {
        return UniversalDetector.detectCharset(Channels.newChannel(inputStream));
    }

    public static DetectedCharset detectCharset(ReadableByteChannel channel) throws IOException {
        UniversalDetector detector = new UniversalDetector(null);
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        while (!detector.isDone() && channel.read(buffer) > 0) {
            buffer.flip();
            detector.handleData(buffer);
            buffer.clear();
        }
        detector.dataEnd();
        DetectedCharset encoding = detector.getDetectedCharset();
        detector.reset();
        return encoding;
    }

    public static enum InputState {
        PURE_ASCII,
        ESC_ASCII,
        HIGHBYTE;

    }
}

