# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: imagebuilder
using AWS.Compat
using AWS.UUIDs

"""
    cancel_image_creation(client_token, image_build_version_arn)
    cancel_image_creation(client_token, image_build_version_arn, params::Dict{String,<:Any})

CancelImageCreation cancels the creation of Image. This operation can only be used on
images in a non-terminal state.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `image_build_version_arn`: The Amazon Resource Name (ARN) of the image that you want to
  cancel creation for.

"""
function cancel_image_creation(
    clientToken, imageBuildVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "PUT",
        "/CancelImageCreation",
        Dict{String,Any}(
            "clientToken" => clientToken, "imageBuildVersionArn" => imageBuildVersionArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_image_creation(
    clientToken,
    imageBuildVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CancelImageCreation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "imageBuildVersionArn" => imageBuildVersionArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_lifecycle_execution(client_token, lifecycle_execution_id)
    cancel_lifecycle_execution(client_token, lifecycle_execution_id, params::Dict{String,<:Any})

Cancel a specific image lifecycle policy runtime instance.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `lifecycle_execution_id`: Identifies the specific runtime instance of the image lifecycle
  to cancel.

"""
function cancel_lifecycle_execution(
    clientToken, lifecycleExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "PUT",
        "/CancelLifecycleExecution",
        Dict{String,Any}(
            "clientToken" => clientToken, "lifecycleExecutionId" => lifecycleExecutionId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_lifecycle_execution(
    clientToken,
    lifecycleExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CancelLifecycleExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "lifecycleExecutionId" => lifecycleExecutionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_component(client_token, name, platform, semantic_version)
    create_component(client_token, name, platform, semantic_version, params::Dict{String,<:Any})

Creates a new component that can be used to build, validate, test, and assess your image.
The component is based on a YAML document that you specify using exactly one of the
following methods:   Inline, using the data property in the request body.   A URL that
points to a YAML document file stored in Amazon S3, using the uri property in the request
body.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `name`: The name of the component.
- `platform`: The operating system platform of the component.
- `semantic_version`: The semantic version of the component. This version follows the
  semantic version syntax.  The semantic version has four nodes:
  &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the
  first three, and can filter on all of them.  Assignment: For the first three nodes you can
  assign any positive integer value, including zero, with an upper limit of 2^30-1, or
  1073741823 for each node. Image Builder automatically assigns the build number to the
  fourth node.  Patterns: You can use any numeric pattern that adheres to the assignment
  requirements for the nodes that you can assign. For example, you might choose a software
  version pattern, such as 1.0.0, or a date, such as 2021.01.01.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"changeDescription"`: The change description of the component. Describes what change has
  been made in this version, or what makes this version different from other versions of the
  component.
- `"data"`: Component data contains inline YAML document content for the component.
  Alternatively, you can specify the uri of a YAML document file stored in Amazon S3.
  However, you cannot specify both properties.
- `"description"`: Describes the contents of the component.
- `"kmsKeyId"`: The ID of the KMS key that is used to encrypt this component.
- `"supportedOsVersions"`: The operating system (OS) version supported by the component. If
  the OS information is available, a prefix match is performed against the base image OS
  version during image recipe creation.
- `"tags"`: The tags that apply to the component.
- `"uri"`: The uri of a YAML component document file. This must be an S3 URL
  (s3://bucket/key), and the requester must have permission to access the S3 bucket it points
  to. If you use Amazon S3, you can specify component content up to your service quota.
  Alternatively, you can specify the YAML document inline, using the component data property.
  You cannot specify both properties.
"""
function create_component(
    clientToken,
    name,
    platform,
    semanticVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateComponent",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "name" => name,
            "platform" => platform,
            "semanticVersion" => semanticVersion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_component(
    clientToken,
    name,
    platform,
    semanticVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateComponent",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "name" => name,
                    "platform" => platform,
                    "semanticVersion" => semanticVersion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_container_recipe(client_token, components, container_type, name, parent_image, semantic_version, target_repository)
    create_container_recipe(client_token, components, container_type, name, parent_image, semantic_version, target_repository, params::Dict{String,<:Any})

Creates a new container recipe. Container recipes define how images are configured, tested,
and assessed.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `components`: Components for build and test that are included in the container recipe.
  Recipes require a minimum of one build component, and can have a maximum of 20 build and
  test components in any combination.
- `container_type`: The type of container to create.
- `name`: The name of the container recipe.
- `parent_image`: The base image for the container recipe.
- `semantic_version`: The semantic version of the container recipe. This version follows
  the semantic version syntax.  The semantic version has four nodes:
  &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the
  first three, and can filter on all of them.  Assignment: For the first three nodes you can
  assign any positive integer value, including zero, with an upper limit of 2^30-1, or
  1073741823 for each node. Image Builder automatically assigns the build number to the
  fourth node.  Patterns: You can use any numeric pattern that adheres to the assignment
  requirements for the nodes that you can assign. For example, you might choose a software
  version pattern, such as 1.0.0, or a date, such as 2021.01.01.
- `target_repository`: The destination repository for the container image.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of the container recipe.
- `"dockerfileTemplateData"`: The Dockerfile template used to build your image as an inline
  data blob.
- `"dockerfileTemplateUri"`: The Amazon S3 URI for the Dockerfile that will be used to
  build your container image.
- `"imageOsVersionOverride"`: Specifies the operating system version for the base image.
- `"instanceConfiguration"`: A group of options that can be used to configure an instance
  for building and testing container images.
- `"kmsKeyId"`: Identifies which KMS key is used to encrypt the container image.
- `"platformOverride"`: Specifies the operating system platform when you use a custom base
  image.
- `"tags"`: Tags that are attached to the container recipe.
- `"workingDirectory"`: The working directory for use during build and test workflows.
"""
function create_container_recipe(
    clientToken,
    components,
    containerType,
    name,
    parentImage,
    semanticVersion,
    targetRepository;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateContainerRecipe",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "components" => components,
            "containerType" => containerType,
            "name" => name,
            "parentImage" => parentImage,
            "semanticVersion" => semanticVersion,
            "targetRepository" => targetRepository,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_container_recipe(
    clientToken,
    components,
    containerType,
    name,
    parentImage,
    semanticVersion,
    targetRepository,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateContainerRecipe",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "components" => components,
                    "containerType" => containerType,
                    "name" => name,
                    "parentImage" => parentImage,
                    "semanticVersion" => semanticVersion,
                    "targetRepository" => targetRepository,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_distribution_configuration(client_token, distributions, name)
    create_distribution_configuration(client_token, distributions, name, params::Dict{String,<:Any})

Creates a new distribution configuration. Distribution configurations define and configure
the outputs of your pipeline.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `distributions`: The distributions of the distribution configuration.
- `name`: The name of the distribution configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of the distribution configuration.
- `"tags"`: The tags of the distribution configuration.
"""
function create_distribution_configuration(
    clientToken, distributions, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "PUT",
        "/CreateDistributionConfiguration",
        Dict{String,Any}(
            "clientToken" => clientToken, "distributions" => distributions, "name" => name
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_distribution_configuration(
    clientToken,
    distributions,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateDistributionConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "distributions" => distributions,
                    "name" => name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_image(client_token, infrastructure_configuration_arn)
    create_image(client_token, infrastructure_configuration_arn, params::Dict{String,<:Any})

Creates a new image. This request will create a new image along with all of the configured
output resources defined in the distribution configuration. You must specify exactly one
recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `infrastructure_configuration_arn`: The Amazon Resource Name (ARN) of the infrastructure
  configuration that defines the environment in which your image will be built and tested.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"containerRecipeArn"`: The Amazon Resource Name (ARN) of the container recipe that
  defines how images are configured and tested.
- `"distributionConfigurationArn"`: The Amazon Resource Name (ARN) of the distribution
  configuration that defines and configures the outputs of your pipeline.
- `"enhancedImageMetadataEnabled"`: Collects additional information about the image being
  created, including the operating system (OS) version and package list. This information is
  used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
- `"executionRole"`: The name or Amazon Resource Name (ARN) for the IAM role you create
  that grants Image Builder access to perform workflow actions.
- `"imageRecipeArn"`: The Amazon Resource Name (ARN) of the image recipe that defines how
  images are configured, tested, and assessed.
- `"imageScanningConfiguration"`: Contains settings for vulnerability scans.
- `"imageTestsConfiguration"`: The image tests configuration of the image.
- `"tags"`: The tags of the image.
- `"workflows"`: Contains an array of workflow configuration objects.
"""
function create_image(
    clientToken,
    infrastructureConfigurationArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateImage",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "infrastructureConfigurationArn" => infrastructureConfigurationArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_image(
    clientToken,
    infrastructureConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "infrastructureConfigurationArn" => infrastructureConfigurationArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_image_pipeline(client_token, infrastructure_configuration_arn, name)
    create_image_pipeline(client_token, infrastructure_configuration_arn, name, params::Dict{String,<:Any})

Creates a new image pipeline. Image pipelines enable you to automate the creation and
distribution of images.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `infrastructure_configuration_arn`: The Amazon Resource Name (ARN) of the infrastructure
  configuration that will be used to build images created by this image pipeline.
- `name`: The name of the image pipeline.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"containerRecipeArn"`: The Amazon Resource Name (ARN) of the container recipe that is
  used to configure images created by this container pipeline.
- `"description"`: The description of the image pipeline.
- `"distributionConfigurationArn"`: The Amazon Resource Name (ARN) of the distribution
  configuration that will be used to configure and distribute images created by this image
  pipeline.
- `"enhancedImageMetadataEnabled"`: Collects additional information about the image being
  created, including the operating system (OS) version and package list. This information is
  used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
- `"executionRole"`: The name or Amazon Resource Name (ARN) for the IAM role you create
  that grants Image Builder access to perform workflow actions.
- `"imageRecipeArn"`: The Amazon Resource Name (ARN) of the image recipe that will be used
  to configure images created by this image pipeline.
- `"imageScanningConfiguration"`: Contains settings for vulnerability scans.
- `"imageTestsConfiguration"`: The image test configuration of the image pipeline.
- `"schedule"`: The schedule of the image pipeline.
- `"status"`: The status of the image pipeline.
- `"tags"`: The tags of the image pipeline.
- `"workflows"`: Contains an array of workflow configuration objects.
"""
function create_image_pipeline(
    clientToken,
    infrastructureConfigurationArn,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateImagePipeline",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "infrastructureConfigurationArn" => infrastructureConfigurationArn,
            "name" => name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_image_pipeline(
    clientToken,
    infrastructureConfigurationArn,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateImagePipeline",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "infrastructureConfigurationArn" => infrastructureConfigurationArn,
                    "name" => name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_image_recipe(client_token, components, name, parent_image, semantic_version)
    create_image_recipe(client_token, components, name, parent_image, semantic_version, params::Dict{String,<:Any})

Creates a new image recipe. Image recipes define how images are configured, tested, and
assessed.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `components`: The components included in the image recipe.
- `name`: The name of the image recipe.
- `parent_image`: The base image of the image recipe. The value of the string can be the
  ARN of the base image or an AMI ID. The format for the ARN follows this example:
  arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x.
  You can provide the specific version that you want to use, or you can use a wildcard in all
  of the fields. If you enter an AMI ID for the string value, you must have access to the
  AMI, and the AMI must be in the same Region in which you are using Image Builder.
- `semantic_version`: The semantic version of the image recipe. This version follows the
  semantic version syntax.  The semantic version has four nodes:
  &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the
  first three, and can filter on all of them.  Assignment: For the first three nodes you can
  assign any positive integer value, including zero, with an upper limit of 2^30-1, or
  1073741823 for each node. Image Builder automatically assigns the build number to the
  fourth node.  Patterns: You can use any numeric pattern that adheres to the assignment
  requirements for the nodes that you can assign. For example, you might choose a software
  version pattern, such as 1.0.0, or a date, such as 2021.01.01.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"additionalInstanceConfiguration"`: Specify additional settings and launch scripts for
  your build instances.
- `"blockDeviceMappings"`: The block device mappings of the image recipe.
- `"description"`: The description of the image recipe.
- `"tags"`: The tags of the image recipe.
- `"workingDirectory"`: The working directory used during build and test workflows.
"""
function create_image_recipe(
    clientToken,
    components,
    name,
    parentImage,
    semanticVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateImageRecipe",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "components" => components,
            "name" => name,
            "parentImage" => parentImage,
            "semanticVersion" => semanticVersion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_image_recipe(
    clientToken,
    components,
    name,
    parentImage,
    semanticVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateImageRecipe",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "components" => components,
                    "name" => name,
                    "parentImage" => parentImage,
                    "semanticVersion" => semanticVersion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_infrastructure_configuration(client_token, instance_profile_name, name)
    create_infrastructure_configuration(client_token, instance_profile_name, name, params::Dict{String,<:Any})

Creates a new infrastructure configuration. An infrastructure configuration defines the
environment in which your image will be built and tested.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `instance_profile_name`: The instance profile to associate with the instance used to
  customize your Amazon EC2 AMI.
- `name`: The name of the infrastructure configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of the infrastructure configuration.
- `"instanceMetadataOptions"`: The instance metadata options that you can set for the HTTP
  requests that pipeline builds use to launch EC2 build and test instances.
- `"instanceTypes"`: The instance types of the infrastructure configuration. You can
  specify one or more instance types to use for this build. The service will pick one of
  these instance types based on availability.
- `"keyPair"`: The key pair of the infrastructure configuration. You can use this to log on
  to and debug the instance used to create your image.
- `"logging"`: The logging configuration of the infrastructure configuration.
- `"resourceTags"`: The tags attached to the resource created by Image Builder.
- `"securityGroupIds"`: The security group IDs to associate with the instance used to
  customize your Amazon EC2 AMI.
- `"snsTopicArn"`: The Amazon Resource Name (ARN) for the SNS topic to which we send image
  build event notifications.  EC2 Image Builder is unable to send notifications to SNS topics
  that are encrypted using keys from other accounts. The key that is used to encrypt the SNS
  topic must reside in the account that the Image Builder service runs under.
- `"subnetId"`: The subnet ID in which to place the instance used to customize your Amazon
  EC2 AMI.
- `"tags"`: The tags of the infrastructure configuration.
- `"terminateInstanceOnFailure"`: The terminate instance on failure setting of the
  infrastructure configuration. Set to false if you want Image Builder to retain the instance
  used to configure your AMI if the build or test phase of your workflow fails.
"""
function create_infrastructure_configuration(
    clientToken,
    instanceProfileName,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateInfrastructureConfiguration",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "instanceProfileName" => instanceProfileName,
            "name" => name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_infrastructure_configuration(
    clientToken,
    instanceProfileName,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateInfrastructureConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "instanceProfileName" => instanceProfileName,
                    "name" => name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_lifecycle_policy(client_token, execution_role, name, policy_details, resource_selection, resource_type)
    create_lifecycle_policy(client_token, execution_role, name, policy_details, resource_selection, resource_type, params::Dict{String,<:Any})

Create a lifecycle policy resource.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `execution_role`: The name or Amazon Resource Name (ARN) for the IAM role you create that
  grants Image Builder access to run lifecycle actions.
- `name`: The name of the lifecycle policy to create.
- `policy_details`: Configuration details for the lifecycle policy rules.
- `resource_selection`: Selection criteria for the resources that the lifecycle policy
  applies to.
- `resource_type`: The type of Image Builder resource that the lifecycle policy applies to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: Optional description for the lifecycle policy.
- `"status"`: Indicates whether the lifecycle policy resource is enabled.
- `"tags"`: Tags to apply to the lifecycle policy resource.
"""
function create_lifecycle_policy(
    clientToken,
    executionRole,
    name,
    policyDetails,
    resourceSelection,
    resourceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateLifecyclePolicy",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "executionRole" => executionRole,
            "name" => name,
            "policyDetails" => policyDetails,
            "resourceSelection" => resourceSelection,
            "resourceType" => resourceType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_lifecycle_policy(
    clientToken,
    executionRole,
    name,
    policyDetails,
    resourceSelection,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateLifecyclePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "executionRole" => executionRole,
                    "name" => name,
                    "policyDetails" => policyDetails,
                    "resourceSelection" => resourceSelection,
                    "resourceType" => resourceType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_workflow(client_token, name, semantic_version, type)
    create_workflow(client_token, name, semantic_version, type, params::Dict{String,<:Any})

Create a new workflow or a new version of an existing workflow.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `name`: The name of the workflow to create.
- `semantic_version`: The semantic version of this workflow resource. The semantic version
  syntax adheres to the following rules.  The semantic version has four nodes:
  &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the
  first three, and can filter on all of them.  Assignment: For the first three nodes you can
  assign any positive integer value, including zero, with an upper limit of 2^30-1, or
  1073741823 for each node. Image Builder automatically assigns the build number to the
  fourth node.  Patterns: You can use any numeric pattern that adheres to the assignment
  requirements for the nodes that you can assign. For example, you might choose a software
  version pattern, such as 1.0.0, or a date, such as 2021.01.01.
- `type`: The phase in the image build process for which the workflow resource is
  responsible.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"changeDescription"`: Describes what change has been made in this version of the
  workflow, or what makes this version different from other versions of the workflow.
- `"data"`: Contains the UTF-8 encoded YAML document content for the workflow.
  Alternatively, you can specify the uri of a YAML document file stored in Amazon S3.
  However, you cannot specify both properties.
- `"description"`: Describes the workflow.
- `"kmsKeyId"`: The ID of the KMS key that is used to encrypt this workflow resource.
- `"tags"`: Tags that apply to the workflow resource.
- `"uri"`: The uri of a YAML component document file. This must be an S3 URL
  (s3://bucket/key), and the requester must have permission to access the S3 bucket it points
  to. If you use Amazon S3, you can specify component content up to your service quota.
  Alternatively, you can specify the YAML document inline, using the component data property.
  You cannot specify both properties.
"""
function create_workflow(
    clientToken,
    name,
    semanticVersion,
    type;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateWorkflow",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "name" => name,
            "semanticVersion" => semanticVersion,
            "type" => type,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_workflow(
    clientToken,
    name,
    semanticVersion,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/CreateWorkflow",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "name" => name,
                    "semanticVersion" => semanticVersion,
                    "type" => type,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_component(component_build_version_arn)
    delete_component(component_build_version_arn, params::Dict{String,<:Any})

Deletes a component build version.

# Arguments
- `component_build_version_arn`: The Amazon Resource Name (ARN) of the component build
  version to delete.

"""
function delete_component(
    componentBuildVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "DELETE",
        "/DeleteComponent",
        Dict{String,Any}("componentBuildVersionArn" => componentBuildVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_component(
    componentBuildVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "DELETE",
        "/DeleteComponent",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("componentBuildVersionArn" => componentBuildVersionArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_container_recipe(container_recipe_arn)
    delete_container_recipe(container_recipe_arn, params::Dict{String,<:Any})

Deletes a container recipe.

# Arguments
- `container_recipe_arn`: The Amazon Resource Name (ARN) of the container recipe to delete.

"""
function delete_container_recipe(
    containerRecipeArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "DELETE",
        "/DeleteContainerRecipe",
        Dict{String,Any}("containerRecipeArn" => containerRecipeArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_container_recipe(
    containerRecipeArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "DELETE",
        "/DeleteContainerRecipe",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("containerRecipeArn" => containerRecipeArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_distribution_configuration(distribution_configuration_arn)
    delete_distribution_configuration(distribution_configuration_arn, params::Dict{String,<:Any})

Deletes a distribution configuration.

# Arguments
- `distribution_configuration_arn`: The Amazon Resource Name (ARN) of the distribution
  configuration to delete.

"""
function delete_distribution_configuration(
    distributionConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "DELETE",
        "/DeleteDistributionConfiguration",
        Dict{String,Any}("distributionConfigurationArn" => distributionConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_distribution_configuration(
    distributionConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "DELETE",
        "/DeleteDistributionConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "distributionConfigurationArn" => distributionConfigurationArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_image(image_build_version_arn)
    delete_image(image_build_version_arn, params::Dict{String,<:Any})

Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container
images that are created during the image build process. You must clean those up separately,
using the appropriate Amazon EC2 or Amazon ECR console actions, or API or CLI commands.
To deregister an EC2 Linux AMI, see Deregister your Linux AMI in the  Amazon EC2 User Guide
.   To deregister an EC2 Windows AMI, see Deregister your Windows AMI in the  Amazon EC2
Windows Guide .   To delete a container image from Amazon ECR, see Deleting an image in the
Amazon ECR User Guide.

# Arguments
- `image_build_version_arn`: The Amazon Resource Name (ARN) of the Image Builder image
  resource to delete.

"""
function delete_image(
    imageBuildVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "DELETE",
        "/DeleteImage",
        Dict{String,Any}("imageBuildVersionArn" => imageBuildVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_image(
    imageBuildVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "DELETE",
        "/DeleteImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("imageBuildVersionArn" => imageBuildVersionArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_image_pipeline(image_pipeline_arn)
    delete_image_pipeline(image_pipeline_arn, params::Dict{String,<:Any})

Deletes an image pipeline.

# Arguments
- `image_pipeline_arn`: The Amazon Resource Name (ARN) of the image pipeline to delete.

"""
function delete_image_pipeline(
    imagePipelineArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "DELETE",
        "/DeleteImagePipeline",
        Dict{String,Any}("imagePipelineArn" => imagePipelineArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_image_pipeline(
    imagePipelineArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "DELETE",
        "/DeleteImagePipeline",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("imagePipelineArn" => imagePipelineArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_image_recipe(image_recipe_arn)
    delete_image_recipe(image_recipe_arn, params::Dict{String,<:Any})

Deletes an image recipe.

# Arguments
- `image_recipe_arn`: The Amazon Resource Name (ARN) of the image recipe to delete.

"""
function delete_image_recipe(
    imageRecipeArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "DELETE",
        "/DeleteImageRecipe",
        Dict{String,Any}("imageRecipeArn" => imageRecipeArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_image_recipe(
    imageRecipeArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "DELETE",
        "/DeleteImageRecipe",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("imageRecipeArn" => imageRecipeArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_infrastructure_configuration(infrastructure_configuration_arn)
    delete_infrastructure_configuration(infrastructure_configuration_arn, params::Dict{String,<:Any})

Deletes an infrastructure configuration.

# Arguments
- `infrastructure_configuration_arn`: The Amazon Resource Name (ARN) of the infrastructure
  configuration to delete.

"""
function delete_infrastructure_configuration(
    infrastructureConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "DELETE",
        "/DeleteInfrastructureConfiguration",
        Dict{String,Any}(
            "infrastructureConfigurationArn" => infrastructureConfigurationArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_infrastructure_configuration(
    infrastructureConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "DELETE",
        "/DeleteInfrastructureConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "infrastructureConfigurationArn" => infrastructureConfigurationArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_lifecycle_policy(lifecycle_policy_arn)
    delete_lifecycle_policy(lifecycle_policy_arn, params::Dict{String,<:Any})

Delete the specified lifecycle policy resource.

# Arguments
- `lifecycle_policy_arn`: The Amazon Resource Name (ARN) of the lifecycle policy resource
  to delete.

"""
function delete_lifecycle_policy(
    lifecyclePolicyArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "DELETE",
        "/DeleteLifecyclePolicy",
        Dict{String,Any}("lifecyclePolicyArn" => lifecyclePolicyArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_lifecycle_policy(
    lifecyclePolicyArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "DELETE",
        "/DeleteLifecyclePolicy",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("lifecyclePolicyArn" => lifecyclePolicyArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_workflow(workflow_build_version_arn)
    delete_workflow(workflow_build_version_arn, params::Dict{String,<:Any})

Deletes a specific workflow resource.

# Arguments
- `workflow_build_version_arn`: The Amazon Resource Name (ARN) of the workflow resource to
  delete.

"""
function delete_workflow(
    workflowBuildVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "DELETE",
        "/DeleteWorkflow",
        Dict{String,Any}("workflowBuildVersionArn" => workflowBuildVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_workflow(
    workflowBuildVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "DELETE",
        "/DeleteWorkflow",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("workflowBuildVersionArn" => workflowBuildVersionArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_component(component_build_version_arn)
    get_component(component_build_version_arn, params::Dict{String,<:Any})

Gets a component object.

# Arguments
- `component_build_version_arn`: The Amazon Resource Name (ARN) of the component that you
  want to get. Regex requires the suffix /d+.

"""
function get_component(
    componentBuildVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetComponent",
        Dict{String,Any}("componentBuildVersionArn" => componentBuildVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_component(
    componentBuildVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetComponent",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("componentBuildVersionArn" => componentBuildVersionArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_component_policy(component_arn)
    get_component_policy(component_arn, params::Dict{String,<:Any})

Gets a component policy.

# Arguments
- `component_arn`: The Amazon Resource Name (ARN) of the component whose policy you want to
  retrieve.

"""
function get_component_policy(
    componentArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetComponentPolicy",
        Dict{String,Any}("componentArn" => componentArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_component_policy(
    componentArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetComponentPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("componentArn" => componentArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_container_recipe(container_recipe_arn)
    get_container_recipe(container_recipe_arn, params::Dict{String,<:Any})

Retrieves a container recipe.

# Arguments
- `container_recipe_arn`: The Amazon Resource Name (ARN) of the container recipe to
  retrieve.

"""
function get_container_recipe(
    containerRecipeArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetContainerRecipe",
        Dict{String,Any}("containerRecipeArn" => containerRecipeArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_container_recipe(
    containerRecipeArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetContainerRecipe",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("containerRecipeArn" => containerRecipeArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_container_recipe_policy(container_recipe_arn)
    get_container_recipe_policy(container_recipe_arn, params::Dict{String,<:Any})

Retrieves the policy for a container recipe.

# Arguments
- `container_recipe_arn`: The Amazon Resource Name (ARN) of the container recipe for the
  policy being requested.

"""
function get_container_recipe_policy(
    containerRecipeArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetContainerRecipePolicy",
        Dict{String,Any}("containerRecipeArn" => containerRecipeArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_container_recipe_policy(
    containerRecipeArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetContainerRecipePolicy",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("containerRecipeArn" => containerRecipeArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_distribution_configuration(distribution_configuration_arn)
    get_distribution_configuration(distribution_configuration_arn, params::Dict{String,<:Any})

Gets a distribution configuration.

# Arguments
- `distribution_configuration_arn`: The Amazon Resource Name (ARN) of the distribution
  configuration that you want to retrieve.

"""
function get_distribution_configuration(
    distributionConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetDistributionConfiguration",
        Dict{String,Any}("distributionConfigurationArn" => distributionConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_distribution_configuration(
    distributionConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetDistributionConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "distributionConfigurationArn" => distributionConfigurationArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_image(image_build_version_arn)
    get_image(image_build_version_arn, params::Dict{String,<:Any})

Gets an image.

# Arguments
- `image_build_version_arn`: The Amazon Resource Name (ARN) of the image that you want to
  get.

"""
function get_image(imageBuildVersionArn; aws_config::AbstractAWSConfig=current_aws_config())
    return imagebuilder(
        "GET",
        "/GetImage",
        Dict{String,Any}("imageBuildVersionArn" => imageBuildVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_image(
    imageBuildVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("imageBuildVersionArn" => imageBuildVersionArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_image_pipeline(image_pipeline_arn)
    get_image_pipeline(image_pipeline_arn, params::Dict{String,<:Any})

Gets an image pipeline.

# Arguments
- `image_pipeline_arn`: The Amazon Resource Name (ARN) of the image pipeline that you want
  to retrieve.

"""
function get_image_pipeline(
    imagePipelineArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetImagePipeline",
        Dict{String,Any}("imagePipelineArn" => imagePipelineArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_image_pipeline(
    imagePipelineArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetImagePipeline",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("imagePipelineArn" => imagePipelineArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_image_policy(image_arn)
    get_image_policy(image_arn, params::Dict{String,<:Any})

Gets an image policy.

# Arguments
- `image_arn`: The Amazon Resource Name (ARN) of the image whose policy you want to
  retrieve.

"""
function get_image_policy(imageArn; aws_config::AbstractAWSConfig=current_aws_config())
    return imagebuilder(
        "GET",
        "/GetImagePolicy",
        Dict{String,Any}("imageArn" => imageArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_image_policy(
    imageArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetImagePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("imageArn" => imageArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_image_recipe(image_recipe_arn)
    get_image_recipe(image_recipe_arn, params::Dict{String,<:Any})

Gets an image recipe.

# Arguments
- `image_recipe_arn`: The Amazon Resource Name (ARN) of the image recipe that you want to
  retrieve.

"""
function get_image_recipe(
    imageRecipeArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetImageRecipe",
        Dict{String,Any}("imageRecipeArn" => imageRecipeArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_image_recipe(
    imageRecipeArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetImageRecipe",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("imageRecipeArn" => imageRecipeArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_image_recipe_policy(image_recipe_arn)
    get_image_recipe_policy(image_recipe_arn, params::Dict{String,<:Any})

Gets an image recipe policy.

# Arguments
- `image_recipe_arn`: The Amazon Resource Name (ARN) of the image recipe whose policy you
  want to retrieve.

"""
function get_image_recipe_policy(
    imageRecipeArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetImageRecipePolicy",
        Dict{String,Any}("imageRecipeArn" => imageRecipeArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_image_recipe_policy(
    imageRecipeArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetImageRecipePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("imageRecipeArn" => imageRecipeArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_infrastructure_configuration(infrastructure_configuration_arn)
    get_infrastructure_configuration(infrastructure_configuration_arn, params::Dict{String,<:Any})

Gets an infrastructure configuration.

# Arguments
- `infrastructure_configuration_arn`: The Amazon Resource Name (ARN) of the infrastructure
  configuration that you want to retrieve.

"""
function get_infrastructure_configuration(
    infrastructureConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetInfrastructureConfiguration",
        Dict{String,Any}(
            "infrastructureConfigurationArn" => infrastructureConfigurationArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_infrastructure_configuration(
    infrastructureConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetInfrastructureConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "infrastructureConfigurationArn" => infrastructureConfigurationArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_lifecycle_execution(lifecycle_execution_id)
    get_lifecycle_execution(lifecycle_execution_id, params::Dict{String,<:Any})

Get the runtime information that was logged for a specific runtime instance of the
lifecycle policy.

# Arguments
- `lifecycle_execution_id`: Use the unique identifier for a runtime instance of the
  lifecycle policy to get runtime details.

"""
function get_lifecycle_execution(
    lifecycleExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetLifecycleExecution",
        Dict{String,Any}("lifecycleExecutionId" => lifecycleExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_lifecycle_execution(
    lifecycleExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetLifecycleExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("lifecycleExecutionId" => lifecycleExecutionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_lifecycle_policy(lifecycle_policy_arn)
    get_lifecycle_policy(lifecycle_policy_arn, params::Dict{String,<:Any})

Get details for the specified image lifecycle policy.

# Arguments
- `lifecycle_policy_arn`: Specifies the Amazon Resource Name (ARN) of the image lifecycle
  policy resource to get.

"""
function get_lifecycle_policy(
    lifecyclePolicyArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetLifecyclePolicy",
        Dict{String,Any}("lifecyclePolicyArn" => lifecyclePolicyArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_lifecycle_policy(
    lifecyclePolicyArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetLifecyclePolicy",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("lifecyclePolicyArn" => lifecyclePolicyArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_workflow(workflow_build_version_arn)
    get_workflow(workflow_build_version_arn, params::Dict{String,<:Any})

Get a workflow resource object.

# Arguments
- `workflow_build_version_arn`: The Amazon Resource Name (ARN) of the workflow resource
  that you want to get.

"""
function get_workflow(
    workflowBuildVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetWorkflow",
        Dict{String,Any}("workflowBuildVersionArn" => workflowBuildVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_workflow(
    workflowBuildVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetWorkflow",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("workflowBuildVersionArn" => workflowBuildVersionArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_workflow_execution(workflow_execution_id)
    get_workflow_execution(workflow_execution_id, params::Dict{String,<:Any})

Get the runtime information that was logged for a specific runtime instance of the workflow.

# Arguments
- `workflow_execution_id`: Use the unique identifier for a runtime instance of the workflow
  to get runtime details.

"""
function get_workflow_execution(
    workflowExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetWorkflowExecution",
        Dict{String,Any}("workflowExecutionId" => workflowExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_workflow_execution(
    workflowExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetWorkflowExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("workflowExecutionId" => workflowExecutionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_workflow_step_execution(step_execution_id)
    get_workflow_step_execution(step_execution_id, params::Dict{String,<:Any})

Get the runtime information that was logged for a specific runtime instance of the workflow
step.

# Arguments
- `step_execution_id`: Use the unique identifier for a specific runtime instance of the
  workflow step to get runtime details for that step.

"""
function get_workflow_step_execution(
    stepExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/GetWorkflowStepExecution",
        Dict{String,Any}("stepExecutionId" => stepExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_workflow_step_execution(
    stepExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/GetWorkflowStepExecution",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("stepExecutionId" => stepExecutionId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_component(client_token, format, name, platform, semantic_version, type)
    import_component(client_token, format, name, platform, semantic_version, type, params::Dict{String,<:Any})

Imports a component and transforms its data into a component document.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `format`: The format of the resource that you want to import as a component.
- `name`: The name of the component.
- `platform`: The platform of the component.
- `semantic_version`: The semantic version of the component. This version follows the
  semantic version syntax.  The semantic version has four nodes:
  &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the
  first three, and can filter on all of them.  Filtering: With semantic versioning, you have
  the flexibility to use wildcards (x) to specify the most recent versions or nodes when
  selecting the base image or components for your recipe. When you use a wildcard in any
  node, all nodes to the right of the first wildcard must also be wildcards.
- `type`: The type of the component denotes whether the component is used to build the
  image, or only to test it.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"changeDescription"`: The change description of the component. This description
  indicates the change that has been made in this version, or what makes this version
  different from other versions of the component.
- `"data"`: The data of the component. Used to specify the data inline. Either data or uri
  can be used to specify the data within the component.
- `"description"`: The description of the component. Describes the contents of the
  component.
- `"kmsKeyId"`: The ID of the KMS key that should be used to encrypt this component.
- `"tags"`: The tags of the component.
- `"uri"`: The uri of the component. Must be an Amazon S3 URL and the requester must have
  permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component
  content up to your service quota. Either data or uri can be used to specify the data within
  the component.
"""
function import_component(
    clientToken,
    format,
    name,
    platform,
    semanticVersion,
    type;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/ImportComponent",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "format" => format,
            "name" => name,
            "platform" => platform,
            "semanticVersion" => semanticVersion,
            "type" => type,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_component(
    clientToken,
    format,
    name,
    platform,
    semanticVersion,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/ImportComponent",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "format" => format,
                    "name" => name,
                    "platform" => platform,
                    "semanticVersion" => semanticVersion,
                    "type" => type,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_vm_image(client_token, name, platform, semantic_version, vm_import_task_id)
    import_vm_image(client_token, name, platform, semantic_version, vm_import_task_id, params::Dict{String,<:Any})

When you export your virtual machine (VM) from its virtualization environment, that process
creates a set of one or more disk container files that act as snapshots of your VM’s
environment, settings, and data. The Amazon EC2 API ImportImage action uses those files to
import your VM and create an AMI. To import using the CLI command, see import-image  You
can reference the task ID from the VM import to pull in the AMI that the import created as
the base image for your Image Builder recipe.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `name`: The name of the base image that is created by the import process.
- `platform`: The operating system platform for the imported VM.
- `semantic_version`: The semantic version to attach to the base image that was created
  during the import process. This version follows the semantic version syntax.  The semantic
  version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
  assign values for the first three, and can filter on all of them.  Assignment: For the
  first three nodes you can assign any positive integer value, including zero, with an upper
  limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build
  number to the fourth node.  Patterns: You can use any numeric pattern that adheres to the
  assignment requirements for the nodes that you can assign. For example, you might choose a
  software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
- `vm_import_task_id`: The importTaskId (API) or ImportTaskId (CLI) from the Amazon EC2 VM
  import process. Image Builder retrieves information from the import process to pull in the
  AMI that is created from the VM source as the base image for your recipe.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description for the base image that is created by the import process.
- `"osVersion"`: The operating system version for the imported VM.
- `"tags"`: Tags that are attached to the import resources.
"""
function import_vm_image(
    clientToken,
    name,
    platform,
    semanticVersion,
    vmImportTaskId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/ImportVmImage",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "name" => name,
            "platform" => platform,
            "semanticVersion" => semanticVersion,
            "vmImportTaskId" => vmImportTaskId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_vm_image(
    clientToken,
    name,
    platform,
    semanticVersion,
    vmImportTaskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/ImportVmImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "name" => name,
                    "platform" => platform,
                    "semanticVersion" => semanticVersion,
                    "vmImportTaskId" => vmImportTaskId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_component_build_versions(component_version_arn)
    list_component_build_versions(component_version_arn, params::Dict{String,<:Any})

Returns the list of component build versions for the specified semantic version.  The
semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;.
You can assign values for the first three, and can filter on all of them.  Filtering: With
semantic versioning, you have the flexibility to use wildcards (x) to specify the most
recent versions or nodes when selecting the base image or components for your recipe. When
you use a wildcard in any node, all nodes to the right of the first wildcard must also be
wildcards.

# Arguments
- `component_version_arn`: The component version Amazon Resource Name (ARN) whose versions
  you want to list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_component_build_versions(
    componentVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListComponentBuildVersions",
        Dict{String,Any}("componentVersionArn" => componentVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_component_build_versions(
    componentVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "POST",
        "/ListComponentBuildVersions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("componentVersionArn" => componentVersionArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_components()
    list_components(params::Dict{String,<:Any})

Returns the list of components that can be filtered by name, or by using the listed filters
to streamline results. Newly created components can take up to two minutes to appear in the
ListComponents API Results.  The semantic version has four nodes:
&lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the
first three, and can filter on all of them.  Filtering: With semantic versioning, you have
the flexibility to use wildcards (x) to specify the most recent versions or nodes when
selecting the base image or components for your recipe. When you use a wildcard in any
node, all nodes to the right of the first wildcard must also be wildcards.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"byName"`: Returns the list of components for the specified name.
- `"filters"`: Use the following filters to streamline results:    description     name
  platform     supportedOsVersion     type     version
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
- `"owner"`: Filters results based on the type of owner for the component. By default, this
  request returns a list of components that your account owns. To see results for other types
  of owners, you can specify components that Amazon manages, third party components, or
  components that other accounts have shared with you.
"""
function list_components(; aws_config::AbstractAWSConfig=current_aws_config())
    return imagebuilder(
        "POST", "/ListComponents"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_components(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListComponents",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_container_recipes()
    list_container_recipes(params::Dict{String,<:Any})

Returns a list of container recipes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Use the following filters to streamline results:    containerType     name
    parentImage     platform
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
- `"owner"`: Returns container recipes belonging to the specified owner, that have been
  shared with you. You can omit this field to return container recipes belonging to your
  account.
"""
function list_container_recipes(; aws_config::AbstractAWSConfig=current_aws_config())
    return imagebuilder(
        "POST",
        "/ListContainerRecipes";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_container_recipes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListContainerRecipes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_distribution_configurations()
    list_distribution_configurations(params::Dict{String,<:Any})

Returns a list of distribution configurations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: You can filter on name to streamline results.
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_distribution_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListDistributionConfigurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_distribution_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListDistributionConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_image_build_versions(image_version_arn)
    list_image_build_versions(image_version_arn, params::Dict{String,<:Any})

Returns a list of image build versions.

# Arguments
- `image_version_arn`: The Amazon Resource Name (ARN) of the image whose build versions you
  want to retrieve.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Use the following filters to streamline results:    name     osVersion
  platform     type     version
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_image_build_versions(
    imageVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListImageBuildVersions",
        Dict{String,Any}("imageVersionArn" => imageVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_image_build_versions(
    imageVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "POST",
        "/ListImageBuildVersions",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("imageVersionArn" => imageVersionArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_image_packages(image_build_version_arn)
    list_image_packages(image_build_version_arn, params::Dict{String,<:Any})

List the Packages that are associated with an Image Build Version, as determined by Amazon
Web Services Systems Manager Inventory at build time.

# Arguments
- `image_build_version_arn`: Filter results for the ListImagePackages request by the Image
  Build Version ARN

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_image_packages(
    imageBuildVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListImagePackages",
        Dict{String,Any}("imageBuildVersionArn" => imageBuildVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_image_packages(
    imageBuildVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "POST",
        "/ListImagePackages",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("imageBuildVersionArn" => imageBuildVersionArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_image_pipeline_images(image_pipeline_arn)
    list_image_pipeline_images(image_pipeline_arn, params::Dict{String,<:Any})

Returns a list of images created by the specified pipeline.

# Arguments
- `image_pipeline_arn`: The Amazon Resource Name (ARN) of the image pipeline whose images
  you want to view.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Use the following filters to streamline results:    name     version
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_image_pipeline_images(
    imagePipelineArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListImagePipelineImages",
        Dict{String,Any}("imagePipelineArn" => imagePipelineArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_image_pipeline_images(
    imagePipelineArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "POST",
        "/ListImagePipelineImages",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("imagePipelineArn" => imagePipelineArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_image_pipelines()
    list_image_pipelines(params::Dict{String,<:Any})

Returns a list of image pipelines.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Use the following filters to streamline results:    description
  distributionConfigurationArn     imageRecipeArn     infrastructureConfigurationArn     name
      status
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_image_pipelines(; aws_config::AbstractAWSConfig=current_aws_config())
    return imagebuilder(
        "POST",
        "/ListImagePipelines";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_image_pipelines(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListImagePipelines",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_image_recipes()
    list_image_recipes(params::Dict{String,<:Any})

Returns a list of image recipes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Use the following filters to streamline results:    name     parentImage
  platform
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
- `"owner"`: The owner defines which image recipes you want to list. By default, this
  request will only show image recipes owned by your account. You can use this field to
  specify if you want to view image recipes owned by yourself, by Amazon, or those image
  recipes that have been shared with you by other customers.
"""
function list_image_recipes(; aws_config::AbstractAWSConfig=current_aws_config())
    return imagebuilder(
        "POST", "/ListImageRecipes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_image_recipes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListImageRecipes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_image_scan_finding_aggregations()
    list_image_scan_finding_aggregations(params::Dict{String,<:Any})

Returns a list of image scan aggregations for your account. You can filter by the type of
key that Image Builder uses to group results. For example, if you want to get a list of
findings by severity level for one of your pipelines, you might specify your pipeline with
the imagePipelineArn filter. If you don't specify a filter, Image Builder returns an
aggregation for your account. To streamline results, you can use the following filters in
your request:    accountId     imageBuildVersionArn     imagePipelineArn
vulnerabilityId

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filter"`:
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_image_scan_finding_aggregations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListImageScanFindingAggregations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_image_scan_finding_aggregations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListImageScanFindingAggregations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_image_scan_findings()
    list_image_scan_findings(params::Dict{String,<:Any})

Returns a list of image scan findings for your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: An array of name value pairs that you can use to filter your results. You
  can use the following filters to streamline results:    imageBuildVersionArn
  imagePipelineArn     vulnerabilityId     severity    If you don't request a filter, then
  all findings in your account are listed.
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_image_scan_findings(; aws_config::AbstractAWSConfig=current_aws_config())
    return imagebuilder(
        "POST",
        "/ListImageScanFindings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_image_scan_findings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListImageScanFindings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_images()
    list_images(params::Dict{String,<:Any})

Returns the list of images that you have access to. Newly created images can take up to two
minutes to appear in the ListImages API Results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"byName"`: Requests a list of images with a specific recipe name.
- `"filters"`: Use the following filters to streamline results:    name     osVersion
  platform     type     version
- `"includeDeprecated"`: Includes deprecated images in the response list.
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
- `"owner"`: The owner defines which images you want to list. By default, this request will
  only show images owned by your account. You can use this field to specify if you want to
  view images owned by yourself, by Amazon, or those images that have been shared with you by
  other customers.
"""
function list_images(; aws_config::AbstractAWSConfig=current_aws_config())
    return imagebuilder(
        "POST", "/ListImages"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_images(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListImages",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_infrastructure_configurations()
    list_infrastructure_configurations(params::Dict{String,<:Any})

Returns a list of infrastructure configurations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: You can filter on name to streamline results.
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_infrastructure_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListInfrastructureConfigurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_infrastructure_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListInfrastructureConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_lifecycle_execution_resources(lifecycle_execution_id)
    list_lifecycle_execution_resources(lifecycle_execution_id, params::Dict{String,<:Any})

List resources that the runtime instance of the image lifecycle identified for lifecycle
actions.

# Arguments
- `lifecycle_execution_id`: Use the unique identifier for a runtime instance of the
  lifecycle policy to get runtime details.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
- `"parentResourceId"`: You can leave this empty to get a list of Image Builder resources
  that were identified for lifecycle actions. To get a list of associated resources that are
  impacted for an individual resource (the parent), specify its Amazon Resource Name (ARN).
  Associated resources are produced from your image and distributed when you run a build,
  such as AMIs or container images stored in ECR repositories.
"""
function list_lifecycle_execution_resources(
    lifecycleExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListLifecycleExecutionResources",
        Dict{String,Any}("lifecycleExecutionId" => lifecycleExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_lifecycle_execution_resources(
    lifecycleExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "POST",
        "/ListLifecycleExecutionResources",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("lifecycleExecutionId" => lifecycleExecutionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_lifecycle_executions(resource_arn)
    list_lifecycle_executions(resource_arn, params::Dict{String,<:Any})

Get the lifecycle runtime history for the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource for which to get a list of
  lifecycle runtime instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_lifecycle_executions(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListLifecycleExecutions",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_lifecycle_executions(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "POST",
        "/ListLifecycleExecutions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_lifecycle_policies()
    list_lifecycle_policies(params::Dict{String,<:Any})

Get a list of lifecycle policies in your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Streamline results based on one of the following values: Name, Status.
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_lifecycle_policies(; aws_config::AbstractAWSConfig=current_aws_config())
    return imagebuilder(
        "POST",
        "/ListLifecyclePolicies";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_lifecycle_policies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListLifecyclePolicies",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Returns the list of tags for the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource whose tags you want to
  retrieve.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_waiting_workflow_steps()
    list_waiting_workflow_steps(params::Dict{String,<:Any})

Get a list of workflow steps that are waiting for action for workflows in your Amazon Web
Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_waiting_workflow_steps(; aws_config::AbstractAWSConfig=current_aws_config())
    return imagebuilder(
        "POST",
        "/ListWaitingWorkflowSteps";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_waiting_workflow_steps(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListWaitingWorkflowSteps",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_workflow_build_versions(workflow_version_arn)
    list_workflow_build_versions(workflow_version_arn, params::Dict{String,<:Any})

Returns a list of build versions for a specific workflow resource.

# Arguments
- `workflow_version_arn`: The Amazon Resource Name (ARN) of the workflow resource for which
  to get a list of build versions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_workflow_build_versions(
    workflowVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListWorkflowBuildVersions",
        Dict{String,Any}("workflowVersionArn" => workflowVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_workflow_build_versions(
    workflowVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "POST",
        "/ListWorkflowBuildVersions",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("workflowVersionArn" => workflowVersionArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_workflow_executions(image_build_version_arn)
    list_workflow_executions(image_build_version_arn, params::Dict{String,<:Any})

Returns a list of workflow runtime instance metadata objects for a specific image build
version.

# Arguments
- `image_build_version_arn`: List all workflow runtime instances for the specified image
  build version resource ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_workflow_executions(
    imageBuildVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListWorkflowExecutions",
        Dict{String,Any}("imageBuildVersionArn" => imageBuildVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_workflow_executions(
    imageBuildVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "POST",
        "/ListWorkflowExecutions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("imageBuildVersionArn" => imageBuildVersionArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_workflow_step_executions(workflow_execution_id)
    list_workflow_step_executions(workflow_execution_id, params::Dict{String,<:Any})

Returns runtime data for each step in a runtime instance of the workflow that you specify
in the request.

# Arguments
- `workflow_execution_id`: The unique identifier that Image Builder assigned to keep track
  of runtime details when it ran the workflow.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
"""
function list_workflow_step_executions(
    workflowExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListWorkflowStepExecutions",
        Dict{String,Any}("workflowExecutionId" => workflowExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_workflow_step_executions(
    workflowExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "POST",
        "/ListWorkflowStepExecutions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("workflowExecutionId" => workflowExecutionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_workflows()
    list_workflows(params::Dict{String,<:Any})

Lists workflow build versions based on filtering parameters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"byName"`: Specify all or part of the workflow name to streamline results.
- `"filters"`: Used to streamline search results.
- `"maxResults"`: The maximum items to return in a request.
- `"nextToken"`: A token to specify where to start paginating. This is the nextToken from a
  previously truncated response.
- `"owner"`: Used to get a list of workflow build version filtered by the identity of the
  creator.
"""
function list_workflows(; aws_config::AbstractAWSConfig=current_aws_config())
    return imagebuilder(
        "POST", "/ListWorkflows"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_workflows(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "POST",
        "/ListWorkflows",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_component_policy(component_arn, policy)
    put_component_policy(component_arn, policy, params::Dict{String,<:Any})

Applies a policy to a component. We recommend that you call the RAM API CreateResourceShare
to share resources. If you call the Image Builder API PutComponentPolicy, you must also
call the RAM API PromoteResourceShareCreatedFromPolicy in order for the resource to be
visible to all principals with whom the resource is shared.

# Arguments
- `component_arn`: The Amazon Resource Name (ARN) of the component that this policy should
  be applied to.
- `policy`: The policy to apply.

"""
function put_component_policy(
    componentArn, policy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "PUT",
        "/PutComponentPolicy",
        Dict{String,Any}("componentArn" => componentArn, "policy" => policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_component_policy(
    componentArn,
    policy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/PutComponentPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("componentArn" => componentArn, "policy" => policy),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_container_recipe_policy(container_recipe_arn, policy)
    put_container_recipe_policy(container_recipe_arn, policy, params::Dict{String,<:Any})

Applies a policy to a container image. We recommend that you call the RAM API
CreateResourceShare
(https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to
share resources. If you call the Image Builder API PutContainerImagePolicy, you must also
call the RAM API PromoteResourceShareCreatedFromPolicy
(https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPol
icy.html) in order for the resource to be visible to all principals with whom the resource
is shared.

# Arguments
- `container_recipe_arn`: The Amazon Resource Name (ARN) of the container recipe that this
  policy should be applied to.
- `policy`: The policy to apply to the container recipe.

"""
function put_container_recipe_policy(
    containerRecipeArn, policy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "PUT",
        "/PutContainerRecipePolicy",
        Dict{String,Any}("containerRecipeArn" => containerRecipeArn, "policy" => policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_container_recipe_policy(
    containerRecipeArn,
    policy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/PutContainerRecipePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "containerRecipeArn" => containerRecipeArn, "policy" => policy
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_image_policy(image_arn, policy)
    put_image_policy(image_arn, policy, params::Dict{String,<:Any})

Applies a policy to an image. We recommend that you call the RAM API CreateResourceShare to
share resources. If you call the Image Builder API PutImagePolicy, you must also call the
RAM API PromoteResourceShareCreatedFromPolicy in order for the resource to be visible to
all principals with whom the resource is shared.

# Arguments
- `image_arn`: The Amazon Resource Name (ARN) of the image that this policy should be
  applied to.
- `policy`: The policy to apply.

"""
function put_image_policy(
    imageArn, policy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "PUT",
        "/PutImagePolicy",
        Dict{String,Any}("imageArn" => imageArn, "policy" => policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_image_policy(
    imageArn,
    policy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/PutImagePolicy",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("imageArn" => imageArn, "policy" => policy), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_image_recipe_policy(image_recipe_arn, policy)
    put_image_recipe_policy(image_recipe_arn, policy, params::Dict{String,<:Any})

Applies a policy to an image recipe. We recommend that you call the RAM API
CreateResourceShare to share resources. If you call the Image Builder API
PutImageRecipePolicy, you must also call the RAM API PromoteResourceShareCreatedFromPolicy
in order for the resource to be visible to all principals with whom the resource is shared.

# Arguments
- `image_recipe_arn`: The Amazon Resource Name (ARN) of the image recipe that this policy
  should be applied to.
- `policy`: The policy to apply.

"""
function put_image_recipe_policy(
    imageRecipeArn, policy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "PUT",
        "/PutImageRecipePolicy",
        Dict{String,Any}("imageRecipeArn" => imageRecipeArn, "policy" => policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_image_recipe_policy(
    imageRecipeArn,
    policy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/PutImageRecipePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("imageRecipeArn" => imageRecipeArn, "policy" => policy),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_workflow_step_action(action, client_token, image_build_version_arn, step_execution_id)
    send_workflow_step_action(action, client_token, image_build_version_arn, step_execution_id, params::Dict{String,<:Any})

Pauses or resumes image creation when the associated workflow runs a WaitForAction step.

# Arguments
- `action`: The action for the image creation process to take while a workflow
  WaitForAction step waits for an asynchronous action to complete.
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `image_build_version_arn`: The Amazon Resource Name (ARN) of the image build version to
  send action for.
- `step_execution_id`: Uniquely identifies the workflow step that sent the step action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"reason"`: The reason why this action is sent.
"""
function send_workflow_step_action(
    action,
    clientToken,
    imageBuildVersionArn,
    stepExecutionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/SendWorkflowStepAction",
        Dict{String,Any}(
            "action" => action,
            "clientToken" => clientToken,
            "imageBuildVersionArn" => imageBuildVersionArn,
            "stepExecutionId" => stepExecutionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_workflow_step_action(
    action,
    clientToken,
    imageBuildVersionArn,
    stepExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/SendWorkflowStepAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "action" => action,
                    "clientToken" => clientToken,
                    "imageBuildVersionArn" => imageBuildVersionArn,
                    "stepExecutionId" => stepExecutionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_image_pipeline_execution(client_token, image_pipeline_arn)
    start_image_pipeline_execution(client_token, image_pipeline_arn, params::Dict{String,<:Any})

Manually triggers a pipeline to create an image.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `image_pipeline_arn`: The Amazon Resource Name (ARN) of the image pipeline that you want
  to manually invoke.

"""
function start_image_pipeline_execution(
    clientToken, imagePipelineArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "PUT",
        "/StartImagePipelineExecution",
        Dict{String,Any}(
            "clientToken" => clientToken, "imagePipelineArn" => imagePipelineArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_image_pipeline_execution(
    clientToken,
    imagePipelineArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/StartImagePipelineExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken, "imagePipelineArn" => imagePipelineArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_resource_state_update(client_token, resource_arn, state)
    start_resource_state_update(client_token, resource_arn, state, params::Dict{String,<:Any})

Begin asynchronous resource state update for lifecycle changes to the specified image
resources.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `resource_arn`: The ARN of the Image Builder resource that is updated. The state update
  might also impact associated resources.
- `state`: Indicates the lifecycle action to take for this request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"exclusionRules"`: Skip action on the image resource and associated resources if
  specified exclusion rules are met.
- `"executionRole"`: The name or Amazon Resource Name (ARN) of the IAM role that’s used
  to update image state.
- `"includeResources"`: A list of image resources to update state for.
- `"updateAt"`: The timestamp that indicates when resources are updated by a lifecycle
  action.
"""
function start_resource_state_update(
    clientToken, resourceArn, state; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "PUT",
        "/StartResourceStateUpdate",
        Dict{String,Any}(
            "clientToken" => clientToken, "resourceArn" => resourceArn, "state" => state
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_resource_state_update(
    clientToken,
    resourceArn,
    state,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/StartResourceStateUpdate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "resourceArn" => resourceArn,
                    "state" => state,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds a tag to a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource that you want to tag.
- `tags`: The tags to apply to the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return imagebuilder(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes a tag from a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource that you want to untag.
- `tag_keys`: The tag keys to remove from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return imagebuilder(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_distribution_configuration(client_token, distribution_configuration_arn, distributions)
    update_distribution_configuration(client_token, distribution_configuration_arn, distributions, params::Dict{String,<:Any})

Updates a new distribution configuration. Distribution configurations define and configure
the outputs of your pipeline.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `distribution_configuration_arn`: The Amazon Resource Name (ARN) of the distribution
  configuration that you want to update.
- `distributions`: The distributions of the distribution configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of the distribution configuration.
"""
function update_distribution_configuration(
    clientToken,
    distributionConfigurationArn,
    distributions;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/UpdateDistributionConfiguration",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "distributionConfigurationArn" => distributionConfigurationArn,
            "distributions" => distributions,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_distribution_configuration(
    clientToken,
    distributionConfigurationArn,
    distributions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/UpdateDistributionConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "distributionConfigurationArn" => distributionConfigurationArn,
                    "distributions" => distributions,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_image_pipeline(client_token, image_pipeline_arn, infrastructure_configuration_arn)
    update_image_pipeline(client_token, image_pipeline_arn, infrastructure_configuration_arn, params::Dict{String,<:Any})

Updates an image pipeline. Image pipelines enable you to automate the creation and
distribution of images. You must specify exactly one recipe for your image, using either a
containerRecipeArn or an imageRecipeArn.  UpdateImagePipeline does not support selective
updates for the pipeline. You must specify all of the required properties in the update
request, not just the properties that have changed.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `image_pipeline_arn`: The Amazon Resource Name (ARN) of the image pipeline that you want
  to update.
- `infrastructure_configuration_arn`: The Amazon Resource Name (ARN) of the infrastructure
  configuration that Image Builder uses to build images that this image pipeline has updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"containerRecipeArn"`: The Amazon Resource Name (ARN) of the container pipeline to
  update.
- `"description"`: The description of the image pipeline.
- `"distributionConfigurationArn"`: The Amazon Resource Name (ARN) of the distribution
  configuration that Image Builder uses to configure and distribute images that this image
  pipeline has updated.
- `"enhancedImageMetadataEnabled"`: Collects additional information about the image being
  created, including the operating system (OS) version and package list. This information is
  used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
- `"executionRole"`: The name or Amazon Resource Name (ARN) for the IAM role you create
  that grants Image Builder access to perform workflow actions.
- `"imageRecipeArn"`: The Amazon Resource Name (ARN) of the image recipe that will be used
  to configure images updated by this image pipeline.
- `"imageScanningConfiguration"`: Contains settings for vulnerability scans.
- `"imageTestsConfiguration"`: The image test configuration of the image pipeline.
- `"schedule"`: The schedule of the image pipeline.
- `"status"`: The status of the image pipeline.
- `"workflows"`: Contains the workflows to run for the pipeline.
"""
function update_image_pipeline(
    clientToken,
    imagePipelineArn,
    infrastructureConfigurationArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/UpdateImagePipeline",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "imagePipelineArn" => imagePipelineArn,
            "infrastructureConfigurationArn" => infrastructureConfigurationArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_image_pipeline(
    clientToken,
    imagePipelineArn,
    infrastructureConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/UpdateImagePipeline",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "imagePipelineArn" => imagePipelineArn,
                    "infrastructureConfigurationArn" => infrastructureConfigurationArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_infrastructure_configuration(client_token, infrastructure_configuration_arn, instance_profile_name)
    update_infrastructure_configuration(client_token, infrastructure_configuration_arn, instance_profile_name, params::Dict{String,<:Any})

Updates a new infrastructure configuration. An infrastructure configuration defines the
environment in which your image will be built and tested.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `infrastructure_configuration_arn`: The Amazon Resource Name (ARN) of the infrastructure
  configuration that you want to update.
- `instance_profile_name`: The instance profile to associate with the instance used to
  customize your Amazon EC2 AMI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of the infrastructure configuration.
- `"instanceMetadataOptions"`: The instance metadata options that you can set for the HTTP
  requests that pipeline builds use to launch EC2 build and test instances. For more
  information about instance metadata options, see one of the following links:    Configure
  the instance metadata options in the  Amazon EC2 User Guide  for Linux instances.
  Configure the instance metadata options in the  Amazon EC2 Windows Guide  for Windows
  instances.
- `"instanceTypes"`: The instance types of the infrastructure configuration. You can
  specify one or more instance types to use for this build. The service will pick one of
  these instance types based on availability.
- `"keyPair"`: The key pair of the infrastructure configuration. You can use this to log on
  to and debug the instance used to create your image.
- `"logging"`: The logging configuration of the infrastructure configuration.
- `"resourceTags"`: The tags attached to the resource created by Image Builder.
- `"securityGroupIds"`: The security group IDs to associate with the instance used to
  customize your Amazon EC2 AMI.
- `"snsTopicArn"`: The Amazon Resource Name (ARN) for the SNS topic to which we send image
  build event notifications.  EC2 Image Builder is unable to send notifications to SNS topics
  that are encrypted using keys from other accounts. The key that is used to encrypt the SNS
  topic must reside in the account that the Image Builder service runs under.
- `"subnetId"`: The subnet ID to place the instance used to customize your Amazon EC2 AMI
  in.
- `"terminateInstanceOnFailure"`: The terminate instance on failure setting of the
  infrastructure configuration. Set to false if you want Image Builder to retain the instance
  used to configure your AMI if the build or test phase of your workflow fails.
"""
function update_infrastructure_configuration(
    clientToken,
    infrastructureConfigurationArn,
    instanceProfileName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/UpdateInfrastructureConfiguration",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "infrastructureConfigurationArn" => infrastructureConfigurationArn,
            "instanceProfileName" => instanceProfileName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_infrastructure_configuration(
    clientToken,
    infrastructureConfigurationArn,
    instanceProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/UpdateInfrastructureConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "infrastructureConfigurationArn" => infrastructureConfigurationArn,
                    "instanceProfileName" => instanceProfileName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_lifecycle_policy(client_token, execution_role, lifecycle_policy_arn, policy_details, resource_selection, resource_type)
    update_lifecycle_policy(client_token, execution_role, lifecycle_policy_arn, policy_details, resource_selection, resource_type, params::Dict{String,<:Any})

Update the specified lifecycle policy.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `execution_role`: The name or Amazon Resource Name (ARN) of the IAM role that Image
  Builder uses to update the lifecycle policy.
- `lifecycle_policy_arn`: The Amazon Resource Name (ARN) of the lifecycle policy resource.
- `policy_details`: The configuration details for a lifecycle policy resource.
- `resource_selection`: Selection criteria for resources that the lifecycle policy applies
  to.
- `resource_type`: The type of image resource that the lifecycle policy applies to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: Optional description for the lifecycle policy.
- `"status"`: Indicates whether the lifecycle policy resource is enabled.
"""
function update_lifecycle_policy(
    clientToken,
    executionRole,
    lifecyclePolicyArn,
    policyDetails,
    resourceSelection,
    resourceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/UpdateLifecyclePolicy",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "executionRole" => executionRole,
            "lifecyclePolicyArn" => lifecyclePolicyArn,
            "policyDetails" => policyDetails,
            "resourceSelection" => resourceSelection,
            "resourceType" => resourceType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_lifecycle_policy(
    clientToken,
    executionRole,
    lifecyclePolicyArn,
    policyDetails,
    resourceSelection,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return imagebuilder(
        "PUT",
        "/UpdateLifecyclePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "executionRole" => executionRole,
                    "lifecyclePolicyArn" => lifecyclePolicyArn,
                    "policyDetails" => policyDetails,
                    "resourceSelection" => resourceSelection,
                    "resourceType" => resourceType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
