# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: lakeformation
using AWS.Compat
using AWS.UUIDs

"""
    add_lftags_to_resource(lftags, resource)
    add_lftags_to_resource(lftags, resource, params::Dict{String,<:Any})

Attaches one or more LF-tags to an existing resource.

# Arguments
- `lftags`: The LF-tags to attach to the resource.
- `resource`: The database, table, or column resource to which to attach an LF-tag.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
"""
function add_lftags_to_resource(
    LFTags, Resource; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/AddLFTagsToResource",
        Dict{String,Any}("LFTags" => LFTags, "Resource" => Resource);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_lftags_to_resource(
    LFTags,
    Resource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/AddLFTagsToResource",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("LFTags" => LFTags, "Resource" => Resource), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    assume_decorated_role_with_saml(principal_arn, role_arn, samlassertion)
    assume_decorated_role_with_saml(principal_arn, role_arn, samlassertion, params::Dict{String,<:Any})

Allows a caller to assume an IAM role decorated as the SAML user specified in the SAML
assertion included in the request. This decoration allows Lake Formation to enforce access
policies against the SAML users and groups. This API operation requires SAML federation
setup in the caller’s account as it can only be called with valid SAML assertions. Lake
Formation does not scope down the permission of the assumed role. All permissions attached
to the role via the SAML federation setup will be included in the role session.   This
decorated role is expected to access data in Amazon S3 by getting temporary access from
Lake Formation which is authorized via the virtual API GetDataAccess. Therefore, all SAML
roles that can be assumed via AssumeDecoratedRoleWithSAML must at a minimum include
lakeformation:GetDataAccess in their role policies. A typical IAM policy attached to such a
role would look as follows:

# Arguments
- `principal_arn`: The Amazon Resource Name (ARN) of the SAML provider in IAM that
  describes the IdP.
- `role_arn`: The role that represents an IAM principal whose scope down policy allows it
  to call credential vending APIs such as GetTemporaryTableCredentials. The caller must also
  have iam:PassRole permission on this role.
- `samlassertion`: A SAML assertion consisting of an assertion statement for the user who
  needs temporary credentials. This must match the SAML assertion that was issued to IAM.
  This must be Base64 encoded.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DurationSeconds"`: The time period, between 900 and 43,200 seconds, for the timeout of
  the temporary credentials.
"""
function assume_decorated_role_with_saml(
    PrincipalArn, RoleArn, SAMLAssertion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/AssumeDecoratedRoleWithSAML",
        Dict{String,Any}(
            "PrincipalArn" => PrincipalArn,
            "RoleArn" => RoleArn,
            "SAMLAssertion" => SAMLAssertion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function assume_decorated_role_with_saml(
    PrincipalArn,
    RoleArn,
    SAMLAssertion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/AssumeDecoratedRoleWithSAML",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PrincipalArn" => PrincipalArn,
                    "RoleArn" => RoleArn,
                    "SAMLAssertion" => SAMLAssertion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_grant_permissions(entries)
    batch_grant_permissions(entries, params::Dict{String,<:Any})

Batch operation to grant permissions to the principal.

# Arguments
- `entries`: A list of up to 20 entries for resource permissions to be granted by batch
  operation to the principal.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
"""
function batch_grant_permissions(
    Entries; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/BatchGrantPermissions",
        Dict{String,Any}("Entries" => Entries);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_grant_permissions(
    Entries,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/BatchGrantPermissions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Entries" => Entries), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_revoke_permissions(entries)
    batch_revoke_permissions(entries, params::Dict{String,<:Any})

Batch operation to revoke permissions from the principal.

# Arguments
- `entries`: A list of up to 20 entries for resource permissions to be revoked by batch
  operation to the principal.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
"""
function batch_revoke_permissions(
    Entries; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/BatchRevokePermissions",
        Dict{String,Any}("Entries" => Entries);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_revoke_permissions(
    Entries,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/BatchRevokePermissions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Entries" => Entries), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_transaction(transaction_id)
    cancel_transaction(transaction_id, params::Dict{String,<:Any})

Attempts to cancel the specified transaction. Returns an exception if the transaction was
previously committed.

# Arguments
- `transaction_id`: The transaction to cancel.

"""
function cancel_transaction(
    TransactionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/CancelTransaction",
        Dict{String,Any}("TransactionId" => TransactionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_transaction(
    TransactionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/CancelTransaction",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TransactionId" => TransactionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    commit_transaction(transaction_id)
    commit_transaction(transaction_id, params::Dict{String,<:Any})

Attempts to commit the specified transaction. Returns an exception if the transaction was
previously aborted. This API action is idempotent if called multiple times for the same
transaction.

# Arguments
- `transaction_id`: The transaction to commit.

"""
function commit_transaction(
    TransactionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/CommitTransaction",
        Dict{String,Any}("TransactionId" => TransactionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function commit_transaction(
    TransactionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/CommitTransaction",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TransactionId" => TransactionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_data_cells_filter(table_data)
    create_data_cells_filter(table_data, params::Dict{String,<:Any})

Creates a data cell filter to allow one to grant access to certain columns on certain rows.

# Arguments
- `table_data`: A DataCellsFilter structure containing information about the data cells
  filter.

"""
function create_data_cells_filter(
    TableData; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/CreateDataCellsFilter",
        Dict{String,Any}("TableData" => TableData);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_data_cells_filter(
    TableData,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/CreateDataCellsFilter",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableData" => TableData), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_lake_formation_identity_center_configuration()
    create_lake_formation_identity_center_configuration(params::Dict{String,<:Any})

Creates an IAM Identity Center connection with Lake Formation to allow IAM Identity Center
users and groups to access Data Catalog resources.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, view definitions, and other control information to manage your Lake Formation
  environment.
- `"ExternalFiltering"`: A list of the account IDs of Amazon Web Services accounts of
  third-party applications that are allowed to access data managed by Lake Formation.
- `"InstanceArn"`: The ARN of the IAM Identity Center instance for which the operation will
  be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
  Web Services Service Namespaces in the Amazon Web Services General Reference.
- `"ShareRecipients"`: A list of Amazon Web Services account IDs and/or Amazon Web Services
  organization/organizational unit ARNs that are allowed to access data managed by Lake
  Formation.  If the ShareRecipients list includes valid values, a resource share is created
  with the principals you want to have access to the resources. If the ShareRecipients value
  is null or the list is empty, no resource share is created.
"""
function create_lake_formation_identity_center_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/CreateLakeFormationIdentityCenterConfiguration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_lake_formation_identity_center_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/CreateLakeFormationIdentityCenterConfiguration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_lake_formation_opt_in(principal, resource)
    create_lake_formation_opt_in(principal, resource, params::Dict{String,<:Any})

Enforce Lake Formation permissions for the given databases, tables, and principals.

# Arguments
- `principal`:
- `resource`:

"""
function create_lake_formation_opt_in(
    Principal, Resource; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/CreateLakeFormationOptIn",
        Dict{String,Any}("Principal" => Principal, "Resource" => Resource);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_lake_formation_opt_in(
    Principal,
    Resource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/CreateLakeFormationOptIn",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Principal" => Principal, "Resource" => Resource),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_lftag(tag_key, tag_values)
    create_lftag(tag_key, tag_values, params::Dict{String,<:Any})

Creates an LF-tag with the specified name and values.

# Arguments
- `tag_key`: The key-name for the LF-tag.
- `tag_values`: A list of possible values an attribute can take.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
"""
function create_lftag(TagKey, TagValues; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/CreateLFTag",
        Dict{String,Any}("TagKey" => TagKey, "TagValues" => TagValues);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_lftag(
    TagKey,
    TagValues,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/CreateLFTag",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("TagKey" => TagKey, "TagValues" => TagValues),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_data_cells_filter()
    delete_data_cells_filter(params::Dict{String,<:Any})

Deletes a data cell filter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DatabaseName"`: A database in the Glue Data Catalog.
- `"Name"`: The name given by the user to the data filter cell.
- `"TableCatalogId"`: The ID of the catalog to which the table belongs.
- `"TableName"`: A table in the database.
"""
function delete_data_cells_filter(; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/DeleteDataCellsFilter";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_data_cells_filter(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/DeleteDataCellsFilter",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_lake_formation_identity_center_configuration()
    delete_lake_formation_identity_center_configuration(params::Dict{String,<:Any})

Deletes an IAM Identity Center connection with Lake Formation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, view definition, and other control information to manage your Lake Formation
  environment.
"""
function delete_lake_formation_identity_center_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/DeleteLakeFormationIdentityCenterConfiguration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_lake_formation_identity_center_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/DeleteLakeFormationIdentityCenterConfiguration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_lake_formation_opt_in(principal, resource)
    delete_lake_formation_opt_in(principal, resource, params::Dict{String,<:Any})

Remove the Lake Formation permissions enforcement of the given databases, tables, and
principals.

# Arguments
- `principal`:
- `resource`:

"""
function delete_lake_formation_opt_in(
    Principal, Resource; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/DeleteLakeFormationOptIn",
        Dict{String,Any}("Principal" => Principal, "Resource" => Resource);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_lake_formation_opt_in(
    Principal,
    Resource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/DeleteLakeFormationOptIn",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Principal" => Principal, "Resource" => Resource),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_lftag(tag_key)
    delete_lftag(tag_key, params::Dict{String,<:Any})

Deletes the specified LF-tag given a key name. If the input parameter tag key was not
found, then the operation will throw an exception. When you delete an LF-tag, the
LFTagPolicy attached to the LF-tag becomes invalid. If the deleted LF-tag was still
assigned to any resource, the tag policy attach to the deleted LF-tag will no longer be
applied to the resource.

# Arguments
- `tag_key`: The key-name for the LF-tag to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
"""
function delete_lftag(TagKey; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/DeleteLFTag",
        Dict{String,Any}("TagKey" => TagKey);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_lftag(
    TagKey, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/DeleteLFTag",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("TagKey" => TagKey), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_objects_on_cancel(database_name, objects, table_name, transaction_id)
    delete_objects_on_cancel(database_name, objects, table_name, transaction_id, params::Dict{String,<:Any})

For a specific governed table, provides a list of Amazon S3 objects that will be written
during the current transaction and that can be automatically deleted if the transaction is
canceled. Without this call, no Amazon S3 objects are automatically deleted when a
transaction cancels.   The Glue ETL library function write_dynamic_frame.from_catalog()
includes an option to automatically call DeleteObjectsOnCancel before writes. For more
information, see Rolling Back Amazon S3 Writes.

# Arguments
- `database_name`: The database that contains the governed table.
- `objects`: A list of VirtualObject structures, which indicates the Amazon S3 objects to
  be deleted if the transaction cancels.
- `table_name`: The name of the governed table.
- `transaction_id`: ID of the transaction that the writes occur in.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The Glue data catalog that contains the governed table. Defaults to the
  current account ID.
"""
function delete_objects_on_cancel(
    DatabaseName,
    Objects,
    TableName,
    TransactionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/DeleteObjectsOnCancel",
        Dict{String,Any}(
            "DatabaseName" => DatabaseName,
            "Objects" => Objects,
            "TableName" => TableName,
            "TransactionId" => TransactionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_objects_on_cancel(
    DatabaseName,
    Objects,
    TableName,
    TransactionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/DeleteObjectsOnCancel",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DatabaseName" => DatabaseName,
                    "Objects" => Objects,
                    "TableName" => TableName,
                    "TransactionId" => TransactionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_resource(resource_arn)
    deregister_resource(resource_arn, params::Dict{String,<:Any})

Deregisters the resource as managed by the Data Catalog. When you deregister a path, Lake
Formation removes the path from the inline policy attached to your service-linked role.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource that you want to
  deregister.

"""
function deregister_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/DeregisterResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/DeregisterResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_lake_formation_identity_center_configuration()
    describe_lake_formation_identity_center_configuration(params::Dict{String,<:Any})

Retrieves the instance ARN and application ARN for the connection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
"""
function describe_lake_formation_identity_center_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/DescribeLakeFormationIdentityCenterConfiguration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_lake_formation_identity_center_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/DescribeLakeFormationIdentityCenterConfiguration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_resource(resource_arn)
    describe_resource(resource_arn, params::Dict{String,<:Any})

Retrieves the current data access role for the given resource registered in Lake Formation.

# Arguments
- `resource_arn`: The resource ARN.

"""
function describe_resource(ResourceArn; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/DescribeResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/DescribeResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_transaction(transaction_id)
    describe_transaction(transaction_id, params::Dict{String,<:Any})

Returns the details of a single transaction.

# Arguments
- `transaction_id`: The transaction for which to return status.

"""
function describe_transaction(
    TransactionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/DescribeTransaction",
        Dict{String,Any}("TransactionId" => TransactionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_transaction(
    TransactionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/DescribeTransaction",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TransactionId" => TransactionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    extend_transaction()
    extend_transaction(params::Dict{String,<:Any})

Indicates to the service that the specified transaction is still active and should not be
treated as idle and aborted. Write transactions that remain idle for a long period are
automatically aborted unless explicitly extended.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TransactionId"`: The transaction to extend.
"""
function extend_transaction(; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST", "/ExtendTransaction"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function extend_transaction(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/ExtendTransaction",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_data_cells_filter(database_name, name, table_catalog_id, table_name)
    get_data_cells_filter(database_name, name, table_catalog_id, table_name, params::Dict{String,<:Any})

Returns a data cells filter.

# Arguments
- `database_name`: A database in the Glue Data Catalog.
- `name`: The name given by the user to the data filter cell.
- `table_catalog_id`: The ID of the catalog to which the table belongs.
- `table_name`: A table in the database.

"""
function get_data_cells_filter(
    DatabaseName,
    Name,
    TableCatalogId,
    TableName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/GetDataCellsFilter",
        Dict{String,Any}(
            "DatabaseName" => DatabaseName,
            "Name" => Name,
            "TableCatalogId" => TableCatalogId,
            "TableName" => TableName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_data_cells_filter(
    DatabaseName,
    Name,
    TableCatalogId,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/GetDataCellsFilter",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DatabaseName" => DatabaseName,
                    "Name" => Name,
                    "TableCatalogId" => TableCatalogId,
                    "TableName" => TableName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_data_lake_principal()
    get_data_lake_principal(params::Dict{String,<:Any})

Returns the identity of the invoking principal.

"""
function get_data_lake_principal(; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/GetDataLakePrincipal";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_data_lake_principal(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/GetDataLakePrincipal",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_data_lake_settings()
    get_data_lake_settings(params::Dict{String,<:Any})

Retrieves the list of the data lake administrators of a Lake Formation-managed data lake.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
"""
function get_data_lake_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/GetDataLakeSettings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_data_lake_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/GetDataLakeSettings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_effective_permissions_for_path(resource_arn)
    get_effective_permissions_for_path(resource_arn, params::Dict{String,<:Any})

Returns the Lake Formation permissions for a specified table or database resource located
at a path in Amazon S3. GetEffectivePermissionsForPath will not return databases and tables
if the catalog is encrypted.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource for which you want to get
  permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: A continuation token, if this is not the first call to retrieve this list.
"""
function get_effective_permissions_for_path(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/GetEffectivePermissionsForPath",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_effective_permissions_for_path(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/GetEffectivePermissionsForPath",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_lftag(tag_key)
    get_lftag(tag_key, params::Dict{String,<:Any})

Returns an LF-tag definition.

# Arguments
- `tag_key`: The key-name for the LF-tag.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
"""
function get_lftag(TagKey; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/GetLFTag",
        Dict{String,Any}("TagKey" => TagKey);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_lftag(
    TagKey, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/GetLFTag",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("TagKey" => TagKey), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_query_state(query_id)
    get_query_state(query_id, params::Dict{String,<:Any})

Returns the state of a query previously submitted. Clients are expected to poll
GetQueryState to monitor the current state of the planning before retrieving the work
units. A query state is only visible to the principal that made the initial call to
StartQueryPlanning.

# Arguments
- `query_id`: The ID of the plan query operation.

"""
function get_query_state(QueryId; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/GetQueryState",
        Dict{String,Any}("QueryId" => QueryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_query_state(
    QueryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/GetQueryState",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("QueryId" => QueryId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_query_statistics(query_id)
    get_query_statistics(query_id, params::Dict{String,<:Any})

Retrieves statistics on the planning and execution of a query.

# Arguments
- `query_id`: The ID of the plan query operation.

"""
function get_query_statistics(QueryId; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/GetQueryStatistics",
        Dict{String,Any}("QueryId" => QueryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_query_statistics(
    QueryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/GetQueryStatistics",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("QueryId" => QueryId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_lftags(resource)
    get_resource_lftags(resource, params::Dict{String,<:Any})

Returns the LF-tags applied to a resource.

# Arguments
- `resource`: The database, table, or column resource for which you want to return LF-tags.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
- `"ShowAssignedLFTags"`: Indicates whether to show the assigned LF-tags.
"""
function get_resource_lftags(Resource; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/GetResourceLFTags",
        Dict{String,Any}("Resource" => Resource);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_lftags(
    Resource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/GetResourceLFTags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Resource" => Resource), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_table_objects(database_name, table_name)
    get_table_objects(database_name, table_name, params::Dict{String,<:Any})

Returns the set of Amazon S3 objects that make up the specified governed table. A
transaction ID or timestamp can be specified for time-travel queries.

# Arguments
- `database_name`: The database containing the governed table.
- `table_name`: The governed table for which to retrieve objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The catalog containing the governed table. Defaults to the caller’s
  account.
- `"MaxResults"`: Specifies how many values to return in a page.
- `"NextToken"`: A continuation token if this is not the first call to retrieve these
  objects.
- `"PartitionPredicate"`: A predicate to filter the objects returned based on the partition
  keys defined in the governed table.   The comparison operators supported are: =, &gt;,
  &lt;, &gt;=, &lt;=   The logical operators supported are: AND   The data types supported
  are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd
  HH:mm:ss\"), string and decimal.
- `"QueryAsOfTime"`: The time as of when to read the governed table contents. If not set,
  the most recent transaction commit time is used. Cannot be specified along with
  TransactionId.
- `"TransactionId"`: The transaction ID at which to read the governed table contents. If
  this transaction has aborted, an error is returned. If not set, defaults to the most recent
  committed transaction. Cannot be specified along with QueryAsOfTime.
"""
function get_table_objects(
    DatabaseName, TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/GetTableObjects",
        Dict{String,Any}("DatabaseName" => DatabaseName, "TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_table_objects(
    DatabaseName,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/GetTableObjects",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DatabaseName" => DatabaseName, "TableName" => TableName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_temporary_glue_partition_credentials(partition, table_arn)
    get_temporary_glue_partition_credentials(partition, table_arn, params::Dict{String,<:Any})

This API is identical to GetTemporaryTableCredentials except that this is used when the
target Data Catalog resource is of type Partition. Lake Formation restricts the permission
of the vended credentials with the same scope down policy which restricts access to a
single Amazon S3 prefix.

# Arguments
- `partition`: A list of partition values identifying a single partition.
- `table_arn`: The ARN of the partitions' table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuditContext"`: A structure representing context to access a resource (column names,
  query ID, etc).
- `"DurationSeconds"`: The time period, between 900 and 21,600 seconds, for the timeout of
  the temporary credentials.
- `"Permissions"`: Filters the request based on the user having been granted a list of
  specified permissions on the requested resource(s).
- `"SupportedPermissionTypes"`: A list of supported permission types for the partition.
  Valid values are COLUMN_PERMISSION and CELL_FILTER_PERMISSION.
"""
function get_temporary_glue_partition_credentials(
    Partition, TableArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/GetTemporaryGluePartitionCredentials",
        Dict{String,Any}("Partition" => Partition, "TableArn" => TableArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_temporary_glue_partition_credentials(
    Partition,
    TableArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/GetTemporaryGluePartitionCredentials",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Partition" => Partition, "TableArn" => TableArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_temporary_glue_table_credentials(table_arn)
    get_temporary_glue_table_credentials(table_arn, params::Dict{String,<:Any})

Allows a caller in a secure environment to assume a role with permission to access Amazon
S3. In order to vend such credentials, Lake Formation assumes the role associated with a
registered location, for example an Amazon S3 bucket, with a scope down policy which
restricts the access to a single prefix.

# Arguments
- `table_arn`: The ARN identifying a table in the Data Catalog for the temporary
  credentials request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuditContext"`: A structure representing context to access a resource (column names,
  query ID, etc).
- `"DurationSeconds"`: The time period, between 900 and 21,600 seconds, for the timeout of
  the temporary credentials.
- `"Permissions"`: Filters the request based on the user having been granted a list of
  specified permissions on the requested resource(s).
- `"QuerySessionContext"`: A structure used as a protocol between query engines and Lake
  Formation or Glue. Contains both a Lake Formation generated authorization identifier and
  information from the request's authorization context.
- `"S3Path"`: The Amazon S3 path for the table.
- `"SupportedPermissionTypes"`: A list of supported permission types for the table. Valid
  values are COLUMN_PERMISSION and CELL_FILTER_PERMISSION.
"""
function get_temporary_glue_table_credentials(
    TableArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/GetTemporaryGlueTableCredentials",
        Dict{String,Any}("TableArn" => TableArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_temporary_glue_table_credentials(
    TableArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/GetTemporaryGlueTableCredentials",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableArn" => TableArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_work_unit_results(query_id, work_unit_id, work_unit_token)
    get_work_unit_results(query_id, work_unit_id, work_unit_token, params::Dict{String,<:Any})

Returns the work units resulting from the query. Work units can be executed in any order
and in parallel.

# Arguments
- `query_id`: The ID of the plan query operation for which to get results.
- `work_unit_id`: The work unit ID for which to get results. Value generated by enumerating
  WorkUnitIdMin to WorkUnitIdMax (inclusive) from the WorkUnitRange in the output of
  GetWorkUnits.
- `work_unit_token`: A work token used to query the execution service. Token output from
  GetWorkUnits.

"""
function get_work_unit_results(
    QueryId, WorkUnitId, WorkUnitToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/GetWorkUnitResults",
        Dict{String,Any}(
            "QueryId" => QueryId,
            "WorkUnitId" => WorkUnitId,
            "WorkUnitToken" => WorkUnitToken,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_work_unit_results(
    QueryId,
    WorkUnitId,
    WorkUnitToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/GetWorkUnitResults",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "QueryId" => QueryId,
                    "WorkUnitId" => WorkUnitId,
                    "WorkUnitToken" => WorkUnitToken,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_work_units(query_id)
    get_work_units(query_id, params::Dict{String,<:Any})

Retrieves the work units generated by the StartQueryPlanning operation.

# Arguments
- `query_id`: The ID of the plan query operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: A continuation token, if this is a continuation call.
- `"PageSize"`: The size of each page to get in the Amazon Web Services service call. This
  does not affect the number of items returned in the command's output. Setting a smaller
  page size results in more calls to the Amazon Web Services service, retrieving fewer items
  in each call. This can help prevent the Amazon Web Services service calls from timing out.
"""
function get_work_units(QueryId; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/GetWorkUnits",
        Dict{String,Any}("QueryId" => QueryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_work_units(
    QueryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/GetWorkUnits",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("QueryId" => QueryId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    grant_permissions(permissions, principal, resource)
    grant_permissions(permissions, principal, resource, params::Dict{String,<:Any})

Grants permissions to the principal to access metadata in the Data Catalog and data
organized in underlying data storage such as Amazon S3. For information about permissions,
see Security and Access Control to Metadata and Data.

# Arguments
- `permissions`: The permissions granted to the principal on the resource. Lake Formation
  defines privileges to grant and revoke access to metadata in the Data Catalog and data
  organized in underlying data storage such as Amazon S3. Lake Formation requires that each
  principal be authorized to perform a specific task on Lake Formation resources.
- `principal`: The principal to be granted the permissions on the resource. Supported
  principals are IAM users or IAM roles, and they are defined by their principal type and
  their ARN. Note that if you define a resource with a particular ARN, then later delete, and
  recreate a resource with that same ARN, the resource maintains the permissions already
  granted.
- `resource`: The resource to which permissions are to be granted. Resources in Lake
  Formation are the Data Catalog, databases, and tables.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
- `"PermissionsWithGrantOption"`: Indicates a list of the granted permissions that the
  principal may pass to other users. These permissions may only be a subset of the
  permissions granted in the Privileges.
"""
function grant_permissions(
    Permissions, Principal, Resource; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/GrantPermissions",
        Dict{String,Any}(
            "Permissions" => Permissions, "Principal" => Principal, "Resource" => Resource
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function grant_permissions(
    Permissions,
    Principal,
    Resource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/GrantPermissions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Permissions" => Permissions,
                    "Principal" => Principal,
                    "Resource" => Resource,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_data_cells_filter()
    list_data_cells_filter(params::Dict{String,<:Any})

Lists all the data cell filters on a table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum size of the response.
- `"NextToken"`: A continuation token, if this is a continuation call.
- `"Table"`: A table in the Glue Data Catalog.
"""
function list_data_cells_filter(; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/ListDataCellsFilter";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_data_cells_filter(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/ListDataCellsFilter",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_lake_formation_opt_ins()
    list_lake_formation_opt_ins(params::Dict{String,<:Any})

Retrieve the current list of resources and principals that are opt in to enforce Lake
Formation permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: A continuation token, if this is not the first call to retrieve this list.
- `"Principal"`:
- `"Resource"`: A structure for the resource.
"""
function list_lake_formation_opt_ins(; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/ListLakeFormationOptIns";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_lake_formation_opt_ins(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/ListLakeFormationOptIns",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_lftags()
    list_lftags(params::Dict{String,<:Any})

Lists LF-tags that the requester has permission to view.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: A continuation token, if this is not the first call to retrieve this list.
- `"ResourceShareType"`: If resource share type is ALL, returns both in-account LF-tags and
  shared LF-tags that the requester has permission to view. If resource share type is
  FOREIGN, returns all share LF-tags that the requester can view. If no resource share type
  is passed, lists LF-tags in the given catalog ID that the requester has permission to view.
"""
function list_lftags(; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST", "/ListLFTags"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_lftags(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/ListLFTags",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_permissions()
    list_permissions(params::Dict{String,<:Any})

Returns a list of the principal permissions on the resource, filtered by the permissions of
the caller. For example, if you are granted an ALTER permission, you are able to see only
the principal permissions for ALTER. This operation returns only those permissions that
have been explicitly granted. For information about permissions, see Security and Access
Control to Metadata and Data.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
- `"IncludeRelated"`: Indicates that related permissions should be included in the results.
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: A continuation token, if this is not the first call to retrieve this list.
- `"Principal"`: Specifies a principal to filter the permissions returned.
- `"Resource"`: A resource where you will get a list of the principal permissions. This
  operation does not support getting privileges on a table with columns. Instead, call this
  operation on the table, and the operation returns the table and the table w columns.
- `"ResourceType"`: Specifies a resource type to filter the permissions returned.
"""
function list_permissions(; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST", "/ListPermissions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_permissions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/ListPermissions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resources()
    list_resources(params::Dict{String,<:Any})

Lists the resources registered to be managed by the Data Catalog.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FilterConditionList"`: Any applicable row-level and/or column-level filtering
  conditions for the resources.
- `"MaxResults"`: The maximum number of resource results.
- `"NextToken"`: A continuation token, if this is not the first call to retrieve these
  resources.
"""
function list_resources(; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST", "/ListResources"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_resources(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/ListResources",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_table_storage_optimizers(database_name, table_name)
    list_table_storage_optimizers(database_name, table_name, params::Dict{String,<:Any})

Returns the configuration of all storage optimizers associated with a specified table.

# Arguments
- `database_name`: Name of the database where the table is present.
- `table_name`: Name of the table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The Catalog ID of the table.
- `"MaxResults"`: The number of storage optimizers to return on each call.
- `"NextToken"`: A continuation token, if this is a continuation call.
- `"StorageOptimizerType"`: The specific type of storage optimizers to list. The supported
  value is compaction.
"""
function list_table_storage_optimizers(
    DatabaseName, TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/ListTableStorageOptimizers",
        Dict{String,Any}("DatabaseName" => DatabaseName, "TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_table_storage_optimizers(
    DatabaseName,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/ListTableStorageOptimizers",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DatabaseName" => DatabaseName, "TableName" => TableName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_transactions()
    list_transactions(params::Dict{String,<:Any})

Returns metadata about transactions and their status. To prevent the response from growing
indefinitely, only uncommitted transactions and those available for time-travel queries are
returned. This operation can help you identify uncommitted transactions or to get
information about transactions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The catalog for which to list transactions. Defaults to the account ID of
  the caller.
- `"MaxResults"`: The maximum number of transactions to return in a single call.
- `"NextToken"`: A continuation token if this is not the first call to retrieve
  transactions.
- `"StatusFilter"`:  A filter indicating the status of transactions to return. Options are
  ALL | COMPLETED | COMMITTED | ABORTED | ACTIVE. The default is ALL.
"""
function list_transactions(; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST", "/ListTransactions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_transactions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/ListTransactions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_data_lake_settings(data_lake_settings)
    put_data_lake_settings(data_lake_settings, params::Dict{String,<:Any})

Sets the list of data lake administrators who have admin privileges on all resources
managed by Lake Formation. For more information on admin privileges, see Granting Lake
Formation Permissions. This API replaces the current list of data lake admins with the new
list being passed. To add an admin, fetch the current list and add the new admin to that
list and pass that list in this API.

# Arguments
- `data_lake_settings`: A structure representing a list of Lake Formation principals
  designated as data lake administrators.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
"""
function put_data_lake_settings(
    DataLakeSettings; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/PutDataLakeSettings",
        Dict{String,Any}("DataLakeSettings" => DataLakeSettings);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_data_lake_settings(
    DataLakeSettings,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/PutDataLakeSettings",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DataLakeSettings" => DataLakeSettings), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_resource(resource_arn)
    register_resource(resource_arn, params::Dict{String,<:Any})

Registers the resource as managed by the Data Catalog. To add or update data, Lake
Formation needs read/write access to the chosen Amazon S3 path. Choose a role that you know
has permission to do this, or choose the AWSServiceRoleForLakeFormationDataAccess
service-linked role. When you register the first Amazon S3 path, the service-linked role
and a new inline policy are created on your behalf. Lake Formation adds the first path to
the inline policy and attaches it to the service-linked role. When you register subsequent
paths, Lake Formation adds the path to the existing policy. The following request registers
a new location and gives Lake Formation permission to use the service-linked role to access
that location.  ResourceArn = arn:aws:s3:::my-bucket UseServiceLinkedRole = true  If
UseServiceLinkedRole is not set to true, you must provide or set the RoleArn:
arn:aws:iam::12345:role/my-data-access-role

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource that you want to register.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"HybridAccessEnabled"`:  Specifies whether the data access of tables pointing to the
  location can be managed by both Lake Formation permissions as well as Amazon S3 bucket
  policies.
- `"RoleArn"`: The identifier for the role that registers the resource.
- `"UseServiceLinkedRole"`: Designates an Identity and Access Management (IAM)
  service-linked role by registering this role with the Data Catalog. A service-linked role
  is a unique type of IAM role that is linked directly to Lake Formation. For more
  information, see Using Service-Linked Roles for Lake Formation.
- `"WithFederation"`: Whether or not the resource is a federated resource.
"""
function register_resource(ResourceArn; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/RegisterResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/RegisterResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_lftags_from_resource(lftags, resource)
    remove_lftags_from_resource(lftags, resource, params::Dict{String,<:Any})

Removes an LF-tag from the resource. Only database, table, or tableWithColumns resource are
allowed. To tag columns, use the column inclusion list in tableWithColumns to specify
column input.

# Arguments
- `lftags`: The LF-tags to be removed from the resource.
- `resource`: The database, table, or column resource where you want to remove an LF-tag.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
"""
function remove_lftags_from_resource(
    LFTags, Resource; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/RemoveLFTagsFromResource",
        Dict{String,Any}("LFTags" => LFTags, "Resource" => Resource);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_lftags_from_resource(
    LFTags,
    Resource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/RemoveLFTagsFromResource",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("LFTags" => LFTags, "Resource" => Resource), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    revoke_permissions(permissions, principal, resource)
    revoke_permissions(permissions, principal, resource, params::Dict{String,<:Any})

Revokes permissions to the principal to access metadata in the Data Catalog and data
organized in underlying data storage such as Amazon S3.

# Arguments
- `permissions`: The permissions revoked to the principal on the resource. For information
  about permissions, see Security and Access Control to Metadata and Data.
- `principal`: The principal to be revoked permissions on the resource.
- `resource`: The resource to which permissions are to be revoked.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
- `"PermissionsWithGrantOption"`: Indicates a list of permissions for which to revoke the
  grant option allowing the principal to pass permissions to other principals.
"""
function revoke_permissions(
    Permissions, Principal, Resource; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/RevokePermissions",
        Dict{String,Any}(
            "Permissions" => Permissions, "Principal" => Principal, "Resource" => Resource
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function revoke_permissions(
    Permissions,
    Principal,
    Resource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/RevokePermissions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Permissions" => Permissions,
                    "Principal" => Principal,
                    "Resource" => Resource,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_databases_by_lftags(expression)
    search_databases_by_lftags(expression, params::Dict{String,<:Any})

This operation allows a search on DATABASE resources by TagCondition. This operation is
used by admins who want to grant user permissions on certain TagConditions. Before making a
grant, the admin can use SearchDatabasesByTags to find all resources where the given
TagConditions are valid to verify whether the returned resources can be shared.

# Arguments
- `expression`: A list of conditions (LFTag structures) to search for in database resources.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: A continuation token, if this is not the first call to retrieve this list.
"""
function search_databases_by_lftags(
    Expression; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/SearchDatabasesByLFTags",
        Dict{String,Any}("Expression" => Expression);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_databases_by_lftags(
    Expression,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/SearchDatabasesByLFTags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Expression" => Expression), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_tables_by_lftags(expression)
    search_tables_by_lftags(expression, params::Dict{String,<:Any})

This operation allows a search on TABLE resources by LFTags. This will be used by admins
who want to grant user permissions on certain LF-tags. Before making a grant, the admin can
use SearchTablesByLFTags to find all resources where the given LFTags are valid to verify
whether the returned resources can be shared.

# Arguments
- `expression`: A list of conditions (LFTag structures) to search for in table resources.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: A continuation token, if this is not the first call to retrieve this list.
"""
function search_tables_by_lftags(
    Expression; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/SearchTablesByLFTags",
        Dict{String,Any}("Expression" => Expression);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_tables_by_lftags(
    Expression,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/SearchTablesByLFTags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Expression" => Expression), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_query_planning(query_planning_context, query_string)
    start_query_planning(query_planning_context, query_string, params::Dict{String,<:Any})

Submits a request to process a query statement. This operation generates work units that
can be retrieved with the GetWorkUnits operation as soon as the query state is
WORKUNITS_AVAILABLE or FINISHED.

# Arguments
- `query_planning_context`: A structure containing information about the query plan.
- `query_string`: A PartiQL query statement used as an input to the planner service.

"""
function start_query_planning(
    QueryPlanningContext, QueryString; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/StartQueryPlanning",
        Dict{String,Any}(
            "QueryPlanningContext" => QueryPlanningContext, "QueryString" => QueryString
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_query_planning(
    QueryPlanningContext,
    QueryString,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/StartQueryPlanning",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "QueryPlanningContext" => QueryPlanningContext,
                    "QueryString" => QueryString,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_transaction()
    start_transaction(params::Dict{String,<:Any})

Starts a new transaction and returns its transaction ID. Transaction IDs are opaque objects
that you can use to identify a transaction.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TransactionType"`: Indicates whether this transaction should be read only or read and
  write. Writes made using a read-only transaction ID will be rejected. Read-only
  transactions do not need to be committed.
"""
function start_transaction(; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST", "/StartTransaction"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function start_transaction(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/StartTransaction",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_data_cells_filter(table_data)
    update_data_cells_filter(table_data, params::Dict{String,<:Any})

Updates a data cell filter.

# Arguments
- `table_data`: A DataCellsFilter structure containing information about the data cells
  filter.

"""
function update_data_cells_filter(
    TableData; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/UpdateDataCellsFilter",
        Dict{String,Any}("TableData" => TableData);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_data_cells_filter(
    TableData,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/UpdateDataCellsFilter",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableData" => TableData), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_lake_formation_identity_center_configuration()
    update_lake_formation_identity_center_configuration(params::Dict{String,<:Any})

Updates the IAM Identity Center connection parameters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApplicationStatus"`: Allows to enable or disable the IAM Identity Center connection.
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, view definitions, and other control information to manage your Lake Formation
  environment.
- `"ExternalFiltering"`: A list of the account IDs of Amazon Web Services accounts of
  third-party applications that are allowed to access data managed by Lake Formation.
- `"ShareRecipients"`: A list of Amazon Web Services account IDs or Amazon Web Services
  organization/organizational unit ARNs that are allowed to access to access data managed by
  Lake Formation.  If the ShareRecipients list includes valid values, then the resource share
  is updated with the principals you want to have access to the resources. If the
  ShareRecipients value is null, both the list of share recipients and the resource share
  remain unchanged. If the ShareRecipients value is an empty list, then the existing share
  recipients list will be cleared, and the resource share will be deleted.
"""
function update_lake_formation_identity_center_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/UpdateLakeFormationIdentityCenterConfiguration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_lake_formation_identity_center_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/UpdateLakeFormationIdentityCenterConfiguration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_lftag(tag_key)
    update_lftag(tag_key, params::Dict{String,<:Any})

Updates the list of possible values for the specified LF-tag key. If the LF-tag does not
exist, the operation throws an EntityNotFoundException. The values in the delete key values
will be deleted from list of possible values. If any value in the delete key values is
attached to a resource, then API errors out with a 400 Exception - \"Update not allowed\".
Untag the attribute before deleting the LF-tag key's value.

# Arguments
- `tag_key`: The key-name for the LF-tag for which to add or delete values.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The identifier for the Data Catalog. By default, the account ID. The Data
  Catalog is the persistent metadata store. It contains database definitions, table
  definitions, and other control information to manage your Lake Formation environment.
- `"TagValuesToAdd"`: A list of LF-tag values to add from the LF-tag.
- `"TagValuesToDelete"`: A list of LF-tag values to delete from the LF-tag.
"""
function update_lftag(TagKey; aws_config::AbstractAWSConfig=current_aws_config())
    return lakeformation(
        "POST",
        "/UpdateLFTag",
        Dict{String,Any}("TagKey" => TagKey);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_lftag(
    TagKey, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/UpdateLFTag",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("TagKey" => TagKey), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_resource(resource_arn, role_arn)
    update_resource(resource_arn, role_arn, params::Dict{String,<:Any})

Updates the data access role used for vending access to the given (registered) resource in
Lake Formation.

# Arguments
- `resource_arn`: The resource ARN.
- `role_arn`: The new role to use for the given resource registered in Lake Formation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"HybridAccessEnabled"`:  Specifies whether the data access of tables pointing to the
  location can be managed by both Lake Formation permissions as well as Amazon S3 bucket
  policies.
- `"WithFederation"`: Whether or not the resource is a federated resource.
"""
function update_resource(
    ResourceArn, RoleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lakeformation(
        "POST",
        "/UpdateResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "RoleArn" => RoleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_resource(
    ResourceArn,
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/UpdateResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "RoleArn" => RoleArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_table_objects(database_name, table_name, write_operations)
    update_table_objects(database_name, table_name, write_operations, params::Dict{String,<:Any})

Updates the manifest of Amazon S3 objects that make up the specified governed table.

# Arguments
- `database_name`: The database containing the governed table to update.
- `table_name`: The governed table to update.
- `write_operations`: A list of WriteOperation objects that define an object to add to or
  delete from the manifest for a governed table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The catalog containing the governed table to update. Defaults to the
  caller’s account ID.
- `"TransactionId"`: The transaction at which to do the write.
"""
function update_table_objects(
    DatabaseName,
    TableName,
    WriteOperations;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/UpdateTableObjects",
        Dict{String,Any}(
            "DatabaseName" => DatabaseName,
            "TableName" => TableName,
            "WriteOperations" => WriteOperations,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_table_objects(
    DatabaseName,
    TableName,
    WriteOperations,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/UpdateTableObjects",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DatabaseName" => DatabaseName,
                    "TableName" => TableName,
                    "WriteOperations" => WriteOperations,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_table_storage_optimizer(database_name, storage_optimizer_config, table_name)
    update_table_storage_optimizer(database_name, storage_optimizer_config, table_name, params::Dict{String,<:Any})

Updates the configuration of the storage optimizers for a table.

# Arguments
- `database_name`: Name of the database where the table is present.
- `storage_optimizer_config`: Name of the table for which to enable the storage optimizer.
- `table_name`: Name of the table for which to enable the storage optimizer.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CatalogId"`: The Catalog ID of the table.
"""
function update_table_storage_optimizer(
    DatabaseName,
    StorageOptimizerConfig,
    TableName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/UpdateTableStorageOptimizer",
        Dict{String,Any}(
            "DatabaseName" => DatabaseName,
            "StorageOptimizerConfig" => StorageOptimizerConfig,
            "TableName" => TableName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_table_storage_optimizer(
    DatabaseName,
    StorageOptimizerConfig,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lakeformation(
        "POST",
        "/UpdateTableStorageOptimizer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DatabaseName" => DatabaseName,
                    "StorageOptimizerConfig" => StorageOptimizerConfig,
                    "TableName" => TableName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
