# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: redshift
using AWS.Compat
using AWS.UUIDs

"""
    accept_reserved_node_exchange(reserved_node_id, target_reserved_node_offering_id)
    accept_reserved_node_exchange(reserved_node_id, target_reserved_node_offering_id, params::Dict{String,<:Any})

Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration
(term, payment type, or number of nodes) and no additional costs.

# Arguments
- `reserved_node_id`: A string representing the node identifier of the DC1 Reserved Node to
  be exchanged.
- `target_reserved_node_offering_id`: The unique identifier of the DC2 Reserved Node
  offering to be used for the exchange. You can obtain the value for the parameter by calling
  GetReservedNodeExchangeOfferings

"""
function accept_reserved_node_exchange(
    ReservedNodeId,
    TargetReservedNodeOfferingId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "AcceptReservedNodeExchange",
        Dict{String,Any}(
            "ReservedNodeId" => ReservedNodeId,
            "TargetReservedNodeOfferingId" => TargetReservedNodeOfferingId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_reserved_node_exchange(
    ReservedNodeId,
    TargetReservedNodeOfferingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "AcceptReservedNodeExchange",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ReservedNodeId" => ReservedNodeId,
                    "TargetReservedNodeOfferingId" => TargetReservedNodeOfferingId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_partner(account_id, cluster_identifier, database_name, partner_name)
    add_partner(account_id, cluster_identifier, database_name, partner_name, params::Dict{String,<:Any})

Adds a partner integration to a cluster. This operation authorizes a partner to push status
updates for the specified database. To complete the integration, you also set up the
integration on the partner website.

# Arguments
- `account_id`: The Amazon Web Services account ID that owns the cluster.
- `cluster_identifier`: The cluster identifier of the cluster that receives data from the
  partner.
- `database_name`: The name of the database that receives data from the partner.
- `partner_name`: The name of the partner that is authorized to send data.

"""
function add_partner(
    AccountId,
    ClusterIdentifier,
    DatabaseName,
    PartnerName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "AddPartner",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "ClusterIdentifier" => ClusterIdentifier,
            "DatabaseName" => DatabaseName,
            "PartnerName" => PartnerName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_partner(
    AccountId,
    ClusterIdentifier,
    DatabaseName,
    PartnerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "AddPartner",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "ClusterIdentifier" => ClusterIdentifier,
                    "DatabaseName" => DatabaseName,
                    "PartnerName" => PartnerName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_data_share_consumer(data_share_arn)
    associate_data_share_consumer(data_share_arn, params::Dict{String,<:Any})

From a datashare consumer account, associates a datashare with the account
(AssociateEntireAccount) or the specified namespace (ConsumerArn). If you make this
association, the consumer can consume the datashare.

# Arguments
- `data_share_arn`: The Amazon Resource Name (ARN) of the datashare that the consumer is to
  use.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowWrites"`: If set to true, allows write operations for a datashare.
- `"AssociateEntireAccount"`: A value that specifies whether the datashare is associated
  with the entire account.
- `"ConsumerArn"`: The Amazon Resource Name (ARN) of the consumer namespace associated with
  the datashare.
- `"ConsumerRegion"`: From a datashare consumer account, associates a datashare with all
  existing and future namespaces in the specified Amazon Web Services Region.
"""
function associate_data_share_consumer(
    DataShareArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "AssociateDataShareConsumer",
        Dict{String,Any}("DataShareArn" => DataShareArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_data_share_consumer(
    DataShareArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "AssociateDataShareConsumer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DataShareArn" => DataShareArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    authorize_cluster_security_group_ingress(cluster_security_group_name)
    authorize_cluster_security_group_ingress(cluster_security_group_name, params::Dict{String,<:Any})

Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether
the application accessing your cluster is running on the Internet or an Amazon EC2
instance, you can authorize inbound access to either a Classless Interdomain Routing
(CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group. You can add as many
as 20 ingress rules to an Amazon Redshift security group. If you authorize access to an
Amazon EC2 security group, specify EC2SecurityGroupName and EC2SecurityGroupOwnerId. The
Amazon EC2 security group and Amazon Redshift cluster must be in the same Amazon Web
Services Region.  If you authorize access to a CIDR/IP address range, specify CIDRIP. For
an overview of CIDR blocks, see the Wikipedia article on Classless Inter-Domain Routing.
You must also associate the security group with a cluster so that clients running on these
IP addresses or the EC2 instance are authorized to connect to the cluster. For information
about managing security groups, go to Working with Security Groups in the Amazon Redshift
Cluster Management Guide.

# Arguments
- `cluster_security_group_name`: The name of the security group to which the ingress rule
  is added.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CIDRIP"`: The IP range to be added the Amazon Redshift security group.
- `"EC2SecurityGroupName"`: The EC2 security group to be added the Amazon Redshift security
  group.
- `"EC2SecurityGroupOwnerId"`: The Amazon Web Services account number of the owner of the
  security group specified by the EC2SecurityGroupName parameter. The Amazon Web Services
  Access Key ID is not an acceptable value.  Example: 111122223333
"""
function authorize_cluster_security_group_ingress(
    ClusterSecurityGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "AuthorizeClusterSecurityGroupIngress",
        Dict{String,Any}("ClusterSecurityGroupName" => ClusterSecurityGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function authorize_cluster_security_group_ingress(
    ClusterSecurityGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "AuthorizeClusterSecurityGroupIngress",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClusterSecurityGroupName" => ClusterSecurityGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    authorize_data_share(consumer_identifier, data_share_arn)
    authorize_data_share(consumer_identifier, data_share_arn, params::Dict{String,<:Any})

From a data producer account, authorizes the sharing of a datashare with one or more
consumer accounts or managing entities. To authorize a datashare for a data consumer, the
producer account must have the correct access permissions.

# Arguments
- `consumer_identifier`: The identifier of the data consumer that is authorized to access
  the datashare. This identifier is an Amazon Web Services account ID or a keyword, such as
  ADX.
- `data_share_arn`: The Amazon Resource Name (ARN) of the datashare namespace that
  producers are to authorize sharing for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowWrites"`: If set to true, allows write operations for a datashare.
"""
function authorize_data_share(
    ConsumerIdentifier, DataShareArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "AuthorizeDataShare",
        Dict{String,Any}(
            "ConsumerIdentifier" => ConsumerIdentifier, "DataShareArn" => DataShareArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function authorize_data_share(
    ConsumerIdentifier,
    DataShareArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "AuthorizeDataShare",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConsumerIdentifier" => ConsumerIdentifier,
                    "DataShareArn" => DataShareArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    authorize_endpoint_access(account)
    authorize_endpoint_access(account, params::Dict{String,<:Any})

Grants access to a cluster.

# Arguments
- `account`: The Amazon Web Services account ID to grant access to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterIdentifier"`: The cluster identifier of the cluster to grant access to.
- `"VpcIds"`: The virtual private cloud (VPC) identifiers to grant access to.
"""
function authorize_endpoint_access(
    Account; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "AuthorizeEndpointAccess",
        Dict{String,Any}("Account" => Account);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function authorize_endpoint_access(
    Account,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "AuthorizeEndpointAccess",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Account" => Account), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    authorize_snapshot_access(account_with_restore_access)
    authorize_snapshot_access(account_with_restore_access, params::Dict{String,<:Any})

Authorizes the specified Amazon Web Services account to restore the specified snapshot.
For more information about working with snapshots, go to Amazon Redshift Snapshots in the
Amazon Redshift Cluster Management Guide.

# Arguments
- `account_with_restore_access`: The identifier of the Amazon Web Services account
  authorized to restore the specified snapshot. To share a snapshot with Amazon Web Services
  Support, specify amazon-redshift-support.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SnapshotArn"`: The Amazon Resource Name (ARN) of the snapshot to authorize access to.
- `"SnapshotClusterIdentifier"`: The identifier of the cluster the snapshot was created
  from.    If the snapshot to access doesn't exist and the associated IAM policy doesn't
  allow access to all (*) snapshots - This parameter is required. Otherwise, permissions
  aren't available to check if the snapshot exists.    If the snapshot to access exists -
  This parameter isn't required. Redshift can retrieve the cluster identifier and use it to
  validate snapshot authorization.
- `"SnapshotIdentifier"`: The identifier of the snapshot the account is authorized to
  restore.
"""
function authorize_snapshot_access(
    AccountWithRestoreAccess; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "AuthorizeSnapshotAccess",
        Dict{String,Any}("AccountWithRestoreAccess" => AccountWithRestoreAccess);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function authorize_snapshot_access(
    AccountWithRestoreAccess,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "AuthorizeSnapshotAccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountWithRestoreAccess" => AccountWithRestoreAccess),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_delete_cluster_snapshots(delete_cluster_snapshot_message)
    batch_delete_cluster_snapshots(delete_cluster_snapshot_message, params::Dict{String,<:Any})

Deletes a set of cluster snapshots.

# Arguments
- `delete_cluster_snapshot_message`: A list of identifiers for the snapshots that you want
  to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Identifiers"`: A list of identifiers for the snapshots that you want to delete.
"""
function batch_delete_cluster_snapshots(
    DeleteClusterSnapshotMessage; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "BatchDeleteClusterSnapshots",
        Dict{String,Any}("DeleteClusterSnapshotMessage" => DeleteClusterSnapshotMessage);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_cluster_snapshots(
    DeleteClusterSnapshotMessage,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "BatchDeleteClusterSnapshots",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DeleteClusterSnapshotMessage" => DeleteClusterSnapshotMessage
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_modify_cluster_snapshots(string)
    batch_modify_cluster_snapshots(string, params::Dict{String,<:Any})

Modifies the settings for a set of cluster snapshots.

# Arguments
- `string`: A list of snapshot identifiers you want to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Force"`: A boolean value indicating whether to override an exception if the retention
  period has passed.
- `"ManualSnapshotRetentionPeriod"`: The number of days that a manual snapshot is retained.
  If you specify the value -1, the manual snapshot is retained indefinitely. The number must
  be either -1 or an integer between 1 and 3,653. If you decrease the manual snapshot
  retention period from its current value, existing manual snapshots that fall outside of the
  new retention period will return an error. If you want to suppress the errors and delete
  the snapshots, use the force option.
- `"SnapshotIdentifierList"`: A list of snapshot identifiers you want to modify.
"""
function batch_modify_cluster_snapshots(
    String; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "BatchModifyClusterSnapshots",
        Dict{String,Any}("String" => String);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_modify_cluster_snapshots(
    String, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "BatchModifyClusterSnapshots",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("String" => String), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_resize(cluster_identifier)
    cancel_resize(cluster_identifier, params::Dict{String,<:Any})

Cancels a resize operation for a cluster.

# Arguments
- `cluster_identifier`: The unique identifier for the cluster that you want to cancel a
  resize operation for.

"""
function cancel_resize(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "CancelResize",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_resize(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CancelResize",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_cluster_snapshot(source_snapshot_identifier, target_snapshot_identifier)
    copy_cluster_snapshot(source_snapshot_identifier, target_snapshot_identifier, params::Dict{String,<:Any})

Copies the specified automated cluster snapshot to a new manual cluster snapshot. The
source must be an automated snapshot and it must be in the available state. When you delete
a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the
retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you
want to keep an automated snapshot for a longer period, you can make a manual copy of the
snapshot. Manual snapshots are retained until you delete them.  For more information about
working with snapshots, go to Amazon Redshift Snapshots in the Amazon Redshift Cluster
Management Guide.

# Arguments
- `source_snapshot_identifier`: The identifier for the source snapshot. Constraints:   Must
  be the identifier for a valid automated snapshot whose state is available.
- `target_snapshot_identifier`: The identifier given to the new manual snapshot.
  Constraints:   Cannot be null, empty, or blank.   Must contain from 1 to 255 alphanumeric
  characters or hyphens.   First character must be a letter.   Cannot end with a hyphen or
  contain two consecutive hyphens.   Must be unique for the Amazon Web Services account that
  is making the request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ManualSnapshotRetentionPeriod"`: The number of days that a manual snapshot is retained.
  If the value is -1, the manual snapshot is retained indefinitely.  The value must be either
  -1 or an integer between 1 and 3,653. The default value is -1.
- `"SourceSnapshotClusterIdentifier"`: The identifier of the cluster the source snapshot
  was created from. This parameter is required if your IAM user has a policy containing a
  snapshot resource element that specifies anything other than * for the cluster name.
  Constraints:   Must be the identifier for a valid cluster.
"""
function copy_cluster_snapshot(
    SourceSnapshotIdentifier,
    TargetSnapshotIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CopyClusterSnapshot",
        Dict{String,Any}(
            "SourceSnapshotIdentifier" => SourceSnapshotIdentifier,
            "TargetSnapshotIdentifier" => TargetSnapshotIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_cluster_snapshot(
    SourceSnapshotIdentifier,
    TargetSnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CopyClusterSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceSnapshotIdentifier" => SourceSnapshotIdentifier,
                    "TargetSnapshotIdentifier" => TargetSnapshotIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_authentication_profile(authentication_profile_content, authentication_profile_name)
    create_authentication_profile(authentication_profile_content, authentication_profile_name, params::Dict{String,<:Any})

Creates an authentication profile with the specified parameters.

# Arguments
- `authentication_profile_content`: The content of the authentication profile in JSON
  format. The maximum length of the JSON string is determined by a quota for your account.
- `authentication_profile_name`: The name of the authentication profile to be created.

"""
function create_authentication_profile(
    AuthenticationProfileContent,
    AuthenticationProfileName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateAuthenticationProfile",
        Dict{String,Any}(
            "AuthenticationProfileContent" => AuthenticationProfileContent,
            "AuthenticationProfileName" => AuthenticationProfileName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_authentication_profile(
    AuthenticationProfileContent,
    AuthenticationProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateAuthenticationProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthenticationProfileContent" => AuthenticationProfileContent,
                    "AuthenticationProfileName" => AuthenticationProfileName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cluster(cluster_identifier, master_username, node_type)
    create_cluster(cluster_identifier, master_username, node_type, params::Dict{String,<:Any})

Creates a new cluster with the specified parameters. To create a cluster in Virtual Private
Cloud (VPC), you must provide a cluster subnet group name. The cluster subnet group
identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For
more information about managing clusters, go to Amazon Redshift Clusters in the Amazon
Redshift Cluster Management Guide.

# Arguments
- `cluster_identifier`: A unique identifier for the cluster. You use this identifier to
  refer to the cluster for any subsequent cluster operations such as deleting or modifying.
  The identifier also appears in the Amazon Redshift console. Constraints:   Must contain
  from 1 to 63 alphanumeric characters or hyphens.   Alphabetic characters must be lowercase.
    First character must be a letter.   Cannot end with a hyphen or contain two consecutive
  hyphens.   Must be unique for all clusters within an Amazon Web Services account.
  Example: myexamplecluster
- `master_username`: The user name associated with the admin user account for the cluster
  that is being created. Constraints:   Must be 1 - 128 alphanumeric characters or hyphens.
  The user name can't be PUBLIC.   Must contain only lowercase letters, numbers, underscore,
  plus sign, period (dot), at symbol (@), or hyphen.   The first character must be a letter.
   Must not contain a colon (:) or a slash (/).   Cannot be a reserved word. A list of
  reserved words can be found in Reserved Words in the Amazon Redshift Database Developer
  Guide.
- `node_type`: The node type to be provisioned for the cluster. For information about node
  types, go to  Working with Clusters in the Amazon Redshift Cluster Management Guide.  Valid
  Values: dc2.large | dc2.8xlarge | ra3.xlplus | ra3.4xlarge | ra3.16xlarge

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AdditionalInfo"`: Reserved.
- `"AllowVersionUpgrade"`: If true, major version upgrades can be applied during the
  maintenance window to the Amazon Redshift engine that is running on the cluster. When a new
  major version of the Amazon Redshift engine is released, you can request that the service
  automatically apply upgrades during the maintenance window to the Amazon Redshift engine
  that is running on your cluster. Default: true
- `"AquaConfigurationStatus"`: This parameter is retired. It does not set the AQUA
  configuration status. Amazon Redshift automatically determines whether to use AQUA
  (Advanced Query Accelerator).
- `"AutomatedSnapshotRetentionPeriod"`: The number of days that automated snapshots are
  retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots
  are disabled, you can still create manual snapshots when you want with
  CreateClusterSnapshot.  You can't disable automated snapshots for RA3 node types. Set the
  automated retention period from 1-35 days. Default: 1  Constraints: Must be a value from 0
  to 35.
- `"AvailabilityZone"`: The EC2 Availability Zone (AZ) in which you want Amazon Redshift to
  provision the cluster. For example, if you have several EC2 instances running in a specific
  Availability Zone, then you might want the cluster to be provisioned in the same zone in
  order to decrease network latency. Default: A random, system-chosen Availability Zone in
  the region that is specified by the endpoint. Example: us-east-2d  Constraint: The
  specified Availability Zone must be in the same region as the current endpoint.
- `"AvailabilityZoneRelocation"`: The option to enable relocation for an Amazon Redshift
  cluster between Availability Zones after the cluster is created.
- `"ClusterParameterGroupName"`: The name of the parameter group to be associated with this
  cluster. Default: The default Amazon Redshift cluster parameter group. For information
  about the default parameter group, go to Working with Amazon Redshift Parameter Groups
  Constraints:   Must be 1 to 255 alphanumeric characters or hyphens.   First character must
  be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.
- `"ClusterSecurityGroups"`: A list of security groups to be associated with this cluster.
  Default: The default cluster security group for Amazon Redshift.
- `"ClusterSubnetGroupName"`: The name of a cluster subnet group to be associated with this
  cluster. If this parameter is not provided the resulting cluster will be deployed outside
  virtual private cloud (VPC).
- `"ClusterType"`: The type of the cluster. When cluster type is specified as
  single-node, the NumberOfNodes parameter is not required.    multi-node, the NumberOfNodes
  parameter is required.   Valid Values: multi-node | single-node  Default: multi-node
- `"ClusterVersion"`: The version of the Amazon Redshift engine software that you want to
  deploy on the cluster. The version selected runs on all the nodes in the cluster.
  Constraints: Only version 1.0 is currently available. Example: 1.0
- `"DBName"`: The name of the first database to be created when the cluster is created. To
  create additional databases after the cluster is created, connect to the cluster with a SQL
  client and use SQL commands to create a database. For more information, go to Create a
  Database in the Amazon Redshift Database Developer Guide.  Default: dev  Constraints:
  Must contain 1 to 64 alphanumeric characters.   Must contain only lowercase letters.
  Cannot be a word that is reserved by the service. A list of reserved words can be found in
  Reserved Words in the Amazon Redshift Database Developer Guide.
- `"DefaultIamRoleArn"`: The Amazon Resource Name (ARN) for the IAM role that was set as
  default for the cluster when the cluster was created.
- `"ElasticIp"`: The Elastic IP (EIP) address for the cluster. Constraints: The cluster
  must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. Don't
  specify the Elastic IP address for a publicly accessible cluster with availability zone
  relocation turned on. For more information about provisioning clusters in EC2-VPC, go to
  Supported Platforms to Launch Your Cluster in the Amazon Redshift Cluster Management Guide.
- `"Encrypted"`: If true, the data in the cluster is encrypted at rest.  Default: false
- `"EnhancedVpcRouting"`: An option that specifies whether to create the cluster with
  enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the
  cluster must be in a VPC. For more information, see Enhanced VPC Routing in the Amazon
  Redshift Cluster Management Guide. If this option is true, enhanced VPC routing is enabled.
   Default: false
- `"HsmClientCertificateIdentifier"`: Specifies the name of the HSM client certificate the
  Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
- `"HsmConfigurationIdentifier"`: Specifies the name of the HSM configuration that contains
  the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
- `"IamRoles"`: A list of Identity and Access Management (IAM) roles that can be used by
  the cluster to access other Amazon Web Services services. You must supply the IAM roles in
  their Amazon Resource Name (ARN) format.  The maximum number of IAM roles that you can
  associate is subject to a quota. For more information, go to Quotas and limits in the
  Amazon Redshift Cluster Management Guide.
- `"IpAddressType"`: The IP address types that the cluster supports. Possible values are
  ipv4 and dualstack.
- `"KmsKeyId"`: The Key Management Service (KMS) key ID of the encryption key that you want
  to use to encrypt data in the cluster.
- `"LoadSampleData"`: A flag that specifies whether to load sample data once the cluster is
  created.
- `"MaintenanceTrackName"`: An optional parameter for the name of the maintenance track for
  the cluster. If you don't provide a maintenance track name, the cluster is assigned to the
  current track.
- `"ManageMasterPassword"`: If true, Amazon Redshift uses Secrets Manager to manage this
  cluster's admin credentials. You can't use MasterUserPassword if ManageMasterPassword is
  true. If ManageMasterPassword is false or not set, Amazon Redshift uses MasterUserPassword
  for the admin user account's password.
- `"ManualSnapshotRetentionPeriod"`: The default number of days to retain a manual
  snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't
  change the retention period of existing snapshots. The value must be either -1 or an
  integer between 1 and 3,653.
- `"MasterPasswordSecretKmsKeyId"`: The ID of the Key Management Service (KMS) key used to
  encrypt and store the cluster's admin credentials secret. You can only use this parameter
  if ManageMasterPassword is true.
- `"MasterUserPassword"`: The password associated with the admin user account for the
  cluster that is being created. You can't use MasterUserPassword if ManageMasterPassword is
  true. Constraints:   Must be between 8 and 64 characters in length.   Must contain at least
  one uppercase letter.   Must contain at least one lowercase letter.   Must contain one
  number.   Can be any printable ASCII character (ASCII code 33-126) except ' (single quote),
  \" (double quote), , /, or @.
- `"MultiAZ"`: If true, Amazon Redshift will deploy the cluster in two Availability Zones
  (AZ).
- `"NumberOfNodes"`: The number of compute nodes in the cluster. This parameter is required
  when the ClusterType parameter is specified as multi-node.  For information about
  determining how many nodes you need, go to  Working with Clusters in the Amazon Redshift
  Cluster Management Guide.  If you don't specify this parameter, you get a single-node
  cluster. When requesting a multi-node cluster, you must specify the number of nodes that
  you want in the cluster. Default: 1  Constraints: Value must be at least 1 and no more than
  100.
- `"Port"`: The port number on which the cluster accepts incoming connections. The cluster
  is accessible only via the JDBC and ODBC connection strings. Part of the connection string
  requires the port on which the cluster will listen for incoming connections. Default: 5439
  Valid Values:    For clusters with ra3 nodes - Select a port within the ranges 5431-5455 or
  8191-8215. (If you have an existing cluster with ra3 nodes, it isn't required that you
  change the port to these ranges.)   For clusters with dc2 nodes - Select a port within the
  range 1150-65535.
- `"PreferredMaintenanceWindow"`: The weekly time range (in UTC) during which automated
  cluster maintenance can occur.  Format: ddd:hh24:mi-ddd:hh24:mi   Default: A 30-minute
  window selected at random from an 8-hour block of time per region, occurring on a random
  day of the week. For more information about the time blocks for each region, see
  Maintenance Windows in Amazon Redshift Cluster Management Guide. Valid Days: Mon | Tue |
  Wed | Thu | Fri | Sat | Sun Constraints: Minimum 30-minute window.
- `"PubliclyAccessible"`: If true, the cluster can be accessed from a public network.
- `"RedshiftIdcApplicationArn"`: The Amazon resource name (ARN) of the Amazon Redshift IAM
  Identity Center application.
- `"SnapshotScheduleIdentifier"`: A unique identifier for the snapshot schedule.
- `"Tags"`: A list of tag instances.
- `"VpcSecurityGroupIds"`: A list of Virtual Private Cloud (VPC) security groups to be
  associated with the cluster. Default: The default VPC security group is associated with the
  cluster.
"""
function create_cluster(
    ClusterIdentifier,
    MasterUsername,
    NodeType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateCluster",
        Dict{String,Any}(
            "ClusterIdentifier" => ClusterIdentifier,
            "MasterUsername" => MasterUsername,
            "NodeType" => NodeType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cluster(
    ClusterIdentifier,
    MasterUsername,
    NodeType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterIdentifier" => ClusterIdentifier,
                    "MasterUsername" => MasterUsername,
                    "NodeType" => NodeType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cluster_parameter_group(description, parameter_group_family, parameter_group_name)
    create_cluster_parameter_group(description, parameter_group_family, parameter_group_name, params::Dict{String,<:Any})

Creates an Amazon Redshift parameter group. Creating parameter groups is independent of
creating clusters. You can associate a cluster with a parameter group when you create the
cluster. You can also associate an existing cluster with a parameter group after the
cluster is created by using ModifyCluster.  Parameters in the parameter group define
specific behavior that applies to the databases you create on the cluster. For more
information about parameters and parameter groups, go to Amazon Redshift Parameter Groups
in the Amazon Redshift Cluster Management Guide.

# Arguments
- `description`: A description of the parameter group.
- `parameter_group_family`: The Amazon Redshift engine version to which the cluster
  parameter group applies. The cluster engine version determines the set of parameters. To
  get a list of valid parameter group family names, you can call
  DescribeClusterParameterGroups. By default, Amazon Redshift returns a list of all the
  parameter groups that are owned by your Amazon Web Services account, including the default
  parameter groups for each Amazon Redshift engine version. The parameter group family names
  associated with the default parameter groups provide you the valid values. For example, a
  valid family name is \"redshift-1.0\".
- `parameter_group_name`: The name of the cluster parameter group. Constraints:   Must be 1
  to 255 alphanumeric characters or hyphens   First character must be a letter.   Cannot end
  with a hyphen or contain two consecutive hyphens.   Must be unique withing your Amazon Web
  Services account.    This value is stored as a lower-case string.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of tag instances.
"""
function create_cluster_parameter_group(
    Description,
    ParameterGroupFamily,
    ParameterGroupName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateClusterParameterGroup",
        Dict{String,Any}(
            "Description" => Description,
            "ParameterGroupFamily" => ParameterGroupFamily,
            "ParameterGroupName" => ParameterGroupName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cluster_parameter_group(
    Description,
    ParameterGroupFamily,
    ParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateClusterParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Description" => Description,
                    "ParameterGroupFamily" => ParameterGroupFamily,
                    "ParameterGroupName" => ParameterGroupName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cluster_security_group(cluster_security_group_name, description)
    create_cluster_security_group(cluster_security_group_name, description, params::Dict{String,<:Any})

Creates a new Amazon Redshift security group. You use security groups to control access to
non-VPC clusters.  For information about managing security groups, go to Amazon Redshift
Cluster Security Groups in the Amazon Redshift Cluster Management Guide.

# Arguments
- `cluster_security_group_name`: The name for the security group. Amazon Redshift stores
  the value as a lowercase string. Constraints:   Must contain no more than 255 alphanumeric
  characters or hyphens.   Must not be \"Default\".   Must be unique for all security groups
  that are created by your Amazon Web Services account.   Example: examplesecuritygroup
- `description`: A description for the security group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of tag instances.
"""
function create_cluster_security_group(
    ClusterSecurityGroupName,
    Description;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateClusterSecurityGroup",
        Dict{String,Any}(
            "ClusterSecurityGroupName" => ClusterSecurityGroupName,
            "Description" => Description,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cluster_security_group(
    ClusterSecurityGroupName,
    Description,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateClusterSecurityGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterSecurityGroupName" => ClusterSecurityGroupName,
                    "Description" => Description,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cluster_snapshot(cluster_identifier, snapshot_identifier)
    create_cluster_snapshot(cluster_identifier, snapshot_identifier, params::Dict{String,<:Any})

Creates a manual snapshot of the specified cluster. The cluster must be in the available
state.   For more information about working with snapshots, go to Amazon Redshift Snapshots
in the Amazon Redshift Cluster Management Guide.

# Arguments
- `cluster_identifier`: The cluster identifier for which you want a snapshot.
- `snapshot_identifier`: A unique identifier for the snapshot that you are requesting. This
  identifier must be unique for all snapshots within the Amazon Web Services account.
  Constraints:   Cannot be null, empty, or blank   Must contain from 1 to 255 alphanumeric
  characters or hyphens   First character must be a letter   Cannot end with a hyphen or
  contain two consecutive hyphens   Example: my-snapshot-id

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ManualSnapshotRetentionPeriod"`: The number of days that a manual snapshot is retained.
  If the value is -1, the manual snapshot is retained indefinitely.  The value must be either
  -1 or an integer between 1 and 3,653. The default value is -1.
- `"Tags"`: A list of tag instances.
"""
function create_cluster_snapshot(
    ClusterIdentifier,
    SnapshotIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateClusterSnapshot",
        Dict{String,Any}(
            "ClusterIdentifier" => ClusterIdentifier,
            "SnapshotIdentifier" => SnapshotIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cluster_snapshot(
    ClusterIdentifier,
    SnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateClusterSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterIdentifier" => ClusterIdentifier,
                    "SnapshotIdentifier" => SnapshotIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cluster_subnet_group(cluster_subnet_group_name, description, subnet_identifier)
    create_cluster_subnet_group(cluster_subnet_group_name, description, subnet_identifier, params::Dict{String,<:Any})

Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets
in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift
subnet group.  For information about subnet groups, go to Amazon Redshift Cluster Subnet
Groups in the Amazon Redshift Cluster Management Guide.

# Arguments
- `cluster_subnet_group_name`: The name for the subnet group. Amazon Redshift stores the
  value as a lowercase string. Constraints:   Must contain no more than 255 alphanumeric
  characters or hyphens.   Must not be \"Default\".   Must be unique for all subnet groups
  that are created by your Amazon Web Services account.   Example: examplesubnetgroup
- `description`: A description for the subnet group.
- `subnet_identifier`: An array of VPC subnet IDs. A maximum of 20 subnets can be modified
  in a single request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SubnetIds"`: An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a
  single request.
- `"Tags"`: A list of tag instances.
"""
function create_cluster_subnet_group(
    ClusterSubnetGroupName,
    Description,
    SubnetIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateClusterSubnetGroup",
        Dict{String,Any}(
            "ClusterSubnetGroupName" => ClusterSubnetGroupName,
            "Description" => Description,
            "SubnetIdentifier" => SubnetIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cluster_subnet_group(
    ClusterSubnetGroupName,
    Description,
    SubnetIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateClusterSubnetGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterSubnetGroupName" => ClusterSubnetGroupName,
                    "Description" => Description,
                    "SubnetIdentifier" => SubnetIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_custom_domain_association(cluster_identifier, custom_domain_certificate_arn, custom_domain_name)
    create_custom_domain_association(cluster_identifier, custom_domain_certificate_arn, custom_domain_name, params::Dict{String,<:Any})

Used to create a custom domain name for a cluster. Properties include the custom domain
name, the cluster the custom domain is associated with, and the certificate Amazon Resource
Name (ARN).

# Arguments
- `cluster_identifier`: The cluster identifier that the custom domain is associated with.
- `custom_domain_certificate_arn`: The certificate Amazon Resource Name (ARN) for the
  custom domain name association.
- `custom_domain_name`: The custom domain name for a custom domain association.

"""
function create_custom_domain_association(
    ClusterIdentifier,
    CustomDomainCertificateArn,
    CustomDomainName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateCustomDomainAssociation",
        Dict{String,Any}(
            "ClusterIdentifier" => ClusterIdentifier,
            "CustomDomainCertificateArn" => CustomDomainCertificateArn,
            "CustomDomainName" => CustomDomainName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_custom_domain_association(
    ClusterIdentifier,
    CustomDomainCertificateArn,
    CustomDomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateCustomDomainAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterIdentifier" => ClusterIdentifier,
                    "CustomDomainCertificateArn" => CustomDomainCertificateArn,
                    "CustomDomainName" => CustomDomainName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_endpoint_access(endpoint_name, subnet_group_name)
    create_endpoint_access(endpoint_name, subnet_group_name, params::Dict{String,<:Any})

Creates a Redshift-managed VPC endpoint.

# Arguments
- `endpoint_name`: The Redshift-managed VPC endpoint name. An endpoint name must contain
  1-30 characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character
  must be a letter. The name can't contain two consecutive hyphens or end with a hyphen.
- `subnet_group_name`: The subnet group from which Amazon Redshift chooses the subnet to
  deploy the endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterIdentifier"`: The cluster identifier of the cluster to access.
- `"ResourceOwner"`: The Amazon Web Services account ID of the owner of the cluster. This
  is only required if the cluster is in another Amazon Web Services account.
- `"VpcSecurityGroupIds"`: The security group that defines the ports, protocols, and
  sources for inbound traffic that you are authorizing into your endpoint.
"""
function create_endpoint_access(
    EndpointName, SubnetGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "CreateEndpointAccess",
        Dict{String,Any}(
            "EndpointName" => EndpointName, "SubnetGroupName" => SubnetGroupName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_endpoint_access(
    EndpointName,
    SubnetGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateEndpointAccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EndpointName" => EndpointName, "SubnetGroupName" => SubnetGroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_event_subscription(sns_topic_arn, subscription_name)
    create_event_subscription(sns_topic_arn, subscription_name, params::Dict{String,<:Any})

Creates an Amazon Redshift event notification subscription. This action requires an ARN
(Amazon Resource Name) of an Amazon SNS topic created by either the Amazon Redshift
console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS,
you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in
the SNS console. You can specify the source type, and lists of Amazon Redshift source IDs,
event categories, and event severities. Notifications will be sent for all events you want
that match those criteria. For example, you can specify source type = cluster, source ID =
my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity = ERROR.
The subscription will only send notifications for those ERROR events in the Availability
and Backup categories for the specified clusters. If you specify both the source type and
source IDs, such as source type = cluster and source identifier = my-cluster-1,
notifications will be sent for all the cluster events for my-cluster-1. If you specify a
source type but do not specify a source identifier, you will receive notice of the events
for the objects of that type in your Amazon Web Services account. If you do not specify
either the SourceType nor the SourceIdentifier, you will be notified of events generated
from all Amazon Redshift sources belonging to your Amazon Web Services account. You must
specify a source type if you specify a source ID.

# Arguments
- `sns_topic_arn`: The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit
  the event notifications. The ARN is created by Amazon SNS when you create a topic and
  subscribe to it.
- `subscription_name`: The name of the event subscription to be created. Constraints:
  Cannot be null, empty, or blank.   Must contain from 1 to 255 alphanumeric characters or
  hyphens.   First character must be a letter.   Cannot end with a hyphen or contain two
  consecutive hyphens.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Enabled"`: A boolean value; set to true to activate the subscription, and set to false
  to create the subscription but not activate it.
- `"EventCategories"`: Specifies the Amazon Redshift event categories to be published by
  the event notification subscription. Values: configuration, management, monitoring,
  security, pending
- `"Severity"`: Specifies the Amazon Redshift event severity to be published by the event
  notification subscription. Values: ERROR, INFO
- `"SourceIds"`: A list of one or more identifiers of Amazon Redshift source objects. All
  of the objects must be of the same type as was specified in the source type parameter. The
  event subscription will return only events generated by the specified objects. If not
  specified, then events are returned for all objects within the source type specified.
  Example: my-cluster-1, my-cluster-2 Example: my-snapshot-20131010
- `"SourceType"`: The type of source that will be generating the events. For example, if
  you want to be notified of events generated by a cluster, you would set this parameter to
  cluster. If this value is not specified, events are returned for all Amazon Redshift
  objects in your Amazon Web Services account. You must specify a source type in order to
  specify source IDs. Valid values: cluster, cluster-parameter-group, cluster-security-group,
  cluster-snapshot, and scheduled-action.
- `"Tags"`: A list of tag instances.
"""
function create_event_subscription(
    SnsTopicArn, SubscriptionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "CreateEventSubscription",
        Dict{String,Any}(
            "SnsTopicArn" => SnsTopicArn, "SubscriptionName" => SubscriptionName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_event_subscription(
    SnsTopicArn,
    SubscriptionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateEventSubscription",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SnsTopicArn" => SnsTopicArn, "SubscriptionName" => SubscriptionName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_hsm_client_certificate(hsm_client_certificate_identifier)
    create_hsm_client_certificate(hsm_client_certificate_identifier, params::Dict{String,<:Any})

Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to
the client's HSM in order to store and retrieve the keys used to encrypt the cluster
databases. The command returns a public key, which you must store in the HSM. In addition
to creating the HSM certificate, you must create an Amazon Redshift HSM configuration that
provides a cluster the information needed to store and use encryption keys in the HSM. For
more information, go to Hardware Security Modules in the Amazon Redshift Cluster Management
Guide.

# Arguments
- `hsm_client_certificate_identifier`: The identifier to be assigned to the new HSM client
  certificate that the cluster will use to connect to the HSM to use the database encryption
  keys.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of tag instances.
"""
function create_hsm_client_certificate(
    HsmClientCertificateIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "CreateHsmClientCertificate",
        Dict{String,Any}(
            "HsmClientCertificateIdentifier" => HsmClientCertificateIdentifier
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_hsm_client_certificate(
    HsmClientCertificateIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateHsmClientCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "HsmClientCertificateIdentifier" => HsmClientCertificateIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_hsm_configuration(description, hsm_configuration_identifier, hsm_ip_address, hsm_partition_name, hsm_partition_password, hsm_server_public_certificate)
    create_hsm_configuration(description, hsm_configuration_identifier, hsm_ip_address, hsm_partition_name, hsm_partition_password, hsm_server_public_certificate, params::Dict{String,<:Any})

Creates an HSM configuration that contains the information required by an Amazon Redshift
cluster to store and use database encryption keys in a Hardware Security Module (HSM).
After creating the HSM configuration, you can specify it as a parameter when creating a
cluster. The cluster will then store its encryption keys in the HSM. In addition to
creating an HSM configuration, you must also create an HSM client certificate. For more
information, go to Hardware Security Modules in the Amazon Redshift Cluster Management
Guide.

# Arguments
- `description`: A text description of the HSM configuration to be created.
- `hsm_configuration_identifier`: The identifier to be assigned to the new Amazon Redshift
  HSM configuration.
- `hsm_ip_address`: The IP address that the Amazon Redshift cluster must use to access the
  HSM.
- `hsm_partition_name`: The name of the partition in the HSM where the Amazon Redshift
  clusters will store their database encryption keys.
- `hsm_partition_password`: The password required to access the HSM partition.
- `hsm_server_public_certificate`: The HSMs public certificate file. When using Cloud HSM,
  the file name is server.pem.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of tag instances.
"""
function create_hsm_configuration(
    Description,
    HsmConfigurationIdentifier,
    HsmIpAddress,
    HsmPartitionName,
    HsmPartitionPassword,
    HsmServerPublicCertificate;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateHsmConfiguration",
        Dict{String,Any}(
            "Description" => Description,
            "HsmConfigurationIdentifier" => HsmConfigurationIdentifier,
            "HsmIpAddress" => HsmIpAddress,
            "HsmPartitionName" => HsmPartitionName,
            "HsmPartitionPassword" => HsmPartitionPassword,
            "HsmServerPublicCertificate" => HsmServerPublicCertificate,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_hsm_configuration(
    Description,
    HsmConfigurationIdentifier,
    HsmIpAddress,
    HsmPartitionName,
    HsmPartitionPassword,
    HsmServerPublicCertificate,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateHsmConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Description" => Description,
                    "HsmConfigurationIdentifier" => HsmConfigurationIdentifier,
                    "HsmIpAddress" => HsmIpAddress,
                    "HsmPartitionName" => HsmPartitionName,
                    "HsmPartitionPassword" => HsmPartitionPassword,
                    "HsmServerPublicCertificate" => HsmServerPublicCertificate,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_redshift_idc_application(iam_role_arn, idc_display_name, idc_instance_arn, redshift_idc_application_name)
    create_redshift_idc_application(iam_role_arn, idc_display_name, idc_instance_arn, redshift_idc_application_name, params::Dict{String,<:Any})

Creates an Amazon Redshift application for use with IAM Identity Center.

# Arguments
- `iam_role_arn`: The IAM role ARN for the Amazon Redshift IAM Identity Center application
  instance. It has the required permissions to be assumed and invoke the IDC Identity Center
  API.
- `idc_display_name`: The display name for the Amazon Redshift IAM Identity Center
  application instance. It appears in the console.
- `idc_instance_arn`: The Amazon resource name (ARN) of the IAM Identity Center instance
  where Amazon Redshift creates a new managed application.
- `redshift_idc_application_name`: The name of the Redshift application in IAM Identity
  Center.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuthorizedTokenIssuerList"`: The token issuer list for the Amazon Redshift IAM Identity
  Center application instance.
- `"IdentityNamespace"`: The namespace for the Amazon Redshift IAM Identity Center
  application instance. It determines which managed application verifies the connection token.
- `"ServiceIntegrations"`: A collection of service integrations for the Redshift IAM
  Identity Center application.
"""
function create_redshift_idc_application(
    IamRoleArn,
    IdcDisplayName,
    IdcInstanceArn,
    RedshiftIdcApplicationName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateRedshiftIdcApplication",
        Dict{String,Any}(
            "IamRoleArn" => IamRoleArn,
            "IdcDisplayName" => IdcDisplayName,
            "IdcInstanceArn" => IdcInstanceArn,
            "RedshiftIdcApplicationName" => RedshiftIdcApplicationName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_redshift_idc_application(
    IamRoleArn,
    IdcDisplayName,
    IdcInstanceArn,
    RedshiftIdcApplicationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateRedshiftIdcApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IamRoleArn" => IamRoleArn,
                    "IdcDisplayName" => IdcDisplayName,
                    "IdcInstanceArn" => IdcInstanceArn,
                    "RedshiftIdcApplicationName" => RedshiftIdcApplicationName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_scheduled_action(iam_role, schedule, scheduled_action_name, target_action)
    create_scheduled_action(iam_role, schedule, scheduled_action_name, target_action, params::Dict{String,<:Any})

Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift
API action. For example, you can create a schedule of when to run the ResizeCluster API
operation.

# Arguments
- `iam_role`: The IAM role to assume to run the target action. For more information about
  this parameter, see ScheduledAction.
- `schedule`: The schedule in at( ) or cron( ) format. For more information about this
  parameter, see ScheduledAction.
- `scheduled_action_name`: The name of the scheduled action. The name must be unique within
  an account. For more information about this parameter, see ScheduledAction.
- `target_action`: A JSON format string of the Amazon Redshift API operation with input
  parameters. For more information about this parameter, see ScheduledAction.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Enable"`: If true, the schedule is enabled. If false, the scheduled action does not
  trigger. For more information about state of the scheduled action, see ScheduledAction.
- `"EndTime"`: The end time in UTC of the scheduled action. After this time, the scheduled
  action does not trigger. For more information about this parameter, see ScheduledAction.
- `"ScheduledActionDescription"`: The description of the scheduled action.
- `"StartTime"`: The start time in UTC of the scheduled action. Before this time, the
  scheduled action does not trigger. For more information about this parameter, see
  ScheduledAction.
"""
function create_scheduled_action(
    IamRole,
    Schedule,
    ScheduledActionName,
    TargetAction;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateScheduledAction",
        Dict{String,Any}(
            "IamRole" => IamRole,
            "Schedule" => Schedule,
            "ScheduledActionName" => ScheduledActionName,
            "TargetAction" => TargetAction,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_scheduled_action(
    IamRole,
    Schedule,
    ScheduledActionName,
    TargetAction,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateScheduledAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IamRole" => IamRole,
                    "Schedule" => Schedule,
                    "ScheduledActionName" => ScheduledActionName,
                    "TargetAction" => TargetAction,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_snapshot_copy_grant(snapshot_copy_grant_name)
    create_snapshot_copy_grant(snapshot_copy_grant_name, params::Dict{String,<:Any})

Creates a snapshot copy grant that permits Amazon Redshift to use an encrypted symmetric
key from Key Management Service (KMS) to encrypt copied snapshots in a destination region.
For more information about managing snapshot copy grants, go to Amazon Redshift Database
Encryption in the Amazon Redshift Cluster Management Guide.

# Arguments
- `snapshot_copy_grant_name`: The name of the snapshot copy grant. This name must be unique
  in the region for the Amazon Web Services account. Constraints:   Must contain from 1 to 63
  alphanumeric characters or hyphens.   Alphabetic characters must be lowercase.   First
  character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.
   Must be unique for all clusters within an Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KmsKeyId"`: The unique identifier of the encrypted symmetric key to which to grant
  Amazon Redshift permission. If no key is specified, the default key is used.
- `"Tags"`: A list of tag instances.
"""
function create_snapshot_copy_grant(
    SnapshotCopyGrantName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "CreateSnapshotCopyGrant",
        Dict{String,Any}("SnapshotCopyGrantName" => SnapshotCopyGrantName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_snapshot_copy_grant(
    SnapshotCopyGrantName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateSnapshotCopyGrant",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SnapshotCopyGrantName" => SnapshotCopyGrantName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_snapshot_schedule()
    create_snapshot_schedule(params::Dict{String,<:Any})

Create a snapshot schedule that can be associated to a cluster and which overrides the
default system backup schedule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`:
- `"NextInvocations"`:
- `"ScheduleDefinitions"`: The definition of the snapshot schedule. The definition is made
  up of schedule expressions, for example \"cron(30 12 *)\" or \"rate(12 hours)\".
- `"ScheduleDescription"`: The description of the snapshot schedule.
- `"ScheduleIdentifier"`: A unique identifier for a snapshot schedule. Only alphanumeric
  characters are allowed for the identifier.
- `"Tags"`: An optional set of tags you can use to search for the schedule.
"""
function create_snapshot_schedule(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "CreateSnapshotSchedule"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function create_snapshot_schedule(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "CreateSnapshotSchedule",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_tags(resource_name, tag)
    create_tags(resource_name, tag, params::Dict{String,<:Any})

Adds tags to a cluster. A resource can have up to 50 tags. If you try to create more than
50 tags for a resource, you will receive an error and the attempt will fail. If you specify
a key that already exists for the resource, the value for that key will be updated with the
new value.

# Arguments
- `resource_name`: The Amazon Resource Name (ARN) to which you want to add the tag or tags.
  For example, arn:aws:redshift:us-east-2:123456789:cluster:t1.
- `tag`: One or more name/value pairs to add as tags to the specified resource. Each tag
  name is passed in with the parameter Key and the corresponding value is passed in with the
  parameter Value. The Key and Value parameters are separated by a comma (,). Separate
  multiple tags with a space. For example, --tags \"Key\"=\"owner\",\"Value\"=\"admin\"
  \"Key\"=\"environment\",\"Value\"=\"test\" \"Key\"=\"version\",\"Value\"=\"1.0\".

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: One or more name/value pairs to add as tags to the specified resource. Each tag
  name is passed in with the parameter Key and the corresponding value is passed in with the
  parameter Value. The Key and Value parameters are separated by a comma (,). Separate
  multiple tags with a space. For example, --tags \"Key\"=\"owner\",\"Value\"=\"admin\"
  \"Key\"=\"environment\",\"Value\"=\"test\" \"Key\"=\"version\",\"Value\"=\"1.0\".
"""
function create_tags(ResourceName, Tag; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "CreateTags",
        Dict{String,Any}("ResourceName" => ResourceName, "Tag" => Tag);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_tags(
    ResourceName,
    Tag,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateTags",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceName" => ResourceName, "Tag" => Tag),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_usage_limit(amount, cluster_identifier, feature_type, limit_type)
    create_usage_limit(amount, cluster_identifier, feature_type, limit_type, params::Dict{String,<:Any})

Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit
is identified by the returned usage limit identifier.

# Arguments
- `amount`: The limit amount. If time-based, this amount is in minutes. If data-based, this
  amount is in terabytes (TB). The value must be a positive number.
- `cluster_identifier`: The identifier of the cluster that you want to limit usage.
- `feature_type`: The Amazon Redshift feature that you want to limit.
- `limit_type`: The type of limit. Depending on the feature type, this can be based on a
  time duration or data size. If FeatureType is spectrum, then LimitType must be
  data-scanned. If FeatureType is concurrency-scaling, then LimitType must be time. If
  FeatureType is cross-region-datasharing, then LimitType must be data-scanned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BreachAction"`: The action that Amazon Redshift takes when the limit is reached. The
  default is log. For more information about this parameter, see UsageLimit.
- `"Period"`: The time period that the amount applies to. A weekly period begins on Sunday.
  The default is monthly.
- `"Tags"`: A list of tag instances.
"""
function create_usage_limit(
    Amount,
    ClusterIdentifier,
    FeatureType,
    LimitType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateUsageLimit",
        Dict{String,Any}(
            "Amount" => Amount,
            "ClusterIdentifier" => ClusterIdentifier,
            "FeatureType" => FeatureType,
            "LimitType" => LimitType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_usage_limit(
    Amount,
    ClusterIdentifier,
    FeatureType,
    LimitType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "CreateUsageLimit",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Amount" => Amount,
                    "ClusterIdentifier" => ClusterIdentifier,
                    "FeatureType" => FeatureType,
                    "LimitType" => LimitType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deauthorize_data_share(consumer_identifier, data_share_arn)
    deauthorize_data_share(consumer_identifier, data_share_arn, params::Dict{String,<:Any})

From a datashare producer account, removes authorization from the specified datashare.

# Arguments
- `consumer_identifier`: The identifier of the data consumer that is to have authorization
  removed from the datashare. This identifier is an Amazon Web Services account ID or a
  keyword, such as ADX.
- `data_share_arn`: The namespace Amazon Resource Name (ARN) of the datashare to remove
  authorization from.

"""
function deauthorize_data_share(
    ConsumerIdentifier, DataShareArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeauthorizeDataShare",
        Dict{String,Any}(
            "ConsumerIdentifier" => ConsumerIdentifier, "DataShareArn" => DataShareArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deauthorize_data_share(
    ConsumerIdentifier,
    DataShareArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeauthorizeDataShare",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConsumerIdentifier" => ConsumerIdentifier,
                    "DataShareArn" => DataShareArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_authentication_profile(authentication_profile_name)
    delete_authentication_profile(authentication_profile_name, params::Dict{String,<:Any})

Deletes an authentication profile.

# Arguments
- `authentication_profile_name`: The name of the authentication profile to delete.

"""
function delete_authentication_profile(
    AuthenticationProfileName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteAuthenticationProfile",
        Dict{String,Any}("AuthenticationProfileName" => AuthenticationProfileName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_authentication_profile(
    AuthenticationProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteAuthenticationProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AuthenticationProfileName" => AuthenticationProfileName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cluster(cluster_identifier)
    delete_cluster(cluster_identifier, params::Dict{String,<:Any})

Deletes a previously provisioned cluster without its final snapshot being created. A
successful response from the web service indicates that the request was received correctly.
Use DescribeClusters to monitor the status of the deletion. The delete operation cannot be
canceled or reverted once submitted. For more information about managing clusters, go to
Amazon Redshift Clusters in the Amazon Redshift Cluster Management Guide. If you want to
shut down the cluster and retain it for future use, set SkipFinalClusterSnapshot to false
and specify a name for FinalClusterSnapshotIdentifier. You can later restore this snapshot
to resume using the cluster. If a final cluster snapshot is requested, the status of the
cluster will be \"final-snapshot\" while the snapshot is being taken, then it's
\"deleting\" once Amazon Redshift begins deleting the cluster.   For more information about
managing clusters, go to Amazon Redshift Clusters in the Amazon Redshift Cluster Management
Guide.

# Arguments
- `cluster_identifier`: The identifier of the cluster to be deleted. Constraints:   Must
  contain lowercase characters.   Must contain from 1 to 63 alphanumeric characters or
  hyphens.   First character must be a letter.   Cannot end with a hyphen or contain two
  consecutive hyphens.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FinalClusterSnapshotIdentifier"`: The identifier of the final snapshot that is to be
  created immediately before deleting the cluster. If this parameter is provided,
  SkipFinalClusterSnapshot must be false.  Constraints:   Must be 1 to 255 alphanumeric
  characters.   First character must be a letter.   Cannot end with a hyphen or contain two
  consecutive hyphens.
- `"FinalClusterSnapshotRetentionPeriod"`: The number of days that a manual snapshot is
  retained. If the value is -1, the manual snapshot is retained indefinitely. The value must
  be either -1 or an integer between 1 and 3,653. The default value is -1.
- `"SkipFinalClusterSnapshot"`: Determines whether a final snapshot of the cluster is
  created before Amazon Redshift deletes the cluster. If true, a final cluster snapshot is
  not created. If false, a final cluster snapshot is created before the cluster is deleted.
  The FinalClusterSnapshotIdentifier parameter must be specified if SkipFinalClusterSnapshot
  is false.  Default: false
"""
function delete_cluster(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteCluster",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cluster(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteCluster",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cluster_parameter_group(parameter_group_name)
    delete_cluster_parameter_group(parameter_group_name, params::Dict{String,<:Any})

Deletes a specified Amazon Redshift parameter group.  You cannot delete a parameter group
if it is associated with a cluster.

# Arguments
- `parameter_group_name`: The name of the parameter group to be deleted. Constraints:
  Must be the name of an existing cluster parameter group.   Cannot delete a default cluster
  parameter group.

"""
function delete_cluster_parameter_group(
    ParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteClusterParameterGroup",
        Dict{String,Any}("ParameterGroupName" => ParameterGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cluster_parameter_group(
    ParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteClusterParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ParameterGroupName" => ParameterGroupName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cluster_security_group(cluster_security_group_name)
    delete_cluster_security_group(cluster_security_group_name, params::Dict{String,<:Any})

Deletes an Amazon Redshift security group.  You cannot delete a security group that is
associated with any clusters. You cannot delete the default security group.   For
information about managing security groups, go to Amazon Redshift Cluster Security Groups
in the Amazon Redshift Cluster Management Guide.

# Arguments
- `cluster_security_group_name`: The name of the cluster security group to be deleted.

"""
function delete_cluster_security_group(
    ClusterSecurityGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteClusterSecurityGroup",
        Dict{String,Any}("ClusterSecurityGroupName" => ClusterSecurityGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cluster_security_group(
    ClusterSecurityGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteClusterSecurityGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClusterSecurityGroupName" => ClusterSecurityGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cluster_snapshot(snapshot_identifier)
    delete_cluster_snapshot(snapshot_identifier, params::Dict{String,<:Any})

Deletes the specified manual snapshot. The snapshot must be in the available state, with no
other users authorized to access the snapshot.  Unlike automated snapshots, manual
snapshots are retained even after you delete your cluster. Amazon Redshift does not delete
your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged.
If other accounts are authorized to access the snapshot, you must revoke all of the
authorizations before you can delete the snapshot.

# Arguments
- `snapshot_identifier`: The unique identifier of the manual snapshot to be deleted.
  Constraints: Must be the name of an existing snapshot that is in the available, failed, or
  cancelled state.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SnapshotClusterIdentifier"`: The unique identifier of the cluster the snapshot was
  created from. This parameter is required if your IAM user has a policy containing a
  snapshot resource element that specifies anything other than * for the cluster name.
  Constraints: Must be the name of valid cluster.
"""
function delete_cluster_snapshot(
    SnapshotIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteClusterSnapshot",
        Dict{String,Any}("SnapshotIdentifier" => SnapshotIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cluster_snapshot(
    SnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteClusterSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SnapshotIdentifier" => SnapshotIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cluster_subnet_group(cluster_subnet_group_name)
    delete_cluster_subnet_group(cluster_subnet_group_name, params::Dict{String,<:Any})

Deletes the specified cluster subnet group.

# Arguments
- `cluster_subnet_group_name`: The name of the cluster subnet group name to be deleted.

"""
function delete_cluster_subnet_group(
    ClusterSubnetGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteClusterSubnetGroup",
        Dict{String,Any}("ClusterSubnetGroupName" => ClusterSubnetGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cluster_subnet_group(
    ClusterSubnetGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteClusterSubnetGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClusterSubnetGroupName" => ClusterSubnetGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_custom_domain_association(cluster_identifier, custom_domain_name)
    delete_custom_domain_association(cluster_identifier, custom_domain_name, params::Dict{String,<:Any})

Contains information about deleting a custom domain association for a cluster.

# Arguments
- `cluster_identifier`: The identifier of the cluster to delete a custom domain association
  for.
- `custom_domain_name`: The custom domain name for the custom domain association.

"""
function delete_custom_domain_association(
    ClusterIdentifier, CustomDomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteCustomDomainAssociation",
        Dict{String,Any}(
            "ClusterIdentifier" => ClusterIdentifier, "CustomDomainName" => CustomDomainName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_custom_domain_association(
    ClusterIdentifier,
    CustomDomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteCustomDomainAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterIdentifier" => ClusterIdentifier,
                    "CustomDomainName" => CustomDomainName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_endpoint_access(endpoint_name)
    delete_endpoint_access(endpoint_name, params::Dict{String,<:Any})

Deletes a Redshift-managed VPC endpoint.

# Arguments
- `endpoint_name`: The Redshift-managed VPC endpoint to delete.

"""
function delete_endpoint_access(
    EndpointName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteEndpointAccess",
        Dict{String,Any}("EndpointName" => EndpointName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_endpoint_access(
    EndpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteEndpointAccess",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EndpointName" => EndpointName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_event_subscription(subscription_name)
    delete_event_subscription(subscription_name, params::Dict{String,<:Any})

Deletes an Amazon Redshift event notification subscription.

# Arguments
- `subscription_name`: The name of the Amazon Redshift event notification subscription to
  be deleted.

"""
function delete_event_subscription(
    SubscriptionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteEventSubscription",
        Dict{String,Any}("SubscriptionName" => SubscriptionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_event_subscription(
    SubscriptionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteEventSubscription",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SubscriptionName" => SubscriptionName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_hsm_client_certificate(hsm_client_certificate_identifier)
    delete_hsm_client_certificate(hsm_client_certificate_identifier, params::Dict{String,<:Any})

Deletes the specified HSM client certificate.

# Arguments
- `hsm_client_certificate_identifier`: The identifier of the HSM client certificate to be
  deleted.

"""
function delete_hsm_client_certificate(
    HsmClientCertificateIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteHsmClientCertificate",
        Dict{String,Any}(
            "HsmClientCertificateIdentifier" => HsmClientCertificateIdentifier
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_hsm_client_certificate(
    HsmClientCertificateIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteHsmClientCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "HsmClientCertificateIdentifier" => HsmClientCertificateIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_hsm_configuration(hsm_configuration_identifier)
    delete_hsm_configuration(hsm_configuration_identifier, params::Dict{String,<:Any})

Deletes the specified Amazon Redshift HSM configuration.

# Arguments
- `hsm_configuration_identifier`: The identifier of the Amazon Redshift HSM configuration
  to be deleted.

"""
function delete_hsm_configuration(
    HsmConfigurationIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteHsmConfiguration",
        Dict{String,Any}("HsmConfigurationIdentifier" => HsmConfigurationIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_hsm_configuration(
    HsmConfigurationIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteHsmConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "HsmConfigurationIdentifier" => HsmConfigurationIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_partner(account_id, cluster_identifier, database_name, partner_name)
    delete_partner(account_id, cluster_identifier, database_name, partner_name, params::Dict{String,<:Any})

Deletes a partner integration from a cluster. Data can still flow to the cluster until the
integration is deleted at the partner's website.

# Arguments
- `account_id`: The Amazon Web Services account ID that owns the cluster.
- `cluster_identifier`: The cluster identifier of the cluster that receives data from the
  partner.
- `database_name`: The name of the database that receives data from the partner.
- `partner_name`: The name of the partner that is authorized to send data.

"""
function delete_partner(
    AccountId,
    ClusterIdentifier,
    DatabaseName,
    PartnerName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeletePartner",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "ClusterIdentifier" => ClusterIdentifier,
            "DatabaseName" => DatabaseName,
            "PartnerName" => PartnerName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_partner(
    AccountId,
    ClusterIdentifier,
    DatabaseName,
    PartnerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeletePartner",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "ClusterIdentifier" => ClusterIdentifier,
                    "DatabaseName" => DatabaseName,
                    "PartnerName" => PartnerName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_redshift_idc_application(redshift_idc_application_arn)
    delete_redshift_idc_application(redshift_idc_application_arn, params::Dict{String,<:Any})

Deletes an Amazon Redshift IAM Identity Center application.

# Arguments
- `redshift_idc_application_arn`: The ARN for a deleted Amazon Redshift IAM Identity Center
  application.

"""
function delete_redshift_idc_application(
    RedshiftIdcApplicationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteRedshiftIdcApplication",
        Dict{String,Any}("RedshiftIdcApplicationArn" => RedshiftIdcApplicationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_redshift_idc_application(
    RedshiftIdcApplicationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteRedshiftIdcApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RedshiftIdcApplicationArn" => RedshiftIdcApplicationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_policy(resource_arn)
    delete_resource_policy(resource_arn, params::Dict{String,<:Any})

Deletes the resource policy for a specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource of which its resource
  policy is deleted.

"""
function delete_resource_policy(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteResourcePolicy",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_policy(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteResourcePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_scheduled_action(scheduled_action_name)
    delete_scheduled_action(scheduled_action_name, params::Dict{String,<:Any})

Deletes a scheduled action.

# Arguments
- `scheduled_action_name`: The name of the scheduled action to delete.

"""
function delete_scheduled_action(
    ScheduledActionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteScheduledAction",
        Dict{String,Any}("ScheduledActionName" => ScheduledActionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_scheduled_action(
    ScheduledActionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteScheduledAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ScheduledActionName" => ScheduledActionName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_snapshot_copy_grant(snapshot_copy_grant_name)
    delete_snapshot_copy_grant(snapshot_copy_grant_name, params::Dict{String,<:Any})

Deletes the specified snapshot copy grant.

# Arguments
- `snapshot_copy_grant_name`: The name of the snapshot copy grant to delete.

"""
function delete_snapshot_copy_grant(
    SnapshotCopyGrantName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteSnapshotCopyGrant",
        Dict{String,Any}("SnapshotCopyGrantName" => SnapshotCopyGrantName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_snapshot_copy_grant(
    SnapshotCopyGrantName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteSnapshotCopyGrant",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SnapshotCopyGrantName" => SnapshotCopyGrantName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_snapshot_schedule(schedule_identifier)
    delete_snapshot_schedule(schedule_identifier, params::Dict{String,<:Any})

Deletes a snapshot schedule.

# Arguments
- `schedule_identifier`: A unique identifier of the snapshot schedule to delete.

"""
function delete_snapshot_schedule(
    ScheduleIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteSnapshotSchedule",
        Dict{String,Any}("ScheduleIdentifier" => ScheduleIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_snapshot_schedule(
    ScheduleIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteSnapshotSchedule",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ScheduleIdentifier" => ScheduleIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_tags(resource_name, tag_key)
    delete_tags(resource_name, tag_key, params::Dict{String,<:Any})

Deletes tags from a resource. You must provide the ARN of the resource from which you want
to delete the tag or tags.

# Arguments
- `resource_name`: The Amazon Resource Name (ARN) from which you want to remove the tag or
  tags. For example, arn:aws:redshift:us-east-2:123456789:cluster:t1.
- `tag_key`: The tag key that you want to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagKeys"`: The tag key that you want to delete.
"""
function delete_tags(
    ResourceName, TagKey; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteTags",
        Dict{String,Any}("ResourceName" => ResourceName, "TagKey" => TagKey);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_tags(
    ResourceName,
    TagKey,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteTags",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceName" => ResourceName, "TagKey" => TagKey),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_usage_limit(usage_limit_id)
    delete_usage_limit(usage_limit_id, params::Dict{String,<:Any})

Deletes a usage limit from a cluster.

# Arguments
- `usage_limit_id`: The identifier of the usage limit to delete.

"""
function delete_usage_limit(
    UsageLimitId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DeleteUsageLimit",
        Dict{String,Any}("UsageLimitId" => UsageLimitId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_usage_limit(
    UsageLimitId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DeleteUsageLimit",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UsageLimitId" => UsageLimitId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_account_attributes()
    describe_account_attributes(params::Dict{String,<:Any})

Returns a list of attributes attached to an account

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributeNames"`: A list of attribute names.
"""
function describe_account_attributes(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeAccountAttributes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_account_attributes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeAccountAttributes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_authentication_profiles()
    describe_authentication_profiles(params::Dict{String,<:Any})

Describes an authentication profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuthenticationProfileName"`: The name of the authentication profile to describe. If not
  specified then all authentication profiles owned by the account are listed.
"""
function describe_authentication_profiles(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeAuthenticationProfiles";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_authentication_profiles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeAuthenticationProfiles",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster_db_revisions()
    describe_cluster_db_revisions(params::Dict{String,<:Any})

Returns an array of ClusterDbRevision objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterIdentifier"`: A unique identifier for a cluster whose ClusterDbRevisions you are
  requesting. This parameter is case sensitive. All clusters defined for an account are
  returned by default.
- `"Marker"`: An optional parameter that specifies the starting point for returning a set
  of response records. When the results of a DescribeClusterDbRevisions request exceed the
  value specified in MaxRecords, Amazon Redshift returns a value in the marker field of the
  response. You can retrieve the next set of response records by providing the returned
  marker value in the marker parameter and retrying the request.  Constraints: You can
  specify either the ClusterIdentifier parameter, or the marker parameter, but not both.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in the marker field of the response. You can retrieve the next set of response
  records by providing the returned marker value in the marker parameter and retrying the
  request.  Default: 100 Constraints: minimum 20, maximum 100.
"""
function describe_cluster_db_revisions(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeClusterDbRevisions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_cluster_db_revisions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeClusterDbRevisions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster_parameter_groups()
    describe_cluster_parameter_groups(params::Dict{String,<:Any})

Returns a list of Amazon Redshift parameter groups, including parameter groups you created
and the default parameter group. For each parameter group, the response includes the
parameter group name, description, and parameter group family name. You can optionally
specify a name to retrieve the description of a specific parameter group.  For more
information about parameters and parameter groups, go to Amazon Redshift Parameter Groups
in the Amazon Redshift Cluster Management Guide. If you specify both tag keys and tag
values in the same request, Amazon Redshift returns all parameter groups that match any
combination of the specified keys and values. For example, if you have owner and
environment for tag keys, and admin and test for tag values, all parameter groups that have
any combination of those values are returned. If both tag keys and values are omitted from
the request, parameter groups are returned regardless of whether they have tag keys or
values associated with them.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeClusterParameterGroups request exceed the
  value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of
  the response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"ParameterGroupName"`: The name of a specific parameter group for which to return
  details. By default, details about all parameter groups and the default parameter group are
  returned.
- `"TagKeys"`: A tag key or keys for which you want to return all matching cluster
  parameter groups that are associated with the specified key or keys. For example, suppose
  that you have parameter groups that are tagged with keys called owner and environment. If
  you specify both of these tag keys in the request, Amazon Redshift returns a response with
  the parameter groups that have either or both of these tag keys associated with them.
- `"TagValues"`: A tag value or values for which you want to return all matching cluster
  parameter groups that are associated with the specified tag value or values. For example,
  suppose that you have parameter groups that are tagged with values called admin and test.
  If you specify both of these tag values in the request, Amazon Redshift returns a response
  with the parameter groups that have either or both of these tag values associated with them.
"""
function describe_cluster_parameter_groups(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeClusterParameterGroups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cluster_parameter_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeClusterParameterGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster_parameters(parameter_group_name)
    describe_cluster_parameters(parameter_group_name, params::Dict{String,<:Any})

Returns a detailed list of parameters contained within the specified Amazon Redshift
parameter group. For each parameter the response includes information such as parameter
name, description, data type, value, whether the parameter value is modifiable, and so on.
You can specify source filter to retrieve parameters of only specific type. For example, to
retrieve parameters that were modified by a user action such as from
ModifyClusterParameterGroup, you can specify source equal to user.  For more information
about parameters and parameter groups, go to Amazon Redshift Parameter Groups in the Amazon
Redshift Cluster Management Guide.

# Arguments
- `parameter_group_name`: The name of a cluster parameter group for which to return details.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeClusterParameters request exceed the value
  specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the
  response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"Source"`: The parameter types to return. Specify user to show parameters that are
  different form the default. Similarly, specify engine-default to show parameters that are
  the same as the default parameter group.  Default: All parameter types returned. Valid
  Values: user | engine-default
"""
function describe_cluster_parameters(
    ParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeClusterParameters",
        Dict{String,Any}("ParameterGroupName" => ParameterGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cluster_parameters(
    ParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DescribeClusterParameters",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ParameterGroupName" => ParameterGroupName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster_security_groups()
    describe_cluster_security_groups(params::Dict{String,<:Any})

Returns information about Amazon Redshift security groups. If the name of a security group
is specified, the response will contain only information about only that security group.
For information about managing security groups, go to Amazon Redshift Cluster Security
Groups in the Amazon Redshift Cluster Management Guide. If you specify both tag keys and
tag values in the same request, Amazon Redshift returns all security groups that match any
combination of the specified keys and values. For example, if you have owner and
environment for tag keys, and admin and test for tag values, all security groups that have
any combination of those values are returned. If both tag keys and values are omitted from
the request, security groups are returned regardless of whether they have tag keys or
values associated with them.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterSecurityGroupName"`: The name of a cluster security group for which you are
  requesting details. You must specify either the Marker parameter or a
  ClusterSecurityGroupName parameter, but not both.   Example: securitygroup1
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeClusterSecurityGroups request exceed the
  value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of
  the response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.  Constraints: You must
  specify either the ClusterSecurityGroupName parameter or the Marker parameter, but not
  both.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"TagKeys"`: A tag key or keys for which you want to return all matching cluster security
  groups that are associated with the specified key or keys. For example, suppose that you
  have security groups that are tagged with keys called owner and environment. If you specify
  both of these tag keys in the request, Amazon Redshift returns a response with the security
  groups that have either or both of these tag keys associated with them.
- `"TagValues"`: A tag value or values for which you want to return all matching cluster
  security groups that are associated with the specified tag value or values. For example,
  suppose that you have security groups that are tagged with values called admin and test. If
  you specify both of these tag values in the request, Amazon Redshift returns a response
  with the security groups that have either or both of these tag values associated with them.
"""
function describe_cluster_security_groups(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeClusterSecurityGroups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cluster_security_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeClusterSecurityGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster_snapshots()
    describe_cluster_snapshots(params::Dict{String,<:Any})

Returns one or more snapshot objects, which contain metadata about your cluster snapshots.
By default, this operation returns information about all snapshots of all clusters that are
owned by your Amazon Web Services account. No information is returned for snapshots owned
by inactive Amazon Web Services accounts. If you specify both tag keys and tag values in
the same request, Amazon Redshift returns all snapshots that match any combination of the
specified keys and values. For example, if you have owner and environment for tag keys, and
admin and test for tag values, all snapshots that have any combination of those values are
returned. Only snapshots that you own are returned in the response; shared snapshots are
not returned with the tag key and tag value request parameters. If both tag keys and values
are omitted from the request, snapshots are returned regardless of whether they have tag
keys or values associated with them.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterExists"`: A value that indicates whether to return snapshots only for an
  existing cluster. You can perform table-level restore only by using a snapshot of an
  existing cluster, that is, a cluster that has not been deleted. Values for this parameter
  work as follows:    If ClusterExists is set to true, ClusterIdentifier is required.   If
  ClusterExists is set to false and ClusterIdentifier isn't specified, all snapshots
  associated with deleted clusters (orphaned snapshots) are returned.    If ClusterExists is
  set to false and ClusterIdentifier is specified for a deleted cluster, snapshots associated
  with that cluster are returned.   If ClusterExists is set to false and ClusterIdentifier is
  specified for an existing cluster, no snapshots are returned.
- `"ClusterIdentifier"`: The identifier of the cluster which generated the requested
  snapshots.
- `"EndTime"`: A time value that requests only snapshots created at or before the specified
  time. The time value is specified in ISO 8601 format. For more information about ISO 8601,
  go to the ISO8601 Wikipedia page.  Example: 2012-07-16T18:00:00Z
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeClusterSnapshots request exceed the value
  specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the
  response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"OwnerAccount"`: The Amazon Web Services account used to create or copy the snapshot.
  Use this field to filter the results to snapshots owned by a particular account. To
  describe snapshots you own, either specify your Amazon Web Services account, or do not
  specify the parameter.
- `"SnapshotArn"`: The Amazon Resource Name (ARN) of the snapshot associated with the
  message to describe cluster snapshots.
- `"SnapshotIdentifier"`: The snapshot identifier of the snapshot about which to return
  information.
- `"SnapshotType"`: The type of snapshots for which you are requesting information. By
  default, snapshots of all types are returned. Valid Values: automated | manual
- `"SortingEntities"`:
- `"StartTime"`: A value that requests only snapshots created at or after the specified
  time. The time value is specified in ISO 8601 format. For more information about ISO 8601,
  go to the ISO8601 Wikipedia page.  Example: 2012-07-16T18:00:00Z
- `"TagKeys"`: A tag key or keys for which you want to return all matching cluster
  snapshots that are associated with the specified key or keys. For example, suppose that you
  have snapshots that are tagged with keys called owner and environment. If you specify both
  of these tag keys in the request, Amazon Redshift returns a response with the snapshots
  that have either or both of these tag keys associated with them.
- `"TagValues"`: A tag value or values for which you want to return all matching cluster
  snapshots that are associated with the specified tag value or values. For example, suppose
  that you have snapshots that are tagged with values called admin and test. If you specify
  both of these tag values in the request, Amazon Redshift returns a response with the
  snapshots that have either or both of these tag values associated with them.
"""
function describe_cluster_snapshots(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeClusterSnapshots"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_cluster_snapshots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeClusterSnapshots",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster_subnet_groups()
    describe_cluster_subnet_groups(params::Dict{String,<:Any})

Returns one or more cluster subnet group objects, which contain metadata about your cluster
subnet groups. By default, this operation returns information about all cluster subnet
groups that are defined in your Amazon Web Services account. If you specify both tag keys
and tag values in the same request, Amazon Redshift returns all subnet groups that match
any combination of the specified keys and values. For example, if you have owner and
environment for tag keys, and admin and test for tag values, all subnet groups that have
any combination of those values are returned. If both tag keys and values are omitted from
the request, subnet groups are returned regardless of whether they have tag keys or values
associated with them.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterSubnetGroupName"`: The name of the cluster subnet group for which information is
  requested.
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeClusterSubnetGroups request exceed the
  value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of
  the response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"TagKeys"`: A tag key or keys for which you want to return all matching cluster subnet
  groups that are associated with the specified key or keys. For example, suppose that you
  have subnet groups that are tagged with keys called owner and environment. If you specify
  both of these tag keys in the request, Amazon Redshift returns a response with the subnet
  groups that have either or both of these tag keys associated with them.
- `"TagValues"`: A tag value or values for which you want to return all matching cluster
  subnet groups that are associated with the specified tag value or values. For example,
  suppose that you have subnet groups that are tagged with values called admin and test. If
  you specify both of these tag values in the request, Amazon Redshift returns a response
  with the subnet groups that have either or both of these tag values associated with them.
"""
function describe_cluster_subnet_groups(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeClusterSubnetGroups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cluster_subnet_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeClusterSubnetGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster_tracks()
    describe_cluster_tracks(params::Dict{String,<:Any})

Returns a list of all the available maintenance tracks.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaintenanceTrackName"`: The name of the maintenance track.
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeClusterTracks request exceed the value
  specified in MaxRecords, Amazon Redshift returns a value in the Marker field of the
  response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: An integer value for the maximum number of maintenance tracks to return.
"""
function describe_cluster_tracks(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeClusterTracks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_cluster_tracks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeClusterTracks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster_versions()
    describe_cluster_versions(params::Dict{String,<:Any})

Returns descriptions of the available Amazon Redshift cluster versions. You can call this
operation even before creating any clusters to learn more about the Amazon Redshift
versions. For more information about managing clusters, go to Amazon Redshift Clusters in
the Amazon Redshift Cluster Management Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterParameterGroupFamily"`: The name of a specific cluster parameter group family to
  return details for. Constraints:   Must be 1 to 255 alphanumeric characters   First
  character must be a letter   Cannot end with a hyphen or contain two consecutive hyphens
- `"ClusterVersion"`: The specific cluster version to return. Example: 1.0
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeClusterVersions request exceed the value
  specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the
  response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
"""
function describe_cluster_versions(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeClusterVersions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_cluster_versions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeClusterVersions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_clusters()
    describe_clusters(params::Dict{String,<:Any})

Returns properties of provisioned clusters including general cluster properties, cluster
database properties, maintenance and backup properties, and security and access properties.
This operation supports pagination. For more information about managing clusters, go to
Amazon Redshift Clusters in the Amazon Redshift Cluster Management Guide. If you specify
both tag keys and tag values in the same request, Amazon Redshift returns all clusters that
match any combination of the specified keys and values. For example, if you have owner and
environment for tag keys, and admin and test for tag values, all clusters that have any
combination of those values are returned. If both tag keys and values are omitted from the
request, clusters are returned regardless of whether they have tag keys or values
associated with them.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterIdentifier"`: The unique identifier of a cluster whose properties you are
  requesting. This parameter is case sensitive. The default is that all clusters defined for
  an account are returned.
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeClusters request exceed the value specified
  in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You
  can retrieve the next set of response records by providing the returned marker value in the
  Marker parameter and retrying the request.  Constraints: You can specify either the
  ClusterIdentifier parameter or the Marker parameter, but not both.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"TagKeys"`: A tag key or keys for which you want to return all matching clusters that
  are associated with the specified key or keys. For example, suppose that you have clusters
  that are tagged with keys called owner and environment. If you specify both of these tag
  keys in the request, Amazon Redshift returns a response with the clusters that have either
  or both of these tag keys associated with them.
- `"TagValues"`: A tag value or values for which you want to return all matching clusters
  that are associated with the specified tag value or values. For example, suppose that you
  have clusters that are tagged with values called admin and test. If you specify both of
  these tag values in the request, Amazon Redshift returns a response with the clusters that
  have either or both of these tag values associated with them.
"""
function describe_clusters(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeClusters"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_clusters(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeClusters", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_custom_domain_associations()
    describe_custom_domain_associations(params::Dict{String,<:Any})

Contains information about custom domain associations for a cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CustomDomainCertificateArn"`: The certificate Amazon Resource Name (ARN) for the custom
  domain association.
- `"CustomDomainName"`: The custom domain name for the custom domain association.
- `"Marker"`: The marker for the custom domain association.
- `"MaxRecords"`: The maximum records setting for the associated custom domain.
"""
function describe_custom_domain_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeCustomDomainAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_custom_domain_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeCustomDomainAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_data_shares()
    describe_data_shares(params::Dict{String,<:Any})

Shows the status of any inbound or outbound datashares available in the specified account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataShareArn"`: The Amazon resource name (ARN) of the datashare to describe details of.
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeDataShares request exceed the value
  specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the
  response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.
"""
function describe_data_shares(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeDataShares"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_data_shares(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeDataShares", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_data_shares_for_consumer()
    describe_data_shares_for_consumer(params::Dict{String,<:Any})

Returns a list of datashares where the account identifier being called is a consumer
account identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConsumerArn"`: The Amazon Resource Name (ARN) of the consumer namespace that returns in
  the list of datashares.
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeDataSharesForConsumer request exceed the
  value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of
  the response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.
- `"Status"`: An identifier giving the status of a datashare in the consumer cluster. If
  this field is specified, Amazon Redshift returns the list of datashares that have the
  specified status.
"""
function describe_data_shares_for_consumer(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeDataSharesForConsumer";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_data_shares_for_consumer(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeDataSharesForConsumer",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_data_shares_for_producer()
    describe_data_shares_for_producer(params::Dict{String,<:Any})

Returns a list of datashares when the account identifier being called is a producer account
identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeDataSharesForProducer request exceed the
  value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of
  the response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.
- `"ProducerArn"`: The Amazon Resource Name (ARN) of the producer namespace that returns in
  the list of datashares.
- `"Status"`: An identifier giving the status of a datashare in the producer. If this field
  is specified, Amazon Redshift returns the list of datashares that have the specified status.
"""
function describe_data_shares_for_producer(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeDataSharesForProducer";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_data_shares_for_producer(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeDataSharesForProducer",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_default_cluster_parameters(parameter_group_family)
    describe_default_cluster_parameters(parameter_group_family, params::Dict{String,<:Any})

Returns a list of parameter settings for the specified parameter group family.  For more
information about parameters and parameter groups, go to Amazon Redshift Parameter Groups
in the Amazon Redshift Cluster Management Guide.

# Arguments
- `parameter_group_family`: The name of the cluster parameter group family.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeDefaultClusterParameters request exceed the
  value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of
  the response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
"""
function describe_default_cluster_parameters(
    ParameterGroupFamily; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeDefaultClusterParameters",
        Dict{String,Any}("ParameterGroupFamily" => ParameterGroupFamily);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_default_cluster_parameters(
    ParameterGroupFamily,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DescribeDefaultClusterParameters",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ParameterGroupFamily" => ParameterGroupFamily),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_endpoint_access()
    describe_endpoint_access(params::Dict{String,<:Any})

Describes a Redshift-managed VPC endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterIdentifier"`: The cluster identifier associated with the described endpoint.
- `"EndpointName"`: The name of the endpoint to be described.
- `"Marker"`: An optional pagination token provided by a previous DescribeEndpointAccess
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by the MaxRecords parameter.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a Marker is included
  in the response so that the remaining results can be retrieved.
- `"ResourceOwner"`: The Amazon Web Services account ID of the owner of the cluster.
- `"VpcId"`: The virtual private cloud (VPC) identifier with access to the cluster.
"""
function describe_endpoint_access(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeEndpointAccess"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_endpoint_access(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeEndpointAccess",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_endpoint_authorization()
    describe_endpoint_authorization(params::Dict{String,<:Any})

Describes an endpoint authorization.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Account"`: The Amazon Web Services account ID of either the cluster owner (grantor) or
  grantee. If Grantee parameter is true, then the Account value is of the grantor.
- `"ClusterIdentifier"`: The cluster identifier of the cluster to access.
- `"Grantee"`: Indicates whether to check authorization from a grantor or grantee point of
  view. If true, Amazon Redshift returns endpoint authorizations that you've been granted. If
  false (default), checks authorization from a grantor point of view.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeEndpointAuthorization request. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by the MaxRecords
  parameter.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a Marker is included
  in the response so that the remaining results can be retrieved.
"""
function describe_endpoint_authorization(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeEndpointAuthorization";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_endpoint_authorization(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeEndpointAuthorization",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_event_categories()
    describe_event_categories(params::Dict{String,<:Any})

Displays a list of event categories for all event source types, or for a specified source
type. For a list of the event categories and source types, go to Amazon Redshift Event
Notifications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SourceType"`: The source type, such as cluster or parameter group, to which the
  described event categories apply. Valid values: cluster, cluster-snapshot,
  cluster-parameter-group, cluster-security-group, and scheduled-action.
"""
function describe_event_categories(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeEventCategories"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_event_categories(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeEventCategories",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_event_subscriptions()
    describe_event_subscriptions(params::Dict{String,<:Any})

Lists descriptions of all the Amazon Redshift event notification subscriptions for a
customer account. If you specify a subscription name, lists the description for that
subscription. If you specify both tag keys and tag values in the same request, Amazon
Redshift returns all event notification subscriptions that match any combination of the
specified keys and values. For example, if you have owner and environment for tag keys, and
admin and test for tag values, all subscriptions that have any combination of those values
are returned. If both tag keys and values are omitted from the request, subscriptions are
returned regardless of whether they have tag keys or values associated with them.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeEventSubscriptions request exceed the value
  specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the
  response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"SubscriptionName"`: The name of the Amazon Redshift event notification subscription to
  be described.
- `"TagKeys"`: A tag key or keys for which you want to return all matching event
  notification subscriptions that are associated with the specified key or keys. For example,
  suppose that you have subscriptions that are tagged with keys called owner and environment.
  If you specify both of these tag keys in the request, Amazon Redshift returns a response
  with the subscriptions that have either or both of these tag keys associated with them.
- `"TagValues"`: A tag value or values for which you want to return all matching event
  notification subscriptions that are associated with the specified tag value or values. For
  example, suppose that you have subscriptions that are tagged with values called admin and
  test. If you specify both of these tag values in the request, Amazon Redshift returns a
  response with the subscriptions that have either or both of these tag values associated
  with them.
"""
function describe_event_subscriptions(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeEventSubscriptions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_event_subscriptions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeEventSubscriptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_events()
    describe_events(params::Dict{String,<:Any})

Returns events related to clusters, security groups, snapshots, and parameter groups for
the past 14 days. Events specific to a particular cluster, security group, snapshot or
parameter group can be obtained by providing the name as a parameter. By default, the past
hour of events are returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Duration"`: The number of minutes prior to the time of the request for which to
  retrieve events. For example, if the request is sent at 18:00 and you specify a duration of
  60, then only events which have occurred after 17:00 will be returned. Default: 60
- `"EndTime"`: The end of the time interval for which to retrieve events, specified in ISO
  8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia page.
  Example: 2009-07-08T18:00Z
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeEvents request exceed the value specified
  in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You
  can retrieve the next set of response records by providing the returned marker value in the
  Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"SourceIdentifier"`: The identifier of the event source for which events will be
  returned. If this parameter is not specified, then all sources are included in the
  response. Constraints: If SourceIdentifier is supplied, SourceType must also be provided.
  Specify a cluster identifier when SourceType is cluster.   Specify a cluster security group
  name when SourceType is cluster-security-group.   Specify a cluster parameter group name
  when SourceType is cluster-parameter-group.   Specify a cluster snapshot identifier when
  SourceType is cluster-snapshot.
- `"SourceType"`: The event source to retrieve events for. If no value is specified, all
  events are returned. Constraints: If SourceType is supplied, SourceIdentifier must also be
  provided.   Specify cluster when SourceIdentifier is a cluster identifier.   Specify
  cluster-security-group when SourceIdentifier is a cluster security group name.   Specify
  cluster-parameter-group when SourceIdentifier is a cluster parameter group name.   Specify
  cluster-snapshot when SourceIdentifier is a cluster snapshot identifier.
- `"StartTime"`: The beginning of the time interval to retrieve events for, specified in
  ISO 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia page.
  Example: 2009-07-08T18:00Z
"""
function describe_events(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeEvents"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_events(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeEvents", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_hsm_client_certificates()
    describe_hsm_client_certificates(params::Dict{String,<:Any})

Returns information about the specified HSM client certificate. If no certificate ID is
specified, returns information about all the HSM certificates owned by your Amazon Web
Services account. If you specify both tag keys and tag values in the same request, Amazon
Redshift returns all HSM client certificates that match any combination of the specified
keys and values. For example, if you have owner and environment for tag keys, and admin and
test for tag values, all HSM client certificates that have any combination of those values
are returned. If both tag keys and values are omitted from the request, HSM client
certificates are returned regardless of whether they have tag keys or values associated
with them.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"HsmClientCertificateIdentifier"`: The identifier of a specific HSM client certificate
  for which you want information. If no identifier is specified, information is returned for
  all HSM client certificates owned by your Amazon Web Services account.
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeHsmClientCertificates request exceed the
  value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of
  the response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"TagKeys"`: A tag key or keys for which you want to return all matching HSM client
  certificates that are associated with the specified key or keys. For example, suppose that
  you have HSM client certificates that are tagged with keys called owner and environment. If
  you specify both of these tag keys in the request, Amazon Redshift returns a response with
  the HSM client certificates that have either or both of these tag keys associated with them.
- `"TagValues"`: A tag value or values for which you want to return all matching HSM client
  certificates that are associated with the specified tag value or values. For example,
  suppose that you have HSM client certificates that are tagged with values called admin and
  test. If you specify both of these tag values in the request, Amazon Redshift returns a
  response with the HSM client certificates that have either or both of these tag values
  associated with them.
"""
function describe_hsm_client_certificates(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeHsmClientCertificates";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_hsm_client_certificates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeHsmClientCertificates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_hsm_configurations()
    describe_hsm_configurations(params::Dict{String,<:Any})

Returns information about the specified Amazon Redshift HSM configuration. If no
configuration ID is specified, returns information about all the HSM configurations owned
by your Amazon Web Services account. If you specify both tag keys and tag values in the
same request, Amazon Redshift returns all HSM connections that match any combination of the
specified keys and values. For example, if you have owner and environment for tag keys, and
admin and test for tag values, all HSM connections that have any combination of those
values are returned. If both tag keys and values are omitted from the request, HSM
connections are returned regardless of whether they have tag keys or values associated with
them.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"HsmConfigurationIdentifier"`: The identifier of a specific Amazon Redshift HSM
  configuration to be described. If no identifier is specified, information is returned for
  all HSM configurations owned by your Amazon Web Services account.
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeHsmConfigurations request exceed the value
  specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the
  response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"TagKeys"`: A tag key or keys for which you want to return all matching HSM
  configurations that are associated with the specified key or keys. For example, suppose
  that you have HSM configurations that are tagged with keys called owner and environment. If
  you specify both of these tag keys in the request, Amazon Redshift returns a response with
  the HSM configurations that have either or both of these tag keys associated with them.
- `"TagValues"`: A tag value or values for which you want to return all matching HSM
  configurations that are associated with the specified tag value or values. For example,
  suppose that you have HSM configurations that are tagged with values called admin and test.
  If you specify both of these tag values in the request, Amazon Redshift returns a response
  with the HSM configurations that have either or both of these tag values associated with
  them.
"""
function describe_hsm_configurations(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeHsmConfigurations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_hsm_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeHsmConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_inbound_integrations()
    describe_inbound_integrations(params::Dict{String,<:Any})

Returns a list of inbound integrations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IntegrationArn"`: The Amazon Resource Name (ARN) of the inbound integration.
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeInboundIntegrations request exceed the
  value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of
  the response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"TargetArn"`: The Amazon Resource Name (ARN) of the target of an inbound integration.
"""
function describe_inbound_integrations(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeInboundIntegrations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_inbound_integrations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeInboundIntegrations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_logging_status(cluster_identifier)
    describe_logging_status(cluster_identifier, params::Dict{String,<:Any})

Describes whether information, such as queries and connection attempts, is being logged for
the specified Amazon Redshift cluster.

# Arguments
- `cluster_identifier`: The identifier of the cluster from which to get the logging status.
  Example: examplecluster

"""
function describe_logging_status(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeLoggingStatus",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_logging_status(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DescribeLoggingStatus",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_node_configuration_options(action_type)
    describe_node_configuration_options(action_type, params::Dict{String,<:Any})

Returns properties of possible node configurations such as node type, number of nodes, and
disk usage for the specified action type.

# Arguments
- `action_type`: The action type to evaluate for possible node configurations. Specify
  \"restore-cluster\" to get configuration combinations based on an existing snapshot.
  Specify \"recommend-node-config\" to get configuration recommendations based on an existing
  cluster or snapshot. Specify \"resize-cluster\" to get configuration combinations for
  elastic resize based on an existing cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterIdentifier"`: The identifier of the cluster to evaluate for possible node
  configurations.
- `"Filter"`: A set of name, operator, and value items to filter the results.
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeNodeConfigurationOptions request exceed the
  value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of
  the response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 500  Constraints: minimum
  100, maximum 500.
- `"OwnerAccount"`: The Amazon Web Services account used to create or copy the snapshot.
  Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
- `"SnapshotArn"`: The Amazon Resource Name (ARN) of the snapshot associated with the
  message to describe node configuration.
- `"SnapshotIdentifier"`: The identifier of the snapshot to evaluate for possible node
  configurations.
"""
function describe_node_configuration_options(
    ActionType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeNodeConfigurationOptions",
        Dict{String,Any}("ActionType" => ActionType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_node_configuration_options(
    ActionType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DescribeNodeConfigurationOptions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ActionType" => ActionType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_orderable_cluster_options()
    describe_orderable_cluster_options(params::Dict{String,<:Any})

Returns a list of orderable cluster options. Before you create a new cluster you can use
this operation to find what options are available, such as the EC2 Availability Zones (AZ)
in the specific Amazon Web Services Region that you can specify, and the node types you can
request. The node types differ by available storage, memory, CPU and price. With the cost
involved you might want to obtain a list of cluster options in the specific region and
specify values when creating a cluster. For more information about managing clusters, go to
Amazon Redshift Clusters in the Amazon Redshift Cluster Management Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterVersion"`: The version filter value. Specify this parameter to show only the
  available offerings matching the specified version. Default: All versions. Constraints:
  Must be one of the version returned from DescribeClusterVersions.
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeOrderableClusterOptions request exceed the
  value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of
  the response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"NodeType"`: The node type filter value. Specify this parameter to show only the
  available offerings matching the specified node type.
"""
function describe_orderable_cluster_options(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeOrderableClusterOptions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_orderable_cluster_options(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeOrderableClusterOptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_partners(account_id, cluster_identifier)
    describe_partners(account_id, cluster_identifier, params::Dict{String,<:Any})

Returns information about the partner integrations defined for a cluster.

# Arguments
- `account_id`: The Amazon Web Services account ID that owns the cluster.
- `cluster_identifier`: The cluster identifier of the cluster whose partner integration is
  being described.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DatabaseName"`: The name of the database whose partner integration is being described.
  If database name is not specified, then all databases in the cluster are described.
- `"PartnerName"`: The name of the partner that is being described. If partner name is not
  specified, then all partner integrations are described.
"""
function describe_partners(
    AccountId, ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribePartners",
        Dict{String,Any}(
            "AccountId" => AccountId, "ClusterIdentifier" => ClusterIdentifier
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_partners(
    AccountId,
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DescribePartners",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId, "ClusterIdentifier" => ClusterIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_redshift_idc_applications()
    describe_redshift_idc_applications(params::Dict{String,<:Any})

Lists the Amazon Redshift IAM Identity Center applications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: A value that indicates the starting point for the next set of response
  records in a subsequent request. If a value is returned in a response, you can retrieve the
  next set of records by providing this returned marker value in the Marker parameter and
  retrying the command. If the Marker field is empty, all response records have been
  retrieved for the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.
- `"RedshiftIdcApplicationArn"`: The ARN for the Redshift application that integrates with
  IAM Identity Center.
"""
function describe_redshift_idc_applications(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeRedshiftIdcApplications";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_redshift_idc_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeRedshiftIdcApplications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_node_exchange_status()
    describe_reserved_node_exchange_status(params::Dict{String,<:Any})

Returns exchange status details and associated metadata for a reserved-node exchange.
Statuses include such values as in progress and requested.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional pagination token provided by a previous
  DescribeReservedNodeExchangeStatus request. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by the MaxRecords
  parameter. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a Marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.
- `"ReservedNodeExchangeRequestId"`: The identifier of the reserved-node exchange request.
- `"ReservedNodeId"`: The identifier of the source reserved node in a reserved-node
  exchange request.
"""
function describe_reserved_node_exchange_status(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeReservedNodeExchangeStatus";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_reserved_node_exchange_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeReservedNodeExchangeStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_node_offerings()
    describe_reserved_node_offerings(params::Dict{String,<:Any})

Returns a list of the available reserved node offerings by Amazon Redshift with their
descriptions including the node type, the fixed and recurring costs of reserving the node
and duration the node will be reserved for you. These descriptions help you determine which
reserve node offering you want to purchase. You then use the unique offering ID in you call
to PurchaseReservedNodeOffering to reserve one or more nodes for your Amazon Redshift
cluster.   For more information about reserved node offerings, go to Purchasing Reserved
Nodes in the Amazon Redshift Cluster Management Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeReservedNodeOfferings request exceed the
  value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of
  the response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"ReservedNodeOfferingId"`: The unique identifier for the offering.
"""
function describe_reserved_node_offerings(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeReservedNodeOfferings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_reserved_node_offerings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeReservedNodeOfferings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_nodes()
    describe_reserved_nodes(params::Dict{String,<:Any})

Returns the descriptions of the reserved nodes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeReservedNodes request exceed the value
  specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the
  response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"ReservedNodeId"`: Identifier for the node reservation.
"""
function describe_reserved_nodes(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeReservedNodes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_reserved_nodes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeReservedNodes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_resize(cluster_identifier)
    describe_resize(cluster_identifier, params::Dict{String,<:Any})

Returns information about the last resize operation for the specified cluster. If no resize
operation has ever been initiated for the specified cluster, a HTTP 404 error is returned.
If a resize operation was initiated and completed, the status of the resize remains as
SUCCEEDED until the next resize.  A resize operation can be requested using ModifyCluster
and specifying a different number or type of nodes for the cluster.

# Arguments
- `cluster_identifier`: The unique identifier of a cluster whose resize progress you are
  requesting. This parameter is case-sensitive. By default, resize operations for all
  clusters defined for an Amazon Web Services account are returned.

"""
function describe_resize(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeResize",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_resize(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DescribeResize",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_scheduled_actions()
    describe_scheduled_actions(params::Dict{String,<:Any})

Describes properties of scheduled actions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Active"`: If true, retrieve only active scheduled actions. If false, retrieve only
  disabled scheduled actions.
- `"EndTime"`: The end time in UTC of the scheduled action to retrieve. Only active
  scheduled actions that have invocations before this time are retrieved.
- `"Filters"`: List of scheduled action filters.
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeScheduledActions request exceed the value
  specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the
  response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"ScheduledActionName"`: The name of the scheduled action to retrieve.
- `"StartTime"`: The start time in UTC of the scheduled actions to retrieve. Only active
  scheduled actions that have invocations after this time are retrieved.
- `"TargetActionType"`: The type of the scheduled actions to retrieve.
"""
function describe_scheduled_actions(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeScheduledActions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_scheduled_actions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeScheduledActions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_snapshot_copy_grants()
    describe_snapshot_copy_grants(params::Dict{String,<:Any})

Returns a list of snapshot copy grants owned by the Amazon Web Services account in the
destination region.  For more information about managing snapshot copy grants, go to Amazon
Redshift Database Encryption in the Amazon Redshift Cluster Management Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeSnapshotCopyGrant request exceed the value
  specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the
  response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.  Constraints: You can
  specify either the SnapshotCopyGrantName parameter or the Marker parameter, but not both.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"SnapshotCopyGrantName"`: The name of the snapshot copy grant.
- `"TagKeys"`: A tag key or keys for which you want to return all matching resources that
  are associated with the specified key or keys. For example, suppose that you have resources
  tagged with keys called owner and environment. If you specify both of these tag keys in the
  request, Amazon Redshift returns a response with all resources that have either or both of
  these tag keys associated with them.
- `"TagValues"`: A tag value or values for which you want to return all matching resources
  that are associated with the specified value or values. For example, suppose that you have
  resources tagged with values called admin and test. If you specify both of these tag values
  in the request, Amazon Redshift returns a response with all resources that have either or
  both of these tag values associated with them.
"""
function describe_snapshot_copy_grants(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeSnapshotCopyGrants"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_snapshot_copy_grants(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeSnapshotCopyGrants",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_snapshot_schedules()
    describe_snapshot_schedules(params::Dict{String,<:Any})

Returns a list of snapshot schedules.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterIdentifier"`: The unique identifier for the cluster whose snapshot schedules you
  want to view.
- `"Marker"`: A value that indicates the starting point for the next set of response
  records in a subsequent request. If a value is returned in a response, you can retrieve the
  next set of records by providing this returned marker value in the marker parameter and
  retrying the command. If the marker field is empty, all response records have been
  retrieved for the request.
- `"MaxRecords"`: The maximum number or response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.
- `"ScheduleIdentifier"`: A unique identifier for a snapshot schedule.
- `"TagKeys"`: The key value for a snapshot schedule tag.
- `"TagValues"`: The value corresponding to the key of the snapshot schedule tag.
"""
function describe_snapshot_schedules(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeSnapshotSchedules"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_snapshot_schedules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeSnapshotSchedules",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_storage()
    describe_storage(params::Dict{String,<:Any})

Returns account level backups storage size and provisional storage.

"""
function describe_storage(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeStorage"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_storage(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeStorage", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_table_restore_status()
    describe_table_restore_status(params::Dict{String,<:Any})

Lists the status of one or more table restore requests made using the
RestoreTableFromClusterSnapshot API action. If you don't specify a value for the
TableRestoreRequestId parameter, then DescribeTableRestoreStatus returns the status of all
table restore requests ordered by the date and time of the request in ascending order.
Otherwise DescribeTableRestoreStatus returns the status of the table specified by
TableRestoreRequestId.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterIdentifier"`: The Amazon Redshift cluster that the table is being restored to.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeTableRestoreStatus request. If this parameter is specified, the response includes
  only records beyond the marker, up to the value specified by the MaxRecords parameter.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that the remaining results can be retrieved.
- `"TableRestoreRequestId"`: The identifier of the table restore request to return status
  for. If you don't specify a TableRestoreRequestId value, then DescribeTableRestoreStatus
  returns the status of all in-progress table restore requests.
"""
function describe_table_restore_status(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeTableRestoreStatus"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_table_restore_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeTableRestoreStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_tags()
    describe_tags(params::Dict{String,<:Any})

Returns a list of tags. You can return tags from a specific resource by specifying an ARN,
or you can return all tags for a given type of resource, such as clusters, snapshots, and
so on. The following are limitations for DescribeTags:    You cannot specify an ARN and a
resource-type value together in the same request.   You cannot use the MaxRecords and
Marker parameters together with the ARN parameter.   The MaxRecords parameter can be a
range from 10 to 50 results to return in a request.   If you specify both tag keys and tag
values in the same request, Amazon Redshift returns all resources that match any
combination of the specified keys and values. For example, if you have owner and
environment for tag keys, and admin and test for tag values, all resources that have any
combination of those values are returned. If both tag keys and values are omitted from the
request, resources are returned regardless of whether they have tag keys or values
associated with them.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: A value that indicates the starting point for the next set of response
  records in a subsequent request. If a value is returned in a response, you can retrieve the
  next set of records by providing this returned marker value in the marker parameter and
  retrying the command. If the marker field is empty, all response records have been
  retrieved for the request.
- `"MaxRecords"`: The maximum number or response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.
- `"ResourceName"`: The Amazon Resource Name (ARN) for which you want to describe the tag
  or tags. For example, arn:aws:redshift:us-east-2:123456789:cluster:t1.
- `"ResourceType"`: The type of resource with which you want to view tags. Valid resource
  types are:    Cluster   CIDR/IP   EC2 security group   Snapshot   Cluster security group
  Subnet group   HSM connection   HSM certificate   Parameter group   Snapshot copy grant
  For more information about Amazon Redshift resource types and constructing ARNs, go to
  Specifying Policy Elements: Actions, Effects, Resources, and Principals in the Amazon
  Redshift Cluster Management Guide.
- `"TagKeys"`: A tag key or keys for which you want to return all matching resources that
  are associated with the specified key or keys. For example, suppose that you have resources
  tagged with keys called owner and environment. If you specify both of these tag keys in the
  request, Amazon Redshift returns a response with all resources that have either or both of
  these tag keys associated with them.
- `"TagValues"`: A tag value or values for which you want to return all matching resources
  that are associated with the specified value or values. For example, suppose that you have
  resources tagged with values called admin and test. If you specify both of these tag values
  in the request, Amazon Redshift returns a response with all resources that have either or
  both of these tag values associated with them.
"""
function describe_tags(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift("DescribeTags"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_tags(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeTags", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_usage_limits()
    describe_usage_limits(params::Dict{String,<:Any})

Shows usage limits on a cluster. Results are filtered based on the combination of input
usage limit identifier, cluster identifier, and feature type parameters:   If usage limit
identifier, cluster identifier, and feature type are not provided, then all usage limit
objects for the current account in the current region are returned.   If usage limit
identifier is provided, then the corresponding usage limit object is returned.   If cluster
identifier is provided, then all usage limit objects for the specified cluster are
returned.   If cluster identifier and feature type are provided, then all usage limit
objects for the combination of cluster and feature are returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterIdentifier"`: The identifier of the cluster for which you want to describe usage
  limits.
- `"FeatureType"`: The feature type for which you want to describe usage limits.
- `"Marker"`: An optional parameter that specifies the starting point to return a set of
  response records. When the results of a DescribeUsageLimits request exceed the value
  specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the
  response. You can retrieve the next set of response records by providing the returned
  marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.  Default: 100  Constraints: minimum
  20, maximum 100.
- `"TagKeys"`: A tag key or keys for which you want to return all matching usage limit
  objects that are associated with the specified key or keys. For example, suppose that you
  have parameter groups that are tagged with keys called owner and environment. If you
  specify both of these tag keys in the request, Amazon Redshift returns a response with the
  usage limit objects have either or both of these tag keys associated with them.
- `"TagValues"`: A tag value or values for which you want to return all matching usage
  limit objects that are associated with the specified tag value or values. For example,
  suppose that you have parameter groups that are tagged with values called admin and test.
  If you specify both of these tag values in the request, Amazon Redshift returns a response
  with the usage limit objects that have either or both of these tag values associated with
  them.
- `"UsageLimitId"`: The identifier of the usage limit to describe.
"""
function describe_usage_limits(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "DescribeUsageLimits"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_usage_limits(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DescribeUsageLimits",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_logging(cluster_identifier)
    disable_logging(cluster_identifier, params::Dict{String,<:Any})

Stops logging information, such as queries and connection attempts, for the specified
Amazon Redshift cluster.

# Arguments
- `cluster_identifier`: The identifier of the cluster on which logging is to be stopped.
  Example: examplecluster

"""
function disable_logging(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DisableLogging",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_logging(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DisableLogging",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_snapshot_copy(cluster_identifier)
    disable_snapshot_copy(cluster_identifier, params::Dict{String,<:Any})

Disables the automatic copying of snapshots from one region to another region for a
specified cluster. If your cluster and its snapshots are encrypted using an encrypted
symmetric key from Key Management Service, use DeleteSnapshotCopyGrant to delete the grant
that grants Amazon Redshift permission to the key in the destination region.

# Arguments
- `cluster_identifier`: The unique identifier of the source cluster that you want to
  disable copying of snapshots to a destination region. Constraints: Must be the valid name
  of an existing cluster that has cross-region snapshot copy enabled.

"""
function disable_snapshot_copy(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DisableSnapshotCopy",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_snapshot_copy(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DisableSnapshotCopy",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_data_share_consumer(data_share_arn)
    disassociate_data_share_consumer(data_share_arn, params::Dict{String,<:Any})

From a datashare consumer account, remove association for the specified datashare.

# Arguments
- `data_share_arn`: The Amazon Resource Name (ARN) of the datashare to remove association
  for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConsumerArn"`: The Amazon Resource Name (ARN) of the consumer namespace that
  association for the datashare is removed from.
- `"ConsumerRegion"`: From a datashare consumer account, removes association of a datashare
  from all the existing and future namespaces in the specified Amazon Web Services Region.
- `"DisassociateEntireAccount"`: A value that specifies whether association for the
  datashare is removed from the entire account.
"""
function disassociate_data_share_consumer(
    DataShareArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "DisassociateDataShareConsumer",
        Dict{String,Any}("DataShareArn" => DataShareArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_data_share_consumer(
    DataShareArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "DisassociateDataShareConsumer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DataShareArn" => DataShareArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_logging(cluster_identifier)
    enable_logging(cluster_identifier, params::Dict{String,<:Any})

Starts logging information, such as queries and connection attempts, for the specified
Amazon Redshift cluster.

# Arguments
- `cluster_identifier`: The identifier of the cluster on which logging is to be started.
  Example: examplecluster

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BucketName"`: The name of an existing S3 bucket where the log files are to be stored.
  Constraints:   Must be in the same region as the cluster   The cluster must have read
  bucket and put object permissions
- `"LogDestinationType"`: The log destination type. An enum with possible values of s3 and
  cloudwatch.
- `"LogExports"`: The collection of exported log types. Possible values are connectionlog,
  useractivitylog, and userlog.
- `"S3KeyPrefix"`: The prefix applied to the log file names. Constraints:   Cannot exceed
  512 characters   Cannot contain spaces( ), double quotes (\"), single quotes ('), a
  backslash (), or control characters. The hexadecimal codes for invalid characters are:
  x00 to x20   x22   x27   x5c   x7f or larger
"""
function enable_logging(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "EnableLogging",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_logging(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "EnableLogging",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_snapshot_copy(cluster_identifier, destination_region)
    enable_snapshot_copy(cluster_identifier, destination_region, params::Dict{String,<:Any})

Enables the automatic copy of snapshots from one region to another region for a specified
cluster.

# Arguments
- `cluster_identifier`: The unique identifier of the source cluster to copy snapshots from.
  Constraints: Must be the valid name of an existing cluster that does not already have
  cross-region snapshot copy enabled.
- `destination_region`: The destination Amazon Web Services Region that you want to copy
  snapshots to. Constraints: Must be the name of a valid Amazon Web Services Region. For more
  information, see Regions and Endpoints in the Amazon Web Services General Reference.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ManualSnapshotRetentionPeriod"`: The number of days to retain newly copied snapshots in
  the destination Amazon Web Services Region after they are copied from the source Amazon Web
  Services Region. If the value is -1, the manual snapshot is retained indefinitely.  The
  value must be either -1 or an integer between 1 and 3,653.
- `"RetentionPeriod"`: The number of days to retain automated snapshots in the destination
  region after they are copied from the source region. Default: 7. Constraints: Must be at
  least 1 and no more than 35.
- `"SnapshotCopyGrantName"`: The name of the snapshot copy grant to use when snapshots of
  an Amazon Web Services KMS-encrypted cluster are copied to the destination region.
"""
function enable_snapshot_copy(
    ClusterIdentifier, DestinationRegion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "EnableSnapshotCopy",
        Dict{String,Any}(
            "ClusterIdentifier" => ClusterIdentifier,
            "DestinationRegion" => DestinationRegion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_snapshot_copy(
    ClusterIdentifier,
    DestinationRegion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "EnableSnapshotCopy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterIdentifier" => ClusterIdentifier,
                    "DestinationRegion" => DestinationRegion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    failover_primary_compute(cluster_identifier)
    failover_primary_compute(cluster_identifier, params::Dict{String,<:Any})

Fails over the primary compute unit of the specified Multi-AZ cluster to another
Availability Zone.

# Arguments
- `cluster_identifier`: The unique identifier of the cluster for which the primary compute
  unit will be failed over to another Availability Zone.

"""
function failover_primary_compute(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "FailoverPrimaryCompute",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function failover_primary_compute(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "FailoverPrimaryCompute",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_cluster_credentials(db_user)
    get_cluster_credentials(db_user, params::Dict{String,<:Any})

Returns a database user name and temporary password with temporary authorization to log on
to an Amazon Redshift database. The action returns the database user name prefixed with
IAM: if AutoCreate is False or IAMA: if AutoCreate is True. You can optionally specify one
or more database user groups that the user will join at log on. By default, the temporary
credentials expire in 900 seconds. You can optionally specify a duration between 900
seconds (15 minutes) and 3600 seconds (60 minutes). For more information, see Using IAM
Authentication to Generate Database User Credentials in the Amazon Redshift Cluster
Management Guide. The Identity and Access Management (IAM) user or role that runs
GetClusterCredentials must have an IAM policy attached that allows access to all necessary
actions and resources. For more information about permissions, see Resource Policies for
GetClusterCredentials in the Amazon Redshift Cluster Management Guide. If the DbGroups
parameter is specified, the IAM policy must allow the redshift:JoinGroup action with access
to the listed dbgroups.  In addition, if the AutoCreate parameter is set to True, then the
policy must include the redshift:CreateClusterUser permission. If the DbName parameter is
specified, the IAM policy must allow access to the resource dbname for the specified
database name.

# Arguments
- `db_user`: The name of a database user. If a user name matching DbUser exists in the
  database, the temporary user credentials have the same permissions as the existing user. If
  DbUser doesn't exist in the database and Autocreate is True, a new user is created using
  the value for DbUser with PUBLIC permissions. If a database user matching the value for
  DbUser doesn't exist and Autocreate is False, then the command succeeds but the connection
  attempt will fail because the user doesn't exist in the database. For more information, see
  CREATE USER in the Amazon Redshift Database Developer Guide.  Constraints:   Must be 1 to
  64 alphanumeric characters or hyphens. The user name can't be PUBLIC.   Must contain
  uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at symbol
  (@), or hyphen.   First character must be a letter.   Must not contain a colon ( : ) or
  slash ( / ).    Cannot be a reserved word. A list of reserved words can be found in
  Reserved Words in the Amazon Redshift Database Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AutoCreate"`: Create a database user with the name specified for the user named in
  DbUser if one does not exist.
- `"ClusterIdentifier"`: The unique identifier of the cluster that contains the database
  for which you are requesting credentials. This parameter is case sensitive.
- `"CustomDomainName"`: The custom domain name for the cluster credentials.
- `"DbGroups"`: A list of the names of existing database groups that the user named in
  DbUser will join for the current session, in addition to any group memberships for an
  existing user. If not specified, a new user is added only to PUBLIC. Database group name
  constraints   Must be 1 to 64 alphanumeric characters or hyphens   Must contain only
  lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.
   First character must be a letter.   Must not contain a colon ( : ) or slash ( / ).
  Cannot be a reserved word. A list of reserved words can be found in Reserved Words in the
  Amazon Redshift Database Developer Guide.
- `"DbName"`: The name of a database that DbUser is authorized to log on to. If DbName is
  not specified, DbUser can log on to any existing database. Constraints:   Must be 1 to 64
  alphanumeric characters or hyphens   Must contain uppercase or lowercase letters, numbers,
  underscore, plus sign, period (dot), at symbol (@), or hyphen.   First character must be a
  letter.   Must not contain a colon ( : ) or slash ( / ).    Cannot be a reserved word. A
  list of reserved words can be found in Reserved Words in the Amazon Redshift Database
  Developer Guide.
- `"DurationSeconds"`: The number of seconds until the returned temporary password expires.
  Constraint: minimum 900, maximum 3600. Default: 900
"""
function get_cluster_credentials(DbUser; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "GetClusterCredentials",
        Dict{String,Any}("DbUser" => DbUser);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_cluster_credentials(
    DbUser, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "GetClusterCredentials",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("DbUser" => DbUser), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_cluster_credentials_with_iam()
    get_cluster_credentials_with_iam(params::Dict{String,<:Any})

Returns a database user name and temporary password with temporary authorization to log in
to an Amazon Redshift database. The database user is mapped 1:1 to the source Identity and
Access Management (IAM) identity. For more information about IAM identities, see IAM
Identities (users, user groups, and roles) in the Amazon Web Services Identity and Access
Management User Guide. The Identity and Access Management (IAM) identity that runs this
operation must have an IAM policy attached that allows access to all necessary actions and
resources. For more information about permissions, see Using identity-based policies (IAM
policies) in the Amazon Redshift Cluster Management Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterIdentifier"`: The unique identifier of the cluster that contains the database
  for which you are requesting credentials.
- `"CustomDomainName"`: The custom domain name for the IAM message cluster credentials.
- `"DbName"`: The name of the database for which you are requesting credentials. If the
  database name is specified, the IAM policy must allow access to the resource dbname for the
  specified database name. If the database name is not specified, access to all databases is
  allowed.
- `"DurationSeconds"`: The number of seconds until the returned temporary password expires.
  Range: 900-3600. Default: 900.
"""
function get_cluster_credentials_with_iam(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "GetClusterCredentialsWithIAM";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_cluster_credentials_with_iam(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "GetClusterCredentialsWithIAM",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_reserved_node_exchange_configuration_options(action_type)
    get_reserved_node_exchange_configuration_options(action_type, params::Dict{String,<:Any})

Gets the configuration options for the reserved-node exchange. These options include
information about the source reserved node and target reserved node offering. Details
include the node type, the price, the node count, and the offering type.

# Arguments
- `action_type`: The action type of the reserved-node configuration. The action type can be
  an exchange initiated from either a snapshot or a resize.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterIdentifier"`: The identifier for the cluster that is the source for a
  reserved-node exchange.
- `"Marker"`: An optional pagination token provided by a previous
  GetReservedNodeExchangeConfigurationOptions request. If this parameter is specified, the
  response includes only records beyond the marker, up to the value specified by the
  MaxRecords parameter. You can retrieve the next set of response records by providing the
  returned marker value in the Marker parameter and retrying the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a Marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.
- `"SnapshotIdentifier"`: The identifier for the snapshot that is the source for the
  reserved-node exchange.
"""
function get_reserved_node_exchange_configuration_options(
    ActionType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "GetReservedNodeExchangeConfigurationOptions",
        Dict{String,Any}("ActionType" => ActionType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_reserved_node_exchange_configuration_options(
    ActionType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "GetReservedNodeExchangeConfigurationOptions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ActionType" => ActionType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_reserved_node_exchange_offerings(reserved_node_id)
    get_reserved_node_exchange_offerings(reserved_node_id, params::Dict{String,<:Any})

Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and
usage price of the given DC1 reserved node.

# Arguments
- `reserved_node_id`: A string representing the node identifier for the DC1 Reserved Node
  to be exchanged.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: A value that indicates the starting point for the next set of
  ReservedNodeOfferings.
- `"MaxRecords"`: An integer setting the maximum number of ReservedNodeOfferings to
  retrieve.
"""
function get_reserved_node_exchange_offerings(
    ReservedNodeId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "GetReservedNodeExchangeOfferings",
        Dict{String,Any}("ReservedNodeId" => ReservedNodeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_reserved_node_exchange_offerings(
    ReservedNodeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "GetReservedNodeExchangeOfferings",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ReservedNodeId" => ReservedNodeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_policy(resource_arn)
    get_resource_policy(resource_arn, params::Dict{String,<:Any})

Get the resource policy for a specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource of which its resource
  policy is fetched.

"""
function get_resource_policy(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "GetResourcePolicy",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_policy(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "GetResourcePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_recommendations()
    list_recommendations(params::Dict{String,<:Any})

List the Amazon Redshift Advisor recommendations for one or multiple Amazon Redshift
clusters in an Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterIdentifier"`: The unique identifier of the Amazon Redshift cluster for which the
  list of Advisor recommendations is returned. If the neither the cluster identifier and the
  cluster namespace ARN parameters are specified, then recommendations for all clusters in
  the account are returned.
- `"Marker"`: A value that indicates the starting point for the next set of response
  records in a subsequent request. If a value is returned in a response, you can retrieve the
  next set of records by providing this returned marker value in the Marker parameter and
  retrying the command. If the Marker field is empty, all response records have been
  retrieved for the request.
- `"MaxRecords"`: The maximum number of response records to return in each call. If the
  number of remaining response records exceeds the specified MaxRecords value, a value is
  returned in a marker field of the response. You can retrieve the next set of records by
  retrying the command with the returned marker value.
- `"NamespaceArn"`: The Amazon Redshift cluster namespace Amazon Resource Name (ARN) for
  which the list of Advisor recommendations is returned. If the neither the cluster
  identifier and the cluster namespace ARN parameters are specified, then recommendations for
  all clusters in the account are returned.
"""
function list_recommendations(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "ListRecommendations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_recommendations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ListRecommendations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_aqua_configuration(cluster_identifier)
    modify_aqua_configuration(cluster_identifier, params::Dict{String,<:Any})

This operation is retired. Calling this operation does not change AQUA configuration.
Amazon Redshift automatically determines whether to use AQUA (Advanced Query Accelerator).

# Arguments
- `cluster_identifier`: The identifier of the cluster to be modified.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AquaConfigurationStatus"`: This parameter is retired. Amazon Redshift automatically
  determines whether to use AQUA (Advanced Query Accelerator).
"""
function modify_aqua_configuration(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyAquaConfiguration",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_aqua_configuration(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyAquaConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_authentication_profile(authentication_profile_content, authentication_profile_name)
    modify_authentication_profile(authentication_profile_content, authentication_profile_name, params::Dict{String,<:Any})

Modifies an authentication profile.

# Arguments
- `authentication_profile_content`: The new content of the authentication profile in JSON
  format. The maximum length of the JSON string is determined by a quota for your account.
- `authentication_profile_name`: The name of the authentication profile to replace.

"""
function modify_authentication_profile(
    AuthenticationProfileContent,
    AuthenticationProfileName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyAuthenticationProfile",
        Dict{String,Any}(
            "AuthenticationProfileContent" => AuthenticationProfileContent,
            "AuthenticationProfileName" => AuthenticationProfileName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_authentication_profile(
    AuthenticationProfileContent,
    AuthenticationProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyAuthenticationProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthenticationProfileContent" => AuthenticationProfileContent,
                    "AuthenticationProfileName" => AuthenticationProfileName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_cluster(cluster_identifier)
    modify_cluster(cluster_identifier, params::Dict{String,<:Any})

Modifies the settings for a cluster. You can also change node type and the number of nodes
to scale up or down the cluster. When resizing a cluster, you must specify both the number
of nodes and the node type even if one of the parameters does not change. You can add
another security or parameter group, or change the admin user password. Resetting a cluster
password or modifying the security groups associated with a cluster do not need a reboot.
However, modifying a parameter group requires a reboot for parameters to take effect. For
more information about managing clusters, go to Amazon Redshift Clusters in the Amazon
Redshift Cluster Management Guide.

# Arguments
- `cluster_identifier`: The unique identifier of the cluster to be modified. Example:
  examplecluster

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowVersionUpgrade"`: If true, major version upgrades will be applied automatically to
  the cluster during the maintenance window.  Default: false
- `"AutomatedSnapshotRetentionPeriod"`: The number of days that automated snapshots are
  retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots
  are disabled, you can still create manual snapshots when you want with
  CreateClusterSnapshot.  If you decrease the automated snapshot retention period from its
  current value, existing automated snapshots that fall outside of the new retention period
  will be immediately deleted. You can't disable automated snapshots for RA3 node types. Set
  the automated retention period from 1-35 days. Default: Uses existing setting. Constraints:
  Must be a value from 0 to 35.
- `"AvailabilityZone"`: The option to initiate relocation for an Amazon Redshift cluster to
  the target Availability Zone.
- `"AvailabilityZoneRelocation"`: The option to enable relocation for an Amazon Redshift
  cluster between Availability Zones after the cluster modification is complete.
- `"ClusterParameterGroupName"`: The name of the cluster parameter group to apply to this
  cluster. This change is applied only after the cluster is rebooted. To reboot a cluster use
  RebootCluster.  Default: Uses existing setting. Constraints: The cluster parameter group
  must be in the same parameter group family that matches the cluster version.
- `"ClusterSecurityGroups"`: A list of cluster security groups to be authorized on this
  cluster. This change is asynchronously applied as soon as possible. Security groups
  currently associated with the cluster, and not in the list of groups to apply, will be
  revoked from the cluster. Constraints:   Must be 1 to 255 alphanumeric characters or
  hyphens   First character must be a letter   Cannot end with a hyphen or contain two
  consecutive hyphens
- `"ClusterType"`: The new cluster type. When you submit your cluster resize request, your
  existing cluster goes into a read-only mode. After Amazon Redshift provisions a new cluster
  based on your resize requirements, there will be outage for a period while the old cluster
  is deleted and your connection is switched to the new cluster. You can use DescribeResize
  to track the progress of the resize request.  Valid Values:  multi-node | single-node
- `"ClusterVersion"`: The new version number of the Amazon Redshift engine to upgrade to.
  For major version upgrades, if a non-default cluster parameter group is currently in use, a
  new cluster parameter group in the cluster parameter group family for the new version must
  be specified. The new cluster parameter group can be the default for that cluster parameter
  group family. For more information about parameters and parameter groups, go to Amazon
  Redshift Parameter Groups in the Amazon Redshift Cluster Management Guide. Example: 1.0
- `"ElasticIp"`: The Elastic IP (EIP) address for the cluster. Constraints: The cluster
  must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For
  more information about provisioning clusters in EC2-VPC, go to Supported Platforms to
  Launch Your Cluster in the Amazon Redshift Cluster Management Guide.
- `"Encrypted"`: Indicates whether the cluster is encrypted. If the value is encrypted
  (true) and you provide a value for the KmsKeyId parameter, we encrypt the cluster with the
  provided KmsKeyId. If you don't provide a KmsKeyId, we encrypt with the default key.  If
  the value is not encrypted (false), then the cluster is decrypted.
- `"EnhancedVpcRouting"`: An option that specifies whether to create the cluster with
  enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the
  cluster must be in a VPC. For more information, see Enhanced VPC Routing in the Amazon
  Redshift Cluster Management Guide. If this option is true, enhanced VPC routing is enabled.
   Default: false
- `"HsmClientCertificateIdentifier"`: Specifies the name of the HSM client certificate the
  Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
- `"HsmConfigurationIdentifier"`: Specifies the name of the HSM configuration that contains
  the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
- `"IpAddressType"`: The IP address types that the cluster supports. Possible values are
  ipv4 and dualstack.
- `"KmsKeyId"`: The Key Management Service (KMS) key ID of the encryption key that you want
  to use to encrypt data in the cluster.
- `"MaintenanceTrackName"`: The name for the maintenance track that you want to assign for
  the cluster. This name change is asynchronous. The new track name stays in the
  PendingModifiedValues for the cluster until the next maintenance window. When the
  maintenance track changes, the cluster is switched to the latest cluster release available
  for the maintenance track. At this point, the maintenance track name is applied.
- `"ManageMasterPassword"`: If true, Amazon Redshift uses Secrets Manager to manage this
  cluster's admin credentials. You can't use MasterUserPassword if ManageMasterPassword is
  true. If ManageMasterPassword is false or not set, Amazon Redshift uses MasterUserPassword
  for the admin user account's password.
- `"ManualSnapshotRetentionPeriod"`: The default for number of days that a newly created
  manual snapshot is retained. If the value is -1, the manual snapshot is retained
  indefinitely. This value doesn't retroactively change the retention periods of existing
  manual snapshots. The value must be either -1 or an integer between 1 and 3,653. The
  default value is -1.
- `"MasterPasswordSecretKmsKeyId"`: The ID of the Key Management Service (KMS) key used to
  encrypt and store the cluster's admin credentials secret. You can only use this parameter
  if ManageMasterPassword is true.
- `"MasterUserPassword"`: The new password for the cluster admin user. This change is
  asynchronously applied as soon as possible. Between the time of the request and the
  completion of the request, the MasterUserPassword element exists in the
  PendingModifiedValues element of the operation response.  You can't use MasterUserPassword
  if ManageMasterPassword is true.  Operations never return the password, so this operation
  provides a way to regain access to the admin user account for a cluster if the password is
  lost.  Default: Uses existing setting. Constraints:   Must be between 8 and 64 characters
  in length.   Must contain at least one uppercase letter.   Must contain at least one
  lowercase letter.   Must contain one number.   Can be any printable ASCII character (ASCII
  code 33-126) except ' (single quote), \" (double quote), , /, or @.
- `"MultiAZ"`: If true and the cluster is currently only deployed in a single Availability
  Zone, the cluster will be modified to be deployed in two Availability Zones.
- `"NewClusterIdentifier"`: The new identifier for the cluster. Constraints:   Must contain
  from 1 to 63 alphanumeric characters or hyphens.   Alphabetic characters must be lowercase.
    First character must be a letter.   Cannot end with a hyphen or contain two consecutive
  hyphens.   Must be unique for all clusters within an Amazon Web Services account.
  Example: examplecluster
- `"NodeType"`: The new node type of the cluster. If you specify a new node type, you must
  also specify the number of nodes parameter.  For more information about resizing clusters,
  go to Resizing Clusters in Amazon Redshift in the Amazon Redshift Cluster Management Guide.
  Valid Values: dc2.large | dc2.8xlarge | ra3.xlplus | ra3.4xlarge | ra3.16xlarge
- `"NumberOfNodes"`: The new number of nodes of the cluster. If you specify a new number of
  nodes, you must also specify the node type parameter.  For more information about resizing
  clusters, go to Resizing Clusters in Amazon Redshift in the Amazon Redshift Cluster
  Management Guide. Valid Values: Integer greater than 0.
- `"Port"`: The option to change the port of an Amazon Redshift cluster. Valid Values:
  For clusters with ra3 nodes - Select a port within the ranges 5431-5455 or 8191-8215. (If
  you have an existing cluster with ra3 nodes, it isn't required that you change the port to
  these ranges.)   For clusters with dc2 nodes - Select a port within the range 1150-65535.
- `"PreferredMaintenanceWindow"`: The weekly time range (in UTC) during which system
  maintenance can occur, if necessary. If system maintenance is necessary during the window,
  it may result in an outage. This maintenance window change is made immediately. If the new
  maintenance window indicates the current time, there must be at least 120 minutes between
  the current time and end of the window in order to ensure that pending changes are applied.
  Default: Uses existing setting. Format: ddd:hh24:mi-ddd:hh24:mi, for example
  wed:07:30-wed:08:00. Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun Constraints: Must
  be at least 30 minutes.
- `"PubliclyAccessible"`: If true, the cluster can be accessed from a public network. Only
  clusters in VPCs can be set to be publicly available.
- `"VpcSecurityGroupIds"`: A list of virtual private cloud (VPC) security groups to be
  associated with the cluster. This change is asynchronously applied as soon as possible.
"""
function modify_cluster(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyCluster",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_cluster(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyCluster",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_cluster_db_revision(cluster_identifier, revision_target)
    modify_cluster_db_revision(cluster_identifier, revision_target, params::Dict{String,<:Any})

Modifies the database revision of a cluster. The database revision is a unique revision of
the database running in a cluster.

# Arguments
- `cluster_identifier`: The unique identifier of a cluster whose database revision you want
  to modify.  Example: examplecluster
- `revision_target`: The identifier of the database revision. You can retrieve this value
  from the response to the DescribeClusterDbRevisions request.

"""
function modify_cluster_db_revision(
    ClusterIdentifier, RevisionTarget; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyClusterDbRevision",
        Dict{String,Any}(
            "ClusterIdentifier" => ClusterIdentifier, "RevisionTarget" => RevisionTarget
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_cluster_db_revision(
    ClusterIdentifier,
    RevisionTarget,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyClusterDbRevision",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterIdentifier" => ClusterIdentifier,
                    "RevisionTarget" => RevisionTarget,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_cluster_iam_roles(cluster_identifier)
    modify_cluster_iam_roles(cluster_identifier, params::Dict{String,<:Any})

Modifies the list of Identity and Access Management (IAM) roles that can be used by the
cluster to access other Amazon Web Services services. The maximum number of IAM roles that
you can associate is subject to a quota. For more information, go to Quotas and limits in
the Amazon Redshift Cluster Management Guide.

# Arguments
- `cluster_identifier`: The unique identifier of the cluster for which you want to
  associate or disassociate IAM roles.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AddIamRoles"`: Zero or more IAM roles to associate with the cluster. The roles must be
  in their Amazon Resource Name (ARN) format.
- `"DefaultIamRoleArn"`: The Amazon Resource Name (ARN) for the IAM role that was set as
  default for the cluster when the cluster was last modified.
- `"RemoveIamRoles"`: Zero or more IAM roles in ARN format to disassociate from the
  cluster.
"""
function modify_cluster_iam_roles(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyClusterIamRoles",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_cluster_iam_roles(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyClusterIamRoles",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_cluster_maintenance(cluster_identifier)
    modify_cluster_maintenance(cluster_identifier, params::Dict{String,<:Any})

Modifies the maintenance settings of a cluster.

# Arguments
- `cluster_identifier`: A unique identifier for the cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeferMaintenance"`: A boolean indicating whether to enable the deferred maintenance
  window.
- `"DeferMaintenanceDuration"`: An integer indicating the duration of the maintenance
  window in days. If you specify a duration, you can't specify an end time. The duration must
  be 45 days or less.
- `"DeferMaintenanceEndTime"`: A timestamp indicating end time for the deferred maintenance
  window. If you specify an end time, you can't specify a duration.
- `"DeferMaintenanceIdentifier"`: A unique identifier for the deferred maintenance window.
- `"DeferMaintenanceStartTime"`: A timestamp indicating the start time for the deferred
  maintenance window.
"""
function modify_cluster_maintenance(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyClusterMaintenance",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_cluster_maintenance(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyClusterMaintenance",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_cluster_parameter_group(parameter, parameter_group_name)
    modify_cluster_parameter_group(parameter, parameter_group_name, params::Dict{String,<:Any})

Modifies the parameters of a parameter group. For the parameters parameter, it can't
contain ASCII characters.  For more information about parameters and parameter groups, go
to Amazon Redshift Parameter Groups in the Amazon Redshift Cluster Management Guide.

# Arguments
- `parameter`: An array of parameters to be modified. A maximum of 20 parameters can be
  modified in a single request. For each parameter to be modified, you must supply at least
  the parameter name and parameter value; other name-value pairs of the parameter are
  optional. For the workload management (WLM) configuration, you must supply all the
  name-value pairs in the wlm_json_configuration parameter.
- `parameter_group_name`: The name of the parameter group to be modified.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Parameters"`: An array of parameters to be modified. A maximum of 20 parameters can be
  modified in a single request. For each parameter to be modified, you must supply at least
  the parameter name and parameter value; other name-value pairs of the parameter are
  optional. For the workload management (WLM) configuration, you must supply all the
  name-value pairs in the wlm_json_configuration parameter.
"""
function modify_cluster_parameter_group(
    Parameter, ParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyClusterParameterGroup",
        Dict{String,Any}(
            "Parameter" => Parameter, "ParameterGroupName" => ParameterGroupName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_cluster_parameter_group(
    Parameter,
    ParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyClusterParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Parameter" => Parameter, "ParameterGroupName" => ParameterGroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_cluster_snapshot(snapshot_identifier)
    modify_cluster_snapshot(snapshot_identifier, params::Dict{String,<:Any})

Modifies the settings for a snapshot. This exanmple modifies the manual retention period
setting for a cluster snapshot.

# Arguments
- `snapshot_identifier`: The identifier of the snapshot whose setting you want to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Force"`: A Boolean option to override an exception if the retention period has already
  passed.
- `"ManualSnapshotRetentionPeriod"`: The number of days that a manual snapshot is retained.
  If the value is -1, the manual snapshot is retained indefinitely. If the manual snapshot
  falls outside of the new retention period, you can specify the force option to immediately
  delete the snapshot. The value must be either -1 or an integer between 1 and 3,653.
"""
function modify_cluster_snapshot(
    SnapshotIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyClusterSnapshot",
        Dict{String,Any}("SnapshotIdentifier" => SnapshotIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_cluster_snapshot(
    SnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyClusterSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SnapshotIdentifier" => SnapshotIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_cluster_snapshot_schedule(cluster_identifier)
    modify_cluster_snapshot_schedule(cluster_identifier, params::Dict{String,<:Any})

Modifies a snapshot schedule for a cluster.

# Arguments
- `cluster_identifier`: A unique identifier for the cluster whose snapshot schedule you
  want to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DisassociateSchedule"`: A boolean to indicate whether to remove the assoiciation
  between the cluster and the schedule.
- `"ScheduleIdentifier"`: A unique alphanumeric identifier for the schedule that you want
  to associate with the cluster.
"""
function modify_cluster_snapshot_schedule(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyClusterSnapshotSchedule",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_cluster_snapshot_schedule(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyClusterSnapshotSchedule",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_cluster_subnet_group(cluster_subnet_group_name, subnet_identifier)
    modify_cluster_subnet_group(cluster_subnet_group_name, subnet_identifier, params::Dict{String,<:Any})

Modifies a cluster subnet group to include the specified list of VPC subnets. The operation
replaces the existing list of subnets with the new list of subnets.

# Arguments
- `cluster_subnet_group_name`: The name of the subnet group to be modified.
- `subnet_identifier`: An array of VPC subnet IDs. A maximum of 20 subnets can be modified
  in a single request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A text description of the subnet group to be modified.
- `"SubnetIds"`: An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a
  single request.
"""
function modify_cluster_subnet_group(
    ClusterSubnetGroupName,
    SubnetIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyClusterSubnetGroup",
        Dict{String,Any}(
            "ClusterSubnetGroupName" => ClusterSubnetGroupName,
            "SubnetIdentifier" => SubnetIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_cluster_subnet_group(
    ClusterSubnetGroupName,
    SubnetIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyClusterSubnetGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterSubnetGroupName" => ClusterSubnetGroupName,
                    "SubnetIdentifier" => SubnetIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_custom_domain_association(cluster_identifier, custom_domain_certificate_arn, custom_domain_name)
    modify_custom_domain_association(cluster_identifier, custom_domain_certificate_arn, custom_domain_name, params::Dict{String,<:Any})

Contains information for changing a custom domain association.

# Arguments
- `cluster_identifier`: The identifier of the cluster to change a custom domain association
  for.
- `custom_domain_certificate_arn`: The certificate Amazon Resource Name (ARN) for the
  changed custom domain association.
- `custom_domain_name`: The custom domain name for a changed custom domain association.

"""
function modify_custom_domain_association(
    ClusterIdentifier,
    CustomDomainCertificateArn,
    CustomDomainName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyCustomDomainAssociation",
        Dict{String,Any}(
            "ClusterIdentifier" => ClusterIdentifier,
            "CustomDomainCertificateArn" => CustomDomainCertificateArn,
            "CustomDomainName" => CustomDomainName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_custom_domain_association(
    ClusterIdentifier,
    CustomDomainCertificateArn,
    CustomDomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyCustomDomainAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterIdentifier" => ClusterIdentifier,
                    "CustomDomainCertificateArn" => CustomDomainCertificateArn,
                    "CustomDomainName" => CustomDomainName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_endpoint_access(endpoint_name)
    modify_endpoint_access(endpoint_name, params::Dict{String,<:Any})

Modifies a Redshift-managed VPC endpoint.

# Arguments
- `endpoint_name`: The endpoint to be modified.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"VpcSecurityGroupIds"`: The complete list of VPC security groups associated with the
  endpoint after the endpoint is modified.
"""
function modify_endpoint_access(
    EndpointName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyEndpointAccess",
        Dict{String,Any}("EndpointName" => EndpointName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_endpoint_access(
    EndpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyEndpointAccess",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EndpointName" => EndpointName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_event_subscription(subscription_name)
    modify_event_subscription(subscription_name, params::Dict{String,<:Any})

Modifies an existing Amazon Redshift event notification subscription.

# Arguments
- `subscription_name`: The name of the modified Amazon Redshift event notification
  subscription.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Enabled"`: A Boolean value indicating if the subscription is enabled. true indicates
  the subscription is enabled
- `"EventCategories"`: Specifies the Amazon Redshift event categories to be published by
  the event notification subscription. Values: configuration, management, monitoring,
  security, pending
- `"Severity"`: Specifies the Amazon Redshift event severity to be published by the event
  notification subscription. Values: ERROR, INFO
- `"SnsTopicArn"`: The Amazon Resource Name (ARN) of the SNS topic to be used by the event
  notification subscription.
- `"SourceIds"`: A list of one or more identifiers of Amazon Redshift source objects. All
  of the objects must be of the same type as was specified in the source type parameter. The
  event subscription will return only events generated by the specified objects. If not
  specified, then events are returned for all objects within the source type specified.
  Example: my-cluster-1, my-cluster-2 Example: my-snapshot-20131010
- `"SourceType"`: The type of source that will be generating the events. For example, if
  you want to be notified of events generated by a cluster, you would set this parameter to
  cluster. If this value is not specified, events are returned for all Amazon Redshift
  objects in your Amazon Web Services account. You must specify a source type in order to
  specify source IDs. Valid values: cluster, cluster-parameter-group, cluster-security-group,
  cluster-snapshot, and scheduled-action.
"""
function modify_event_subscription(
    SubscriptionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyEventSubscription",
        Dict{String,Any}("SubscriptionName" => SubscriptionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_event_subscription(
    SubscriptionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyEventSubscription",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SubscriptionName" => SubscriptionName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_redshift_idc_application(redshift_idc_application_arn)
    modify_redshift_idc_application(redshift_idc_application_arn, params::Dict{String,<:Any})

Changes an existing Amazon Redshift IAM Identity Center application.

# Arguments
- `redshift_idc_application_arn`: The ARN for the Redshift application that integrates with
  IAM Identity Center.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuthorizedTokenIssuerList"`: The authorized token issuer list for the Amazon Redshift
  IAM Identity Center application to change.
- `"IamRoleArn"`: The IAM role ARN associated with the Amazon Redshift IAM Identity Center
  application to change. It has the required permissions to be assumed and invoke the IDC
  Identity Center API.
- `"IdcDisplayName"`: The display name for the Amazon Redshift IAM Identity Center
  application to change. It appears on the console.
- `"IdentityNamespace"`: The namespace for the Amazon Redshift IAM Identity Center
  application to change. It determines which managed application verifies the connection
  token.
- `"ServiceIntegrations"`: A collection of service integrations associated with the
  application.
"""
function modify_redshift_idc_application(
    RedshiftIdcApplicationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyRedshiftIdcApplication",
        Dict{String,Any}("RedshiftIdcApplicationArn" => RedshiftIdcApplicationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_redshift_idc_application(
    RedshiftIdcApplicationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyRedshiftIdcApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RedshiftIdcApplicationArn" => RedshiftIdcApplicationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_scheduled_action(scheduled_action_name)
    modify_scheduled_action(scheduled_action_name, params::Dict{String,<:Any})

Modifies a scheduled action.

# Arguments
- `scheduled_action_name`: The name of the scheduled action to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Enable"`: A modified enable flag of the scheduled action. If true, the scheduled action
  is active. If false, the scheduled action is disabled.
- `"EndTime"`: A modified end time of the scheduled action. For more information about this
  parameter, see ScheduledAction.
- `"IamRole"`: A different IAM role to assume to run the target action. For more
  information about this parameter, see ScheduledAction.
- `"Schedule"`: A modified schedule in either at( ) or cron( ) format. For more information
  about this parameter, see ScheduledAction.
- `"ScheduledActionDescription"`: A modified description of the scheduled action.
- `"StartTime"`: A modified start time of the scheduled action. For more information about
  this parameter, see ScheduledAction.
- `"TargetAction"`: A modified JSON format of the scheduled action. For more information
  about this parameter, see ScheduledAction.
"""
function modify_scheduled_action(
    ScheduledActionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyScheduledAction",
        Dict{String,Any}("ScheduledActionName" => ScheduledActionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_scheduled_action(
    ScheduledActionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyScheduledAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ScheduledActionName" => ScheduledActionName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_snapshot_copy_retention_period(cluster_identifier, retention_period)
    modify_snapshot_copy_retention_period(cluster_identifier, retention_period, params::Dict{String,<:Any})

Modifies the number of days to retain snapshots in the destination Amazon Web Services
Region after they are copied from the source Amazon Web Services Region. By default, this
operation only changes the retention period of copied automated snapshots. The retention
periods for both new and existing copied automated snapshots are updated with the new
retention period. You can set the manual option to change only the retention periods of
copied manual snapshots. If you set this option, only newly copied manual snapshots have
the new retention period.

# Arguments
- `cluster_identifier`: The unique identifier of the cluster for which you want to change
  the retention period for either automated or manual snapshots that are copied to a
  destination Amazon Web Services Region. Constraints: Must be the valid name of an existing
  cluster that has cross-region snapshot copy enabled.
- `retention_period`: The number of days to retain automated snapshots in the destination
  Amazon Web Services Region after they are copied from the source Amazon Web Services
  Region. By default, this only changes the retention period of copied automated snapshots.
  If you decrease the retention period for automated snapshots that are copied to a
  destination Amazon Web Services Region, Amazon Redshift deletes any existing automated
  snapshots that were copied to the destination Amazon Web Services Region and that fall
  outside of the new retention period. Constraints: Must be at least 1 and no more than 35
  for automated snapshots.  If you specify the manual option, only newly copied manual
  snapshots will have the new retention period.  If you specify the value of -1 newly copied
  manual snapshots are retained indefinitely. Constraints: The number of days must be either
  -1 or an integer between 1 and 3,653 for manual snapshots.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Manual"`: Indicates whether to apply the snapshot retention period to newly copied
  manual snapshots instead of automated snapshots.
"""
function modify_snapshot_copy_retention_period(
    ClusterIdentifier, RetentionPeriod; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifySnapshotCopyRetentionPeriod",
        Dict{String,Any}(
            "ClusterIdentifier" => ClusterIdentifier, "RetentionPeriod" => RetentionPeriod
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_snapshot_copy_retention_period(
    ClusterIdentifier,
    RetentionPeriod,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifySnapshotCopyRetentionPeriod",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterIdentifier" => ClusterIdentifier,
                    "RetentionPeriod" => RetentionPeriod,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_snapshot_schedule(schedule_definition, schedule_identifier)
    modify_snapshot_schedule(schedule_definition, schedule_identifier, params::Dict{String,<:Any})

Modifies a snapshot schedule. Any schedule associated with a cluster is modified
asynchronously.

# Arguments
- `schedule_definition`: An updated list of schedule definitions. A schedule definition is
  made up of schedule expressions, for example, \"cron(30 12 *)\" or \"rate(12 hours)\".
- `schedule_identifier`: A unique alphanumeric identifier of the schedule to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ScheduleDefinitions"`: An updated list of schedule definitions. A schedule definition
  is made up of schedule expressions, for example, \"cron(30 12 *)\" or \"rate(12 hours)\".
"""
function modify_snapshot_schedule(
    ScheduleDefinition,
    ScheduleIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifySnapshotSchedule",
        Dict{String,Any}(
            "ScheduleDefinition" => ScheduleDefinition,
            "ScheduleIdentifier" => ScheduleIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_snapshot_schedule(
    ScheduleDefinition,
    ScheduleIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifySnapshotSchedule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ScheduleDefinition" => ScheduleDefinition,
                    "ScheduleIdentifier" => ScheduleIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_usage_limit(usage_limit_id)
    modify_usage_limit(usage_limit_id, params::Dict{String,<:Any})

Modifies a usage limit in a cluster. You can't modify the feature type or period of a usage
limit.

# Arguments
- `usage_limit_id`: The identifier of the usage limit to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Amount"`: The new limit amount. For more information about this parameter, see
  UsageLimit.
- `"BreachAction"`: The new action that Amazon Redshift takes when the limit is reached.
  For more information about this parameter, see UsageLimit.
"""
function modify_usage_limit(
    UsageLimitId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ModifyUsageLimit",
        Dict{String,Any}("UsageLimitId" => UsageLimitId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_usage_limit(
    UsageLimitId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ModifyUsageLimit",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UsageLimitId" => UsageLimitId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    pause_cluster(cluster_identifier)
    pause_cluster(cluster_identifier, params::Dict{String,<:Any})

Pauses a cluster.

# Arguments
- `cluster_identifier`: The identifier of the cluster to be paused.

"""
function pause_cluster(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "PauseCluster",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function pause_cluster(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "PauseCluster",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    purchase_reserved_node_offering(reserved_node_offering_id)
    purchase_reserved_node_offering(reserved_node_offering_id, params::Dict{String,<:Any})

Allows you to purchase reserved nodes. Amazon Redshift offers a predefined set of reserved
node offerings. You can purchase one or more of the offerings. You can call the
DescribeReservedNodeOfferings API to obtain the available reserved node offerings. You can
call this API by providing a specific reserved node offering and the number of nodes you
want to reserve.   For more information about reserved node offerings, go to Purchasing
Reserved Nodes in the Amazon Redshift Cluster Management Guide.

# Arguments
- `reserved_node_offering_id`: The unique identifier of the reserved node offering you want
  to purchase.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NodeCount"`: The number of reserved nodes that you want to purchase. Default: 1
"""
function purchase_reserved_node_offering(
    ReservedNodeOfferingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "PurchaseReservedNodeOffering",
        Dict{String,Any}("ReservedNodeOfferingId" => ReservedNodeOfferingId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function purchase_reserved_node_offering(
    ReservedNodeOfferingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "PurchaseReservedNodeOffering",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ReservedNodeOfferingId" => ReservedNodeOfferingId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_policy(policy, resource_arn)
    put_resource_policy(policy, resource_arn, params::Dict{String,<:Any})

Updates the resource policy for a specified resource.

# Arguments
- `policy`: The content of the resource policy being updated.
- `resource_arn`: The Amazon Resource Name (ARN) of the resource of which its resource
  policy is updated.

"""
function put_resource_policy(
    Policy, ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "PutResourcePolicy",
        Dict{String,Any}("Policy" => Policy, "ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_policy(
    Policy,
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "PutResourcePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Policy" => Policy, "ResourceArn" => ResourceArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reboot_cluster(cluster_identifier)
    reboot_cluster(cluster_identifier, params::Dict{String,<:Any})

Reboots a cluster. This action is taken as soon as possible. It results in a momentary
outage to the cluster, during which the cluster status is set to rebooting. A cluster event
is created when the reboot is completed. Any pending cluster modifications (see
ModifyCluster) are applied at this reboot. For more information about managing clusters, go
to Amazon Redshift Clusters in the Amazon Redshift Cluster Management Guide.

# Arguments
- `cluster_identifier`: The cluster identifier.

"""
function reboot_cluster(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "RebootCluster",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reboot_cluster(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "RebootCluster",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reject_data_share(data_share_arn)
    reject_data_share(data_share_arn, params::Dict{String,<:Any})

From a datashare consumer account, rejects the specified datashare.

# Arguments
- `data_share_arn`: The Amazon Resource Name (ARN) of the datashare to reject.

"""
function reject_data_share(DataShareArn; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "RejectDataShare",
        Dict{String,Any}("DataShareArn" => DataShareArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reject_data_share(
    DataShareArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "RejectDataShare",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DataShareArn" => DataShareArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_cluster_parameter_group(parameter_group_name)
    reset_cluster_parameter_group(parameter_group_name, params::Dict{String,<:Any})

Sets one or more parameters of the specified parameter group to their default values and
sets the source values of the parameters to \"engine-default\". To reset the entire
parameter group specify the ResetAllParameters parameter. For parameter changes to take
effect you must reboot any associated clusters.

# Arguments
- `parameter_group_name`: The name of the cluster parameter group to be reset.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Parameters"`: An array of names of parameters to be reset. If ResetAllParameters option
  is not used, then at least one parameter name must be supplied.  Constraints: A maximum of
  20 parameters can be reset in a single request.
- `"ResetAllParameters"`: If true, all parameters in the specified parameter group will be
  reset to their default values.  Default: true
"""
function reset_cluster_parameter_group(
    ParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ResetClusterParameterGroup",
        Dict{String,Any}("ParameterGroupName" => ParameterGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reset_cluster_parameter_group(
    ParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ResetClusterParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ParameterGroupName" => ParameterGroupName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    resize_cluster(cluster_identifier)
    resize_cluster(cluster_identifier, params::Dict{String,<:Any})

Changes the size of the cluster. You can change the cluster's type, or change the number or
type of nodes. The default behavior is to use the elastic resize method. With an elastic
resize, your cluster is available for read and write operations more quickly than with the
classic resize method.  Elastic resize operations have the following restrictions:   You
can only resize clusters of the following types:   dc2.large   dc2.8xlarge   ra3.xlplus
ra3.4xlarge   ra3.16xlarge     The type of nodes that you add must match the node type for
the cluster.

# Arguments
- `cluster_identifier`: The unique identifier for the cluster to resize.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Classic"`: A boolean value indicating whether the resize operation is using the classic
  resize process. If you don't provide this parameter or set the value to false, the resize
  type is elastic.
- `"ClusterType"`: The new cluster type for the specified cluster.
- `"NodeType"`: The new node type for the nodes you are adding. If not specified, the
  cluster's current node type is used.
- `"NumberOfNodes"`: The new number of nodes for the cluster. If not specified, the
  cluster's current number of nodes is used.
- `"ReservedNodeId"`: The identifier of the reserved node.
- `"TargetReservedNodeOfferingId"`: The identifier of the target reserved node offering.
"""
function resize_cluster(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ResizeCluster",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function resize_cluster(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ResizeCluster",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_from_cluster_snapshot(cluster_identifier)
    restore_from_cluster_snapshot(cluster_identifier, params::Dict{String,<:Any})

Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting
cluster with the same configuration as the original cluster from which the snapshot was
created, except that the new cluster is created with the default cluster security and
parameter groups. After Amazon Redshift creates the cluster, you can use the ModifyCluster
API to associate a different security group and different parameter group with the restored
cluster. If you are using a DS node type, you can also choose to change to another DS node
type of the same size during restore. If you restore a cluster into a VPC, you must provide
a cluster subnet group where you want the cluster restored.  For more information about
working with snapshots, go to Amazon Redshift Snapshots in the Amazon Redshift Cluster
Management Guide.

# Arguments
- `cluster_identifier`: The identifier of the cluster that will be created from restoring
  the snapshot. Constraints:   Must contain from 1 to 63 alphanumeric characters or hyphens.
   Alphabetic characters must be lowercase.   First character must be a letter.   Cannot end
  with a hyphen or contain two consecutive hyphens.   Must be unique for all clusters within
  an Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AdditionalInfo"`: Reserved.
- `"AllowVersionUpgrade"`: If true, major version upgrades can be applied during the
  maintenance window to the Amazon Redshift engine that is running on the cluster.  Default:
  true
- `"AquaConfigurationStatus"`: This parameter is retired. It does not set the AQUA
  configuration status. Amazon Redshift automatically determines whether to use AQUA
  (Advanced Query Accelerator).
- `"AutomatedSnapshotRetentionPeriod"`: The number of days that automated snapshots are
  retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots
  are disabled, you can still create manual snapshots when you want with
  CreateClusterSnapshot.  You can't disable automated snapshots for RA3 node types. Set the
  automated retention period from 1-35 days. Default: The value selected for the cluster from
  which the snapshot was taken. Constraints: Must be a value from 0 to 35.
- `"AvailabilityZone"`: The Amazon EC2 Availability Zone in which to restore the cluster.
  Default: A random, system-chosen Availability Zone. Example: us-east-2a
- `"AvailabilityZoneRelocation"`: The option to enable relocation for an Amazon Redshift
  cluster between Availability Zones after the cluster is restored.
- `"ClusterParameterGroupName"`: The name of the parameter group to be associated with this
  cluster. Default: The default Amazon Redshift cluster parameter group. For information
  about the default parameter group, go to Working with Amazon Redshift Parameter Groups.
  Constraints:   Must be 1 to 255 alphanumeric characters or hyphens.   First character must
  be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.
- `"ClusterSecurityGroups"`: A list of security groups to be associated with this cluster.
  Default: The default cluster security group for Amazon Redshift. Cluster security groups
  only apply to clusters outside of VPCs.
- `"ClusterSubnetGroupName"`: The name of the subnet group where you want to cluster
  restored. A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must
  provide subnet group name where you want the cluster restored.
- `"DefaultIamRoleArn"`: The Amazon Resource Name (ARN) for the IAM role that was set as
  default for the cluster when the cluster was last modified while it was restored from a
  snapshot.
- `"ElasticIp"`: The Elastic IP (EIP) address for the cluster. Don't specify the Elastic IP
  address for a publicly accessible cluster with availability zone relocation turned on.
- `"Encrypted"`: Enables support for restoring an unencrypted snapshot to a cluster
  encrypted with Key Management Service (KMS) and a customer managed key.
- `"EnhancedVpcRouting"`: An option that specifies whether to create the cluster with
  enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the
  cluster must be in a VPC. For more information, see Enhanced VPC Routing in the Amazon
  Redshift Cluster Management Guide. If this option is true, enhanced VPC routing is enabled.
   Default: false
- `"HsmClientCertificateIdentifier"`: Specifies the name of the HSM client certificate the
  Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
- `"HsmConfigurationIdentifier"`: Specifies the name of the HSM configuration that contains
  the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
- `"IamRoles"`: A list of Identity and Access Management (IAM) roles that can be used by
  the cluster to access other Amazon Web Services services. You must supply the IAM roles in
  their Amazon Resource Name (ARN) format.  The maximum number of IAM roles that you can
  associate is subject to a quota. For more information, go to Quotas and limits in the
  Amazon Redshift Cluster Management Guide.
- `"IpAddressType"`: The IP address type for the cluster. Possible values are ipv4 and
  dualstack.
- `"KmsKeyId"`: The Key Management Service (KMS) key ID of the encryption key that encrypts
  data in the cluster restored from a shared snapshot. You can also provide the key ID when
  you restore from an unencrypted snapshot to an encrypted cluster in the same account.
  Additionally, you can specify a new KMS key ID when you restore from an encrypted snapshot
  in the same account in order to change it. In that case, the restored cluster is encrypted
  with the new KMS key ID.
- `"MaintenanceTrackName"`: The name of the maintenance track for the restored cluster.
  When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the
  cluster. The snapshot might be on a different track than the cluster that was the source
  for the snapshot. For example, suppose that you take a snapshot of a cluster that is on the
  current track and then change the cluster to be on the trailing track. In this case, the
  snapshot and the source cluster are on different tracks.
- `"ManageMasterPassword"`: If true, Amazon Redshift uses Secrets Manager to manage the
  restored cluster's admin credentials. If ManageMasterPassword is false or not set, Amazon
  Redshift uses the admin credentials the cluster had at the time the snapshot was taken.
- `"ManualSnapshotRetentionPeriod"`: The default number of days to retain a manual
  snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't
  change the retention period of existing snapshots. The value must be either -1 or an
  integer between 1 and 3,653.
- `"MasterPasswordSecretKmsKeyId"`: The ID of the Key Management Service (KMS) key used to
  encrypt and store the cluster's admin credentials secret. You can only use this parameter
  if ManageMasterPassword is true.
- `"MultiAZ"`: If true, the snapshot will be restored to a cluster deployed in two
  Availability Zones.
- `"NodeType"`: The node type that the restored cluster will be provisioned with. If you
  have a DC instance type, you must restore into that same instance type and size. In other
  words, you can only restore a dc2.large node type into another dc2 type. For more
  information about node types, see  About Clusters and Nodes in the Amazon Redshift Cluster
  Management Guide.
- `"NumberOfNodes"`: The number of nodes specified when provisioning the restored cluster.
- `"OwnerAccount"`: The Amazon Web Services account used to create or copy the snapshot.
  Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
- `"Port"`: The port number on which the cluster accepts connections. Default: The same
  port as the original cluster. Valid values: For clusters with DC2 nodes, must be within the
  range 1150-65535. For clusters with ra3 nodes, must be within the ranges 5431-5455 or
  8191-8215.
- `"PreferredMaintenanceWindow"`: The weekly time range (in UTC) during which automated
  cluster maintenance can occur.  Format: ddd:hh24:mi-ddd:hh24:mi   Default: The value
  selected for the cluster from which the snapshot was taken. For more information about the
  time blocks for each region, see Maintenance Windows in Amazon Redshift Cluster Management
  Guide.  Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun Constraints: Minimum 30-minute
  window.
- `"PubliclyAccessible"`: If true, the cluster can be accessed from a public network.
- `"ReservedNodeId"`: The identifier of the target reserved node offering.
- `"SnapshotArn"`: The Amazon Resource Name (ARN) of the snapshot associated with the
  message to restore from a cluster. You must specify this parameter or snapshotIdentifier,
  but not both.
- `"SnapshotClusterIdentifier"`: The name of the cluster the source snapshot was created
  from. This parameter is required if your IAM user has a policy containing a snapshot
  resource element that specifies anything other than * for the cluster name.
- `"SnapshotIdentifier"`: The name of the snapshot from which to create the new cluster.
  This parameter isn't case sensitive. You must specify this parameter or snapshotArn, but
  not both. Example: my-snapshot-id
- `"SnapshotScheduleIdentifier"`: A unique identifier for the snapshot schedule.
- `"TargetReservedNodeOfferingId"`: The identifier of the target reserved node offering.
- `"VpcSecurityGroupIds"`: A list of Virtual Private Cloud (VPC) security groups to be
  associated with the cluster. Default: The default VPC security group is associated with the
  cluster. VPC security groups only apply to clusters in VPCs.
"""
function restore_from_cluster_snapshot(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "RestoreFromClusterSnapshot",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_from_cluster_snapshot(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "RestoreFromClusterSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_table_from_cluster_snapshot(cluster_identifier, new_table_name, snapshot_identifier, source_database_name, source_table_name)
    restore_table_from_cluster_snapshot(cluster_identifier, new_table_name, snapshot_identifier, source_database_name, source_table_name, params::Dict{String,<:Any})

Creates a new table from a table in an Amazon Redshift cluster snapshot. You must create
the new table within the Amazon Redshift cluster that the snapshot was taken from. You
cannot use RestoreTableFromClusterSnapshot to restore a table with the same name as an
existing table in an Amazon Redshift cluster. That is, you cannot overwrite an existing
table in a cluster with a restored table. If you want to replace your original table with a
new, restored table, then rename or drop your original table before you call
RestoreTableFromClusterSnapshot. When you have renamed your original table, then you can
pass the original name of the table as the NewTableName parameter value in the call to
RestoreTableFromClusterSnapshot. This way, you can replace the original table with the
table created from the snapshot. You can't use this operation to restore tables with
interleaved sort keys.

# Arguments
- `cluster_identifier`: The identifier of the Amazon Redshift cluster to restore the table
  to.
- `new_table_name`: The name of the table to create as a result of the current request.
- `snapshot_identifier`: The identifier of the snapshot to restore the table from. This
  snapshot must have been created from the Amazon Redshift cluster specified by the
  ClusterIdentifier parameter.
- `source_database_name`: The name of the source database that contains the table to
  restore from.
- `source_table_name`: The name of the source table to restore from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EnableCaseSensitiveIdentifier"`: Indicates whether name identifiers for database,
  schema, and table are case sensitive. If true, the names are case sensitive. If false
  (default), the names are not case sensitive.
- `"SourceSchemaName"`: The name of the source schema that contains the table to restore
  from. If you do not specify a SourceSchemaName value, the default is public.
- `"TargetDatabaseName"`: The name of the database to restore the table to.
- `"TargetSchemaName"`: The name of the schema to restore the table to.
"""
function restore_table_from_cluster_snapshot(
    ClusterIdentifier,
    NewTableName,
    SnapshotIdentifier,
    SourceDatabaseName,
    SourceTableName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "RestoreTableFromClusterSnapshot",
        Dict{String,Any}(
            "ClusterIdentifier" => ClusterIdentifier,
            "NewTableName" => NewTableName,
            "SnapshotIdentifier" => SnapshotIdentifier,
            "SourceDatabaseName" => SourceDatabaseName,
            "SourceTableName" => SourceTableName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_table_from_cluster_snapshot(
    ClusterIdentifier,
    NewTableName,
    SnapshotIdentifier,
    SourceDatabaseName,
    SourceTableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "RestoreTableFromClusterSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterIdentifier" => ClusterIdentifier,
                    "NewTableName" => NewTableName,
                    "SnapshotIdentifier" => SnapshotIdentifier,
                    "SourceDatabaseName" => SourceDatabaseName,
                    "SourceTableName" => SourceTableName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    resume_cluster(cluster_identifier)
    resume_cluster(cluster_identifier, params::Dict{String,<:Any})

Resumes a paused cluster.

# Arguments
- `cluster_identifier`: The identifier of the cluster to be resumed.

"""
function resume_cluster(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "ResumeCluster",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function resume_cluster(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "ResumeCluster",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    revoke_cluster_security_group_ingress(cluster_security_group_name)
    revoke_cluster_security_group_ingress(cluster_security_group_name, params::Dict{String,<:Any})

Revokes an ingress rule in an Amazon Redshift security group for a previously authorized IP
range or Amazon EC2 security group. To add an ingress rule, see
AuthorizeClusterSecurityGroupIngress. For information about managing security groups, go to
Amazon Redshift Cluster Security Groups in the Amazon Redshift Cluster Management Guide.

# Arguments
- `cluster_security_group_name`: The name of the security Group from which to revoke the
  ingress rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CIDRIP"`: The IP range for which to revoke access. This range must be a valid Classless
  Inter-Domain Routing (CIDR) block of IP addresses. If CIDRIP is specified,
  EC2SecurityGroupName and EC2SecurityGroupOwnerId cannot be provided.
- `"EC2SecurityGroupName"`: The name of the EC2 Security Group whose access is to be
  revoked. If EC2SecurityGroupName is specified, EC2SecurityGroupOwnerId must also be
  provided and CIDRIP cannot be provided.
- `"EC2SecurityGroupOwnerId"`: The Amazon Web Services account number of the owner of the
  security group specified in the EC2SecurityGroupName parameter. The Amazon Web Services
  access key ID is not an acceptable value. If EC2SecurityGroupOwnerId is specified,
  EC2SecurityGroupName must also be provided. and CIDRIP cannot be provided.  Example:
  111122223333
"""
function revoke_cluster_security_group_ingress(
    ClusterSecurityGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "RevokeClusterSecurityGroupIngress",
        Dict{String,Any}("ClusterSecurityGroupName" => ClusterSecurityGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function revoke_cluster_security_group_ingress(
    ClusterSecurityGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "RevokeClusterSecurityGroupIngress",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClusterSecurityGroupName" => ClusterSecurityGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    revoke_endpoint_access()
    revoke_endpoint_access(params::Dict{String,<:Any})

Revokes access to a cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Account"`: The Amazon Web Services account ID whose access is to be revoked.
- `"ClusterIdentifier"`: The cluster to revoke access from.
- `"Force"`: Indicates whether to force the revoke action. If true, the Redshift-managed
  VPC endpoints associated with the endpoint authorization are also deleted.
- `"VpcIds"`: The virtual private cloud (VPC) identifiers for which access is to be revoked.
"""
function revoke_endpoint_access(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift(
        "RevokeEndpointAccess"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function revoke_endpoint_access(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "RevokeEndpointAccess",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    revoke_snapshot_access(account_with_restore_access)
    revoke_snapshot_access(account_with_restore_access, params::Dict{String,<:Any})

Removes the ability of the specified Amazon Web Services account to restore the specified
snapshot. If the account is currently restoring the snapshot, the restore will run to
completion.  For more information about working with snapshots, go to Amazon Redshift
Snapshots in the Amazon Redshift Cluster Management Guide.

# Arguments
- `account_with_restore_access`: The identifier of the Amazon Web Services account that can
  no longer restore the specified snapshot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SnapshotArn"`: The Amazon Resource Name (ARN) of the snapshot associated with the
  message to revoke access.
- `"SnapshotClusterIdentifier"`: The identifier of the cluster the snapshot was created
  from. This parameter is required if your IAM user has a policy containing a snapshot
  resource element that specifies anything other than * for the cluster name.
- `"SnapshotIdentifier"`: The identifier of the snapshot that the account can no longer
  access.
"""
function revoke_snapshot_access(
    AccountWithRestoreAccess; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "RevokeSnapshotAccess",
        Dict{String,Any}("AccountWithRestoreAccess" => AccountWithRestoreAccess);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function revoke_snapshot_access(
    AccountWithRestoreAccess,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "RevokeSnapshotAccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountWithRestoreAccess" => AccountWithRestoreAccess),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    rotate_encryption_key(cluster_identifier)
    rotate_encryption_key(cluster_identifier, params::Dict{String,<:Any})

Rotates the encryption keys for a cluster.

# Arguments
- `cluster_identifier`: The unique identifier of the cluster that you want to rotate the
  encryption keys for. Constraints: Must be the name of valid cluster that has encryption
  enabled.

"""
function rotate_encryption_key(
    ClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift(
        "RotateEncryptionKey",
        Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function rotate_encryption_key(
    ClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "RotateEncryptionKey",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClusterIdentifier" => ClusterIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_partner_status(account_id, cluster_identifier, database_name, partner_name, status)
    update_partner_status(account_id, cluster_identifier, database_name, partner_name, status, params::Dict{String,<:Any})

Updates the status of a partner integration.

# Arguments
- `account_id`: The Amazon Web Services account ID that owns the cluster.
- `cluster_identifier`: The cluster identifier of the cluster whose partner integration
  status is being updated.
- `database_name`: The name of the database whose partner integration status is being
  updated.
- `partner_name`: The name of the partner whose integration status is being updated.
- `status`: The value of the updated status.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"StatusMessage"`: The status message provided by the partner.
"""
function update_partner_status(
    AccountId,
    ClusterIdentifier,
    DatabaseName,
    PartnerName,
    Status;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "UpdatePartnerStatus",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "ClusterIdentifier" => ClusterIdentifier,
            "DatabaseName" => DatabaseName,
            "PartnerName" => PartnerName,
            "Status" => Status,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_partner_status(
    AccountId,
    ClusterIdentifier,
    DatabaseName,
    PartnerName,
    Status,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift(
        "UpdatePartnerStatus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "ClusterIdentifier" => ClusterIdentifier,
                    "DatabaseName" => DatabaseName,
                    "PartnerName" => PartnerName,
                    "Status" => Status,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
