# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: sagemaker_metrics
using AWS.Compat
using AWS.UUIDs

"""
    batch_put_metrics(metric_data, trial_component_name)
    batch_put_metrics(metric_data, trial_component_name, params::Dict{String,<:Any})

Used to ingest training metrics into SageMaker. These metrics can be visualized in
SageMaker Studio and retrieved with the GetMetrics API.

# Arguments
- `metric_data`: A list of raw metric values to put.
- `trial_component_name`: The name of the Trial Component to associate with the metrics.

"""
function batch_put_metrics(
    MetricData, TrialComponentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sagemaker_metrics(
        "PUT",
        "/BatchPutMetrics",
        Dict{String,Any}(
            "MetricData" => MetricData, "TrialComponentName" => TrialComponentName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_put_metrics(
    MetricData,
    TrialComponentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sagemaker_metrics(
        "PUT",
        "/BatchPutMetrics",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "MetricData" => MetricData, "TrialComponentName" => TrialComponentName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
