function is_prime(x::Integer)
  return is_prime(ZZRingElem(x))
end

function next_prime(x::BigInt, proved::Bool=true)
  return BigInt(next_prime(ZZRingElem(x), proved))
end

function next_prime(x::T, proved::Bool=true) where {T<:Integer}
  return T(next_prime(BigInt(x), proved))
end

function valuation(a::UInt, b::UInt)
  return @ccall libflint.n_remove(a::Ref{UInt}, b::UInt)::Int
end

function fits(::Type{T}, a::Integer) where {T <: Integer}
  return typemin(T) <= a <= typemax(T)
end

clog(a::Int, b::Int) = clog(ZZRingElem(a), b)
