# utils.py
#
# Copyright 2024 Lo
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from gi.repository import Gtk

def get_category_color(card, category: str, activatable: bool = True):
    color: str = ""

    if category == _('diatomic nonmetal') or category == _('polyatomic nonmetal'):
        color = "green"

    if category == _('alkali metal'):
        color = "red"
    elif category == _('transition metal'):
        color = "blue"
    elif category == _('noble gas'):
        color = "orange"
    elif category == _('metalloid'):
        color = "yellow"
    elif category == _('alkaline earth metal'):
        color = "purple"
    elif category == _('lanthanide'):
        color = "teal"
    elif category == _('post-transition metal'):
        color = "pink"
    elif category == _('actinide'):
        color = "slate"

    if not color == "":
        if activatable:
            card.add_css_class("suggested-action")
            card.add_css_class(color)
        else:
            card.add_css_class(f"elements-{color}")

