/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

public class NcVarType {
    public static final NcVarType SCALAR = new NcVarType(VarType.SCALAR);
    public static final NcVarType ONE_D = new NcVarType(VarType.ONE_D);
    public static final NcVarType OTHER = new NcVarType(VarType.OTHER);
    private final VarType vtype_;

    NcVarType(VarType vtype) {
        this.vtype_ = vtype;
    }

    public boolean isGeoreferenced() {
        return false;
    }

    public boolean isScalar() {
        return this.vtype_ == VarType.SCALAR;
    }

    public String toString() {
        return "[NcVarType." + this.vtype_ + "]";
    }

    protected static enum VarType {
        GRIDDED,
        ONE_D,
        DISCRETE,
        SCALAR,
        OTHER;

    }
}

