/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcGridderUtils;
import gov.nasa.giss.data.nc.gridder.NcGridderXY;
import java.awt.Dimension;

public class NcGridderLonTime
extends NcGridderXY {
    public NcGridderLonTime() {
        this(100, 50);
    }

    public NcGridderLonTime(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridderLonTime(int w, int h) {
        this.setSize(w, h);
        this.setBounds(0.0, 0.0, 1.0, 1.0);
    }

    @Override
    public void regridNoInterpolate(NcArray nca, double[] target) {
        int j;
        this.prepareGridAxes();
        NcArray2D nca2D = (NcArray2D)nca;
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        int numXs = nca2D.getColumnCount();
        int numYs = nca2D.getRowCount();
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block0: for (j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < numYs; ++jj) {
                if (!(this.rowYY_[j] >= yBounds[jj][0] && this.rowYY_[j] < yBounds[jj][1]) && (!(this.rowYY_[j] < yBounds[jj][0]) || !(this.rowYY_[j] >= yBounds[jj][1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            double lon = this.colXX_[i];
            for (int ii = 0; ii < numXs; ++ii) {
                double leftII = xBounds[ii][0];
                double rightII = xBounds[ii][1];
                while (lon < leftII && lon < rightII) {
                    lon += 360.0;
                }
                while (lon > leftII && lon > rightII) {
                    lon -= 360.0;
                }
                if (!(lon >= leftII && lon < rightII) && (!(lon < leftII) || !(lon >= rightII))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (j = 0; j < this.gridHeight_; ++j) {
            if (srcRow[j] < 0) continue;
            for (int i = 0; i < this.gridWidth_; ++i) {
                if (srcCol[i] < 0) continue;
                double value = nca2D.valueAt(srcCol[i], srcRow[j]);
                if (hasBad && nca2D.isMissingOrInvalid(value)) {
                    value = Double.NaN;
                }
                this.setValue(target, i, j, value);
            }
        }
    }

    @Override
    public void regridInterpolate(NcArray nca, double[] target) {
        this.prepareGridAxes();
        NcArray2D nca2D = (NcArray2D)nca;
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        double[] xVals = xAxis.getValues();
        double[] yVals = yAxis.getValues();
        int numXs = xVals.length;
        int numYs = yVals.length;
        int lastX = xAxis.isWraparound() ? numXs : numXs - 1;
        int lastY = numYs - 1;
        boolean westToEast = xVals[1] > xVals[0];
        int[] srcCol = new int[this.gridWidth_];
        int[] srcRow = new int[this.gridHeight_];
        block0: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < lastY; ++jj) {
                if (!(this.rowYY_[j] >= yVals[jj] && this.rowYY_[j] < yVals[jj + 1]) && (!(this.rowYY_[j] <= yVals[jj]) || !(this.rowYY_[j] > yVals[jj + 1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            double lon = this.colXX_[i];
            for (int ii = 0; ii < lastX; ++ii) {
                double rightII;
                double leftII = xVals[ii];
                double d = ii == numXs - 1 ? xVals[0] + (westToEast ? 360.0 : -360.0) : (rightII = xVals[ii + 1]);
                while (lon < leftII && lon < rightII) {
                    lon += 360.0;
                }
                while (lon > leftII && lon > rightII) {
                    lon -= 360.0;
                }
                if (!(lon >= leftII && lon < rightII) && (!(lon <= leftII) || !(lon > rightII))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            int rowJ = srcRow[j];
            int rowJP1 = srcRow[j] + 1;
            if (rowJ < 0) continue;
            double yPct = (this.rowYY_[j] - yVals[rowJ]) / (yVals[rowJP1] - yVals[rowJ]);
            for (int i = 0; i < this.gridWidth_; ++i) {
                double lon;
                int colIP1;
                int colI = srcCol[i];
                int n = colIP1 = colI + 1 < numXs ? colI + 1 : 0;
                if (colI == -1) continue;
                double leftLon = xVals[colI];
                double rightLon = xVals[colIP1];
                if (westToEast) {
                    if (rightLon < leftLon) {
                        rightLon += 360.0;
                    }
                } else if (rightLon > leftLon) {
                    rightLon -= 360.0;
                }
                for (lon = this.colXX_[i]; lon < leftLon && lon < rightLon; lon += 360.0) {
                }
                while (lon > leftLon && lon > rightLon) {
                    lon -= 360.0;
                }
                double xPct = (lon - leftLon) / (rightLon - leftLon);
                double valTL = nca2D.valueAt(colI, rowJ);
                double valTR = nca2D.valueAt(colIP1, rowJ);
                double valBL = nca2D.valueAt(colI, rowJP1);
                double valBR = nca2D.valueAt(colIP1, rowJP1);
                if (hasBad) {
                    if (nca2D.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                this.setValue(target, i, j, value);
            }
        }
    }
}

