/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ObliqueEllipseProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AitoffOblique
extends ObliqueEllipseProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Aitoff (Oblique)";
    public static final int PROPERTIES = 0xA00020;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;

    public AitoffOblique(int width, int height) {
        this(width, height, 0, 0);
    }

    public AitoffOblique(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0xA00020, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double[] llP = this.lonlat2lonlatP(lon, lat);
        double halfLambdaPRad = 0.5 * Math.toRadians(llP[0]);
        double phiPRad = Math.toRadians(llP[1]);
        double cosPhiP = Math.cos(phiPRad);
        double cosAlpha = cosPhiP * Math.cos(halfLambdaPRad);
        double alphaRad = Math.acos(cosAlpha);
        if (Math.abs(alphaRad) < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double sinAlpha = Math.sin(alphaRad);
        double cosBeta = Math.sin(phiPRad) / sinAlpha;
        double sinBeta = cosPhiP * Math.sin(halfLambdaPRad) / sinAlpha;
        double x = 2.0 * alphaRad * sinBeta;
        double y = alphaRad * cosBeta;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaPRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double alphaRad = Math.hypot(0.5 * x, y) * this.invRS_;
        double sinPhiP = y * this.invRS_ * Math.sin(alphaRad) / alphaRad;
        double phiPRad = Math.asin(sinPhiP);
        if (Math.abs(phiPRad) > 1.5707963267948966) {
            return null;
        }
        double d = lambdaPRad = phiPRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.acos(Math.cos(alphaRad) / Math.cos(phiPRad));
        if (Double.isNaN(lambdaPRad) || lambdaPRad > Math.PI) {
            return null;
        }
        if (x < 0.0) {
            lambdaPRad = 0.0 - lambdaPRad;
        }
        double phiP = Math.toDegrees(phiPRad);
        double lambdaP = Math.toDegrees(lambdaPRad);
        double[] ll = this.lonlatP2lonlat(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AitoffOblique aitoffOblique = this;
        synchronized (aitoffOblique) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double alphaRad;
                double sinPhiP;
                double phiPRad;
                double y = (double)iy + 0.5;
                for (int ix = 0; ix < this.dxMax_ && !(Math.abs(phiPRad = Math.asin(sinPhiP = y * this.invRS_ * Math.sin(alphaRad = Math.hypot(0.5 * (x = (double)ix + 0.5), y) * this.invRS_) / alphaRad)) > 1.5707963267948966); ++ix) {
                    double lambdaPRad;
                    double d = lambdaPRad = phiPRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.acos(Math.cos(alphaRad) / Math.cos(phiPRad));
                    if (lambdaPRad > Math.PI) continue block3;
                    double lambdaP = Math.toDegrees(lambdaPRad);
                    double phiP = Math.toDegrees(phiPRad);
                    double[] llTR = this.lonlatP2lonlat(lambdaP, phiP);
                    double[] llBR = this.lonlatP2lonlat(lambdaP, -phiP);
                    double[] llBL = this.lonlatP2lonlat(-lambdaP, -phiP);
                    double[] llTL = this.lonlatP2lonlat(-lambdaP, phiP);
                    this.setInvPoint(ix, iy, llTR[0], llTR[1]);
                    this.setInvPoint(ix, -iy - 1, llBR[0], llBR[1]);
                    this.setInvPoint(-ix - 1, -iy - 1, llBL[0], llBL[1]);
                    this.setInvPoint(-ix - 1, iy, llTL[0], llTL[1]);
                }
            }
        }
    }
}

