/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GeneralEquidistantConic;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquidistantConic
extends GeneralEquidistantConic {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Equidistant Conic";

    public EquidistantConic(int width, int height) {
        this(width, height, 0, 0);
    }

    public EquidistantConic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200010, width, height, xmargin, ymargin);
        this.finishConstruction();
    }

    @Override
    protected void calculateParams() {
        double phi1Rad = Math.toRadians(this.phi1_);
        if (this.phi1_ == this.phi2_) {
            this.termN_ = Math.sin(phi1Rad);
            this.termF_ = 1.0 / Math.tan(phi1Rad) + phi1Rad;
        } else {
            double cosPhi1 = Math.cos(phi1Rad);
            double phi2Rad = Math.toRadians(this.phi2_);
            double cosPhi2 = Math.cos(phi2Rad);
            this.termN_ = (cosPhi1 - cosPhi2) / (phi2Rad - phi1Rad);
            this.termF_ = (phi2Rad * cosPhi1 - phi1Rad * cosPhi2) / (cosPhi1 - cosPhi2);
        }
        this.invN_ = 1.0 / this.termN_;
        this.rhoC_ = this.termF_ - this.phiCRad_;
        LOGGER.trace("F {}, n {}, rhoC {}", this.termF_, this.termN_, this.rhoC_);
    }
}

