/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.panoply.PanoplyCL;
import gov.nasa.giss.panoply.about.PanAboutFrame;
import gov.nasa.giss.panoply.desktop.PanDesktopAdapter;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.log.PanLoggingGroup;
import gov.nasa.giss.panoply.log.PanLoggingUtils;
import gov.nasa.giss.panoply.macos.PanMacApplication;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefs.PanPrefsSaverTask;
import gov.nasa.giss.panoply.prefs.PanSavedSettingsHandler;
import gov.nasa.giss.panoply.server.PanClient;
import gov.nasa.giss.panoply.server.PanServer;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.task.PanVersionCheckTask;
import gov.nasa.giss.panoply.util.PanCLOptionKey;
import gov.nasa.giss.panoply.util.PanMemoryWatcher;
import gov.nasa.giss.panoply.util.PanNcUtils;
import gov.nasa.giss.panoply.util.PanQuitWatcher;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.task.TaskQueue;
import java.awt.EventQueue;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class Panoply {
    private static final Marker FATAL = MarkerFactory.getMarker("FATAL");
    private static long SPLASH_MILLIS = 4001L;
    private static long CLOSE_START = 75001L;
    private static long CLOSE_MILLIS = 5001L;
    private static long AUTOSAVE_MILLIS = 180001L;
    private static boolean starting_;
    private static boolean filesRequested_;

    public static void main(String ... args) {
        starting_ = true;
        PanLoggingUtils.initLogging();
        new Panoply(args);
    }

    private Panoply(String ... args) {
        Logger logger;
        Hashtable<PanCLOptionKey, Object> opts = Panoply.parseCommandLineOptions(args);
        if (opts.containsKey((Object)PanCLOptionKey.SCRIPT_PATH)) {
            logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
            logger.info("Script option invoked. Diverting to PanoplyCL.");
            new PanoplyCL(args);
            System.exit(0);
        }
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        PanUtils.printIdentity();
        Panoply.testInstance(opts);
        this.initPrefsEtc();
        this.initLookAndFeel(opts);
        if (PlatformUtils.isMacintosh()) {
            this.initMacOS();
        }
        PanDesktopAdapter.init();
        long splashStop = -1L;
        if (!filesRequested_ && !opts.containsKey((Object)PanCLOptionKey.FILESREQ)) {
            try {
                Thread.sleep(101L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            splashStop = System.currentTimeMillis() + SPLASH_MILLIS;
            EventQueue.invokeLater(() -> PanAboutFrame.getSharedInstance().reveal());
        }
        if (opts.containsKey((Object)PanCLOptionKey.FILESREQ)) {
            ArrayList dataFiles = (ArrayList)opts.get((Object)PanCLOptionKey.FILES);
            logger.trace("Trying to open {} datasets specified in command line options", (Object)dataFiles.size());
            for (File f : dataFiles) {
                try {
                    if (f == null) continue;
                    PanFileUtils.openDatasetUsingTask(f);
                }
                catch (Exception exc) {
                    logger.warn("Skipping file {} due to {}", (Object)f.getName(), (Object)exc.toString());
                }
            }
            dataFiles.clear();
        }
        if (splashStop > 0L) {
            while (System.currentTimeMillis() < splashStop) {
                try {
                    Thread.sleep(101L);
                }
                catch (Exception exception) {}
            }
            EventQueue.invokeLater(() -> {
                PanAboutFrame paf = PanAboutFrame.getSharedInstance();
                paf.setVisible(false);
                paf.setLaunched(true);
            });
        }
        EventQueue.invokeLater(() -> PanSourcesFrame.getSharedInstance());
        EventQueue.invokeLater(() -> {
            File[] ff;
            if (filesRequested_ || opts.containsKey((Object)PanCLOptionKey.FILESREQ)) {
                return;
            }
            if (PanPreferences.getSharedInstance().getBoolean("files:dialog.launch") && (ff = PanFileUtils.showOpenDataFileChooser(null)) != null) {
                PanFileUtils.openLocalFiles(null, ff);
            }
        });
        EventQueue.invokeLater(() -> PanSourcesFrame.getSharedInstance().reveal());
        if (!PlatformUtils.isMacintosh()) {
            EventQueue.invokeLater(() -> new Timer().schedule((TimerTask)new PanQuitWatcher(), CLOSE_START, CLOSE_MILLIS));
        }
        new Timer().schedule((TimerTask)new PanPrefsSaverTask(), AUTOSAVE_MILLIS, AUTOSAVE_MILLIS);
        if (PanPreferences.getSharedInstance().getBoolean("app:version.enabled")) {
            EventQueue.invokeLater(() -> {
                if (PanVersionCheckTask.isTimeForCheck()) {
                    PanVersionCheckTask task = new PanVersionCheckTask(false, true);
                    TaskQueue.getSharedInstance().add(task);
                }
            });
        }
        if (PanUtils.isDebugMemoryLogging() && logger.isTraceEnabled()) {
            EventQueue.invokeLater(() -> new Timer().schedule((TimerTask)new PanMemoryWatcher(), 20001L, 20001L));
        }
        starting_ = false;
    }

    private void initPrefsEtc() {
        PanUtils.initMiscProperties();
        PanPreferences.getSharedInstance().read();
        if (PanUtils.isDevoSavedSettings()) {
            PanSavedSettingsHandler.getSharedInstance();
        }
        Hashtable<PanNcUtils.Key, Object> initHash = new Hashtable<PanNcUtils.Key, Object>();
        initHash.put(PanNcUtils.Key.DEVO_MODE, PanUtils.isDevo());
        initHash.put(PanNcUtils.Key.SERVER_MODE, false);
        PanNcUtils.initNetcdf(initHash);
        if (PanUtils.isDevo()) {
            ProjectionFactory.setDevoEnabled();
        }
    }

    private void initLookAndFeel(Hashtable<PanCLOptionKey, Object> opts) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        String lafName = null;
        if (PlatformUtils.isLinuxEtc()) {
            if (opts.containsKey((Object)PanCLOptionKey.SKIN)) {
                String skin = (String)opts.get((Object)PanCLOptionKey.SKIN);
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!skin.equalsIgnoreCase(info.getName())) continue;
                    lafName = info.getClassName();
                    break;
                }
            }
        } else {
            lafName = UIManager.getSystemLookAndFeelClassName();
        }
        if (lafName == null) {
            logger.trace("Using default L&F: {}", (Object)UIManager.getLookAndFeel().getClass().getSimpleName());
        } else {
            try {
                UIManager.setLookAndFeel(lafName);
            }
            catch (Exception exc) {
                logger.warn("Unable to install L&F {} due to {}", (Object)lafName, (Object)exc.getMessage());
            }
        }
    }

    private void initMacOS() {
        if (!PlatformUtils.isMacintosh()) {
            return;
        }
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        EventQueue.invokeLater(() -> {
            block2: {
                try {
                    PanMacApplication.getSharedInstance();
                }
                catch (Exception exc) {
                    logger.error("Failed to init PanMacApplication.");
                    if (!logger.isTraceEnabled()) break block2;
                    exc.printStackTrace();
                }
            }
        });
    }

    private static Hashtable<PanCLOptionKey, Object> parseCommandLineOptions(String ... args) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Hashtable<PanCLOptionKey, Object> opts = new Hashtable<PanCLOptionKey, Object>(20);
        boolean optionsAllowed = true;
        boolean logLevelSet = false;
        String dataPath = null;
        ArrayList<String> dataFnames = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (optionsAllowed && args[i].charAt(0) == '-') {
                if ("--".equals(args[i])) {
                    optionsAllowed = false;
                    continue;
                }
                String optkey = args[i].substring(1);
                switch (optkey) {
                    case "script": {
                        if (++i >= args.length || args[i].charAt(0) == '-') {
                            logger.error(FATAL, "No value provided for script name.");
                            System.exit(1);
                        } else {
                            opts.put(PanCLOptionKey.SCRIPT_PATH, args[i]);
                        }
                        logger.info("Script command and filename detected.");
                        logger.info("Subsequent CL options will be ignored.");
                        logger.info("We'll will switch over to PanoplyCL now.");
                        return opts;
                    }
                    case "console": {
                        PanLoggingUtils.resetOut();
                        break;
                    }
                    case "log": {
                        if (++i >= args.length || args[i].charAt(0) == '-') {
                            logger.error(FATAL, "No value provided for log level.");
                            System.exit(1);
                        }
                        if (logLevelSet) {
                            logger.info("LogLevel previously reset by CL option");
                            break;
                        }
                        PanLoggingUtils.setLogLevel(PanLoggingGroup.PANOPLY, args[i]);
                        logLevelSet = true;
                        break;
                    }
                    case "v": {
                        if (logLevelSet) {
                            logger.info("LogLevel already reset");
                            break;
                        }
                        PanLoggingUtils.setLogLevel(PanLoggingGroup.PANOPLY, "FINE");
                        logLevelSet = true;
                        break;
                    }
                    case "vv": {
                        if (logLevelSet) {
                            logger.info("LogLevel already reset");
                            break;
                        }
                        PanLoggingUtils.setLogLevel(PanLoggingGroup.PANOPLY, "FINER");
                        logLevelSet = true;
                        break;
                    }
                    case "vvv": {
                        if (logLevelSet) {
                            logger.info("LogLevel already reset");
                            break;
                        }
                        PanLoggingUtils.setLogLevel(PanLoggingGroup.PANOPLY, "FINEST");
                        logLevelSet = true;
                        break;
                    }
                    case "single": {
                        opts.put(PanCLOptionKey.SINGLE, true);
                        break;
                    }
                    case "multi": {
                        opts.put(PanCLOptionKey.MULTI, true);
                        break;
                    }
                    case "skin": {
                        opts.put(PanCLOptionKey.SKIN, true);
                        break;
                    }
                    case "path": {
                        if (dataPath != null) {
                            logger.warn("Data path option specified more than once; last choice wins.");
                        }
                        if (++i >= args.length || args[i].charAt(0) == '-') {
                            logger.error(FATAL, "No value provided for path option.");
                            System.exit(1);
                            break;
                        }
                        dataPath = args[i];
                        break;
                    }
                    case "NSDocumentRevisionsDebugMode": {
                        ++i;
                        break;
                    }
                    default: {
                        if (optkey.startsWith("psn_")) {
                            logger.trace("Encountered macOS -psn -- ignoring it.");
                            break;
                        }
                        logger.warn("Encountered unknown option '{}' -- ignoring it", (Object)args[i]);
                        break;
                    }
                }
                continue;
            }
            dataFnames.add(args[i]);
        }
        if (dataFnames.size() > 0) {
            ArrayList<File> dataFiles = new ArrayList<File>();
            File dataPathdir = null;
            try {
                if (dataPath != null) {
                    dataPathdir = new File(dataPath);
                }
            }
            catch (Exception exc) {
                logger.error(FATAL, "Bad data path specification '{}'", (Object)dataPath);
                System.exit(2);
            }
            for (String fname : dataFnames) {
                try {
                    File f = new File(dataPathdir, fname);
                    if (f.exists()) {
                        dataFiles.add(new File(dataPathdir, fname));
                    } else {
                        logger.warn("Skipping '{}'. File does not exist.", (Object)fname);
                    }
                }
                catch (Exception exc) {
                    logger.warn("Skipping '{}' due to {}.", (Object)fname, (Object)exc.getMessage());
                    continue;
                }
                if (dataFiles.size() <= 0) continue;
                opts.put(PanCLOptionKey.FILESREQ, true);
                opts.put(PanCLOptionKey.FILES, dataFiles);
            }
        }
        return opts;
    }

    public static boolean isStarting() {
        return starting_;
    }

    public static void setFilesRequested() {
        filesRequested_ = true;
    }

    private static void testInstance(Hashtable<PanCLOptionKey, Object> opts) {
        block9: {
            Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
            if (opts.containsKey((Object)PanCLOptionKey.SINGLE) && opts.containsKey((Object)PanCLOptionKey.MULTI)) {
                logger.warn("Setting -single and -multi flags both true is contradictory.");
                logger.trace("Will default to multi, and will NOT test for prior instance.");
                return;
            }
            if (opts.containsKey((Object)PanCLOptionKey.SINGLE)) {
                logger.trace("RequireSingleInstance set; will test for prior instance.");
            } else {
                if (opts.containsKey((Object)PanCLOptionKey.MULTI)) {
                    logger.trace("AllowMultipleInstances set; will NOT test for prior instance.");
                    return;
                }
                if (PlatformUtils.isLinuxEtc()) {
                    logger.trace("Linux-etc detected and neither single/multi previously set.");
                    logger.trace("Will default to multi, and will NOT test for prior instance.");
                    return;
                }
            }
            logger.info("Testing whether an instance of Panoply is already running on this system.");
            ArrayList dataFiles = (ArrayList)opts.get((Object)PanCLOptionKey.FILES);
            if (PanClient.testForPriorInstance(dataFiles)) {
                logger.warn("A previous instance of Panoply is running on this system.");
                if (dataFiles != null) {
                    logger.warn("Datasets in your command-line options have been handed off to that instance.");
                }
                logger.warn("This instance will exit.");
                System.exit(0);
            }
            try {
                logger.info("Starting a \"server\" instance listener.");
                PanServer.getSharedInstance().start();
            }
            catch (Exception exc) {
                logger.error("Could not start an instance listener: {}", (Object)exc.getMessage());
                if (!logger.isTraceEnabled()) break block9;
                exc.printStackTrace();
            }
        }
    }

    static {
        filesRequested_ = false;
    }
}

