/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.AmericanPolyconic;
import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.BonneRegional;
import gov.nasa.giss.map.proj.Cassini;
import gov.nasa.giss.map.proj.ConicProjection;
import gov.nasa.giss.map.proj.Equirectangular;
import gov.nasa.giss.map.proj.EquirectangularOblique;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.map.proj.MercatorRegional;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjIntegerParameter;
import gov.nasa.giss.map.proj.ProjListEnum;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.RectangularPolyconic;
import gov.nasa.giss.map.proj.TransverseMercator;
import gov.nasa.giss.panoply.prefs.PanProjectionPrefs;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanProjectionMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PrintfFormat PFORMAT_10G = new PrintfFormat("%.10g");
    private AbstractProjection projection_;
    private final Hashtable<String, Object> paramHash_ = new Hashtable(25);
    private int width_ = 2;
    private int height_ = 2;
    private int hmargin_;
    private int vmargin_;
    private LonLatEdges bounds_ = LonLatEdges.ENTIRE_GLOBE;

    public AbstractProjection getProjection() {
        return this.projection_;
    }

    public void setProjection(String name) {
        PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
        AbstractProjection old = this.projection_;
        int w = Math.max(2, this.width_);
        int h = Math.max(2, this.height_);
        if (name.equals("Equirectangular Regional")) {
            this.projection_ = new EquirectangularRegional(w, h, this.hmargin_, this.vmargin_);
        } else {
            try {
                this.projection_ = ProjectionFactory.create(name);
                this.projection_.setSizeAndMargins(w, h, this.hmargin_, this.vmargin_);
            }
            catch (Exception exc) {
                LOGGER.debug("ProjectionFactory did not recognize \"{}\"", (Object)name);
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                this.projection_ = new Equirectangular(w, h, this.hmargin_, this.vmargin_);
            }
        }
        if (old == null) {
            this.projection_.setCenter(0.0, 0.0);
        } else {
            this.projection_.setCenter(old.getCenter());
            this.projection_.setLonGridSpacing(old.getLonGridSpacing());
            this.projection_.setLatGridSpacing(old.getLatGridSpacing());
            this.projection_.setLatGridOffset(old.getLatGridOffset());
            this.projection_.setBackground(old.getBackground());
            this.projection_.setBorderColor(old.getBorderColor());
            this.projection_.setBorderStroke(old.getBorderStroke());
            this.projection_.setGridColor(old.getGridColor());
            this.projection_.setGridStroke(old.getGridStroke());
            this.projection_.setGridLabeled(old.isGridLabeled());
            this.projection_.setPathColor(old.getPathColor());
            this.projection_.setPathStroke(old.getPathStroke());
        }
        int pcount = this.projection_.getExtraParamCount();
        for (int i = 0; i < pcount; ++i) {
            String key = name + "-" + i;
            Object value = this.paramHash_.get(key);
            if (value == null || value instanceof String && ((String)value).isEmpty()) {
                value = pprefs.getParam(name, i);
            }
            if (value == null || value instanceof String && ((String)value).isEmpty()) {
                return;
            }
            try {
                this.setExtraParameter(i, value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.calculateBounds();
    }

    public void setSize(int width, int height) {
        this.width_ = width;
        this.height_ = height;
        this.projection_.setSizeAndMargins(this.width_, this.height_, this.hmargin_, this.vmargin_);
        this.calculateBounds();
    }

    public void setMargins(int hmargin, int vmargin) {
        this.hmargin_ = hmargin;
        this.vmargin_ = vmargin;
        this.projection_.setSizeAndMargins(this.width_, this.height_, this.hmargin_, this.vmargin_);
        this.calculateBounds();
    }

    public void setCenterLon(double lon) {
        LOGGER.trace("{}", (Object)lon);
        this.projection_.setCenter(lon, this.projection_.getCenter().getLat());
        this.calculateBounds();
    }

    public void setCenterLat(double lat) {
        double xlat = lat;
        if (Math.abs(xlat) > 90.0) {
            LOGGER.warn("Invalid latitude received for center of projection. Fixorating it.");
            xlat = 90.0 * Math.signum(xlat);
        }
        LOGGER.trace("{}, {}", (Object)lat, (Object)xlat);
        try {
            this.projection_.setCenter(this.projection_.getCenter().getLon(), xlat);
        }
        catch (Exception exc) {
            LOGGER.warn("Invalid center was rejected by map projection handler.");
        }
        this.calculateBounds();
    }

    public synchronized LonLatEdges getBounds() {
        this.calculateBounds();
        return this.bounds_;
    }

    private void calculateBounds() {
        this.bounds_ = this.projection_.getBounds();
    }

    public Object getXParamValue(int pid) {
        if (pid < 0 || pid >= this.projection_.getExtraParamCount()) {
            return null;
        }
        String name = this.projection_.getName();
        String key = name + "-" + pid;
        Object value = this.paramHash_.get(key);
        if (value != null) {
            return value;
        }
        PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
        value = pprefs.getParam(name, pid);
        if (value != null) {
            return value;
        }
        return this.projection_.getParameter(pid).getDefaultObject();
    }

    public boolean setExtraParameter(int pid, Object pvalue) throws NumberFormatException {
        LOGGER.trace("{}, {}", (Object)pid, pvalue);
        if (pid < 0 || pid >= this.projection_.getExtraParamCount()) {
            return false;
        }
        AbstractProjection proj = this.getProjection();
        ProjExtraParameter xparam = proj.getParameter(pid);
        Object xvalue = pvalue;
        if (xvalue == null) {
            try {
                Object oo = xparam.getDefaultObject();
                if (oo != null) {
                    xvalue = oo;
                }
            }
            catch (Exception oo) {
                // empty catch block
            }
        }
        if (xvalue == null) {
            LOGGER.trace("xvalue for extra param {} is null", (Object)pid);
            return false;
        }
        String svalue = null;
        svalue = xvalue instanceof Double ? PFORMAT_10G.sprintfx((double)((Double)xvalue)) : xvalue.toString();
        String pname = this.projection_.getName();
        String key = pname + "-" + pid;
        if (xparam instanceof ProjBooleanParameter) {
            Boolean bb = xvalue instanceof Boolean ? (Boolean)xvalue : Boolean.valueOf(svalue);
            this.paramHash_.put(key, bb);
            ((ProjBooleanParameter)xparam).setSelected(bb);
            return true;
        }
        if (xparam instanceof ProjDoubleParameter) {
            Double dd = xvalue instanceof Double ? (Double)xvalue : StringUtils.parseDouble(svalue);
            this.paramHash_.put(key, dd);
            ((ProjDoubleParameter)xparam).setValue(dd);
            return true;
        }
        if (xparam instanceof ProjIntegerParameter) {
            Integer ii = xvalue instanceof Integer ? (Integer)xvalue : Integer.parseInt(svalue);
            this.paramHash_.put(key, ii);
            ((ProjIntegerParameter)xparam).setValue(ii);
            return true;
        }
        if (xparam instanceof ProjListParameter) {
            try {
                Integer ii = Integer.parseInt(svalue);
                ((ProjListParameter)xparam).setIndex(ii);
                this.paramHash_.put(key, ii);
            }
            catch (Exception exc) {
                ((ProjListParameter)xparam).setValue(svalue);
                ProjListEnum ple = (ProjListEnum)((ProjListParameter)xparam).getValue();
                this.paramHash_.put(key, ple.name());
            }
            return true;
        }
        LOGGER.warn("Unknown xparam class {}", (Object)xparam.getClass());
        return false;
    }

    public boolean isZoomable() {
        if (this.projection_ instanceof Equirectangular || this.projection_ instanceof EquirectangularRegional || this.projection_ instanceof EquirectangularOblique || this.projection_ instanceof TransverseMercator || this.projection_ instanceof AmericanPolyconic || this.projection_ instanceof BonneRegional || this.projection_ instanceof Cassini || this.projection_ instanceof MercatorRegional || this.projection_ instanceof RectangularPolyconic) {
            return true;
        }
        if (this.projection_ instanceof AzimuthalProjection) {
            return ((AzimuthalProjection)this.projection_).getEdgeAngleParameter() != null;
        }
        return this.projection_.hasProperty(16);
    }

    public boolean canZoomIn() {
        if (!this.isZoomable()) {
            return false;
        }
        if (this.projection_ instanceof Equirectangular) {
            return true;
        }
        if (this.projection_ instanceof EquirectangularRegional) {
            try {
                ProjDoubleParameter wp = (ProjDoubleParameter)this.projection_.getParameter(0);
                ProjDoubleParameter hp = (ProjDoubleParameter)this.projection_.getParameter(1);
                double w = wp.getValue();
                double h = hp.getValue();
                return w > wp.getMinimum() || h > hp.getMinimum();
            }
            catch (Exception exc) {
                LOGGER.trace("Exception {}", (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
        }
        if (this.projection_ instanceof MercatorRegional) {
            try {
                ProjDoubleParameter wp = (ProjDoubleParameter)this.projection_.getParameter(0);
                double w = wp.getValue();
                return w > wp.getMinimum();
            }
            catch (Exception exc) {
                LOGGER.trace("Exception {}", (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
        }
        if (this.projection_ instanceof EquirectangularOblique || this.projection_ instanceof TransverseMercator || this.projection_ instanceof AmericanPolyconic || this.projection_ instanceof Cassini) {
            try {
                ProjDoubleParameter hp = (ProjDoubleParameter)this.projection_.getParameter(0);
                double hval = hp.getValue();
                return hval > hp.getMinimum();
            }
            catch (Exception exc) {
                LOGGER.trace("Exception {}", (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
        }
        if (this.projection_ instanceof BonneRegional || this.projection_ instanceof RectangularPolyconic) {
            try {
                ProjDoubleParameter hp = (ProjDoubleParameter)this.projection_.getParameter(1);
                double hval = hp.getValue();
                return hval > hp.getMinimum();
            }
            catch (Exception exc) {
                LOGGER.trace("Exception {}", (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
        }
        if (this.projection_ instanceof AzimuthalProjection) {
            try {
                ProjDoubleParameter cap = ((AzimuthalProjection)this.projection_).getEdgeAngleParameter();
                if (cap == null) {
                    return false;
                }
                double angle = cap.getValue();
                return angle > cap.getMinimum();
            }
            catch (Exception exc) {
                LOGGER.trace("Exception {}", (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
        }
        if (this.projection_ instanceof ConicProjection) {
            try {
                ProjDoubleParameter hp = ((ConicProjection)this.projection_).getHeightParameter();
                double hval = hp.getValue();
                return hval > hp.getMinimum();
            }
            catch (Exception exc) {
                LOGGER.trace("Exception {}", (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
        }
        return false;
    }

    public boolean canZoomOut() {
        if (!this.isZoomable()) {
            return false;
        }
        if (this.projection_ instanceof Equirectangular) {
            return false;
        }
        if (this.projection_ instanceof EquirectangularRegional) {
            try {
                ProjDoubleParameter wp = (ProjDoubleParameter)this.projection_.getParameter(0);
                ProjDoubleParameter hp = (ProjDoubleParameter)this.projection_.getParameter(1);
                double w = wp.getValue();
                double h = hp.getValue();
                return w < wp.getMaximum() || h < hp.getMaximum();
            }
            catch (Exception exc) {
                LOGGER.trace("Exception {}", (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
        }
        if (this.projection_ instanceof MercatorRegional) {
            try {
                ProjDoubleParameter wp = (ProjDoubleParameter)this.projection_.getParameter(0);
                double w = wp.getValue();
                return w < wp.getMaximum();
            }
            catch (Exception exc) {
                LOGGER.trace("Exception {}", (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
        }
        if (this.projection_ instanceof EquirectangularOblique || this.projection_ instanceof TransverseMercator || this.projection_ instanceof AmericanPolyconic || this.projection_ instanceof Cassini) {
            try {
                ProjDoubleParameter hp = (ProjDoubleParameter)this.projection_.getParameter(0);
                double hval = hp.getValue();
                return hval < hp.getMaximum();
            }
            catch (Exception exc) {
                LOGGER.trace("Exception {}", (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
        }
        if (this.projection_ instanceof BonneRegional || this.projection_ instanceof RectangularPolyconic) {
            try {
                ProjDoubleParameter hp = (ProjDoubleParameter)this.projection_.getParameter(1);
                double hval = hp.getValue();
                return hval < hp.getMaximum();
            }
            catch (Exception exc) {
                LOGGER.trace("Exception {}", (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
        }
        if (this.projection_ instanceof AzimuthalProjection) {
            try {
                ProjDoubleParameter cap = ((AzimuthalProjection)this.projection_).getEdgeAngleParameter();
                if (cap == null) {
                    return false;
                }
                double angle = cap.getValue();
                return angle < cap.getMaximum();
            }
            catch (Exception exc) {
                LOGGER.trace("Exception {}", (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
        }
        if (this.projection_ instanceof ConicProjection) {
            try {
                ProjDoubleParameter hp = ((ConicProjection)this.projection_).getHeightParameter();
                double hval = hp.getValue();
                return hval < hp.getMaximum();
            }
            catch (Exception exc) {
                LOGGER.trace("Exception {}", (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
        }
        return false;
    }
}

