/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogarithmicAzimuthal
extends AzimuthalProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Logarithmic Azimuthal";
    private static final double MAX_CLIP_ANGLE = 150.0;
    private static final double DEFAULT_CLIP_ANGLE = 90.0;
    private double centralScaling_ = 5.0;
    private double logSBFactor_;
    private double invLogSBFactor_;
    private final ProjDoubleParameter centParam_;

    public LogarithmicAzimuthal(int width, int height) {
        this(width, height, 0, 0);
    }

    public LogarithmicAzimuthal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addEdgeAngleParameter(90.0, 150.0, false);
        this.centParam_ = new ProjDoubleParameter("Central scaling factor", "Central Scaling", "", 30.0, 0.0, 500.0, false, true);
        this.addParameter(this.centParam_);
        this.addAzimuthalFillParameter();
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        super.parameterChanged(e);
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.centParam_)) {
            this.setCentralScaling(this.centParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setCentralScaling(double csf) {
        this.centralScaling_ = csf;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.logSBFactor_ = Math.log(1.0 + this.centralScaling_ * this.edgeAngleRad_);
        this.invLogSBFactor_ = 1.0 / this.logSBFactor_;
        double lz = Math.log(1.0 + this.centralScaling_ * this.edgeAngleRad_) * this.invLogSBFactor_;
        this.setMaxXYOverRS(lz);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double rhoBOverR = Math.log(1.0 + this.centralScaling_ * Math.toRadians(150.0)) * this.invLogSBFactor_;
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        double z = Math.acos(cosZ);
        double rho = Math.log(1.0 + this.centralScaling_ * z) * this.invLogSBFactor_;
        if (rho < 0.0) {
            return -1.0;
        }
        return rho / Math.sin(z);
    }

    @Override
    protected double getZRadForRho(double rho) {
        double rhoOverRS = rho * this.invRS_;
        if (this.centralScaling_ > 0.0) {
            return (Math.exp(rhoOverRS * this.logSBFactor_) - 1.0) / this.centralScaling_;
        }
        return rhoOverRS;
    }
}

