/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class TimesAtlas
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Times Atlas";
    private static final double CY = 1.7071067811865475;
    private static final double INV_CY = 0.585786437626905;
    private static final double MAX_X_OVER_RS = 2.33992104024675;
    private static final double MAX_Y_OVER_RS = 1.7071067811865475 * Math.tan(Math.toRadians(45.0));
    double invCyRS_ = 0.585786437626905;

    public TimesAtlas(int width, int height) {
        this(width, height, 0, 0);
    }

    public TimesAtlas(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.33992104024675, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.invCyRS_ = 0.585786437626905 * this.invRS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(lat);
        double tanHalfPhi = Math.tan(0.5 * phiRad);
        double lambdaRad = this.lonToLambdaRad(lon);
        double sinTerm = Math.sin(0.7853981633974483 * tanHalfPhi);
        double x = lambdaRad * (0.74482 - 0.34588 * sinTerm * sinTerm);
        double y = 1.7071067811865475 * tanHalfPhi;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = 2.0 * Math.atan(y * this.invCyRS_);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double tanHalfPhi = Math.tan(0.5 * phiRad);
        double sinTerm = Math.sin(0.7853981633974483 * tanHalfPhi);
        double lambdaRad = x * this.invRS_ / (0.74482 - 0.34588 * sinTerm * sinTerm);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        TimesAtlas timesAtlas = this;
        synchronized (timesAtlas) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = 2.0 * Math.atan((y = (double)iy + 0.5) * this.invCyRS_)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double tanHalfPhi = Math.tan(0.5 * phiRad);
                double sinTerm = Math.sin(0.7853981633974483 * tanHalfPhi);
                double xFactor = this.invRS_ / (0.74482 - 0.34588 * sinTerm * sinTerm);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

