/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjListEnum;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wagner2
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Wagner II";
    private ProjListParameter variantParam_ = new ProjListParameter("Variant", "Variant", Variant.class, 0);
    private Variant variant_;
    private double cx_ = 1.0;
    private double cy_ = 1.0;
    private double cm1_ = 1.0;
    private double cm2_ = 1.0;
    private double invCx_ = 1.0;
    private double invCy_ = 1.0;
    private double invCm1_ = 1.0;
    private double invCm2_ = 1.0;
    private double invCxRS_ = 1.0;
    private double invCyRS_ = 1.0;

    public Wagner2(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.0, 1.0);
        this.addParameter(this.variantParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.variantParam_)) {
            int varIndex = this.variantParam_.getIndex();
            this.variant_ = Variant.values()[varIndex];
            LOGGER.trace("variant {}", (Object)this.variant_);
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.cx_ = this.variant_.getCx();
        this.cy_ = this.variant_.getCy();
        this.cm1_ = this.variant_.getCm1();
        this.cm2_ = this.variant_.getCm2();
        this.invCx_ = 1.0 / this.cx_;
        this.invCy_ = 1.0 / this.cy_;
        this.invCm1_ = 1.0 / this.cm1_;
        this.invCm2_ = 1.0 / this.cm2_;
        double wfactor = this.cx_ * Math.PI;
        double hfactor = this.cy_ * Math.asin(this.cm1_ * Math.sin(this.cm2_ * 1.5707963267948966));
        this.setMaxXYOverRS(wfactor, hfactor);
    }

    @Override
    protected final void finishScaling() {
        this.invCxRS_ = this.invCx_ * this.invRS_;
        this.invCyRS_ = this.invCy_ * this.invRS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(lat);
        double psiRad = Math.asin(this.cm1_ * Math.sin(this.cm2_ * phiRad));
        double x = this.cx_ * this.lonToLambdaRad(lon) * Math.cos(psiRad);
        double y = this.cy_ * psiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double psiRad = y * this.invCyRS_;
        double phiRad = Math.asin(Math.sin(psiRad) * this.invCm1_) * this.invCm2_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invCxRS_ / Math.cos(psiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner2 wagner2 = this;
        synchronized (wagner2) {
            double y;
            double psiRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(Math.sin(psiRad = (y = (double)iy + 0.5) * this.invCyRS_) * this.invCm1_) * this.invCm2_) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invCxRS_ / Math.cos(psiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    private static enum Variant implements ProjListEnum
    {
        WAGNER1("Wagner II", 0.8802, 0.8855, 0.6666666666666666),
        CANTERSW02("Canters W02", 0.7223, 0.8855, 0.4921);

        private String text_;
        private double cx_;
        private double cy_;
        private double cm1_;
        private double cm2_;

        private Variant(String text, double m1, double m2, double n2) {
            this.text_ = text;
            this.cm1_ = m1;
            this.cm2_ = m2;
            this.cx_ = n2 / Math.sqrt(n2 * m1 * m2);
            this.cy_ = 1.0 / Math.sqrt(n2 * m1 * m2);
        }

        double getCx() {
            return this.cx_;
        }

        double getCy() {
            return this.cy_;
        }

        double getCm1() {
            return this.cm1_;
        }

        double getCm2() {
            return this.cm2_;
        }

        public String toString() {
            return this.text_;
        }

        @Override
        public boolean matches(String str) {
            return this.nameMatches(str) || this.textMatches(str);
        }

        public boolean nameMatches(String str) {
            return this.name().equalsIgnoreCase(str);
        }

        public boolean textMatches(String str) {
            return this.text_.equalsIgnoreCase(str);
        }
    }
}

