/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.io;

import gov.nasa.giss.data.nc.NcConfig;
import gov.nasa.giss.data.nc.NcFileUtils;
import gov.nasa.giss.data.nc.NcFilenameFilter;
import gov.nasa.giss.graphics.ColorTableFilenameFilter;
import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.img.SvgUtils;
import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.io.FtypeInfo;
import gov.nasa.giss.io.FtypeInfoHash;
import gov.nasa.giss.macos.MacNative;
import gov.nasa.giss.map.kml.KMLDataFilenameFilter;
import gov.nasa.giss.map.kml.KMLDataResourceList;
import gov.nasa.giss.map.overlay.OverlayFilenameFilter;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.io.PanGribTableOptionsDialog;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.task.PanOpenCatalogTask;
import gov.nasa.giss.panoply.task.PanOpenDatasetTask;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanQuitHandler;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.ui.filechooser.OpenFileChooser;
import gov.nasa.giss.ui.filechooser.SaveFileChooser;
import gov.nasa.giss.ui.filechooser.SelectDirectoryChooser;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.DatasetUrl;

public final class PanFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private static final String REMOTE_DATASET_MESSAGE = "Enter the URL of a remote dataset to open:";
    private static final String REMOTE_CATALOG_MESSAGE = "Enter the URL of a remote data catalog to open:";
    private static final String DOT = ".";
    private static final String DEFAULT_IMG_EXT = "png";
    private static boolean isMacNative_;
    private static OpenFileChooser openChooser_;
    private static SaveFileChooser saveChooser_;
    private static Dimension chooserSize_;
    private static FtypeInfoHash inputFtypes_;
    private static FtypeInfoHash outputFtypes_;
    private static String lastRemoteFileAddress_;
    private static String lastRemoteCatalogAddress_;

    public static File[] showOpenAnyFileChooser(PanFrame pf) {
        return PanFileUtils.showOpenLocalFileChooser(pf, "Open", PanFileUtils.getAllFileTypesArray());
    }

    public static File[] showOpenDataFileChooser(PanFrame pf) {
        return PanFileUtils.showOpenLocalFileChooser(pf, "Open Data File", PanFileUtils.getAllDataTypesArray());
    }

    public static File[] showOpenColorTableFileChooser(PanFrame pf) {
        return PanFileUtils.showOpenLocalFileChooser(pf, "Open Color Table", PanFileUtils.getAllClutTypesArray());
    }

    public static File[] showOpenOverlayFileChooser(PanFrame pf) {
        return PanFileUtils.showOpenLocalFileChooser(pf, "Open Overlay", PanFileUtils.getAllOverlayTypesArray());
    }

    public static File[] showOpenKMLFileChooser(PanFrame pf) {
        return PanFileUtils.showOpenLocalFileChooser(pf, "Open Ground Overlay", "kml");
    }

    private static File[] showOpenLocalFileChooser(PanFrame pf, String title, String ... ftypeKeys) {
        String startpath = PREFS.getString("files:open.path");
        String[][] ftypeData = inputFtypes_.toFtypeInfoArray(ftypeKeys);
        File[] ff = null;
        if (isMacNative_) {
            PanQuitHandler.setEnabled(false);
            MacNative panel = new MacNative();
            String[] paths = panel.showOpenDialog(title + "\u2026", ftypeData, startpath, ftypeKeys[0], false, true);
            PanQuitHandler.setEnabled(true);
            if (paths == null) {
                return null;
            }
            ff = new File[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                ff[i] = new File(paths[i]);
            }
        } else {
            if (openChooser_ == null) {
                openChooser_ = new OpenFileChooser();
                openChooser_.setMultiSelectionEnabled(false);
                openChooser_.setAcceptAllFileFilterUsed(false);
            }
            openChooser_.setDialogTitle(title);
            Dimension dsize = PanFileUtils.getChooserSize();
            if (dsize != null) {
                openChooser_.setPreferredSize(dsize);
            }
            openChooser_.resetChoosableFileFilters();
            openChooser_.addFtypeDataFilters(ftypeData);
            openChooser_.setCurrentDirectory(startpath);
            int returnVal = openChooser_.showOpenDialog(pf);
            PanFileUtils.setChooserSize(openChooser_.getSize());
            if (returnVal == 0) {
                ff = openChooser_.getSelectedFiles();
            }
        }
        if (ff == null) {
            return null;
        }
        if (ff.length == 0) {
            LOGGER.debug("File chooser response had length 0");
            return null;
        }
        if (!PREFS.getBoolean("files:open.preferred")) {
            PREFS.set("files:open.path", ff[0].getParent());
        }
        return ff;
    }

    public static File showOpenLocalZarrDirChooser(PanFrame pf) {
        String startpath = PREFS.getString("files:open.path");
        File ff = null;
        SelectDirectoryChooser chooser = new SelectDirectoryChooser();
        chooser.setDialogTitle("Open Zarr Directory Store\u2026");
        Dimension dsize = PanFileUtils.getChooserSize();
        if (dsize != null) {
            chooser.setPreferredSize(dsize);
        }
        chooser.setCurrentDirectory(startpath);
        int returnVal = chooser.showOpenDialog(pf);
        PanFileUtils.setChooserSize(chooser.getSize());
        if (returnVal == 0) {
            ff = chooser.getSelectedFile();
        }
        if (ff == null) {
            return null;
        }
        if (!PREFS.getBoolean("files:open.preferred")) {
            PREFS.set("files:open.path", ff.getParent());
        }
        return ff;
    }

    public static String showOpenRemoteDatasetDialog(PanFrame pf) {
        String address = PanFileUtils.showOpenRemoteDialog(pf, RemoteType.DATASET);
        LOGGER.trace("address, '{}'", (Object)address);
        if (address == null) {
            return null;
        }
        if (address.length() == 0) {
            LOGGER.trace("address is empty");
            return null;
        }
        if (address.matches("^\\s*$")) {
            LOGGER.trace("address is all whitespace");
            return null;
        }
        try {
            DatasetUrl durl = NcFileUtils.createDatasetUrl(address);
            if (durl != null) {
                LOGGER.trace("String address looks good for creating a DatasetUrl");
                return address;
            }
            LOGGER.trace("Creating a DatasetUrl returned a null");
        }
        catch (Exception exc) {
            LOGGER.trace("Unable to create DatasetUrl from {}", (Object)address);
        }
        try {
            URL url = new URL(address);
            if (url != null) {
                LOGGER.trace("String address looks good for creating a URL");
                return address;
            }
            LOGGER.trace("Creating a URL just returned a null");
        }
        catch (Exception ignore) {
            LOGGER.trace("Unable to create URL from {}", (Object)address);
        }
        SlowMessage.show((Component)pf, "File Error", "Unable to create a URL or DatasetUrl from that address.");
        return null;
    }

    public static Object showOpenRemoteCatalogDialog(PanFrame pf) {
        String address = PanFileUtils.showOpenRemoteDialog(pf, RemoteType.CATALOG);
        try {
            URL url = new URL(address);
            LOGGER.trace("Returning a URL");
            return url;
        }
        catch (Exception ignore) {
            LOGGER.trace("Unable to create URL from {}", (Object)address);
            LOGGER.trace("Unable to create URL from {}", (Object)address);
            LOGGER.trace("Trying to create a DatasetUrl");
            try {
                return NcFileUtils.createDatasetUrl(address);
            }
            catch (Exception exc) {
                SlowMessage.show((Component)pf, "File Error", "I could not parse that address as a DatasetUrl. " + exc.getMessage());
                LOGGER.warn("Exception creating DatasetUrl: {}", (Object)exc.getMessage());
                return null;
            }
        }
    }

    private static String showOpenRemoteDialog(PanFrame pf, RemoteType rtype) {
        JOptionPane loadPane = new JOptionPane("", 3, 0, null, new String[]{"Load", "Cancel"});
        loadPane.setWantsInput(true);
        if (rtype == RemoteType.DATASET) {
            if (lastRemoteFileAddress_ != null && lastRemoteFileAddress_.length() > 0) {
                loadPane.setInitialSelectionValue(lastRemoteFileAddress_);
            }
            loadPane.setMessage(REMOTE_DATASET_MESSAGE);
        } else {
            if (lastRemoteCatalogAddress_ != null && lastRemoteCatalogAddress_.length() > 0) {
                loadPane.setInitialSelectionValue(lastRemoteCatalogAddress_);
            }
            loadPane.setMessage(REMOTE_CATALOG_MESSAGE);
        }
        Dimension d = loadPane.getPreferredSize();
        if (d.width < 540) {
            d.width = 540;
            loadPane.setPreferredSize(d);
            loadPane.setPreferredSize(d);
        }
        loadPane.createDialog(pf, "Open Remote").setVisible(true);
        Object choice = loadPane.getValue();
        if (choice == null) {
            LOGGER.trace("Close dialog. No choice made");
            return null;
        }
        if (!"Load".equals(choice.toString())) {
            LOGGER.trace("Apparently 'Cancel' selected");
            return null;
        }
        String address = loadPane.getInputValue().toString();
        if (address == null || address.isEmpty()) {
            LOGGER.trace("Address was null or empty");
            return null;
        }
        if (rtype == RemoteType.DATASET) {
            lastRemoteFileAddress_ = address;
        } else {
            lastRemoteCatalogAddress_ = address;
        }
        return address;
    }

    public static File showSaveImageFileChooser(PanFrame pf, String fnameRoot, String fnameExt) {
        String[][] ftypeData = SvgUtils.isSvgAvailable() ? outputFtypes_.toFtypeInfoArray("gif", "jpeg", "pdf", DEFAULT_IMG_EXT, "ps", "svg", "tiff") : outputFtypes_.toFtypeInfoArray("gif", "jpeg", "pdf", DEFAULT_IMG_EXT, "ps", "tiff");
        String xfnameExt = fnameExt;
        File file = null;
        String dpath = PREFS.getString("files:save.path");
        if (dpath.isEmpty()) {
            dpath = null;
        }
        String fullname = fnameRoot + DOT + xfnameExt;
        if (!((FtypeInfo)outputFtypes_.get("img")).accepts(fullname)) {
            xfnameExt = DEFAULT_IMG_EXT;
            fullname = fnameRoot + ".png";
        }
        if (isMacNative_) {
            MacNative panel;
            String result;
            if (dpath.isEmpty()) {
                dpath = null;
            }
            if ((result = (panel = new MacNative()).showSaveDialog("Save image as\u2026", ftypeData, dpath, fullname, xfnameExt)) == null) {
                return null;
            }
            file = new File(result);
        } else {
            Dimension dsize;
            if (saveChooser_ == null) {
                saveChooser_ = new SaveFileChooser(ftypeData);
            }
            if ((dsize = PanFileUtils.getChooserSize()) != null) {
                saveChooser_.setPreferredSize(dsize);
            }
            if (dpath != null) {
                try {
                    saveChooser_.setCurrentDirectory(new File(dpath));
                }
                catch (Exception exc) {
                    LOGGER.trace("Failed to set directory: {}", (Object)exc.getMessage());
                }
            }
            saveChooser_.setFileName(fullname);
            saveChooser_.setExtension(xfnameExt);
            int returnVal = saveChooser_.showSaveDialog(pf);
            PanFileUtils.setChooserSize(saveChooser_.getSize());
            if (returnVal != 0) {
                return null;
            }
            file = saveChooser_.getSelectedFile();
        }
        if (file == null) {
            return null;
        }
        Object fname = file.getName();
        String xfnameRoot = FileUtils.extractFnameRoot(file);
        boolean goodExtension = ((FtypeInfo)outputFtypes_.get("img")).accepts(file);
        if (!goodExtension) {
            xfnameRoot = fname;
            xfnameExt = DEFAULT_IMG_EXT;
            fname = xfnameRoot + ".png";
            file = new File(file.getParent(), (String)fname);
        }
        PREFS.set("files:save.path", file.getParent());
        return file;
    }

    public static File showSingleTypeSaveFileChooser(PanFrame pf, String title, String fnameRoot, String fnameExt) {
        String dotExt;
        String[][] ftypeData = outputFtypes_.toFtypeInfoArray(fnameExt);
        String dpath = PREFS.getString("files:save.path");
        String fullname = fnameRoot + DOT + fnameExt;
        File file = null;
        if (isMacNative_) {
            MacNative panel;
            String result;
            if (dpath.isEmpty()) {
                dpath = null;
            }
            if ((result = (panel = new MacNative()).showSaveDialog(title, ftypeData, dpath, fullname, fnameExt)) == null) {
                return null;
            }
            file = new File(result);
        } else {
            Dimension dsize;
            SaveFileChooser chooser = new SaveFileChooser(ftypeData);
            if (dpath.length() > 0) {
                try {
                    chooser.setCurrentDirectory(new File(dpath));
                }
                catch (Exception result) {
                    // empty catch block
                }
            }
            if ((dsize = PanFileUtils.getChooserSize()) != null) {
                chooser.setPreferredSize(dsize);
            }
            chooser.setDialogTitle(title);
            chooser.setFileName(fullname);
            chooser.setExtension(fnameExt);
            int returnVal = chooser.showSaveDialog(pf);
            PanFileUtils.setChooserSize(chooser.getSize());
            if (returnVal != 0) {
                return null;
            }
            file = chooser.getSelectedFile();
        }
        if (file == null) {
            return null;
        }
        PREFS.set("files:save.path", file.getParent());
        String xfnameRoot = FileUtils.extractFnameRoot(file);
        if (xfnameRoot == null) {
            return null;
        }
        String fname = file.getName();
        String lcname = fname.toLowerCase();
        if (!lcname.endsWith(dotExt = DOT + fnameExt.toLowerCase())) {
            file = new File(file.getParent(), fname + dotExt);
        }
        return file;
    }

    public static Object openLocalFiles(PanFrame pf, File ... files) {
        if (files == null) {
            return null;
        }
        ArrayList<File> datasets = new ArrayList<File>(5);
        ArrayList<File> ctables = new ArrayList<File>(5);
        ArrayList<File> overlays = new ArrayList<File>(5);
        ArrayList<File> kmls = new ArrayList<File>(5);
        for (File f : files) {
            if (f == null) continue;
            if (ColorTableFilenameFilter.isColorTableName(f)) {
                ctables.add(f);
                continue;
            }
            if (OverlayFilenameFilter.isOverlayName(f)) {
                overlays.add(f);
                continue;
            }
            if (KMLDataFilenameFilter.isKMLName(f)) {
                kmls.add(f);
                continue;
            }
            datasets.add(f);
        }
        LOGGER.trace("Datasets list includes {} files to open.", (Object)datasets.size());
        if (!ctables.isEmpty()) {
            ColorTableResourceList reslist = PanResourceUtils.getColorTableList();
            if (PREFS.getBoolean("files:autoimport.colorbars")) {
                reslist.addAlphabetic((Component)pf, true, ctables.toArray(new File[0]));
            } else {
                reslist.addAlphabetic((Component)pf, ctables);
            }
        }
        if (!overlays.isEmpty()) {
            OverlayResourceList olset = PanResourceUtils.getOverlayList();
            if (PREFS.getBoolean("files:autoimport.overlays")) {
                olset.addAlphabetic((Component)pf, true, overlays.toArray(new File[0]));
            } else {
                olset.addAlphabetic((Component)pf, overlays);
            }
        }
        if (!kmls.isEmpty()) {
            KMLDataResourceList kmlset = PanResourceUtils.getUnderlayList();
            kmlset.addAlphabetic((Component)pf, kmls);
        }
        if (!datasets.isEmpty()) {
            Object o = null;
            for (File f : datasets) {
                o = PanFileUtils.openLocalDataset(pf, f);
            }
            return o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object openLocalDataset(PanFrame pf, File f) {
        Objects.requireNonNull(f, "File cannot be null.");
        if (!f.exists()) {
            FileUtils.showFileError((Component)pf, f.getName(), "File doesn't seem to exist.");
            return null;
        }
        if (NcFilenameFilter.accept(f)) {
            PanSourcesFrame sourcesFrame;
            PanSourcesFrame panSourcesFrame = sourcesFrame = PanSourcesFrame.getSharedInstance();
            synchronized (panSourcesFrame) {
                PanFileUtils.openDatasetUsingTask(f);
                if (!Panoply.isStarting()) {
                    sourcesFrame.reveal();
                }
            }
            return null;
        }
        if (((FtypeInfo)inputFtypes_.get("gtab")).accepts(f)) {
            PanGribTableOptionsDialog gtod = new PanGribTableOptionsDialog(pf);
            gtod.setVisible(true);
            if (!gtod.isSuccessful()) {
                return null;
            }
            int[] results = gtod.getResponses();
            boolean success = NcConfig.openGrib1Table(f, results[0], results[1], results[2]);
            if (!success) {
                JOptionPane.showMessageDialog(pf, "I was not able to read a GRIBTAB.");
            }
        } else {
            PanSourcesFrame sourcesFrame;
            PanSourcesFrame panSourcesFrame = sourcesFrame = PanSourcesFrame.getSharedInstance();
            synchronized (panSourcesFrame) {
                try {
                    PanFileUtils.openDatasetUsingTask(f);
                }
                catch (Exception exc) {
                    LOGGER.warn("Skipping '{}' due to {}.", (Object)f.getName(), (Object)exc.toString());
                    return null;
                }
                if (!Panoply.isStarting()) {
                    sourcesFrame.reveal();
                }
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object openLocalDataset(PanFrame pf, String address) {
        Objects.requireNonNull(address, "File address cannot be null.");
        File f = null;
        try {
            f = address.startsWith("file:") ? new File(address.substring(5)) : new File(address);
        }
        catch (Exception exc) {
            LOGGER.debug("Error creating File object, {}", (Object)exc.getMessage());
            throw new IllegalArgumentException("Could not create File from address.");
        }
        if (!f.exists()) {
            LOGGER.warn("No file found at {}", (Object)f.getPath());
            FileUtils.showFileError((Component)pf, f.getName(), "No file seems to exist at that address.");
            return null;
        }
        if (((FtypeInfo)inputFtypes_.get("gtab")).accepts(f)) {
            PanGribTableOptionsDialog gtod = new PanGribTableOptionsDialog(pf);
            gtod.setVisible(true);
            if (!gtod.isSuccessful()) {
                return null;
            }
            int[] results = gtod.getResponses();
            boolean success = NcConfig.openGrib1Table(f, results[0], results[1], results[2]);
            if (!success) {
                JOptionPane.showMessageDialog(pf, "Not able to read file as a GRIBTAB.");
            }
        } else {
            PanSourcesFrame sourcesFrame;
            PanSourcesFrame panSourcesFrame = sourcesFrame = PanSourcesFrame.getSharedInstance();
            synchronized (panSourcesFrame) {
                PanFileUtils.openDatasetUsingTask(f);
                if (!Panoply.isStarting()) {
                    sourcesFrame.reveal();
                }
            }
        }
        return null;
    }

    public static void openDatasetUsingTask(String address) {
        try {
            PanFileUtils.convertStringToAddress(address);
        }
        catch (Exception exc) {
            throw new RuntimeException("Address string does not look like URL or File.");
        }
        PanFrame pf = PanFrame.getActivePanFrame();
        pf.addTask(new PanOpenDatasetTask(address));
    }

    public static void openDatasetUsingTask(File f) {
        PanFrame pf = PanFrame.getActivePanFrame();
        pf.addTask(new PanOpenDatasetTask(f));
    }

    public static void openDatasetUsingTask(URL url) {
        PanFrame pf = PanFrame.getActivePanFrame();
        pf.addTask(new PanOpenDatasetTask(url));
    }

    public static void openCatalogUsingTask(PanFrame pf, Object address) {
        PanFrame actf = pf == null ? PanFrame.getActivePanFrame() : pf;
        actf.addTask(new PanOpenCatalogTask(address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object openLocalZarrStore(PanFrame pf, File f) {
        PanSourcesFrame sourcesFrame;
        Objects.requireNonNull(f, "Directory address cannot be null.");
        if (!f.exists()) {
            FileUtils.showFileError((Component)pf, f.getName(), "Directory doesn't seem to exist.");
            return null;
        }
        if (!f.isDirectory()) {
            FileUtils.showFileError((Component)pf, f.getName(), "Address is not a directory.");
            return null;
        }
        PanSourcesFrame panSourcesFrame = sourcesFrame = PanSourcesFrame.getSharedInstance();
        synchronized (panSourcesFrame) {
            pf.addTask(new PanOpenDatasetTask(f));
            if (!Panoply.isStarting()) {
                sourcesFrame.reveal();
            }
        }
        return null;
    }

    public static Object convertStringToAddress(String s) throws MalformedURLException {
        Objects.requireNonNull(s, "Address string cannot be null.");
        if (s.startsWith("http:") || s.startsWith("https:") || s.startsWith("ftp:")) {
            return new URL(s);
        }
        Object ss = s.replaceFirst("file:", "");
        if (((String)ss).charAt(0) == '~') {
            String homeDir = System.getProperty("user.home");
            ss = homeDir + ((String)ss).substring(1);
        }
        return new File((String)ss);
    }

    private static Dimension getChooserSize() {
        if (chooserSize_ == null) {
            PanPreferences prefs = PanPreferences.getSharedInstance();
            Dimension dd = new Dimension(prefs.getInt("files:dialog.width"), prefs.getInt("files:dialog.height"));
            if (dd.width > 25 && dd.height > 25) {
                chooserSize_ = dd;
            } else {
                return null;
            }
        }
        return chooserSize_;
    }

    private static void setChooserSize(Dimension dsize) {
        if (dsize == null) {
            return;
        }
        chooserSize_ = dsize;
        PanPreferences prefs = PanPreferences.getSharedInstance();
        prefs.setInt("files:dialog.width", dsize.width);
        prefs.setInt("files:dialog.height", dsize.height);
    }

    private static String[] getAllFileTypesArray() {
        return new String[]{"all", "data", "nc", "hdf", "grib", "gem", "ctab", "act", "cpt", "cwc", "gct", "rgb", "olay", "cno", "shp", "mask", "any"};
    }

    private static String[] getAllDataTypesArray() {
        return new String[]{"data", "nc", "hdf", "grib", "gem"};
    }

    private static String[] getAllClutTypesArray() {
        return new String[]{"ctab", "act", "cpt", "cwc", "gct", "rgb"};
    }

    private static String[] getAllOverlayTypesArray() {
        return new String[]{"olay", "cno", "shp", "mask"};
    }

    private static void initInputFtypeInfo() {
        inputFtypes_ = new FtypeInfoHash();
        inputFtypes_.put("nc", new FtypeInfo("netCDF datasets", NcFilenameFilter.getExtensions(NcFilenameFilter.FilterType.NETCDF)));
        inputFtypes_.put("hdf", new FtypeInfo("HDF datasets", NcFilenameFilter.getExtensions(NcFilenameFilter.FilterType.HDF)));
        inputFtypes_.put("grib", new FtypeInfo("GRIB datasets", NcFilenameFilter.getExtensions(NcFilenameFilter.FilterType.GRIB)));
        inputFtypes_.put("gem", new FtypeInfo("GEMPAK datasets", NcFilenameFilter.getExtensions(NcFilenameFilter.FilterType.GEMPAK)));
        inputFtypes_.put("gtab", new FtypeInfo("GRIB-1 tables", "gribtab,tab"));
        inputFtypes_.put("act", new FtypeInfo("Adobe color tables", "act"));
        inputFtypes_.put("cwc", new FtypeInfo("ClarisWorks color tables", "cwc"));
        inputFtypes_.put("ggr", new FtypeInfo("GIMP gradient files", "ggr"));
        inputFtypes_.put("gpl", new FtypeInfo("GIMP palette files", "gpl"));
        inputFtypes_.put("gct", new FtypeInfo("GISS color tables", "gct"));
        inputFtypes_.put("cpt", new FtypeInfo("GMT CPT color tables", "cpt"));
        inputFtypes_.put("rgb", new FtypeInfo("NCL RGB color tables", "rgb"));
        inputFtypes_.put("pal", new FtypeInfo("PAL color tables", "pal,pal1,pal2"));
        inputFtypes_.put("cno", new FtypeInfo("CNO overlays", "cno,cnob"));
        inputFtypes_.put("shp", new FtypeInfo("Shapefiles", "shp"));
        inputFtypes_.put("mask", new FtypeInfo("B/W image mask overlays", "gif,png"));
        inputFtypes_.put("kml", new FtypeInfo("KMZ ground overlays", "kmz"));
        inputFtypes_.groupTypes("data", "All recognized datasets", "nc", "hdf", "grib", "gem");
        inputFtypes_.groupTypes("ctab", "All color tables", "act", "cwc", "ggr", "gpl", "gct", "cpt", "rgb", "pal");
        inputFtypes_.groupTypes("olay", "All overlay files", "cno", "shp", "mask");
        inputFtypes_.groupTypes("all", "All recognized files", "data", "ctab", "olay");
        inputFtypes_.put("any", new FtypeInfo("All files", ""));
    }

    private static void initOutputFtypeInfo() {
        outputFtypes_ = new FtypeInfoHash();
        outputFtypes_.put("gif", new FtypeInfo("GIF image", "gif"));
        outputFtypes_.put("jpeg", new FtypeInfo("JPEG image", "jpg,jpeg"));
        outputFtypes_.put(DEFAULT_IMG_EXT, new FtypeInfo("PNG image", DEFAULT_IMG_EXT));
        outputFtypes_.put("tiff", new FtypeInfo("TIFF image", "tif,tiff"));
        outputFtypes_.put("pdf", new FtypeInfo("PDF file", "pdf"));
        outputFtypes_.put("ps", new FtypeInfo("PostScript file", "ps"));
        outputFtypes_.put("svg", new FtypeInfo("SVG file", "svg"));
        if (SvgUtils.isSvgAvailable()) {
            LOGGER.trace("SVG library is available");
            outputFtypes_.groupTypes("img", "All saveable graphics types", "gif", "jpeg", DEFAULT_IMG_EXT, "tiff", "pdf", "ps", "svg");
        } else {
            LOGGER.trace("SVG library is NOT available");
            outputFtypes_.groupTypes("img", "All saveable graphics types", "gif", "jpeg", DEFAULT_IMG_EXT, "tiff", "pdf", "ps");
        }
        outputFtypes_.put("kmz", new FtypeInfo("KMZ ground overlay", "kmz"));
        outputFtypes_.put("pcl", new FtypeInfo("PanoplyCL script", "pcl,pancl,panjs,pjs"));
        outputFtypes_.put("cdl", new FtypeInfo("CDL data file", "cdl"));
        outputFtypes_.put("csv", new FtypeInfo("CSV data file", "csv"));
        outputFtypes_.put("txt", new FtypeInfo("CSV data file", "txt,text"));
        outputFtypes_.put("mp4", new FtypeInfo("MP4 video", "mp4"));
        outputFtypes_.put("log", new FtypeInfo("Text logfile", "log"));
        outputFtypes_.put("nc3", new FtypeInfo("netCDF-3 data file", "nc3"));
    }

    public static boolean isLocalFile(URL url) {
        return "file".equalsIgnoreCase(url.getProtocol());
    }

    public static boolean isLocalFile(String addrStr) {
        if (addrStr.startsWith("file:") || addrStr.startsWith("/") || !addrStr.contains(":")) {
            return true;
        }
        try {
            DatasetUrl.findDatasetUrl(addrStr);
        }
        catch (Exception exc) {
            LOGGER.trace("Cannot create a DatasetUrl from {}", (Object)addrStr);
            return false;
        }
        List<String> protocols = DatasetUrl.getProtocols(addrStr);
        int isize = protocols.size();
        for (int i = 0; i < isize; ++i) {
            if (!"file".equalsIgnoreCase(protocols.get(i))) continue;
            return true;
        }
        return false;
    }

    private PanFileUtils() {
    }

    static {
        if (!PlatformUtils.isHeadless()) {
            if (PlatformUtils.isMacintosh()) {
                try {
                    isMacNative_ = MacNative.isLoaded();
                    if (!isMacNative_) {
                        LOGGER.info("Failed to load libgiss, perhaps because it isn't present.");
                    }
                }
                catch (ExceptionInInitializerError err) {
                    LOGGER.info("Failed to load libgiss due to initializer error.");
                    isMacNative_ = false;
                }
                catch (Exception exc) {
                    LOGGER.info("Failed to load libgiss due to {}", (Object)exc.getClass().getSimpleName());
                    isMacNative_ = false;
                }
                if (!isMacNative_) {
                    LOGGER.info("You're going to get the standard Java file chooser.");
                }
            }
            PanFileUtils.initInputFtypeInfo();
            PanFileUtils.initOutputFtypeInfo();
        }
    }

    private static enum RemoteType {
        DATASET,
        CATALOG;

    }
}

