/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.task;

import gov.nasa.giss.data.nc.NcDump;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.util.task.Task;
import java.awt.Component;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportTextTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanSourcesFrame parent_;
    private final NcVariable node_;
    private final File file_;
    private String errMsg_;

    public PanExportTextTask(PanSourcesFrame parent, NcVariable node, File file) {
        super("Exporting labeled text file");
        Objects.requireNonNull(node, "Cannot export a null node.");
        this.parent_ = parent;
        this.node_ = node;
        this.file_ = file;
    }

    @Override
    protected Object beginTask() {
        block2: {
            try {
                NcDump.exportLabeledText(this.file_, this.node_);
            }
            catch (Exception exc) {
                this.errMsg_ = exc.toString();
                LOGGER.error("Could not write labeled data to text file.");
                LOGGER.error(exc.toString());
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected void finishTask() {
        if (this.errMsg_ != null) {
            SlowMessage.show((Component)this.parent_, "Output Error", new StringBuilder("There was an error writing the text file: ").append(this.errMsg_));
        }
    }
}

