/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.ui.BottomBar;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.StatusProgressBar;
import gov.nasa.giss.ui.plaf.EmphasizedLabelUI;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.task.TaskQueue;
import gov.nasa.giss.util.task.TaskQueueEvent;
import gov.nasa.giss.util.task.TaskQueueListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusBar
extends BottomBar
implements TaskQueueListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final StatusProgressBar pbar_ = new StatusProgressBar();
    private final JLabel noteLabel_;
    private final Component strut_;
    private final Component glue_;

    public StatusBar() {
        this(24);
    }

    public StatusBar(int height) {
        super(height);
        this.pbar_.setIndeterminate(true);
        this.pbar_.setStringPainted(false);
        this.pbar_.setBorderPainted(true);
        GuiUtils.setSizeMini(this.pbar_);
        Insets ins = this.getInsets();
        Dimension d = this.pbar_.getPreferredSize();
        d.width = Math.max(d.width, 200);
        d.height = Math.min(d.height, height - ins.top - ins.bottom);
        this.pbar_.setPreferredSize(d);
        this.pbar_.setMaximumSize(d);
        this.noteLabel_ = new JLabel("X");
        GuiUtils.setSizeMini(this.noteLabel_);
        Font f = this.noteLabel_.getFont();
        if (PlatformUtils.isMacintosh()) {
            this.noteLabel_.setUI(new EmphasizedLabelUI());
        }
        this.noteLabel_.setFont(f);
        this.noteLabel_.setPreferredSize(null);
        this.noteLabel_.setMinimumSize(null);
        this.noteLabel_.setMaximumSize(null);
        this.noteLabel_.setText(" ");
        this.strut_ = Box.createHorizontalStrut(6);
        this.glue_ = Box.createHorizontalGlue();
        this.add(this.pbar_);
        this.add(this.strut_);
        this.add(this.noteLabel_);
        this.add(this.glue_);
        int h = Math.max(this.pbar_.getPreferredSize().height, this.noteLabel_.getPreferredSize().height);
        this.setSize(h += this.getInsets().top + this.getInsets().bottom);
        TaskQueue.getSharedInstance().addQueueListener(this);
    }

    @Override
    public void taskStarted(TaskQueueEvent tqe) {
        StringBuilder sb = new StringBuilder("");
        TaskQueue queue = TaskQueue.getSharedInstance();
        int size = queue.size();
        if (size == 1) {
            sb.append("1 task");
        } else {
            sb.append(size).append(" tasks");
        }
        sb.append("\u2026 ").append(queue.getCurrentTask().getDescription());
        this.noteLabel_.setText(sb.toString());
        this.pbar_.setActive(true);
        this.validate();
        this.repaint();
    }

    @Override
    public void taskCompleted(TaskQueueEvent tqe) {
        if (LOGGER.isDebugEnabled()) {
            this.noteLabel_.setText("Task completed");
        } else {
            this.noteLabel_.setText("");
        }
        this.pbar_.setActive(false);
        this.validate();
        this.repaint();
    }

    @Override
    public void taskCanceled(TaskQueueEvent tqe) {
        if (LOGGER.isDebugEnabled()) {
            this.noteLabel_.setText("Task cancelled");
        } else {
            this.noteLabel_.setText("");
        }
        this.pbar_.setActive(false);
        this.validate();
        this.repaint();
    }

    @Override
    public void queueEmptied(TaskQueueEvent tqe) {
        if (LOGGER.isDebugEnabled()) {
            this.noteLabel_.setText("No tasks in progress");
        } else {
            this.noteLabel_.setText("");
        }
        this.pbar_.setActive(false);
        this.validate();
        this.repaint();
    }
}

