/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn;

import com.ghostchu.peerbanhelper.DownloaderServer;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.btn.ability.BtnAbility;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityException;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityHeartBeat;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityReconfigure;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityRules;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilitySubmitBans;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilitySubmitSwarm;
import com.ghostchu.peerbanhelper.btn.ability.impl.legacy.LegacyBtnAbilitySubmitBans;
import com.ghostchu.peerbanhelper.btn.ability.impl.legacy.LegacyBtnAbilitySubmitHistory;
import com.ghostchu.peerbanhelper.btn.ability.impl.legacy.LegacyBtnAbilitySubmitPeers;
import com.ghostchu.peerbanhelper.database.dao.impl.HistoryDao;
import com.ghostchu.peerbanhelper.database.dao.impl.MetadataDao;
import com.ghostchu.peerbanhelper.database.dao.impl.PeerRecordDao;
import com.ghostchu.peerbanhelper.database.dao.impl.tmp.TrackedSwarmDao;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.rule.ModuleMatchCache;
import com.ghostchu.peerbanhelper.util.scriptengine.ScriptEngine;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class BtnNetwork
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnNetwork.class);
    private final Map<Class<? extends BtnAbility>, BtnAbility> abilities = Collections.synchronizedMap(new HashMap());
    private final ScriptEngine scriptEngine;
    private final AtomicBoolean configSuccess = new AtomicBoolean(false);
    private TranslationComponent configResult;
    private boolean scriptExecute;
    private ScheduledExecutorService scheduler = null;
    private String configUrl;
    private boolean submit;
    private String appId;
    private String appSecret;
    private OkHttpClient httpClient;
    private final DownloaderServer server;
    private final PeerRecordDao peerRecordDao;
    private final TrackedSwarmDao trackedSwarmDao;
    private final MetadataDao metadataDao;
    private final HistoryDao historyDao;
    private final HTTPUtil httpUtil;
    private final ModuleMatchCache moduleMatchCache;
    private boolean enabled;

    public BtnNetwork(ScriptEngine scriptEngine, ModuleMatchCache moduleMatchCache, DownloaderServer downloaderServer, HTTPUtil httpUtil, MetadataDao metadataDao, HistoryDao historyDao, TrackedSwarmDao trackedSwarmDao, PeerRecordDao peerRecordDao) {
        this.server = downloaderServer;
        this.scriptEngine = scriptEngine;
        this.moduleMatchCache = moduleMatchCache;
        this.httpUtil = httpUtil;
        this.metadataDao = metadataDao;
        this.historyDao = historyDao;
        this.peerRecordDao = peerRecordDao;
        this.trackedSwarmDao = trackedSwarmDao;
        new Thread(() -> {
            Main.getReloadManager().register((Reloadable)this);
            this.reloadConfig();
        }).start();
    }

    public ReloadResult reloadModule() throws Exception {
        new Thread(this::reloadConfig).start();
        return super.reloadModule();
    }

    public synchronized void reloadConfig() {
        log.info("Reconfiguring BtnNetwork...");
        this.enabled = Main.getMainConfig().getBoolean("btn.enabled");
        this.configUrl = Main.getMainConfig().getString("btn.config-url");
        this.submit = Main.getMainConfig().getBoolean("btn.submit");
        this.appId = Main.getMainConfig().getString("btn.app-id");
        this.appSecret = Main.getMainConfig().getString("btn.app-secret");
        this.scriptExecute = Main.getMainConfig().getBoolean("btn.allow-script-execute");
        this.configSuccess.set(false);
        this.configResult = null;
        this.resetAbilities();
        this.setupHttpClient();
        this.resetScheduler();
        this.checkIfNeedRetryConfig();
        log.info("BtnNetwork reloaded");
    }

    private void resetAbilities() {
        this.abilities.values().forEach(BtnAbility::unload);
        this.abilities.clear();
    }

    private void resetScheduler() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        if (this.enabled) {
            this.scheduler = Executors.newScheduledThreadPool(2);
            this.scheduler.scheduleWithFixedDelay(this::checkIfNeedRetryConfig, 0L, 600L, TimeUnit.SECONDS);
        } else {
            this.scheduler = null;
        }
    }

    public synchronized void configBtnNetwork() {
        Request request = new Request.Builder().url(this.configUrl).get().build();
        try (Response resp = this.httpClient.newCall(request).execute();){
            int statusCode = resp.code();
            if (!resp.isSuccessful()) {
                String response = resp.body().string();
                log.error(TextManager.tlUI(Lang.BTN_CONFIG_FAILS, statusCode + " - " + response, 600));
                this.configResult = new TranslationComponent(Lang.BTN_CONFIG_STATUS_UNSUCCESSFUL_HTTP_REQUEST, this.configUrl, statusCode, response);
                return;
            }
            String response = resp.body().string();
            JsonObject json = JsonParser.parseString((String)response).getAsJsonObject();
            if (!json.has("min_protocol_version")) {
                throw new IllegalStateException(TextManager.tlUI(Lang.MISSING_VERSION_PROTOCOL_FIELD, new Object[0]));
            }
            int min_protocol_version = json.get("min_protocol_version").getAsInt();
            if (13 < min_protocol_version) {
                this.configResult = new TranslationComponent(Lang.BTN_CONFIG_STATUS_UNSUCCESSFUL_INCOMPATIBLE_BTN_PROTOCOL_VERSION_CLIENT, 13, min_protocol_version);
                throw new IllegalStateException(TextManager.tlUI(this.configResult));
            }
            int max_protocol_version = json.get("max_protocol_version").getAsInt();
            if (13 > max_protocol_version) {
                this.configResult = new TranslationComponent(Lang.BTN_CONFIG_STATUS_UNSUCCESSFUL_INCOMPATIBLE_BTN_PROTOCOL_VERSION_SERVER, 13, max_protocol_version);
                throw new IllegalStateException(TextManager.tlUI(Lang.BTN_INCOMPATIBLE_SERVER, new Object[0]));
            }
            boolean useLegacyAbilities = min_protocol_version <= 10;
            this.resetScheduler();
            this.abilities.values().forEach(BtnAbility::unload);
            this.abilities.clear();
            JsonObject ability = json.get("ability").getAsJsonObject();
            if (useLegacyAbilities) {
                if (ability.has("submit_peers") && this.submit) {
                    this.abilities.put(LegacyBtnAbilitySubmitPeers.class, new LegacyBtnAbilitySubmitPeers(this, ability.get("submit_peers").getAsJsonObject()));
                }
                if (ability.has("submit_bans") && this.submit) {
                    this.abilities.put(LegacyBtnAbilitySubmitBans.class, new LegacyBtnAbilitySubmitBans(this, ability.get("submit_bans").getAsJsonObject()));
                }
                if (ability.has("submit_histories") && this.submit) {
                    this.abilities.put(LegacyBtnAbilitySubmitHistory.class, new LegacyBtnAbilitySubmitHistory(this, ability.get("submit_histories").getAsJsonObject()));
                }
            } else {
                if (ability.has("submit_bans") && this.submit) {
                    this.abilities.put(BtnAbilitySubmitBans.class, new BtnAbilitySubmitBans(this, ability.get("submit_bans").getAsJsonObject(), this.metadataDao, this.historyDao));
                }
                if (ability.has("submit_swarm") && this.submit) {
                    this.abilities.put(BtnAbilitySubmitSwarm.class, new BtnAbilitySubmitSwarm(this, ability.get("submit_swarm").getAsJsonObject(), this.metadataDao, this.trackedSwarmDao));
                }
            }
            if (ability.has("rules")) {
                this.abilities.put(BtnAbilityRules.class, new BtnAbilityRules(this, this.scriptEngine, ability.get("rules").getAsJsonObject(), this.scriptExecute));
            }
            if (ability.has("reconfigure")) {
                this.abilities.put(BtnAbilityReconfigure.class, new BtnAbilityReconfigure(this, ability.get("reconfigure").getAsJsonObject()));
            }
            if (ability.has("exception")) {
                this.abilities.put(BtnAbilityException.class, new BtnAbilityReconfigure(this, ability.get("exception").getAsJsonObject()));
            }
            if (ability.has("heartbeat")) {
                this.abilities.put(BtnAbilityHeartBeat.class, new BtnAbilityHeartBeat(this, ability.get("heartbeat").getAsJsonObject()));
            }
            this.abilities.values().forEach(a -> {
                try {
                    a.load();
                }
                catch (Exception e) {
                    log.error(TextManager.tlUI(Lang.UNABLE_LOAD_BTN_ABILITY, a.getClass().getSimpleName()), (Throwable)e);
                }
            });
            this.configSuccess.set(true);
            this.configResult = new TranslationComponent(Lang.BTN_CONFIG_STATUS_SUCCESSFUL);
        }
        catch (Throwable e) {
            log.error(TextManager.tlUI(Lang.BTN_CONFIG_FAILS, e.getMessage()), e);
            this.configResult = new TranslationComponent(Lang.BTN_CONFIG_STATUS_EXCEPTION, e.getClass().getName(), e.getMessage());
            this.configSuccess.set(false);
        }
    }

    private void checkIfNeedRetryConfig() {
        try {
            if (this.enabled) {
                if (!this.configSuccess.get()) {
                    this.configBtnNetwork();
                }
            } else {
                this.configSuccess.set(false);
            }
        }
        catch (Throwable throwable) {
            log.error(TextManager.tlUI(Lang.UNABLE_COMPLETE_SCHEDULE_TASKS, new Object[0]), throwable);
        }
    }

    private void setupHttpClient() {
        this.httpClient = this.httpUtil.newBuilder().addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder requestBuilder = original.newBuilder().header("User-Agent", Main.getUserAgent()).header("Content-Type", "application/json").header("BTN-AppID", this.appId).header("BTN-AppSecret", this.appSecret).header("X-BTN-AppID", this.appId).header("X-BTN-AppSecret", this.appSecret).header("Authentication", "Bearer " + this.appId + "@" + this.appSecret);
            return chain.proceed(requestBuilder.build());
        }).authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + this.appId + "@" + this.appSecret).build()).callTimeout(Duration.ofMinutes(1L)).build();
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ModuleMatchCache getModuleMatchCache() {
        return this.moduleMatchCache;
    }

    public DownloaderServer getServer() {
        return this.server;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public HTTPUtil getHttpUtil() {
        return this.httpUtil;
    }

    public void close() {
        log.info(TextManager.tlUI(Lang.BTN_SHUTTING_DOWN, new Object[0]));
        this.scheduler.shutdown();
        this.abilities.values().forEach(BtnAbility::unload);
        this.abilities.clear();
    }

    @Generated
    public Map<Class<? extends BtnAbility>, BtnAbility> getAbilities() {
        return this.abilities;
    }

    @Generated
    public AtomicBoolean getConfigSuccess() {
        return this.configSuccess;
    }

    @Generated
    public TranslationComponent getConfigResult() {
        return this.configResult;
    }

    @Generated
    public String getConfigUrl() {
        return this.configUrl;
    }

    @Generated
    public boolean isSubmit() {
        return this.submit;
    }

    @Generated
    public String getAppId() {
        return this.appId;
    }

    @Generated
    public String getAppSecret() {
        return this.appSecret;
    }

    @Generated
    public PeerRecordDao getPeerRecordDao() {
        return this.peerRecordDao;
    }

    @Generated
    public TrackedSwarmDao getTrackedSwarmDao() {
        return this.trackedSwarmDao;
    }

    @Generated
    public MetadataDao getMetadataDao() {
        return this.metadataDao;
    }

    @Generated
    public HistoryDao getHistoryDao() {
        return this.historyDao;
    }
}

