/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.module;

import com.googlecode.aviator.annotation.Function;
import com.googlecode.aviator.annotation.Import;
import com.googlecode.aviator.annotation.ImportScope;
import com.googlecode.aviator.runtime.module.LineSequence;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;

@Import(scopes={ImportScope.Static}, ns="io")
public class IoModule {
    private static final int INIT_BUFFER_SIZE = 32768;
    private static final int BUFFER_SIZE = 8096;

    public static final File file(String path) {
        return new File(path);
    }

    public static boolean exists(File file) {
        return file.exists();
    }

    @Function(rename="list_files")
    public static File[] files(File file) {
        return file.listFiles();
    }

    public static final URL resource(String name) {
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    @Function(rename="input_stream")
    public static InputStream inputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    @Function(rename="input_stream")
    public static InputStream inputStream(URL url) throws IOException {
        return url.openStream();
    }

    @Function(rename="output_stream")
    public static FileOutputStream outputStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    public int read(InputStream in) throws IOException {
        return in.read();
    }

    public void write(OutputStream out, int b) throws IOException {
        out.write(b);
    }

    public static BufferedReader reader(File file) throws IOException {
        return IoModule.reader(file, Charset.defaultCharset().name());
    }

    public static BufferedReader reader(File file, String charsetName) throws IOException {
        return IoModule.reader(IoModule.inputStream(file), charsetName);
    }

    public static BufferedReader reader(InputStream in) throws IOException {
        return new BufferedReader(new InputStreamReader(in, Charset.defaultCharset().name()));
    }

    public static BufferedReader reader(InputStream in, String charsetName) throws IOException {
        return new BufferedReader(new InputStreamReader(in, Charset.forName(charsetName)));
    }

    public static BufferedWriter writer(File file) throws IOException {
        return IoModule.writer(file, Charset.defaultCharset().name());
    }

    public static BufferedWriter writer(File file, String charsetName) throws IOException {
        return IoModule.writer(IoModule.outputStream(file), charsetName);
    }

    public static BufferedWriter writer(OutputStream out) throws IOException {
        return IoModule.writer(out, Charset.defaultCharset().name());
    }

    public static BufferedWriter writer(OutputStream out, String charsetName) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(out, Charset.forName(charsetName)));
    }

    public static String slurp(String path) throws IOException {
        return IoModule.slurp(IoModule.file(path));
    }

    public static String slurp(String path, String charset) throws IOException {
        return IoModule.slurp(IoModule.file(path), charset);
    }

    public static String slurp(File file) throws IOException {
        return IoModule.slurp(file, Charset.defaultCharset().name());
    }

    public static boolean delete(File file) {
        return file.delete();
    }

    public static String slurp(File file, String charset) throws IOException {
        byte[] data = new byte[(int)file.length()];
        try (InputStream in = IoModule.inputStream(file);){
            int read = in.read(data);
            assert (read == data.length);
        }
        return new String(data, charset);
    }

    public static String slurp(URL file) throws IOException {
        return IoModule.slurp(file, Charset.defaultCharset().name());
    }

    private static byte[] resizeBuffer(byte[] buffer, int newSize, int len) {
        byte[] newBuffer = new byte[newSize];
        System.arraycopy(buffer, 0, newBuffer, 0, len);
        return newBuffer;
    }

    public static String slurp(URL file, String charset) throws IOException {
        byte[] data = new byte[8096];
        byte[] buffer = new byte[32768];
        int destPos = 0;
        try (InputStream in = IoModule.inputStream(file);){
            int read = 0;
            while ((read = in.read(data)) == data.length) {
                while (destPos + read > buffer.length) {
                    buffer = IoModule.resizeBuffer(buffer, buffer.length + 32768, destPos);
                }
                System.arraycopy(data, 0, buffer, destPos, read);
                destPos += data.length;
            }
            if (read > 0) {
                while (destPos + read > buffer.length) {
                    buffer = IoModule.resizeBuffer(buffer, buffer.length + 32768, destPos);
                }
                System.arraycopy(data, 0, buffer, destPos, read);
                destPos += data.length;
            }
        }
        return new String(data, 0, destPos, charset);
    }

    public static void spit(String path, String content) throws IOException {
        IoModule.spit(IoModule.file(path), content);
    }

    public static void spit(String path, String content, String charset) throws IOException {
        IoModule.spit(IoModule.file(path), content, charset);
    }

    public static void spit(File file, String content) throws IOException {
        IoModule.spit(file, content, Charset.defaultCharset().name());
    }

    public static void spit(File file, String content, String charset) throws IOException {
        byte[] data = content.getBytes(Charset.forName(charset));
        try (FileOutputStream out = IoModule.outputStream(file);){
            ((OutputStream)out).write(data);
        }
    }

    @Function(rename="line_seq")
    public static LineSequence seq(File file) throws IOException {
        return new LineSequence(IoModule.reader(file));
    }

    @Function(rename="line_seq")
    public static LineSequence seq(BufferedReader reader) {
        return new LineSequence(reader);
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

