/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.diplomacy;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.CityStateFunctions;
import com.unciv.logic.civilization.diplomacy.CityStatePersonality;
import com.unciv.logic.civilization.diplomacy.DeclareWar;
import com.unciv.logic.civilization.diplomacy.DeclareWarReason;
import com.unciv.logic.civilization.diplomacy.Demand;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.diplomacy.WarType;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeEvaluation;
import com.unciv.logic.trade.TradeLogic;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import yairm210.purity.annotations.Cache;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u0094\u00012\u00020\u0001:\u0002\u0094\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\nJ\u0006\u0010@\u001a\u00020\u0000J\b\u0010A\u001a\u00020\u0000H\u0007J\b\u0010B\u001a\u00020,H\u0007J\b\u0010C\u001a\u000203H\u0007J\u0018\u0010D\u001a\u00020\u00172\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020,H\u0003J\u0010\u0010H\u001a\u00020\u00172\u0006\u0010E\u001a\u00020FH\u0007J\u0010\u0010I\u001a\u00020\u00172\u0006\u0010E\u001a\u00020FH\u0007J\u0010\u0010J\u001a\u00020\u00172\u0006\u0010E\u001a\u00020FH\u0007J\u0010\u0010K\u001a\u00020\u00172\u0006\u0010E\u001a\u00020FH\u0007J\u0010\u0010L\u001a\u00020\u00172\u0006\u0010E\u001a\u00020FH\u0007J\b\u0010M\u001a\u00020FH\u0007J\b\u0010N\u001a\u00020FH\u0007J\b\u0010O\u001a\u00020\u0017H\u0003J\b\u0010P\u001a\u00020,H\u0007J\u000e\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u000203J\u000e\u0010T\u001a\u00020R2\u0006\u0010S\u001a\u000203J\u000e\u0010U\u001a\u00020R2\u0006\u0010S\u001a\u000203J\u0010\u0010V\u001a\u00020R2\u0006\u0010S\u001a\u000203H\u0007J\b\u0010W\u001a\u000203H\u0007J\r\u0010X\u001a\u000203H\u0001\u00a2\u0006\u0002\bYJ\r\u0010Z\u001a\u000203H\u0001\u00a2\u0006\u0002\b[J\b\u0010\\\u001a\u00020\u0017H\u0007J\u0010\u0010]\u001a\u00020R2\b\b\u0002\u0010^\u001a\u00020_J\b\u0010`\u001a\u00020\u0017H\u0007J\b\u0010a\u001a\u00020,H\u0007J\b\u0010b\u001a\u00020cH\u0007J\u000e\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00050eH\u0007J\u000e\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00050eH\u0007J\b\u0010g\u001a\u00020\u0017H\u0007J\u0006\u0010h\u001a\u00020RJ\b\u0010i\u001a\u00020RH\u0002J\u0006\u0010j\u001a\u00020RJ\u0010\u0010k\u001a\u00020\u00172\u0006\u0010l\u001a\u00020mH\u0007J\u0016\u0010n\u001a\u00020R2\u0006\u0010l\u001a\u00020m2\u0006\u0010S\u001a\u00020,J\u0010\u0010o\u001a\u00020,2\u0006\u0010l\u001a\u00020mH\u0007J\u000e\u0010p\u001a\u00020R2\u0006\u0010l\u001a\u00020mJ\u0016\u0010q\u001a\u00020R2\u0006\u0010r\u001a\u00020s2\u0006\u0010S\u001a\u000203J\u0016\u0010t\u001a\u00020R2\u0006\u0010r\u001a\u00020s2\u0006\u0010S\u001a\u000203J\u0015\u0010u\u001a\u0002032\u0006\u0010r\u001a\u00020sH\u0001\u00a2\u0006\u0002\bvJ\u0019\u0010w\u001a\u0004\u0018\u0001032\u0006\u0010r\u001a\u00020sH\u0000\u00a2\u0006\u0004\bx\u0010yJ\u0010\u0010z\u001a\u00020\u00172\u0006\u0010r\u001a\u00020sH\u0007J\u001e\u0010{\u001a\u00020R2\u0006\u0010|\u001a\u00020s2\u0006\u0010}\u001a\u00020s2\u0006\u0010S\u001a\u000203J\u0006\u0010~\u001a\u00020RJ\u000e\u0010\u007f\u001a\u00020RH\u0000\u00a2\u0006\u0003\b\u0080\u0001J\u0010\u0010\u0081\u0001\u001a\u00020R2\u0007\u0010\u0082\u0001\u001a\u00020,J\u000f\u0010\u0083\u0001\u001a\u00020RH\u0000\u00a2\u0006\u0003\b\u0084\u0001J\u000f\u0010\u0085\u0001\u001a\u00020RH\u0000\u00a2\u0006\u0003\b\u0086\u0001J\u0007\u0010\u0087\u0001\u001a\u00020RJ\t\u0010\u0088\u0001\u001a\u00020RH\u0002J\u0011\u0010\u0089\u0001\u001a\u00020R2\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001J\u0011\u0010\u008c\u0001\u001a\u00020R2\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001J\u0007\u0010\u008d\u0001\u001a\u00020RJ\u0007\u0010\u008e\u0001\u001a\u00020RJ\u0019\u0010\u008f\u0001\u001a\u00020R2\u0007\u0010\u0090\u0001\u001a\u00020,2\u0007\u0010\u0091\u0001\u001a\u00020\u0017J\u0010\u0010\u0092\u0001\u001a\u00020R2\u0007\u0010\u0090\u0001\u001a\u00020,J\t\u0010\u0093\u0001\u001a\u00020,H\u0007R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u00058\u0002@\u0002X\u0083.\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0003R\u0011\u0010\t\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR*\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R6\u0010*\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020,0+j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020,`-X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R6\u00102\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002030+j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u000203`-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010/\"\u0004\b5\u00101R\u001a\u00106\u001a\u000203X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020,X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\u00a8\u0006\u0095\u0001"}, d2={"Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "civilization", "Lcom/unciv/logic/civilization/Civilization;", "otherCivName", "", "(Lcom/unciv/logic/civilization/Civilization;Ljava/lang/String;)V", "otherCiv", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/civilization/Civilization;)V", "civInfo", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "value", "getOtherCivName", "()Ljava/lang/String;", "_otherCiv", "get_otherCiv$annotations", "getOtherCiv", "hasOpenBorders", "", "getHasOpenBorders", "()Z", "setHasOpenBorders", "(Z)V", "trades", "Ljava/util/ArrayList;", "Lcom/unciv/logic/trade/Trade;", "Lkotlin/collections/ArrayList;", "getTrades", "()Ljava/util/ArrayList;", "setTrades", "(Ljava/util/ArrayList;)V", "diplomaticStatus", "Lcom/unciv/logic/civilization/diplomacy/DiplomaticStatus;", "getDiplomaticStatus", "()Lcom/unciv/logic/civilization/diplomacy/DiplomaticStatus;", "setDiplomaticStatus", "(Lcom/unciv/logic/civilization/diplomacy/DiplomaticStatus;)V", "flagsCountdown", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getFlagsCountdown$core", "()Ljava/util/HashMap;", "setFlagsCountdown$core", "(Ljava/util/HashMap;)V", "diplomaticModifiers", "", "getDiplomaticModifiers", "setDiplomaticModifiers", "influence", "getInfluence$core", "()F", "setInfluence$core", "(F)V", "totalOfScienceDuringRA", "getTotalOfScienceDuringRA$core", "()I", "setTotalOfScienceDuringRA$core", "(I)V", "clone", "otherCivDiplomacy", "turnsToPeaceTreaty", "opinionOfOtherCiv", "compareRelationshipLevel", "level", "Lcom/unciv/logic/civilization/diplomacy/RelationshipLevel;", "comparesAs", "isRelationshipLevelEQ", "isRelationshipLevelLT", "isRelationshipLevelGT", "isRelationshipLevelLE", "isRelationshipLevelGE", "relationshipLevel", "relationshipIgnoreAfraid", "believesSameReligion", "getTurnsToRelationshipChange", "addInfluence", "", "amount", "reduceInfluence", "setInfluence", "setInfluenceWithoutSideEffects", "getInfluence", "getCityStateInfluenceRestingPoint", "getCityStateInfluenceRestingPoint$core", "getCityStateInfluenceDegrade", "getCityStateInfluenceDegrade$core", "canDeclareWar", "declareWar", "declareWarReason", "Lcom/unciv/logic/civilization/diplomacy/DeclareWarReason;", "canAttack", "goldPerTurn", "resourcesFromTrade", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "getCommonKnownCivs", "", "getCommonKnownCivsWithSpectators", "isConsideredFriendlyTerritory", "updateHasOpenBorders", "makePeaceOneSide", "makePeace", "hasFlag", "flag", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyFlags;", "setFlag", "getFlag", "removeFlag", "addModifier", "modifier", "Lcom/unciv/logic/civilization/diplomacy/DiplomaticModifiers;", "setModifier", "getModifier", "getModifier$core", "removeModifier", "removeModifier$core", "(Lcom/unciv/logic/civilization/diplomacy/DiplomaticModifiers;)Ljava/lang/Float;", "hasModifier", "replaceModifier", "oldModifier", "newModifier", "signDeclarationOfFriendship", "setFriendshipBasedModifier", "setFriendshipBasedModifier$core", "signDefensivePact", "duration", "setDefensivePactBasedModifier", "setDefensivePactBasedModifier$core", "setReligionBasedModifier", "setReligionBasedModifier$core", "denounce", "activateDenounceEffects", "agreeToDemand", "demand", "Lcom/unciv/logic/civilization/diplomacy/Demand;", "refuseDemand", "sideWithCityState", "becomeWary", "giftGold", "gold", "isPureGift", "recieveGoldGifts", "getGoldGifts", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDiplomacyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiplomacyManager.kt\ncom/unciv/logic/civilization/diplomacy/DiplomacyManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,823:1\n1563#2:824\n1634#2,3:825\n774#2:829\n865#2,2:830\n774#2:832\n865#2,2:833\n774#2:835\n865#2,2:836\n774#2:838\n865#2,2:839\n774#2:841\n865#2,2:842\n1374#2:844\n1460#2,5:845\n1761#2,3:850\n774#2:853\n865#2,2:854\n774#2:856\n865#2,2:857\n1869#2,2:859\n1#3:828\n*S KotlinDebug\n*F\n+ 1 DiplomacyManager.kt\ncom/unciv/logic/civilization/diplomacy/DiplomacyManager\n*L\n204#1:824\n204#1:825,3\n437#1:829\n437#1:830,2\n461#1:832\n461#1:833,2\n463#1:835\n463#1:836,2\n479#1:838\n479#1:839,2\n481#1:841\n481#1:842,2\n510#1:844\n510#1:845,5\n510#1:850,3\n626#1:853\n626#1:854,2\n677#1:856\n677#1:857,2\n726#1:859,2\n*E\n"})
public final class DiplomacyManager
implements IsPartOfGameInfoSerialization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public transient Civilization civInfo;
    private String otherCivName;
    private transient Civilization _otherCiv;
    private transient boolean hasOpenBorders;
    @NotNull
    private ArrayList<Trade> trades;
    @NotNull
    private DiplomaticStatus diplomaticStatus;
    @NotNull
    private HashMap<String, Integer> flagsCountdown;
    @NotNull
    private HashMap<String, Float> diplomaticModifiers;
    private float influence;
    private int totalOfScienceDuringRA;
    public static final float MINIMUM_INFLUENCE = -60.0f;

    public DiplomacyManager() {
        this.trades = new ArrayList();
        this.diplomaticStatus = DiplomaticStatus.War;
        this.flagsCountdown = new HashMap();
        this.diplomaticModifiers = new HashMap();
    }

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    @NotNull
    public final String getOtherCivName() {
        String string = this.otherCivName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("otherCivName");
        return null;
    }

    @Cache
    private static /* synthetic */ void get_otherCiv$annotations() {
    }

    @Readonly
    @NotNull
    public final Civilization getOtherCiv() {
        Civilization civilization;
        if (this._otherCiv == null) {
            this._otherCiv = this.getCivInfo().getGameInfo().getCivilization(this.getOtherCivName());
        }
        if ((civilization = this._otherCiv) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("_otherCiv");
            civilization = null;
        }
        return civilization;
    }

    public final boolean getHasOpenBorders() {
        return this.hasOpenBorders;
    }

    public final void setHasOpenBorders(boolean bl) {
        this.hasOpenBorders = bl;
    }

    @NotNull
    public final ArrayList<Trade> getTrades() {
        return this.trades;
    }

    public final void setTrades(@NotNull ArrayList<Trade> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.trades = arrayList;
    }

    @NotNull
    public final DiplomaticStatus getDiplomaticStatus() {
        return this.diplomaticStatus;
    }

    public final void setDiplomaticStatus(@NotNull DiplomaticStatus diplomaticStatus) {
        Intrinsics.checkNotNullParameter(diplomaticStatus, "<set-?>");
        this.diplomaticStatus = diplomaticStatus;
    }

    @NotNull
    public final HashMap<String, Integer> getFlagsCountdown$core() {
        return this.flagsCountdown;
    }

    public final void setFlagsCountdown$core(@NotNull HashMap<String, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.flagsCountdown = hashMap;
    }

    @NotNull
    public final HashMap<String, Float> getDiplomaticModifiers() {
        return this.diplomaticModifiers;
    }

    public final void setDiplomaticModifiers(@NotNull HashMap<String, Float> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.diplomaticModifiers = hashMap;
    }

    public final float getInfluence$core() {
        return this.influence;
    }

    public final void setInfluence$core(float f) {
        this.influence = f;
    }

    public final int getTotalOfScienceDuringRA$core() {
        return this.totalOfScienceDuringRA;
    }

    public final void setTotalOfScienceDuringRA$core(int n) {
        this.totalOfScienceDuringRA = n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DiplomacyManager clone() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DiplomacyManager toReturn = new DiplomacyManager();
        toReturn.otherCivName = this.getOtherCivName();
        toReturn.diplomaticStatus = this.diplomaticStatus;
        Iterable iterable = this.trades;
        ArrayList<Trade> arrayList = toReturn.trades;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Trade trade = (Trade)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.clone());
        }
        arrayList.addAll((List)destination$iv$iv);
        toReturn.influence = this.influence;
        toReturn.flagsCountdown.putAll((Map<String, Integer>)this.flagsCountdown);
        toReturn.diplomaticModifiers.putAll((Map<String, Float>)this.diplomaticModifiers);
        toReturn.totalOfScienceDuringRA = this.totalOfScienceDuringRA;
        return toReturn;
    }

    public DiplomacyManager(@NotNull Civilization civilization, @NotNull String otherCivName) {
        Intrinsics.checkNotNullParameter(civilization, "civilization");
        Intrinsics.checkNotNullParameter(otherCivName, "otherCivName");
        this();
        this.setCivInfo(civilization);
        this.otherCivName = otherCivName;
        this.updateHasOpenBorders();
    }

    public DiplomacyManager(@NotNull Civilization civilization, @NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(civilization, "civilization");
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        this();
        this.setCivInfo(civilization);
        this._otherCiv = otherCiv;
        this.otherCivName = otherCiv.getCivName();
        this.updateHasOpenBorders();
    }

    @Readonly
    @NotNull
    public final DiplomacyManager otherCivDiplomacy() {
        DiplomacyManager diplomacyManager = this.getOtherCiv().getDiplomacyManager(this.getCivInfo());
        Intrinsics.checkNotNull(diplomacyManager);
        return diplomacyManager;
    }

    @Readonly
    public final int turnsToPeaceTreaty() {
        Iterator<Trade> iterator2 = this.trades.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Trade> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Iterator iterator4;
            Trade trade;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Intrinsics.checkNotNullExpressionValue(trade.getOurOffers().iterator(), "iterator(...)");
            while (iterator4.hasNext()) {
                Object e = iterator4.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                TradeOffer offer = (TradeOffer)e;
                if (!Intrinsics.areEqual(offer.getName(), "Peace Treaty") || offer.getDuration() <= 0) continue;
                return offer.getDuration();
            }
        }
        return 0;
    }

    @Readonly
    public final float opinionOfOtherCiv() {
        Collection<Float> collection = this.diplomaticModifiers.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        float modifierSum = CollectionsKt.sumOfFloat((Iterable<Float>)collection);
        if (this.hasModifier(DiplomaticModifiers.DestroyedProtectedMinor) && this.hasModifier(DiplomaticModifiers.AttackedProtectedMinor)) {
            modifierSum -= this.getModifier$core(DiplomaticModifiers.AttackedProtectedMinor);
        }
        return modifierSum;
    }

    @Readonly
    private final boolean compareRelationshipLevel(RelationshipLevel level, int comparesAs) {
        boolean bl;
        if (!this.getCivInfo().isCityState()) {
            return MathKt.getSign(this.relationshipLevel().compareTo((Enum)level)) == comparesAs;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                if (comparesAs < 0) {
                    if (this.getInfluence() < 0.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (comparesAs > 0) {
                    if (this.getInfluence() >= 30.0f || this.relationshipLevel().compareTo((Enum)level) > 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                float it = this.getInfluence();
                boolean bl2 = false;
                boolean bl3 = it >= 0.0f && it < 30.0f;
                if (bl3 && this.relationshipLevel() == level) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (comparesAs < 0) {
                    if (this.getInfluence() < 0.0f || this.relationshipLevel().compareTo((Enum)level) < 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (comparesAs > 0) {
                    if (this.getInfluence() >= 30.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                float it = this.getInfluence();
                boolean bl4 = false;
                boolean bl5 = it >= 0.0f && it < 30.0f;
                if (bl5 && this.relationshipLevel() == level) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = MathKt.getSign(this.relationshipLevel().compareTo((Enum)level)) == comparesAs;
            }
        }
        return bl;
    }

    @Readonly
    public final boolean isRelationshipLevelEQ(@NotNull RelationshipLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, "level");
        return this.compareRelationshipLevel(level, 0);
    }

    @Readonly
    public final boolean isRelationshipLevelLT(@NotNull RelationshipLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, "level");
        return this.compareRelationshipLevel(level, -1);
    }

    @Readonly
    public final boolean isRelationshipLevelGT(@NotNull RelationshipLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, "level");
        return this.compareRelationshipLevel(level, 1);
    }

    @Readonly
    public final boolean isRelationshipLevelLE(@NotNull RelationshipLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, "level");
        return level == RelationshipLevel.Ally ? true : this.compareRelationshipLevel(level.plus(1), -1);
    }

    @Readonly
    public final boolean isRelationshipLevelGE(@NotNull RelationshipLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, "level");
        return level == RelationshipLevel.Unforgivable ? true : this.compareRelationshipLevel(level.plus(-1), 1);
    }

    @Readonly
    @NotNull
    public final RelationshipLevel relationshipLevel() {
        RelationshipLevel level = this.relationshipIgnoreAfraid();
        return level != RelationshipLevel.Neutral || !this.getCivInfo().isCityState() ? level : (CityStateFunctions.getTributeWillingness$default(this.getCivInfo().getCityStateFunctions(), this.getOtherCiv(), false, 2, null) > 0 ? RelationshipLevel.Afraid : RelationshipLevel.Neutral);
    }

    @Readonly
    @NotNull
    public final RelationshipLevel relationshipIgnoreAfraid() {
        if (this.getCivInfo().isHuman() && this.getOtherCiv().isHuman()) {
            return RelationshipLevel.Neutral;
        }
        if (this.getCivInfo().isHuman()) {
            return this.otherCivDiplomacy().relationshipLevel();
        }
        if (this.getCivInfo().isCityState()) {
            return this.getInfluence() <= -30.0f ? RelationshipLevel.Unforgivable : (this.getInfluence() < 0.0f ? RelationshipLevel.Enemy : (this.getInfluence() >= 60.0f && Intrinsics.areEqual(this.getCivInfo().getAllyCiv(), this.getOtherCiv()) ? RelationshipLevel.Ally : (this.getInfluence() >= 30.0f ? RelationshipLevel.Friend : RelationshipLevel.Neutral)));
        }
        float opinion = this.opinionOfOtherCiv();
        return opinion <= -80.0f ? RelationshipLevel.Unforgivable : (opinion <= -40.0f || this.getCivInfo().isAtWarWith(this.getOtherCiv()) ? RelationshipLevel.Enemy : (opinion <= -15.0f ? RelationshipLevel.Competitor : (opinion >= 80.0f ? RelationshipLevel.Ally : (opinion >= 40.0f ? RelationshipLevel.Friend : (opinion >= 15.0f ? RelationshipLevel.Favorable : RelationshipLevel.Neutral)))));
    }

    @Readonly
    private final boolean believesSameReligion() {
        Religion religion = this.getCivInfo().getReligionManager().getMajorityReligion();
        if (religion == null) {
            return false;
        }
        Religion civMajorityReligion = religion;
        return this.getOtherCiv().getReligionManager().isMajorityReligionForCiv(civMajorityReligion);
    }

    @Readonly
    public final int getTurnsToRelationshipChange() {
        if (this.getOtherCiv().isCityState()) {
            return this.otherCivDiplomacy().getTurnsToRelationshipChange();
        }
        if (this.getCivInfo().isCityState() && !this.getOtherCiv().isCityState()) {
            float dropPerTurn = this.getCityStateInfluenceDegrade$core();
            return dropPerTurn == 0.0f ? 0 : (this.isRelationshipLevelEQ(RelationshipLevel.Ally) ? (int)Math.ceil((this.getInfluence() - 60.0f) / dropPerTurn) + 1 : (this.isRelationshipLevelEQ(RelationshipLevel.Friend) ? (int)Math.ceil((this.getInfluence() - 30.0f) / dropPerTurn) + 1 : 0));
        }
        return 0;
    }

    public final void addInfluence(float amount) {
        this.setInfluence(this.influence + amount);
    }

    public final void reduceInfluence(float amount) {
        if (this.influence <= 0.0f) {
            return;
        }
        this.influence = RangesKt.coerceAtLeast(this.influence - amount, 0.0f);
    }

    public final void setInfluence(float amount) {
        this.influence = Math.max(amount, -60.0f);
        this.getCivInfo().getCityStateFunctions().updateAllyCivForCityState();
    }

    @VisibleForTesting
    public final void setInfluenceWithoutSideEffects(float amount) {
        this.influence = amount;
    }

    @Readonly
    public final float getInfluence() {
        return this.getCivInfo().isAtWarWith(this.getOtherCiv()) ? -60.0f : this.influence;
    }

    @Readonly
    public final float getCityStateInfluenceRestingPoint$core() {
        Unique unique;
        float restingPoint = 0.0f;
        Iterator iterator2 = Civilization.getMatchingUniques$default(this.getOtherCiv(), UniqueType.CityStateRestingPoint, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            restingPoint += (float)Integer.parseInt(unique.getParams().get(0));
        }
        if (CollectionsKt.any((Iterable)this.getCivInfo().getCities()) && Civilization.getCapital$default(this.getCivInfo(), false, 1, null) != null) {
            iterator2 = Civilization.getMatchingUniques$default(this.getOtherCiv(), UniqueType.RestingPointOfCityStatesFollowingReligionChange, null, 2, null).iterator();
            while (iterator2.hasNext()) {
                unique = (Unique)iterator2.next();
                Religion religion = this.getOtherCiv().getReligionManager().getReligion();
                String string = religion != null ? religion.getName() : null;
                City city = Civilization.getCapital$default(this.getCivInfo(), false, 1, null);
                Intrinsics.checkNotNull(city);
                if (!Intrinsics.areEqual(string, city.getReligion().getMajorityReligionName())) continue;
                restingPoint += (float)Integer.parseInt(unique.getParams().get(0));
            }
        }
        if (this.diplomaticStatus == DiplomaticStatus.Protector) {
            restingPoint += (float)10;
        }
        if (this.hasFlag(DiplomacyFlags.WaryOf)) {
            restingPoint -= (float)20;
        }
        return restingPoint;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final float getCityStateInfluenceDegrade$core() {
        void $this$filterTo$iv$iv;
        String religion;
        String string;
        if (this.getInfluence() <= this.getCityStateInfluenceRestingPoint$core()) {
            return 0.0f;
        }
        float decrement = this.getCivInfo().getCityStatePersonality() == CityStatePersonality.Hostile ? 1.5f : (this.getOtherCiv().isMinorCivAggressor() ? 2.0f : 1.0f);
        float modifierPercent = 0.0f;
        Iterator iterator2 = Civilization.getMatchingUniques$default(this.getOtherCiv(), UniqueType.CityStateInfluenceDegradation, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            modifierPercent += Float.parseFloat(unique.getParams().get(0));
        }
        if (this.getCivInfo().getCities().isEmpty() || Civilization.getCapital$default(this.getCivInfo(), false, 1, null) == null) {
            string = null;
        } else {
            City city = Civilization.getCapital$default(this.getCivInfo(), false, 1, null);
            Intrinsics.checkNotNull(city);
            string = religion = city.getReligion().getMajorityReligionName();
        }
        if (religion != null) {
            Religion religion2 = this.getOtherCiv().getReligionManager().getReligion();
            if (Intrinsics.areEqual(religion, religion2 != null ? religion2.getName() : null)) {
                modifierPercent -= 25.0f;
            }
        }
        Iterable $this$filter$iv = this.getCivInfo().getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(it.isMajorCiv() && !Intrinsics.areEqual(it, this.getOtherCiv()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization civ : (List)destination$iv$iv) {
            Iterator iterator3 = Civilization.getMatchingUniques$default(civ, UniqueType.OtherCivsCityStateRelationsDegradeFaster, null, 2, null).iterator();
            while (iterator3.hasNext()) {
                Unique unique = (Unique)iterator3.next();
                modifierPercent += Float.parseFloat(unique.getParams().get(0));
            }
        }
        return Math.max(0.0f, decrement) * FormattingExtensionsKt.toPercent(Math.max(-100.0f, modifierPercent));
    }

    @Readonly
    public final boolean canDeclareWar() {
        return !this.getCivInfo().isDefeated() && !this.getOtherCiv().isDefeated() && this.turnsToPeaceTreaty() == 0 && this.diplomaticStatus != DiplomaticStatus.War;
    }

    public final void declareWar(@NotNull DeclareWarReason declareWarReason) {
        Intrinsics.checkNotNullParameter(declareWarReason, "declareWarReason");
        DeclareWar.INSTANCE.declareWar$core(this, declareWarReason);
    }

    public static /* synthetic */ void declareWar$default(DiplomacyManager diplomacyManager, DeclareWarReason declareWarReason, int n, Object object) {
        if ((n & 1) != 0) {
            declareWarReason = new DeclareWarReason(WarType.DirectWar, null, 2, null);
        }
        diplomacyManager.declareWar(declareWarReason);
    }

    @Readonly
    public final boolean canAttack() {
        return this.turnsToPeaceTreaty() == 0;
    }

    @Readonly
    public final int goldPerTurn() {
        int goldPerTurnForUs = 0;
        Iterator<Trade> iterator2 = this.trades.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Trade> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            TradeOffer offer;
            TradeOffer it;
            Iterable $this$filterTo$iv$iv;
            Trade trade;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Iterable $this$filter$iv = trade.getOurOffers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TradeOffer)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == TradeOfferType.Gold_Per_Turn)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Object e : (List)destination$iv$iv) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                offer = (TradeOffer)e;
                goldPerTurnForUs -= offer.getAmount();
            }
            $this$filter$iv = trade.getTheirOffers();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TradeOffer)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == TradeOfferType.Gold_Per_Turn)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Object e : (List)destination$iv$iv) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                offer = (TradeOffer)e;
                goldPerTurnForUs += offer.getAmount();
            }
        }
        return goldPerTurnForUs;
    }

    @Readonly
    @NotNull
    public final ResourceSupplyList resourcesFromTrade() {
        ResourceSupplyList newResourceSupplyList = new ResourceSupplyList(false, 1, null);
        LinkedHashMap<String, TileResource> resourcesMap = this.getCivInfo().getGameInfo().getRuleset().getTileResources();
        Function1<TradeOffer, Boolean> isResourceFilter = arg_0 -> DiplomacyManager.resourcesFromTrade$lambda$0(resourcesMap, arg_0);
        Iterator<Trade> iterator2 = this.trades.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Trade> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            TradeOffer offer;
            Iterable $this$filterTo$iv$iv;
            Trade trade;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Iterable $this$filter$iv = trade.getOurOffers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                if (!isResourceFilter.invoke((TradeOffer)element$iv$iv).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Object e : (List)destination$iv$iv) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                offer = (TradeOffer)e;
                TileResource tileResource = resourcesMap.get(offer.getName());
                Intrinsics.checkNotNull(tileResource);
                newResourceSupplyList.add(tileResource, "Trade", -offer.getAmount());
            }
            $this$filter$iv = trade.getTheirOffers();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                if (!isResourceFilter.invoke((TradeOffer)element$iv$iv).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Object e : (List)destination$iv$iv) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                offer = (TradeOffer)e;
                TileResource tileResource = resourcesMap.get(offer.getName());
                Intrinsics.checkNotNull(tileResource);
                newResourceSupplyList.add(tileResource, "Trade", offer.getAmount());
            }
        }
        return newResourceSupplyList;
    }

    @Readonly
    @NotNull
    public final Set<Civilization> getCommonKnownCivs() {
        return CollectionsKt.intersect(SequencesKt.asIterable(this.getCivInfo().getKnownCivs()), (Iterable)SequencesKt.toSet(this.getOtherCiv().getKnownCivs()));
    }

    @Readonly
    @NotNull
    public final Set<Civilization> getCommonKnownCivsWithSpectators() {
        return CollectionsKt.intersect(SequencesKt.asIterable(this.getCivInfo().getKnownCivsWithSpectators()), (Iterable)SequencesKt.toSet(this.getOtherCiv().getKnownCivsWithSpectators()));
    }

    @Readonly
    public final boolean isConsideredFriendlyTerritory() {
        if (this.getCivInfo().isCityState() && (this.isRelationshipLevelGE(RelationshipLevel.Friend) || Civilization.hasUnique$default(this.getOtherCiv(), UniqueType.CityStateTerritoryAlwaysFriendly, null, 2, null))) {
            return true;
        }
        return this.otherCivDiplomacy().hasOpenBorders;
    }

    /*
     * Unable to fully structure code
     */
    public final void updateHasOpenBorders() {
        block8: {
            if (Intrinsics.areEqual(this.getCivInfo().getAllyCiv(), this.getOtherCiv())) ** GOTO lbl-1000
            $this$flatMap$iv = this.trades;
            $i$f$flatMap = false;
            var4_5 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            var7_9 = $this$flatMapTo$iv$iv.iterator();
            while (var7_9.hasNext()) {
                element$iv$iv = var7_9.next();
                it = (Trade)element$iv$iv;
                $i$a$-flatMap-DiplomacyManager$updateHasOpenBorders$newHasOpenBorders$1 = false;
                list$iv$iv = it.getTheirOffers();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            $this$any$iv = (List)destination$iv$iv;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-DiplomacyManager$updateHasOpenBorders$newHasOpenBorders$2 = false;
                    if (!(Intrinsics.areEqual(it.getName(), "Open Borders") != false && it.getDuration() > 0)) continue;
                    v0 = true;
                    break block8;
                }
                v0 = false;
            }
        }
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        newHasOpenBorders = v1;
        bordersWereClosed = this.hasOpenBorders != false && newHasOpenBorders == false;
        this.hasOpenBorders = newHasOpenBorders;
        if (bordersWereClosed) {
            for (MapUnit unit : SequencesKt.toList(SequencesKt.filter(this.getCivInfo().getUnits().getCivUnits(), (Function1<MapUnit, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, updateHasOpenBorders$lambda$2(com.unciv.logic.civilization.diplomacy.DiplomacyManager com.unciv.logic.map.mapunit.MapUnit ), (Lcom/unciv/logic/map/mapunit/MapUnit;)Ljava/lang/Boolean;)((DiplomacyManager)this)))) {
                unit.getMovement().teleportToClosestMoveableTile();
            }
        }
    }

    private final void makePeaceOneSide() {
        this.diplomaticStatus = DiplomaticStatus.Peace;
        Civilization otherCiv = this.getOtherCiv();
        for (MapUnit unit : SequencesKt.toList(SequencesKt.filter(this.getCivInfo().getUnits().getCivUnits(), arg_0 -> DiplomacyManager.makePeaceOneSide$lambda$0(otherCiv, arg_0)))) {
            unit.getMovement().teleportToClosestMoveableTile();
        }
        Iterator<IsPartOfGameInfoSerialization> iterator2 = this.getCivInfo().getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            Civilization thirdCiv = (Civilization)iterator2.next();
            if (Intrinsics.areEqual(thirdCiv.getAllyCiv(), this.getCivInfo()) && thirdCiv.isAtWarWith(otherCiv)) {
                DiplomacyManager thirdCivDiplo;
                Intrinsics.checkNotNull(thirdCiv.getDiplomacyManager(otherCiv));
                thirdCivDiplo.makePeace();
                TradeLogic tradeLogic = new TradeLogic(thirdCiv, otherCiv);
                tradeLogic.getCurrentTrade().getOurOffers().add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, this.getCivInfo().getGameInfo().getSpeed(), 4, null));
                tradeLogic.getCurrentTrade().getTheirOffers().add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, this.getCivInfo().getGameInfo().getSpeed(), 4, null));
                thirdCivDiplo.trades.add(tradeLogic.getCurrentTrade());
                thirdCivDiplo.otherCivDiplomacy().trades.add(tradeLogic.getCurrentTrade().reverse());
            }
            if (Intrinsics.areEqual(thirdCiv.getAllyCiv(), this.getCivInfo()) || !thirdCiv.isAtWarWith(otherCiv)) continue;
            DiplomacyManager diplomacyManager = thirdCiv.getDiplomacyManager(this.getCivInfo());
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.addInfluence(-10.0f);
        }
    }

    public final void makePeace() {
        this.makePeaceOneSide();
        this.otherCivDiplomacy().makePeaceOneSide();
        for (Civilization civ : this.getCommonKnownCivsWithSpectators()) {
            String[] stringArray = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Diplomacy", this.getOtherCivName()};
            civ.addNotification('[' + this.getCivInfo().getCivName() + "] and [" + this.getOtherCivName() + "] have signed a Peace Treaty!", Notification.NotificationCategory.Diplomacy, stringArray);
        }
    }

    @Readonly
    public final boolean hasFlag(@NotNull DiplomacyFlags flag) {
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        return this.flagsCountdown.containsKey(flag.name());
    }

    public final void setFlag(@NotNull DiplomacyFlags flag, int amount) {
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        ((Map)this.flagsCountdown).put(flag.name(), amount);
    }

    @Readonly
    public final int getFlag(@NotNull DiplomacyFlags flag) {
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        Integer n = this.flagsCountdown.get(flag.name());
        return n != null ? n : 0;
    }

    public final void removeFlag(@NotNull DiplomacyFlags flag) {
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        this.flagsCountdown.remove(flag.name());
    }

    public final void addModifier(@NotNull DiplomaticModifiers modifier, float amount) {
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        String modifierString = modifier.name();
        if (!this.hasModifier(modifier)) {
            this.setModifier(modifier, 0.0f);
        }
        Map map2 = this.diplomaticModifiers;
        Float f = this.diplomaticModifiers.get(modifierString);
        Intrinsics.checkNotNull(f);
        map2.put(modifierString, Float.valueOf(((Number)f).floatValue() + amount));
        if (Intrinsics.areEqual(this.diplomaticModifiers.get(modifierString), 0.0f)) {
            this.diplomaticModifiers.remove(modifierString);
        }
    }

    public final void setModifier(@NotNull DiplomaticModifiers modifier, float amount) {
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        ((Map)this.diplomaticModifiers).put(modifier.name(), Float.valueOf(amount));
    }

    @Readonly
    public final float getModifier$core(@NotNull DiplomaticModifiers modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        if (!this.hasModifier(modifier)) {
            return 0.0f;
        }
        Float f = this.diplomaticModifiers.get(modifier.name());
        Intrinsics.checkNotNull(f);
        return ((Number)f).floatValue();
    }

    @Nullable
    public final Float removeModifier$core(@NotNull DiplomaticModifiers modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        return this.diplomaticModifiers.remove(modifier.name());
    }

    @Readonly
    public final boolean hasModifier(@NotNull DiplomaticModifiers modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        return this.diplomaticModifiers.containsKey(modifier.name());
    }

    public final void replaceModifier(@NotNull DiplomaticModifiers oldModifier, @NotNull DiplomaticModifiers newModifier, float amount) {
        Intrinsics.checkNotNullParameter((Object)oldModifier, "oldModifier");
        Intrinsics.checkNotNullParameter((Object)newModifier, "newModifier");
        this.removeModifier$core(oldModifier);
        this.addModifier(newModifier, amount);
    }

    public final void signDeclarationOfFriendship() {
        this.setModifier(DiplomaticModifiers.DeclarationOfFriendship, 35.0f);
        this.otherCivDiplomacy().setModifier(DiplomaticModifiers.DeclarationOfFriendship, 35.0f);
        this.setFlag(DiplomacyFlags.DeclarationOfFriendship, 30);
        this.otherCivDiplomacy().setFlag(DiplomacyFlags.DeclarationOfFriendship, 30);
        for (Civilization thirdCiv : this.getCommonKnownCivsWithSpectators()) {
            String[] stringArray = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Diplomacy", this.getOtherCivName()};
            thirdCiv.addNotification('[' + this.getCivInfo().getCivName() + "] and [" + this.getOtherCivName() + "] have signed a Declaration of Friendship!", Notification.NotificationCategory.Diplomacy, stringArray);
            DiplomacyManager diplomacyManager = thirdCiv.getDiplomacyManager(this.getCivInfo());
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.setFriendshipBasedModifier$core();
            if (thirdCiv.isSpectator()) {
                return;
            }
            DiplomacyManager diplomacyManager2 = thirdCiv.getDiplomacyManager(this.getCivInfo());
            Intrinsics.checkNotNull(diplomacyManager2);
            diplomacyManager2.setFriendshipBasedModifier$core();
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponDeclaringFriendship, GameContext.Companion.getIgnoreConditionals(), null, 4, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getOtherCiv(), UniqueType.TriggerUponDeclaringFriendship, GameContext.Companion.getIgnoreConditionals(), null, 4, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getOtherCiv(), null, null, null, null, null, 124, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setFriendshipBasedModifier$core() {
        void $this$filterTo$iv$iv;
        this.removeModifier$core(DiplomaticModifiers.DeclaredFriendshipWithOurAllies);
        this.removeModifier$core(DiplomaticModifiers.DeclaredFriendshipWithOurEnemies);
        Iterable $this$filter$iv = this.getCommonKnownCivs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            DiplomacyManager diplomacyManager = it.getDiplomacyManager(this.getOtherCiv());
            Intrinsics.checkNotNull(diplomacyManager);
            if (!diplomacyManager.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List civsOtherCivHasDeclaredFriendshipWith = (List)destination$iv$iv;
        for (Civilization thirdCiv : civsOtherCivHasDeclaredFriendshipWith) {
            float f;
            DiplomaticModifiers diplomaticModifiers;
            DiplomacyManager diplomacyManager = this.getCivInfo().getDiplomacyManager(thirdCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            RelationshipLevel ourRelationshipWithThirdCiv = diplomacyManager.relationshipIgnoreAfraid();
            switch (WhenMappings.$EnumSwitchMapping$0[ourRelationshipWithThirdCiv.ordinal()]) {
                case 3: 
                case 4: {
                    diplomaticModifiers = DiplomaticModifiers.DeclaredFriendshipWithOurEnemies;
                    break;
                }
                default: {
                    diplomaticModifiers = DiplomaticModifiers.DeclaredFriendshipWithOurAllies;
                }
            }
            DiplomaticModifiers modifierType = diplomaticModifiers;
            switch (WhenMappings.$EnumSwitchMapping$0[ourRelationshipWithThirdCiv.ordinal()]) {
                case 3: {
                    f = -15.0f;
                    break;
                }
                case 4: {
                    f = -5.0f;
                    break;
                }
                case 5: {
                    f = 5.0f;
                    break;
                }
                case 6: {
                    f = 15.0f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            float modifierValue = f;
            this.addModifier(modifierType, modifierValue);
        }
    }

    public final void signDefensivePact(int duration) {
        this.setModifier(DiplomaticModifiers.DefensivePact, 10.0f);
        this.otherCivDiplomacy().setModifier(DiplomaticModifiers.DefensivePact, 10.0f);
        this.setFlag(DiplomacyFlags.DefensivePact, duration);
        this.otherCivDiplomacy().setFlag(DiplomacyFlags.DefensivePact, duration);
        this.diplomaticStatus = DiplomaticStatus.DefensivePact;
        this.otherCivDiplomacy().diplomaticStatus = DiplomaticStatus.DefensivePact;
        for (Civilization thirdCiv : this.getCommonKnownCivsWithSpectators()) {
            String[] stringArray = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Diplomacy", this.getOtherCivName()};
            thirdCiv.addNotification('[' + this.getCivInfo().getCivName() + "] and [" + this.getOtherCivName() + "] have signed a Defensive Pact!", Notification.NotificationCategory.Diplomacy, stringArray);
            if (thirdCiv.isSpectator()) {
                return;
            }
            DiplomacyManager diplomacyManager = thirdCiv.getDiplomacyManager(this.getCivInfo());
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.setDefensivePactBasedModifier$core();
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponSigningDefensivePact, GameContext.Companion.getIgnoreConditionals(), null, 4, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getOtherCiv(), UniqueType.TriggerUponSigningDefensivePact, GameContext.Companion.getIgnoreConditionals(), null, 4, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getOtherCiv(), null, null, null, null, null, 124, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setDefensivePactBasedModifier$core() {
        void $this$filterTo$iv$iv;
        this.removeModifier$core(DiplomaticModifiers.SignedDefensivePactWithOurAllies);
        this.removeModifier$core(DiplomaticModifiers.SignedDefensivePactWithOurEnemies);
        Iterable $this$filter$iv = this.getCommonKnownCivs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            DiplomacyManager diplomacyManager = this.getOtherCiv().getDiplomacyManager(it);
            Intrinsics.checkNotNull(diplomacyManager);
            if (!diplomacyManager.hasFlag(DiplomacyFlags.DefensivePact)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List civsTheyHavePactWith = (List)destination$iv$iv;
        for (Civilization thirdCiv : civsTheyHavePactWith) {
            float f;
            DiplomaticModifiers diplomaticModifiers;
            DiplomacyManager diplomacyManager = this.getCivInfo().getDiplomacyManager(thirdCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            RelationshipLevel ourRelationshipWithThirdCiv = diplomacyManager.relationshipIgnoreAfraid();
            switch (WhenMappings.$EnumSwitchMapping$0[ourRelationshipWithThirdCiv.ordinal()]) {
                case 3: 
                case 4: {
                    diplomaticModifiers = DiplomaticModifiers.SignedDefensivePactWithOurEnemies;
                    break;
                }
                default: {
                    diplomaticModifiers = DiplomaticModifiers.SignedDefensivePactWithOurAllies;
                }
            }
            DiplomaticModifiers modifierType = diplomaticModifiers;
            switch (WhenMappings.$EnumSwitchMapping$0[ourRelationshipWithThirdCiv.ordinal()]) {
                case 3: {
                    f = -15.0f;
                    break;
                }
                case 4: {
                    f = -10.0f;
                    break;
                }
                case 5: {
                    f = 2.0f;
                    break;
                }
                case 6: {
                    f = 5.0f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            float modifierValue = f;
            this.addModifier(modifierType, modifierValue);
        }
    }

    public final void setReligionBasedModifier$core() {
        if (this.otherCivDiplomacy().believesSameReligion()) {
            this.setModifier(DiplomaticModifiers.BelieveSameReligion, 5.0f);
        } else {
            this.removeModifier$core(DiplomaticModifiers.BelieveSameReligion);
        }
    }

    public final void denounce() {
        this.activateDenounceEffects();
        if (this.getOtherCiv().isAI()) {
            this.otherCivDiplomacy().activateDenounceEffects();
        }
    }

    private final void activateDenounceEffects() {
        this.setFlag(DiplomacyFlags.Denunciation, 30);
        this.otherCivDiplomacy().setModifier(DiplomaticModifiers.Denunciation, -35.0f);
        String[] stringArray = new String[]{"OtherIcons/Diplomacy", this.getCivInfo().getCivName()};
        this.getOtherCiv().addNotification('[' + this.getCivInfo().getCivName() + "] has denounced us!", Notification.NotificationCategory.Diplomacy, stringArray);
        this.getCivInfo().getDiplomacyFunctions().removeEmbassies(this.getOtherCiv());
        Iterable $this$forEach$iv = this.getCommonKnownCivsWithSpectators();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Civilization thirdCiv = (Civilization)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Diplomacy", this.getOtherCivName()};
            thirdCiv.addNotification('[' + this.getCivInfo().getCivName() + "] has denounced [" + this.getOtherCiv().getCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray2);
            if (thirdCiv.isSpectator()) continue;
            Intrinsics.checkNotNull(thirdCiv.getDiplomacyManager(this.getCivInfo()));
            DiplomacyManager diplomacyManager = thirdCiv.getDiplomacyManager(this.getOtherCiv());
            Intrinsics.checkNotNull(diplomacyManager);
            RelationshipLevel thirdCivRelationshipWithTarget = diplomacyManager.relationshipIgnoreAfraid();
            switch (WhenMappings.$EnumSwitchMapping$0[thirdCivRelationshipWithTarget.ordinal()]) {
                case 3: {
                    DiplomacyManager thirdCivRelationship;
                    thirdCivRelationship.addModifier(DiplomaticModifiers.DenouncedOurEnemies, 15.0f);
                    break;
                }
                case 4: {
                    DiplomacyManager thirdCivRelationship;
                    thirdCivRelationship.addModifier(DiplomaticModifiers.DenouncedOurEnemies, 5.0f);
                    break;
                }
                case 5: {
                    DiplomacyManager thirdCivRelationship;
                    thirdCivRelationship.addModifier(DiplomaticModifiers.DenouncedOurAllies, -5.0f);
                    break;
                }
                case 6: {
                    DiplomacyManager thirdCivRelationship;
                    thirdCivRelationship.addModifier(DiplomaticModifiers.DenouncedOurAllies, -15.0f);
                }
            }
        }
    }

    public final void agreeToDemand(@NotNull Demand demand) {
        Intrinsics.checkNotNullParameter((Object)demand, "demand");
        this.otherCivDiplomacy().setFlag(demand.getAgreedToDemand(), 100);
        this.addModifier(DiplomaticModifiers.UnacceptableDemands, -10.0f);
        String[] stringArray = new String[]{this.getCivInfo().getCivName()};
        String text2 = TranslationsKt.fillPlaceholders(demand.getAgreedToDemandText(), stringArray);
        stringArray = new String[]{"OtherIcons/Diplomacy", this.getCivInfo().getCivName()};
        this.getOtherCiv().addNotification(text2, Notification.NotificationCategory.Diplomacy, stringArray);
    }

    public final void refuseDemand(@NotNull Demand demand) {
        Intrinsics.checkNotNullParameter((Object)demand, "demand");
        this.addModifier(DiplomaticModifiers.UnacceptableDemands, -20.0f);
        this.otherCivDiplomacy().setFlag(demand.getWillIgnoreViolation(), 100);
        this.otherCivDiplomacy().addModifier(demand.getRefusedDiplomaticModifier(), -15.0f);
        String[] stringArray = new String[]{this.getCivInfo().getCivName()};
        String text2 = TranslationsKt.fillPlaceholders(demand.getRefusedDemandText(), stringArray);
        stringArray = new String[]{"OtherIcons/Diplomacy", this.getCivInfo().getCivName()};
        this.getOtherCiv().addNotification(text2, Notification.NotificationCategory.Diplomacy, stringArray);
    }

    public final void sideWithCityState() {
        this.otherCivDiplomacy().setModifier(DiplomaticModifiers.SidedWithProtectedMinor, -5.0f);
        this.otherCivDiplomacy().setFlag(DiplomacyFlags.RememberSidedWithProtectedMinor, 25);
    }

    public final void becomeWary() {
        if (this.hasFlag(DiplomacyFlags.WaryOf)) {
            return;
        }
        this.setFlag(DiplomacyFlags.WaryOf, -1);
        String[] stringArray = new String[]{this.getCivInfo().getCivName()};
        this.getOtherCiv().addNotification("City-States grow wary of your aggression. The resting point for Influence has decreased by [20] for [" + this.getCivInfo().getCivName() + "].", Notification.NotificationCategory.Diplomacy, stringArray);
    }

    public final void giftGold(int gold, boolean isPureGift) {
        int currentGold = isPureGift ? MathKt.roundToInt((float)gold * this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getGoldGiftMultiplier()) : MathKt.roundToInt((float)gold * this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getGoldGiftTradeMultiplier());
        int otherGold = this.otherCivDiplomacy().getGoldGifts();
        if (otherGold > currentGold) {
            this.otherCivDiplomacy().recieveGoldGifts(-currentGold);
        } else {
            this.otherCivDiplomacy().removeModifier$core(DiplomaticModifiers.GaveUsGifts);
            this.recieveGoldGifts(currentGold - otherGold);
        }
    }

    public final void recieveGoldGifts(int gold) {
        double diplomaticValueOfTrade = (double)gold * new TradeEvaluation().getGoldInflation(this.getCivInfo()) / (double)(this.getCivInfo().getGameInfo().getSpeed().getGoldGiftModifier() * (float)100);
        this.addModifier(DiplomaticModifiers.GaveUsGifts, (float)diplomaticValueOfTrade);
    }

    @Readonly
    public final int getGoldGifts() {
        float giftAmount = this.getModifier$core(DiplomaticModifiers.GaveUsGifts);
        return (int)((double)(giftAmount * this.getCivInfo().getGameInfo().getSpeed().getGoldGiftModifier() * (float)100) / new TradeEvaluation().getGoldInflation(this.getCivInfo()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean resourcesFromTrade$lambda$0(LinkedHashMap $resourcesMap, TradeOffer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.getType() != TradeOfferType.Strategic_Resource) {
            if (it.getType() != TradeOfferType.Luxury_Resource) return false;
        }
        if (!$resourcesMap.containsKey(it.getName())) return false;
        Object v = $resourcesMap.get(it.getName());
        Intrinsics.checkNotNull(v);
        if (((TileResource)v).isStockpiled()) return false;
        return true;
    }

    private static final boolean updateHasOpenBorders$lambda$2(DiplomacyManager this$0, MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getCurrentTile().getOwner(), this$0.getOtherCiv());
    }

    private static final boolean makePeaceOneSide$lambda$0(Civilization $otherCiv, MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getTile().getOwner(), $otherCiv);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager$Companion;", "", "<init>", "()V", "MINIMUM_INFLUENCE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RelationshipLevel.values().length];
            try {
                nArray[RelationshipLevel.Afraid.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Neutral.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Unforgivable.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Enemy.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Friend.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Ally.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

