/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic;

import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Pure;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0003J\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/unciv/logic/IdChecker;", "", "<init>", "()V", "checkAndReturnPlayerUuid", "", "playerId", "checkAndReturnGameUuid", "gameId", "checkAndReturnUuiId", "id", "prefix", "getCheckDigit", "", "uuid", "(Ljava/lang/String;)Ljava/lang/Integer;", "core"})
@SourceDebugExtension(value={"SMAP\nIdChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdChecker.kt\ncom/unciv/logic/IdChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1869#2,2:118\n*S KotlinDebug\n*F\n+ 1 IdChecker.kt\ncom/unciv/logic/IdChecker\n*L\n75#1:118,2\n*E\n"})
public final class IdChecker {
    @NotNull
    public static final IdChecker INSTANCE = new IdChecker();

    private IdChecker() {
    }

    @Pure
    @Nullable
    public final String checkAndReturnPlayerUuid(@NotNull String playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        return this.checkAndReturnUuiId(playerId, "P");
    }

    @Pure
    @Nullable
    public final String checkAndReturnGameUuid(@NotNull String gameId) {
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        return this.checkAndReturnUuiId(gameId, "G");
    }

    @Pure
    private final String checkAndReturnUuiId(String id, String prefix) {
        String trimmedPlayerId = ((Object)StringsKt.trim((CharSequence)id)).toString();
        if (trimmedPlayerId.length() == 40) {
            if (!StringsKt.startsWith(trimmedPlayerId, prefix, true)) {
                return null;
            }
            String string = trimmedPlayerId.substring(StringsKt.getLastIndex(trimmedPlayerId), StringsKt.getLastIndex(trimmedPlayerId) + 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String checkDigit = string;
            String string2 = trimmedPlayerId.substring(2, 38);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String shortenedPlayerId = string2;
            Integer calculatedCheckDigit = this.getCheckDigit(shortenedPlayerId);
            if (calculatedCheckDigit == null || !Intrinsics.areEqual(String.valueOf(calculatedCheckDigit), checkDigit)) {
                return null;
            }
            return shortenedPlayerId;
        }
        if (trimmedPlayerId.length() == 36) {
            return trimmedPlayerId;
        }
        return null;
    }

    @Pure
    @Nullable
    public final Integer getCheckDigit(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        String validChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVYWXZ-";
        String idWithoutCheckdigit = null;
        idWithoutCheckdigit = uuid;
        String string = ((Object)StringsKt.trim((CharSequence)idWithoutCheckdigit)).toString();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue(locale, "ENGLISH");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        idWithoutCheckdigit = string2;
        int sum = 0;
        Iterable $this$forEach$iv = StringsKt.getIndices(idWithoutCheckdigit);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            char ch = idWithoutCheckdigit.charAt(idWithoutCheckdigit.length() - i - 1);
            if (!StringsKt.contains$default((CharSequence)validChars, ch, false, 2, null)) {
                return null;
            }
            int digit = ch - 48;
            int weight = 0;
            weight = i % 2 == 0 ? 2 * digit - digit / 5 * 9 : digit;
            sum += weight;
        }
        sum = Math.abs(sum) + 10;
        return (10 - sum % 10) % 10;
    }
}

