/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.UnitType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0012\u0010 \u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010\"\u001a\u00020\t2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0010H\u0016J&\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0012H\u0007J\u001c\u0010/\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+2\n\b\u0002\u00100\u001a\u0004\u0018\u00010-H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00061"}, d2={"Lcom/unciv/logic/battle/MapUnitCombatant;", "Lcom/unciv/logic/battle/ICombatant;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "<init>", "(Lcom/unciv/logic/map/mapunit/MapUnit;)V", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "getHealth", "", "getMaxHealth", "getCivInfo", "Lcom/unciv/logic/civilization/Civilization;", "getTile", "Lcom/unciv/logic/map/tile/Tile;", "getName", "", "isDefeated", "", "isInvisible", "to", "canAttack", "matchesFilter", "filter", "multiFilter", "getAttackSound", "Lcom/unciv/models/UncivSound;", "getNotificationDisplay", "leadingText", "takeDamage", "", "damage", "getAttackingStrength", "defender", "getDefendingStrength", "attacker", "getUnitType", "Lcom/unciv/models/ruleset/unit/UnitType;", "toString", "getMatchingUniques", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/unique/Unique;", "uniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "gameContext", "Lcom/unciv/models/ruleset/unique/GameContext;", "checkCivUniques", "hasUnique", "conditionalState", "core"})
@SourceDebugExtension(value={"SMAP\nMapUnitCombatant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapUnitCombatant.kt\ncom/unciv/logic/battle/MapUnitCombatant\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class MapUnitCombatant
implements ICombatant {
    @NotNull
    private final MapUnit unit;

    public MapUnitCombatant(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.unit = unit;
    }

    @NotNull
    public final MapUnit getUnit() {
        return this.unit;
    }

    @Override
    public int getHealth() {
        return this.unit.getHealth();
    }

    @Override
    public int getMaxHealth() {
        return 100;
    }

    @Override
    @NotNull
    public Civilization getCivInfo() {
        return this.unit.getCiv();
    }

    @Override
    @NotNull
    public Tile getTile() {
        return this.unit.getTile();
    }

    @Override
    @NotNull
    public String getName() {
        return this.unit.getName();
    }

    @Override
    public boolean isDefeated() {
        return this.unit.getHealth() <= 0;
    }

    @Override
    public boolean isInvisible(@NotNull Civilization to) {
        Intrinsics.checkNotNullParameter(to, "to");
        return this.unit.isInvisible(to);
    }

    @Override
    public boolean canAttack() {
        return this.unit.canAttack();
    }

    @Override
    public boolean matchesFilter(@NotNull String filter2, boolean multiFilter) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        return this.unit.matchesFilter(filter2, multiFilter);
    }

    @Override
    @NotNull
    public UncivSound getAttackSound() {
        String it = this.unit.getBaseUnit().getAttackSound();
        boolean bl = false;
        return it == null ? UncivSound.Companion.getClick() : new UncivSound(it);
    }

    @Override
    @NotNull
    public String getNotificationDisplay(@NotNull String leadingText) {
        Intrinsics.checkNotNullParameter(leadingText, "leadingText");
        CharSequence charSequence = this.unit.getInstanceName();
        boolean isUnitUnnamed = charSequence == null || charSequence.length() == 0;
        return isUnitUnnamed ? '[' + this.unit.getName() + ']' : leadingText + '[' + this.unit.getInstanceName() + ']';
    }

    @Override
    public void takeDamage(int damage) {
        this.unit.takeDamage(damage);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getAttackingStrength(@Nullable ICombatant defender) {
        GameContext state = new GameContext(this, defender, this.getTile(), CombatAction.Attack);
        Sequence sequence = MapUnit.getMatchingUniques$default(this.unit, UniqueType.StrengthAmount, state, false, 4, null);
        int n = 0;
        Iterator iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object t = iterator2.next();
            Unique unique = (Unique)t;
            int n2 = n;
            boolean bl = false;
            int n3 = Integer.parseInt(it.getParams().get(0));
            n = n2 + n3;
        }
        int extraStrength = n;
        return this.isRanged() ? this.unit.getBaseUnit().getRangedStrength() + extraStrength : this.unit.getBaseUnit().getStrength() + extraStrength;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getDefendingStrength(@Nullable ICombatant attacker) {
        ICombatant iCombatant = attacker;
        boolean attackedByRanged = iCombatant != null ? iCombatant.isRanged() : false;
        GameContext state = new GameContext(this, attacker, this.getTile(), CombatAction.Defend);
        Sequence sequence = MapUnit.getMatchingUniques$default(this.unit, UniqueType.StrengthAmount, state, false, 4, null);
        int n = 0;
        Iterator iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object t = iterator2.next();
            Unique unique = (Unique)t;
            int n2 = n;
            boolean bl = false;
            int n3 = Integer.parseInt(it.getParams().get(0));
            n = n2 + n3;
        }
        int extraStrength = n;
        return this.unit.isEmbarked() && !this.isCivilian() ? this.unit.getCiv().getEra().getEmbarkDefense() : (this.isRanged() && attackedByRanged ? this.unit.getBaseUnit().getRangedStrength() + extraStrength : this.unit.getBaseUnit().getStrength() + extraStrength);
    }

    @Override
    @NotNull
    public UnitType getUnitType() {
        return this.unit.getType();
    }

    @NotNull
    public String toString() {
        return this.unit.getName() + " of " + this.unit.getCiv().getCivName();
    }

    @Readonly
    @NotNull
    public final Sequence<Unique> getMatchingUniques(@NotNull UniqueType uniqueType, @NotNull GameContext gameContext, boolean checkCivUniques) {
        Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
        Intrinsics.checkNotNullParameter(gameContext, "gameContext");
        return this.unit.getMatchingUniques(uniqueType, gameContext, checkCivUniques);
    }

    @Readonly
    public final boolean hasUnique(@NotNull UniqueType uniqueType, @Nullable GameContext conditionalState) {
        Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
        return conditionalState == null ? MapUnit.hasUnique$default(this.unit, uniqueType, null, false, 6, null) : MapUnit.hasUnique$default(this.unit, uniqueType, conditionalState, false, 4, null);
    }

    public static /* synthetic */ boolean hasUnique$default(MapUnitCombatant mapUnitCombatant, UniqueType uniqueType, GameContext gameContext, int n, Object object) {
        if ((n & 2) != 0) {
            gameContext = null;
        }
        return mapUnitCombatant.hasUnique(uniqueType, gameContext);
    }
}

