/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer.storage;

import com.unciv.UncivGame;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import io.ktor.http.HttpHeaders;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0083\u0001\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000b2Q\u0010\f\u001aM\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0015\u0012\u0013\u0018\u00010\t\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00050\rj\u0002`\u0014J\u0093\u0001\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000b2Q\u0010\f\u001aM\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0015\u0012\u0013\u0018\u00010\t\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00050\rj\u0002`\u0014J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/unciv/logic/multiplayer/storage/SimpleHttp;", "", "<init>", "()V", "sendGetRequest", "", "url", "", "timeout", "", "header", "", "action", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "success", "result", "code", "Lcom/unciv/logic/multiplayer/storage/SendRequestCallback;", "sendRequest", "method", "content", "getIpAddress", "core"})
public final class SimpleHttp {
    @NotNull
    public static final SimpleHttp INSTANCE = new SimpleHttp();

    private SimpleHttp() {
    }

    public final void sendGetRequest(@NotNull String url, int timeout2, @Nullable Map<String, String> header, @NotNull Function3<? super Boolean, ? super String, ? super Integer, Unit> action2) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(action2, "action");
        this.sendRequest("GET", url, "", timeout2, header, action2);
    }

    public static /* synthetic */ void sendGetRequest$default(SimpleHttp simpleHttp, String string, int n, Map map2, Function3 function3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 5000;
        }
        if ((n2 & 4) != 0) {
            map2 = null;
        }
        simpleHttp.sendGetRequest(string, n, map2, function3);
    }

    public final void sendRequest(@NotNull String method, @NotNull String url, @NotNull String content2, int timeout2, @Nullable Map<String, String> header, @NotNull Function3<? super Boolean, ? super String, ? super Integer, Unit> action2) {
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(content2, "content");
        Intrinsics.checkNotNullParameter(action2, "action");
        URI uri = new URI(url);
        if (uri.getHost() == null) {
            uri = new URI("http://" + url);
        }
        URL urlObj = null;
        try {
            URL uRL = uri.toURL();
            Intrinsics.checkNotNullExpressionValue(uRL, "toURL(...)");
            urlObj = uRL;
        }
        catch (Throwable t) {
            Log.INSTANCE.debug("Bad URL", t);
            action2.invoke((Boolean)false, "Bad URL", null);
            return;
        }
        URLConnection uRLConnection = urlObj.openConnection();
        Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection $this$sendRequest_u24lambda_u240 = (HttpURLConnection)uRLConnection;
        boolean bl = false;
        $this$sendRequest_u24lambda_u240.setRequestMethod(method);
        $this$sendRequest_u24lambda_u240.setConnectTimeout(timeout2);
        $this$sendRequest_u24lambda_u240.setInstanceFollowRedirects(true);
        $this$sendRequest_u24lambda_u240.setRequestProperty(HttpHeaders.INSTANCE.getUserAgent(), UncivGame.Companion.getUserAgent("Turn-Checker"));
        $this$sendRequest_u24lambda_u240.setRequestProperty(HttpHeaders.INSTANCE.getContentType(), "text/plain");
        Map<String, String> map2 = header;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            $this$sendRequest_u24lambda_u240.setRequestProperty(key, value);
        }
        try {
            if (((CharSequence)content2).length() > 0) {
                $this$sendRequest_u24lambda_u240.setDoOutput(true);
                byte[] byArray = content2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                byte[] postData = byArray;
                DataOutputStream outputStream = new DataOutputStream($this$sendRequest_u24lambda_u240.getOutputStream());
                outputStream.write(postData);
                outputStream.flush();
            }
            String text2 = TextStreamsKt.readText(new BufferedReader(new InputStreamReader($this$sendRequest_u24lambda_u240.getInputStream(), Charsets.UTF_8)));
            action2.invoke((Boolean)true, text2, (Integer)$this$sendRequest_u24lambda_u240.getResponseCode());
        }
        catch (Throwable t) {
            String string;
            LogKt.debug("Error during HTTP request", t);
            if ($this$sendRequest_u24lambda_u240.getErrorStream() != null) {
                string = TextStreamsKt.readText(new BufferedReader(new InputStreamReader($this$sendRequest_u24lambda_u240.getErrorStream(), Charsets.UTF_8)));
            } else {
                String string2 = t.getMessage();
                string = string2;
                Intrinsics.checkNotNull(string2);
            }
            String errorMessageToReturn = string;
            Object[] objectArray = new Object[]{errorMessageToReturn};
            LogKt.debug("Returning error message [%s]", objectArray);
            action2.invoke((Boolean)false, errorMessageToReturn, (Integer)$this$sendRequest_u24lambda_u240.getResponseCode());
        }
    }

    public static /* synthetic */ void sendRequest$default(SimpleHttp simpleHttp, String string, String string2, String string3, int n, Map map2, Function3 function3, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 5000;
        }
        if ((n2 & 0x10) != 0) {
            map2 = null;
        }
        simpleHttp.sendRequest(string, string2, string3, n, map2, function3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getIpAddress() {
        Closeable closeable = new DatagramSocket();
        Throwable throwable = null;
        try {
            DatagramSocket socket = (DatagramSocket)closeable;
            boolean bl = false;
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            String string = socket.getLocalAddress().getHostAddress();
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }
}

