/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.unique;

import com.badlogic.gdx.math.Rectangle;
import com.unciv.logic.GameInfo;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.mapgenerator.mapregions.Region;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.stats.Stat;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b'\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\b\u0018\u0000 S2\u00020\u0001:\u0001SB\u0089\u0001\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0016\u0010\u0018B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0019B5\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0016\u0010\u001aJ\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0007J\u0010\u0010@\u001a\u00020=2\u0006\u0010A\u001a\u00020BH\u0007J\b\u0010C\u001a\u00020=H\u0017J\u000b\u0010D\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010F\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010G\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010I\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010J\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010K\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\u000b\u0010L\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\u000b\u0010M\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003J\t\u0010N\u001a\u00020\u0015H\u00c6\u0003J\u008b\u0001\u0010O\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u00c6\u0001J\u0013\u0010P\u001a\u00020\u00152\b\u0010Q\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010R\u001a\u00020?H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0013\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010$R\u0013\u0010\r\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\"R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001d\u0010/\u001a\u0004\u0018\u00010\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b0\u0010 R\u001d\u00103\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u00102\u001a\u0004\b4\u0010\"R\u001d\u00106\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u00102\u001a\u0004\b7\u0010\u001eR\u001d\u00109\u001a\u0004\u0018\u00010\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u00102\u001a\u0004\b:\u0010\u001c\u00a8\u0006T"}, d2={"Lcom/unciv/models/ruleset/unique/GameContext;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "city", "Lcom/unciv/logic/city/City;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "ourCombatant", "Lcom/unciv/logic/battle/ICombatant;", "theirCombatant", "attackedTile", "combatAction", "Lcom/unciv/logic/battle/CombatAction;", "region", "Lcom/unciv/logic/map/mapgenerator/mapregions/Region;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "ignoreConditionals", "", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/city/City;Lcom/unciv/logic/map/mapunit/MapUnit;Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/logic/battle/ICombatant;Lcom/unciv/logic/battle/ICombatant;Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/logic/battle/CombatAction;Lcom/unciv/logic/map/mapgenerator/mapregions/Region;Lcom/unciv/logic/GameInfo;Z)V", "(Lcom/unciv/logic/city/City;)V", "(Lcom/unciv/logic/map/mapunit/MapUnit;)V", "(Lcom/unciv/logic/battle/ICombatant;Lcom/unciv/logic/battle/ICombatant;Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/logic/battle/CombatAction;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "getCity", "()Lcom/unciv/logic/city/City;", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "getOurCombatant", "()Lcom/unciv/logic/battle/ICombatant;", "getTheirCombatant", "getAttackedTile", "getCombatAction", "()Lcom/unciv/logic/battle/CombatAction;", "getRegion", "()Lcom/unciv/logic/map/mapgenerator/mapregions/Region;", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "getIgnoreConditionals", "()Z", "relevantUnit", "getRelevantUnit", "relevantUnit$delegate", "Lkotlin/Lazy;", "relevantTile", "getRelevantTile", "relevantTile$delegate", "relevantCity", "getRelevantCity", "relevantCity$delegate", "relevantCiv", "getRelevantCiv", "relevantCiv$delegate", "getResourceAmount", "", "resourceName", "", "getStatAmount", "stat", "Lcom/unciv/models/stats/Stat;", "hashCode", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "other", "toString", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nGameContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameContext.kt\ncom/unciv/models/ruleset/unique/GameContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public final class GameContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Civilization civInfo;
    @Nullable
    private final City city;
    @Nullable
    private final MapUnit unit;
    @Nullable
    private final Tile tile;
    @Nullable
    private final ICombatant ourCombatant;
    @Nullable
    private final ICombatant theirCombatant;
    @Nullable
    private final Tile attackedTile;
    @Nullable
    private final CombatAction combatAction;
    @Nullable
    private final Region region;
    @Nullable
    private final GameInfo gameInfo;
    private final boolean ignoreConditionals;
    @NotNull
    private final Lazy relevantUnit$delegate;
    @NotNull
    private final Lazy relevantTile$delegate;
    @NotNull
    private final Lazy relevantCity$delegate;
    @NotNull
    private final Lazy relevantCiv$delegate;
    @NotNull
    private static final GameContext IgnoreConditionals = new GameContext(null, null, null, null, null, null, null, null, null, null, true, 1023, null);
    @NotNull
    private static final GameContext EmptyState = new GameContext(null, null, null, null, null, null, null, null, null, null, false, 2047, null);
    @NotNull
    private static final GameContext IgnoreMultiplicationForCaching = new GameContext(null, null, null, null, null, null, null, null, null, null, true, 1023, null);

    public GameContext(@Nullable Civilization civInfo, @Nullable City city, @Nullable MapUnit unit, @Nullable Tile tile, @Nullable ICombatant ourCombatant, @Nullable ICombatant theirCombatant, @Nullable Tile attackedTile, @Nullable CombatAction combatAction, @Nullable Region region, @Nullable GameInfo gameInfo, boolean ignoreConditionals) {
        this.civInfo = civInfo;
        this.city = city;
        this.unit = unit;
        this.tile = tile;
        this.ourCombatant = ourCombatant;
        this.theirCombatant = theirCombatant;
        this.attackedTile = attackedTile;
        this.combatAction = combatAction;
        this.region = region;
        this.gameInfo = gameInfo;
        this.ignoreConditionals = ignoreConditionals;
        this.relevantUnit$delegate = LazyKt.lazy(() -> GameContext.relevantUnit_delegate$lambda$0(this));
        this.relevantTile$delegate = LazyKt.lazy(() -> GameContext.relevantTile_delegate$lambda$0(this));
        this.relevantCity$delegate = LazyKt.lazy(() -> GameContext.relevantCity_delegate$lambda$0(this));
        this.relevantCiv$delegate = LazyKt.lazy(() -> GameContext.relevantCiv_delegate$lambda$0(this));
    }

    public /* synthetic */ GameContext(Civilization civilization, City city, MapUnit mapUnit, Tile tile, ICombatant iCombatant, ICombatant iCombatant2, Tile tile2, CombatAction combatAction, Region region, GameInfo gameInfo, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            civilization = null;
        }
        if ((n & 2) != 0) {
            city = null;
        }
        if ((n & 4) != 0) {
            mapUnit = null;
        }
        if ((n & 8) != 0) {
            tile = null;
        }
        if ((n & 0x10) != 0) {
            iCombatant = null;
        }
        if ((n & 0x20) != 0) {
            iCombatant2 = null;
        }
        if ((n & 0x40) != 0) {
            tile2 = null;
        }
        if ((n & 0x80) != 0) {
            combatAction = null;
        }
        if ((n & 0x100) != 0) {
            region = null;
        }
        if ((n & 0x200) != 0) {
            Civilization civilization2 = civilization;
            GameInfo gameInfo2 = gameInfo = civilization2 != null ? civilization2.getGameInfo() : null;
        }
        if ((n & 0x400) != 0) {
            bl = false;
        }
        this(civilization, city, mapUnit, tile, iCombatant, iCombatant2, tile2, combatAction, region, gameInfo, bl);
    }

    @Nullable
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    @Nullable
    public final City getCity() {
        return this.city;
    }

    @Nullable
    public final MapUnit getUnit() {
        return this.unit;
    }

    @Nullable
    public final Tile getTile() {
        return this.tile;
    }

    @Nullable
    public final ICombatant getOurCombatant() {
        return this.ourCombatant;
    }

    @Nullable
    public final ICombatant getTheirCombatant() {
        return this.theirCombatant;
    }

    @Nullable
    public final Tile getAttackedTile() {
        return this.attackedTile;
    }

    @Nullable
    public final CombatAction getCombatAction() {
        return this.combatAction;
    }

    @Nullable
    public final Region getRegion() {
        return this.region;
    }

    @Nullable
    public final GameInfo getGameInfo() {
        return this.gameInfo;
    }

    public final boolean getIgnoreConditionals() {
        return this.ignoreConditionals;
    }

    public GameContext(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        this(city.getCiv(), city, null, city.getCenterTileOrNull(), null, null, null, null, null, null, false, 2036, null);
    }

    public GameContext(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this(unit.getCiv(), null, unit, unit.hasTile() ? unit.getTile() : null, null, null, null, null, null, null, false, 2034, null);
    }

    public GameContext(@NotNull ICombatant ourCombatant, @Nullable ICombatant theirCombatant, @Nullable Tile attackedTile, @Nullable CombatAction combatAction) {
        Intrinsics.checkNotNullParameter(ourCombatant, "ourCombatant");
        CityCombatant cityCombatant = ourCombatant instanceof CityCombatant ? (CityCombatant)ourCombatant : null;
        MapUnitCombatant mapUnitCombatant = ourCombatant instanceof MapUnitCombatant ? (MapUnitCombatant)ourCombatant : null;
        this(ourCombatant.getCivInfo(), cityCombatant != null ? cityCombatant.getCity() : null, mapUnitCombatant != null ? mapUnitCombatant.getUnit() : null, ourCombatant.getTile(), ourCombatant, theirCombatant, attackedTile, combatAction, null, null, false, 1792, null);
    }

    public /* synthetic */ GameContext(ICombatant iCombatant, ICombatant iCombatant2, Tile tile, CombatAction combatAction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iCombatant2 = null;
        }
        if ((n & 4) != 0) {
            tile = null;
        }
        if ((n & 8) != 0) {
            combatAction = null;
        }
        this(iCombatant, iCombatant2, tile, combatAction);
    }

    @Nullable
    public final MapUnit getRelevantUnit() {
        Lazy lazy = this.relevantUnit$delegate;
        return (MapUnit)lazy.getValue();
    }

    @Nullable
    public final Tile getRelevantTile() {
        Lazy lazy = this.relevantTile$delegate;
        return (Tile)lazy.getValue();
    }

    @Nullable
    public final City getRelevantCity() {
        Lazy lazy = this.relevantCity$delegate;
        return (City)lazy.getValue();
    }

    @Nullable
    public final Civilization getRelevantCiv() {
        Lazy lazy = this.relevantCiv$delegate;
        return (Civilization)lazy.getValue();
    }

    @Readonly
    public final int getResourceAmount(@NotNull String resourceName) {
        int n;
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        if (this.getRelevantCity() != null) {
            City city = this.getRelevantCity();
            Intrinsics.checkNotNull(city);
            n = city.getAvailableResourceAmount(resourceName);
        } else if (this.getRelevantCiv() != null) {
            Civilization civilization = this.getRelevantCiv();
            Intrinsics.checkNotNull(civilization);
            n = civilization.getResourceAmount(resourceName);
        } else {
            n = 0;
        }
        return n;
    }

    @Readonly
    public final int getStatAmount(@NotNull Stat stat) {
        int n;
        Intrinsics.checkNotNullParameter(stat, "stat");
        if (this.getRelevantCity() != null) {
            City city = this.getRelevantCity();
            Intrinsics.checkNotNull(city);
            n = city.getStatReserve(stat);
        } else if (this.getRelevantCiv() != null && Stat.Companion.getStatsWithCivWideField().contains(stat)) {
            Civilization civilization = this.getRelevantCiv();
            Intrinsics.checkNotNull(civilization);
            n = civilization.getStatReserve(stat);
        } else {
            n = 0;
        }
        return n;
    }

    @Readonly
    public int hashCode() {
        int result2 = GameContext.hashCode$hash(this.getRelevantCiv());
        result2 = 31 * result2 + GameContext.hashCode$hash$0(this.getRelevantCity());
        result2 = 31 * result2 + GameContext.hashCode$hash$2(this.getRelevantUnit());
        result2 = 31 * result2 + GameContext.hashCode$hash$1(this.getRelevantTile());
        result2 = 31 * result2 + GameContext.hashCode$hash$3(this.ourCombatant);
        result2 = 31 * result2 + GameContext.hashCode$hash$3(this.theirCombatant);
        result2 = 31 * result2 + GameContext.hashCode$hash$1(this.attackedTile);
        result2 = 31 * result2 + GameContext.hashCode$hash$4(this.combatAction);
        result2 = 31 * result2 + GameContext.hashCode$hash$5(this.region);
        result2 = 31 * result2 + Boolean.hashCode(this.ignoreConditionals);
        return result2;
    }

    @Nullable
    public final Civilization component1() {
        return this.civInfo;
    }

    @Nullable
    public final City component2() {
        return this.city;
    }

    @Nullable
    public final MapUnit component3() {
        return this.unit;
    }

    @Nullable
    public final Tile component4() {
        return this.tile;
    }

    @Nullable
    public final ICombatant component5() {
        return this.ourCombatant;
    }

    @Nullable
    public final ICombatant component6() {
        return this.theirCombatant;
    }

    @Nullable
    public final Tile component7() {
        return this.attackedTile;
    }

    @Nullable
    public final CombatAction component8() {
        return this.combatAction;
    }

    @Nullable
    public final Region component9() {
        return this.region;
    }

    @Nullable
    public final GameInfo component10() {
        return this.gameInfo;
    }

    public final boolean component11() {
        return this.ignoreConditionals;
    }

    @NotNull
    public final GameContext copy(@Nullable Civilization civInfo, @Nullable City city, @Nullable MapUnit unit, @Nullable Tile tile, @Nullable ICombatant ourCombatant, @Nullable ICombatant theirCombatant, @Nullable Tile attackedTile, @Nullable CombatAction combatAction, @Nullable Region region, @Nullable GameInfo gameInfo, boolean ignoreConditionals) {
        return new GameContext(civInfo, city, unit, tile, ourCombatant, theirCombatant, attackedTile, combatAction, region, gameInfo, ignoreConditionals);
    }

    public static /* synthetic */ GameContext copy$default(GameContext gameContext, Civilization civilization, City city, MapUnit mapUnit, Tile tile, ICombatant iCombatant, ICombatant iCombatant2, Tile tile2, CombatAction combatAction, Region region, GameInfo gameInfo, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            civilization = gameContext.civInfo;
        }
        if ((n & 2) != 0) {
            city = gameContext.city;
        }
        if ((n & 4) != 0) {
            mapUnit = gameContext.unit;
        }
        if ((n & 8) != 0) {
            tile = gameContext.tile;
        }
        if ((n & 0x10) != 0) {
            iCombatant = gameContext.ourCombatant;
        }
        if ((n & 0x20) != 0) {
            iCombatant2 = gameContext.theirCombatant;
        }
        if ((n & 0x40) != 0) {
            tile2 = gameContext.attackedTile;
        }
        if ((n & 0x80) != 0) {
            combatAction = gameContext.combatAction;
        }
        if ((n & 0x100) != 0) {
            region = gameContext.region;
        }
        if ((n & 0x200) != 0) {
            gameInfo = gameContext.gameInfo;
        }
        if ((n & 0x400) != 0) {
            bl = gameContext.ignoreConditionals;
        }
        return gameContext.copy(civilization, city, mapUnit, tile, iCombatant, iCombatant2, tile2, combatAction, region, gameInfo, bl);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GameContext(civInfo=").append(this.civInfo).append(", city=").append(this.city).append(", unit=").append(this.unit).append(", tile=").append(this.tile).append(", ourCombatant=").append(this.ourCombatant).append(", theirCombatant=").append(this.theirCombatant).append(", attackedTile=").append(this.attackedTile).append(", combatAction=").append((Object)this.combatAction).append(", region=").append(this.region).append(", gameInfo=").append(this.gameInfo).append(", ignoreConditionals=").append(this.ignoreConditionals).append(')');
        return stringBuilder.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GameContext)) {
            return false;
        }
        GameContext gameContext = (GameContext)other;
        if (!Intrinsics.areEqual(this.civInfo, gameContext.civInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.city, gameContext.city)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.unit, gameContext.unit)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tile, gameContext.tile)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.ourCombatant, gameContext.ourCombatant)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.theirCombatant, gameContext.theirCombatant)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.attackedTile, gameContext.attackedTile)) {
            return false;
        }
        if (this.combatAction != gameContext.combatAction) {
            return false;
        }
        if (!Intrinsics.areEqual(this.region, gameContext.region)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.gameInfo, gameContext.gameInfo)) {
            return false;
        }
        return this.ignoreConditionals == gameContext.ignoreConditionals;
    }

    private static final MapUnit relevantUnit_delegate$lambda$0(GameContext this$0) {
        return this$0.ourCombatant != null && this$0.ourCombatant instanceof MapUnitCombatant ? ((MapUnitCombatant)this$0.ourCombatant).getUnit() : this$0.unit;
    }

    private static final Tile relevantTile_delegate$lambda$0(GameContext this$0) {
        Tile tile = this$0.attackedTile;
        if (tile == null && (tile = this$0.tile) == null) {
            Tile tile2;
            MapUnit mapUnit = this$0.getRelevantUnit();
            if (mapUnit != null) {
                MapUnit $this$relevantTile_delegate_u24lambda_u240_u240 = mapUnit;
                boolean bl = false;
                tile2 = $this$relevantTile_delegate_u24lambda_u240_u240.hasTile() ? $this$relevantTile_delegate_u24lambda_u240_u240.getTile() : null;
            } else {
                tile2 = tile = null;
            }
            if (tile2 == null) {
                City city = this$0.city;
                tile = city != null ? city.getCenterTileOrNull() : null;
            }
        }
        return tile;
    }

    private static final City relevantCity_delegate$lambda$0(GameContext this$0) {
        block7: {
            City cityForRelevantTile;
            block8: {
                Tile relevantTileForCity;
                if (this$0.city != null) {
                    return this$0.city;
                }
                Tile tile = this$0.tile;
                if (tile == null) {
                    MapUnit mapUnit = this$0.getRelevantUnit();
                    if (mapUnit != null) {
                        MapUnit $this$relevantCity_delegate_u24lambda_u240_u240 = mapUnit;
                        boolean bl = false;
                        tile = $this$relevantCity_delegate_u24lambda_u240_u240.hasTile() ? $this$relevantCity_delegate_u24lambda_u240_u240.getTile() : null;
                    } else {
                        tile = null;
                    }
                }
                Tile tile2 = relevantTileForCity = tile;
                City city = cityForRelevantTile = tile2 != null ? tile2.getCity() : null;
                if (cityForRelevantTile == null) break block7;
                if (Intrinsics.areEqual(cityForRelevantTile.getCiv(), this$0.civInfo)) break block8;
                MapUnit mapUnit = this$0.getRelevantUnit();
                if (!Intrinsics.areEqual(cityForRelevantTile.getCiv(), mapUnit != null ? mapUnit.getCiv() : null)) break block7;
            }
            return cityForRelevantTile;
        }
        return null;
    }

    private static final Civilization relevantCiv_delegate$lambda$0(GameContext this$0) {
        Civilization civilization = this$0.civInfo;
        if (civilization == null) {
            City city = this$0.getRelevantCity();
            civilization = city != null ? city.getCiv() : null;
            if (civilization == null) {
                MapUnit mapUnit = this$0.getRelevantUnit();
                civilization = mapUnit != null ? mapUnit.getCiv() : null;
            }
        }
        return civilization;
    }

    private static final int hashCode$hash(Civilization $this$hashCode_u24hash) {
        Object object = $this$hashCode_u24hash;
        return object != null && (object = ((Civilization)object).getCivName()) != null ? ((String)object).hashCode() : 0;
    }

    private static final int hashCode$hash$0(City $this$hashCode_u24hash_u240) {
        Object object = $this$hashCode_u24hash_u240;
        return object != null && (object = ((City)object).getId()) != null ? ((String)object).hashCode() : 0;
    }

    private static final int hashCode$hash$1(Tile $this$hashCode_u24hash_u241) {
        Object object = $this$hashCode_u24hash_u241;
        return object != null && (object = ((Tile)object).getPosition()) != null ? ((HexCoord)object).hashCode() : 0;
    }

    private static final int hashCode$hash$2(MapUnit $this$hashCode_u24hash_u242) {
        MapUnit mapUnit = $this$hashCode_u24hash_u242;
        return mapUnit == null ? 0 : mapUnit.getName().hashCode() + ($this$hashCode_u24hash_u242.hasTile() ? 17 * GameContext.hashCode$hash$1($this$hashCode_u24hash_u242.getCurrentTile()) : 0);
    }

    private static final int hashCode$hash$3(ICombatant $this$hashCode_u24hash_u243) {
        return $this$hashCode_u24hash_u243 == null ? 0 : ($this$hashCode_u24hash_u243 instanceof MapUnitCombatant ? GameContext.hashCode$hash$2(((MapUnitCombatant)$this$hashCode_u24hash_u243).getUnit()) : $this$hashCode_u24hash_u243.getName().hashCode() + 17 * GameContext.hashCode$hash$1($this$hashCode_u24hash_u243.getTile()));
    }

    private static final int hashCode$hash$4(CombatAction $this$hashCode_u24hash_u244) {
        Object object = $this$hashCode_u24hash_u244;
        return object != null && (object = object.name()) != null ? ((String)object).hashCode() : 0;
    }

    private static final int hashCode$hash$5(Region $this$hashCode_u24hash_u245) {
        Object object = $this$hashCode_u24hash_u245;
        return object != null && (object = ((Region)object).getRect()) != null ? ((Rectangle)object).hashCode() : 0;
    }

    public GameContext() {
        this(null, null, null, null, null, null, null, null, null, null, false, 2047, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/unciv/models/ruleset/unique/GameContext$Companion;", "", "<init>", "()V", "IgnoreConditionals", "Lcom/unciv/models/ruleset/unique/GameContext;", "getIgnoreConditionals", "()Lcom/unciv/models/ruleset/unique/GameContext;", "EmptyState", "getEmptyState", "IgnoreMultiplicationForCaching", "getIgnoreMultiplicationForCaching", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GameContext getIgnoreConditionals() {
            return IgnoreConditionals;
        }

        @NotNull
        public final GameContext getEmptyState() {
            return EmptyState;
        }

        @NotNull
        public final GameContext getIgnoreMultiplicationForCaching() {
            return IgnoreMultiplicationForCaching;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

