/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.unit;

import com.unciv.UncivGame;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.objectdescriptions.DescriptionHelpersKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.net.URLEncoder;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\u0000J%\u0010\r\u001a\r\u0012\t\u0012\u00070\u000f\u00a2\u0006\u0002\b\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R*\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/unciv/models/ruleset/unit/UnitNameGroup;", "Lcom/unciv/models/ruleset/RulesetObject;", "<init>", "()V", "unitNames", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getUnitNames", "()Ljava/util/ArrayList;", "setUnitNames", "(Ljava/util/ArrayList;)V", "clone", "getUnits", "", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "Lkotlin/jvm/internal/EnhancedNullability;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "gameContext", "Lcom/unciv/models/ruleset/unique/GameContext;", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "makeLink", "getCivilopediaTextLines", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "core"})
@SourceDebugExtension(value={"SMAP\nUnitNameGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitNameGroup.kt\ncom/unciv/models/ruleset/unit/UnitNameGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n774#2:73\n865#2:74\n866#2:77\n1255#3,2:75\n1#4:78\n*S KotlinDebug\n*F\n+ 1 UnitNameGroup.kt\ncom/unciv/models/ruleset/unit/UnitNameGroup\n*L\n36#1:73\n36#1:74\n36#1:77\n37#1:75,2\n*E\n"})
public final class UnitNameGroup
extends RulesetObject {
    @NotNull
    private ArrayList<String> unitNames = new ArrayList();

    @NotNull
    public final ArrayList<String> getUnitNames() {
        return this.unitNames;
    }

    public final void setUnitNames(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.unitNames = arrayList;
    }

    @NotNull
    public final UnitNameGroup clone() {
        UnitNameGroup newUnitNameGroup = new UnitNameGroup();
        newUnitNameGroup.setName(this.getName());
        newUnitNameGroup.setUniques(this.getUniques());
        newUnitNameGroup.unitNames = this.unitNames;
        return newUnitNameGroup;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final List<BaseUnit> getUnits(@NotNull Ruleset ruleset, @NotNull GameContext gameContext) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Intrinsics.checkNotNullParameter(gameContext, "gameContext");
        Collection<BaseUnit> collection = ruleset.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block2: {
                BaseUnit unit = (BaseUnit)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(unit);
                Sequence $this$any$iv = IHasUniques.getMatchingUniques$default(unit, UniqueType.OneTimeUnitGetsName, null, 2, null);
                boolean $i$f$any = false;
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    Unique unique = (Unique)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual(unique.getParams().get(1), this.getName()) || this.hasTagUnique(unique.getParams().get(1), gameContext))) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getUnits$default(UnitNameGroup unitNameGroup, Ruleset ruleset, GameContext gameContext, int n, Object object) {
        if ((n & 2) != 0) {
            gameContext = GameContext.Companion.getIgnoreConditionals();
        }
        return unitNameGroup.getUnits(ruleset, gameContext);
    }

    @Override
    @NotNull
    public UniqueTarget getUniqueTarget() {
        return UniqueTarget.EventChoice;
    }

    @Override
    @NotNull
    public String makeLink() {
        return "Unit Names/" + this.getName();
    }

    @Override
    @NotNull
    public List<FormattedLine> getCivilopediaTextLines(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        ArrayList<FormattedLine> lines2 = new ArrayList<FormattedLine>();
        DescriptionHelpersKt.uniquesToCivilopediaTextLines$default(this, lines2, null, false, null, 14, null);
        List units = UnitNameGroup.getUnits$default(this, ruleset, null, 2, null);
        if (!((Collection)units).isEmpty()) {
            lines2.add(new FormattedLine("Units", null, null, null, 0.0f, 0, 4, 0, 0.0f, null, false, false, false, false, 16318, null));
            for (Object e : units) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                BaseUnit unit = (BaseUnit)e;
                lines2.add(new FormattedLine(unit.getName(), unit.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        if (!((Collection)this.unitNames).isEmpty()) {
            lines2.add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            lines2.add(new FormattedLine("Unit Names", null, null, null, 0.0f, 0, 4, 0, 0.0f, null, false, false, false, false, 16318, null));
            GameSettings $this$getCivilopediaTextLines_u24lambda_u240 = UncivGame.Companion.getCurrent().getSettings();
            boolean bl = false;
            Collator collator = $this$getCivilopediaTextLines_u24lambda_u240.getCollatorFromLocale();
            Locale locale = $this$getCivilopediaTextLines_u24lambda_u240.getLocale();
            Intrinsics.checkNotNull(locale);
            Pair<Collator, String> pair = TuplesKt.to(collator, locale.getLanguage());
            Collator collator2 = (Collator)pair.component1();
            String language = (String)pair.component2();
            for (String name : CollectionsKt.sortedWith((Iterable)this.unitNames, collator2)) {
                lines2.add(new FormattedLine(name, UnitNameGroup.getCivilopediaTextLines$wikilink(language, name), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        return lines2;
    }

    private static final String getCivilopediaTextLines$wikilink(String language, String name) {
        return "https://" + language + ".wikipedia.org/w/index.php?search=" + URLEncoder.encode(TranslationsKt.tr$default(name, false, false, 3, null), Charsets.UTF_8.name());
    }
}

