﻿vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO moehoshio/NekoThreadPool
    REF v1.0.1
    SHA512 CBE9DE82D5AE8214A7B2D648F2C8A12CC34EB9DBF49F9C4F6677A252AE46F6EC767430A9EBE9FEFE2C5859E154F3116B28B9F46FC941E0BAC29D0208A97953ED
    HEAD_REF main
)

set(VCPKG_BUILD_TYPE release)

vcpkg_cmake_configure(
    SOURCE_PATH "${SOURCE_PATH}"
    OPTIONS
        -DNEKO_THREAD_POOL_BUILD_TESTS=OFF
        -DNEKO_THREAD_POOL_AUTO_FETCH_DEPS=OFF
        -DNEKO_THREAD_POOL_ENABLE_MODULE=OFF
)

vcpkg_cmake_install()
vcpkg_cmake_config_fixup(CONFIG_PATH lib/cmake/NekoThreadPool PACKAGE_NAME nekothreadpool)

file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/lib")

vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/LICENSE")

file(INSTALL "${CMAKE_CURRENT_LIST_DIR}/usage" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}")

